/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.PowerManager;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.DccLocoAddressSelector;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.GlobalRosterEntryComboBox;
import jmri.jmrix.bachrus.Bundle;
import jmri.jmrix.bachrus.DccSpeedProfile;
import jmri.jmrix.bachrus.GraphPane;
import jmri.jmrix.bachrus.Speed;
import jmri.jmrix.bachrus.SpeedoDial;
import jmri.jmrix.bachrus.SpeedoListener;
import jmri.jmrix.bachrus.SpeedoReply;
import jmri.jmrix.bachrus.SpeedoSystemConnectionMemo;
import jmri.jmrix.bachrus.SpeedoTrafficController;
import jmri.jmrix.bachrus.speedmatcher.SpeedMatcher;
import jmri.jmrix.bachrus.speedmatcher.basic.BasicSpeedMatcherConfig;
import jmri.jmrix.bachrus.speedmatcher.basic.BasicSpeedMatcherFactory;
import jmri.jmrix.bachrus.speedmatcher.speedStepScale.SpeedStepScaleSpeedMatcherConfig;
import jmri.jmrix.bachrus.speedmatcher.speedStepScale.SpeedStepScaleSpeedMatcherFactory;
import jmri.jmrix.bachrus.speedmatcher.speedStepScale.SpeedTableStepSpeed;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedoConsoleFrame
extends JmriJFrame
implements SpeedoListener,
ThrottleListener,
ProgListener,
PropertyChangeListener {
    protected JLabel scaleLabel = new JLabel();
    protected JLabel customScaleLabel = new JLabel();
    protected JTextField customScaleField = new JTextField(3);
    protected int customScale = 148;
    protected JTextField speedTextField = new JTextField(12);
    protected JPanel displayCards = new JPanel();
    protected ButtonGroup speedGroup = new ButtonGroup();
    protected JRadioButton mphButton = new JRadioButton(Bundle.getMessage("MPH"));
    protected JRadioButton kphButton = new JRadioButton(Bundle.getMessage("KPH"));
    protected ButtonGroup displayGroup = new ButtonGroup();
    protected JRadioButton numButton = new JRadioButton(Bundle.getMessage("Numeric"));
    protected JRadioButton dialButton = new JRadioButton(Bundle.getMessage("Dial"));
    protected SpeedoDial speedoDialDisplay = new SpeedoDial();
    protected JCheckBox dirFwdButton = new JCheckBox(Bundle.getMessage("ScanForward"));
    protected JCheckBox dirRevButton = new JCheckBox(Bundle.getMessage("ScanReverse"));
    protected JCheckBox toggleGridButton = new JCheckBox(Bundle.getMessage("ToggleGrid"));
    protected JLabel statusLabel = new JLabel(" ");
    protected JLabel readerLabel = new JLabel();
    protected static final int DEFAULT_SCALE = 8;
    protected float selectedScale = 0.0f;
    protected int series = 0;
    protected float sampleSpeed = 0.0f;
    protected float targetSpeed = 0.0f;
    protected float currentSpeed = 0.0f;
    protected float incSpeed = 0.0f;
    protected float oldSpeed = 0.0f;
    protected float acc = 0.0f;
    protected float avSpeed = 0.0f;
    protected int range = 1;
    protected float circ = 0.0f;
    protected float count = 1.0f;
    protected float freq;
    protected static final int DISPLAY_UPDATE = 500;
    protected static final int FAST_DISPLAY_RATIO = 5;
    protected static final int RANGE1LO = 0;
    protected static final int RANGE1HI = 9;
    protected static final int RANGE2LO = 7;
    protected static final int RANGE2HI = 31;
    protected static final int RANGE3LO = 29;
    protected static final int RANGE3HI = 62;
    protected static final int RANGE4LO = 58;
    protected static final int RANGE4HI = 9999;
    static final int[] FILTER_LENGTH = new int[]{0, 3, 6, 10, 20};
    String selectedScalePref = this.getClass().getName() + ".SelectedScale";
    String customScalePref = this.getClass().getName() + ".CustomScale";
    String speedUnitsKphPref = this.getClass().getName() + ".SpeedUnitsKph";
    String dialTypePref = this.getClass().getName() + ".DialType";
    UserPreferencesManager prefs;
    SpeedoTrafficController tc = null;
    protected String[] scaleStrings = new String[]{Bundle.getMessage("ScaleZ"), Bundle.getMessage("ScaleEuroN"), Bundle.getMessage("ScaleNFine"), Bundle.getMessage("ScaleJapaneseN"), Bundle.getMessage("ScaleBritishN"), Bundle.getMessage("Scale3mm"), Bundle.getMessage("ScaleTT"), Bundle.getMessage("Scale00"), Bundle.getMessage("ScaleH0"), Bundle.getMessage("ScaleS"), Bundle.getMessage("Scale048"), Bundle.getMessage("Scale045"), Bundle.getMessage("Scale043"), Bundle.getMessage("ScaleOther")};
    protected float[] scales = new float[]{220.0f, 160.0f, 152.0f, 150.0f, 148.0f, 120.0f, 101.6f, 76.0f, 87.0f, 64.0f, 48.0f, 45.0f, 43.0f, -1.0f};
    JComboBox<String> scaleList = new JComboBox<String>(this.scaleStrings);
    private SpeedoSystemConnectionMemo _memo = null;
    protected DisplayType display = DisplayType.NUMERIC;
    protected int dccServices;
    protected static final int BASIC = 0;
    protected static final int PROG = 1;
    protected static final int COMMAND = 2;
    protected static final int THROTTLE = 4;
    protected boolean timerRunning = false;
    protected ProgState progState = ProgState.IDLE;
    protected float throttleIncrement;
    protected Programmer prog = null;
    protected CommandStation commandStation = null;
    private PowerManager pm = null;
    protected JButton readAddressButton = new JButton(Bundle.getMessage("Read"));
    private final DccLocoAddressSelector addrSelector = new DccLocoAddressSelector();
    private JButton setButton;
    private GlobalRosterEntryComboBox rosterBox;
    protected RosterEntry rosterEntry;
    private final boolean disableRosterBoxActions = false;
    private DccLocoAddress locomotiveAddress = new DccLocoAddress(0, false);
    protected int readAddress = 0;
    protected SpinnerNumberModel accelerationSM = new SpinnerNumberModel(0, 0, 255, 1);
    protected SpinnerNumberModel decelerationSM = new SpinnerNumberModel(0, 0, 255, 1);
    protected JLabel accelerationLabel = new JLabel(Bundle.getMessage("MomentumAccelLabel"));
    protected JSpinner accelerationField = new JSpinner(this.accelerationSM);
    protected JLabel decelerationLabel = new JLabel(Bundle.getMessage("MomentumDecelLabel"));
    protected JSpinner decelerationField = new JSpinner(this.decelerationSM);
    protected JButton readMomentumButton = new JButton(Bundle.getMessage("MomentumReadBtn"));
    protected JButton setMomentumButton = new JButton(Bundle.getMessage("MomentumSetBtn"));
    protected JButton trackPowerButton = new JButton(Bundle.getMessage("PowerUp"));
    protected JButton startProfileButton = new JButton(Bundle.getMessage("Start"));
    protected JButton stopProfileButton = new JButton(Bundle.getMessage("Stop"));
    protected JButton exportProfileButton = new JButton(Bundle.getMessage("Export"));
    protected JButton printProfileButton = new JButton(Bundle.getMessage("Print"));
    protected JButton resetGraphButton = new JButton(Bundle.getMessage("ResetGraph"));
    protected JButton loadProfileButton = new JButton(Bundle.getMessage("LoadRef"));
    protected JTextField printTitleText = new JTextField();
    GraphPane profileGraphPane;
    protected DccSpeedProfile spFwd;
    protected DccSpeedProfile spRev;
    protected DccSpeedProfile spRef;
    protected ProfileDirection profileDir = ProfileDirection.FORWARD;
    protected DccThrottle throttle = null;
    protected int profileStep = 0;
    protected float profileSpeed;
    protected ProfileState profileState = ProfileState.IDLE;
    protected JLabel basicSpeedMatchInfo = new JLabel("<html><p>" + Bundle.getMessage("BasicSpeedMatchDescLine1") + "<br/><br/>" + Bundle.getMessage("BasicSpeedMatchDescLine2") + "<br/><br/>" + Bundle.getMessage("BasicSpeedMatchDescSettings") + "<br/><ul><li>" + Bundle.getMessage("BasicSpeedMatchDescDigitrax") + "</li><li>" + Bundle.getMessage("BasicSpeedMatchDescESU") + "</li><li>" + Bundle.getMessage("BasicSpeedMatchDescNCE") + "</li><li>" + Bundle.getMessage("BasicSpeedMatchDescSoundtraxx") + "</li></ul>" + Bundle.getMessage("BasicSpeedMatchDescLine3") + "<br/><br/>" + Bundle.getMessage("BasicSpeedMatchDescLine4") + "<br/><br/>" + Bundle.getMessage("BasicSpeedMatchDescLine5") + "<br/><br/></p></html>");
    protected ButtonGroup basicSpeedMatcherTypeGroup = new ButtonGroup();
    protected JRadioButton basicSimpleCVSpeedMatchButton = new JRadioButton(Bundle.getMessage("SpeedMatchSimpleCVRadio"));
    protected JRadioButton basicSpeedTableSpeedMatchButton = new JRadioButton(Bundle.getMessage("SpeedMatchSpeedTableRadio"));
    protected JRadioButton basicESUSpeedMatchButton = new JRadioButton(Bundle.getMessage("SpeedMatchESUSpeedTableRadio"));
    protected SpinnerNumberModel basicSpeedMatchWarmUpForwardSecondsSM = new SpinnerNumberModel(240, 0, 480, 1);
    protected SpinnerNumberModel basicSpeedMatchWarmUpReverseSecondsSM = new SpinnerNumberModel(120, 0, 480, 1);
    protected JCheckBox basicSpeedMatchReverseCheckbox = new JCheckBox(Bundle.getMessage("SpeedMatchTrimReverseChk"));
    protected JCheckBox basicSpeedMatchWarmUpCheckBox = new JCheckBox(Bundle.getMessage("SpeedMatchWarmUpChk"));
    protected JLabel basicSpeedMatchWarmUpForwardLabel = new JLabel(Bundle.getMessage("SpeedMatchForwardWarmUpLabel"));
    protected JSpinner basicSpeedMatchWarmUpForwardSeconds = new JSpinner(this.basicSpeedMatchWarmUpForwardSecondsSM);
    protected JLabel basicSpeedMatchWarmUpForwardUnit = new JLabel(Bundle.getMessage("SpeedMatchSecondsLabel"));
    protected JLabel basicSpeedMatchWarmUpReverseLabel = new JLabel(Bundle.getMessage("SpeedMatchReverseWarmUpLabel"));
    protected JSpinner basicSpeedMatchWarmUpReverseSeconds = new JSpinner(this.basicSpeedMatchWarmUpReverseSecondsSM);
    protected JLabel basicSpeedMatchWarmUpReverseUnit = new JLabel(Bundle.getMessage("SpeedMatchSecondsLabel"));
    protected JLabel basicSpeedMatchTargetStartSpeedLabel = new JLabel(Bundle.getMessage("BasioSpeedMatchStartSpeedLabel"));
    protected SpinnerNumberModel startSpeedSM = new SpinnerNumberModel(3, 1, 255, 1);
    protected JSpinner basicSpeedMatchTargetStartSpeedField = new JSpinner(this.startSpeedSM);
    protected JLabel basicSpeedMatchTargetStartSpeedUnit = new JLabel(Bundle.getMessage("SpeedMatchMPHLabel"));
    protected JLabel basicSpeedMatchTargetHighSpeedLabel = new JLabel(Bundle.getMessage("BasicSpeedMatchTopSpeedLabel"));
    protected SpinnerNumberModel highSpeedSM = new SpinnerNumberModel(55, 1, 255, 1);
    protected JSpinner basicSpeedMatchTargetHighSpeedField = new JSpinner(this.highSpeedSM);
    protected JLabel basicSpeedMatchTargetHighSpeedUnit = new JLabel(Bundle.getMessage("SpeedMatchMPHLabel"));
    protected JButton basicSpeedMatchStartStopButton = new JButton(Bundle.getMessage("SpeedMatchStartBtn"));
    protected JLabel speedStepScaleSpeedMatchInfo = new JLabel("<html><p>" + Bundle.getMessage("AdvancedSpeedMatchDescLine1") + "<br/><br/>" + Bundle.getMessage("AdvancedSpeedMatchDescLine2") + "<br/><br/>" + Bundle.getMessage("AdvancedSpeedMatchDescSettings") + "<br/><ul><li>" + Bundle.getMessage("AdvancedSpeedMatchDescDigitrax") + "</li><li>" + Bundle.getMessage("AdvancedSpeedMatchDescESU") + "</li><li>" + Bundle.getMessage("AdvancedSpeedMatchDescNCE") + "</li><li>" + Bundle.getMessage("AdvancedSpeedMatchDescSoundtraxx") + "</li></ul>" + Bundle.getMessage("AdvancedSpeedMatchDescLine3") + "<br/><br/>" + Bundle.getMessage("AdvancedSpeedMatchDescLine4") + "<br/><br/>" + Bundle.getMessage("AdvancedSpeedMatchDescLine5") + "<br/><br/>" + Bundle.getMessage("AdvancedSpeedMatchDescLine6") + "<br/><br/></p></html>");
    protected ButtonGroup speedStepScaleSpeedMatcherTypeGroup = new ButtonGroup();
    protected JRadioButton speedStepScaleSpeedTableSpeedMatchButton = new JRadioButton(Bundle.getMessage("SpeedMatchSpeedTableRadio"));
    protected JRadioButton speedStepScaleESUSpeedMatchButton = new JRadioButton(Bundle.getMessage("SpeedMatchESUSpeedTableRadio"));
    protected SpinnerNumberModel speedStepScaleSpeedMatchWarmUpForwardSecondsSM = new SpinnerNumberModel(240, 0, 480, 1);
    protected SpinnerNumberModel speedStepScaleSpeedMatchWarmUpReverseSecondsSM = new SpinnerNumberModel(120, 0, 480, 1);
    protected JCheckBox speedStepScaleSpeedMatchReverseCheckbox = new JCheckBox(Bundle.getMessage("SpeedMatchTrimReverseChk"));
    protected JCheckBox speedStepScaleSpeedMatchWarmUpCheckBox = new JCheckBox(Bundle.getMessage("SpeedMatchWarmUpChk"));
    protected JLabel speedStepScaleSpeedMatchWarmUpForwardLabel = new JLabel(Bundle.getMessage("SpeedMatchForwardWarmUpLabel"));
    protected JSpinner speedStepScaleSpeedMatchWarmUpForwardSeconds = new JSpinner(this.speedStepScaleSpeedMatchWarmUpForwardSecondsSM);
    protected JLabel speedStepScaleSpeedMatchWarmUpForwardUnit = new JLabel(Bundle.getMessage("SpeedMatchSecondsLabel"));
    protected JLabel speedStepScaleSpeedMatchWarmUpReverseLabel = new JLabel(Bundle.getMessage("SpeedMatchReverseWarmUpLabel"));
    protected JSpinner speedStepScaleSpeedMatchWarmUpReverseSeconds = new JSpinner(this.speedStepScaleSpeedMatchWarmUpReverseSecondsSM);
    protected JLabel speedStepScaleSpeedMatchWarmUpReverseUnit = new JLabel(Bundle.getMessage("SpeedMatchSecondsLabel"));
    protected JLabel speedStepScaleMaxSpeedTargetLabel = new JLabel(Bundle.getMessage("AdvancedSpeedMatchMaxSpeed"));
    private final JComboBox<SpeedTableStepSpeed> speedStepScaleSpeedMatchMaxSpeedField = new JComboBox();
    protected JLabel speedStepScaleSpeedMatchMaxSpeedUnit = new JLabel(Bundle.getMessage("SpeedMatchMPHLabel"));
    protected JButton speedStepScaleSpeedMatchStartStopButton = new JButton(Bundle.getMessage("SpeedMatchStartBtn"));
    protected JLabel speedStepScaleMaxSpeedActualLabel = new JLabel(Bundle.getMessage("AdvancedSpeedMatchActualMaxSpeed"), 4);
    protected JLabel speedStepScaleMaxSpeedActualField = new JLabel("___");
    protected JLabel speedStepScaleMaxSpeedActualUnit = new JLabel(Bundle.getMessage("SpeedMatchMPHLabel"));
    protected SpeedMatcher speedMatcher;
    protected static final int SPEED_TEST_SCALE_FACTOR = 1;
    Timer profileTimer = null;
    Timer replyTimer = null;
    Timer displayTimer = null;
    Timer fastDisplayTimer = null;
    private static final Logger log = LoggerFactory.getLogger(SpeedoConsoleFrame.class);

    public SpeedoConsoleFrame(SpeedoSystemConnectionMemo memo) {
        this._memo = memo;
    }

    protected String title() {
        return Bundle.getMessage("SpeedoConsole");
    }

    private void setTitle() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE d MMM yyyy", Locale.getDefault());
        Date today = new Date();
        String result = formatter.format(today);
        String annotate = Bundle.getMessage("ProfileFor") + " " + this.locomotiveAddress.getNumber() + " " + Bundle.getMessage("CreatedOn") + " " + result;
        this.printTitleText.setText(annotate);
    }

    @Override
    public void dispose() {
        if (this.prefs != null) {
            this.prefs.setComboBoxLastSelection(this.selectedScalePref, (String)this.scaleList.getSelectedItem());
            this.prefs.setProperty(this.customScalePref, "customScale", this.customScale);
            this.prefs.setSimplePreferenceState(this.speedUnitsKphPref, this.kphButton.isSelected());
            this.prefs.setSimplePreferenceState(this.dialTypePref, this.dialButton.isSelected());
        }
        this._memo.getTrafficController().removeSpeedoListener(this);
        super.dispose();
    }

    @Override
    public void initComponents() {
        this.prefs = InstanceManager.getDefault(UserPreferencesManager.class);
        this.setTitle(this.title());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.dccServices = 0;
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) != null && InstanceManager.getDefault(GlobalProgrammerManager.class).isGlobalProgrammerAvailable()) {
            this.prog = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
            this.dccServices |= 1;
        }
        if (InstanceManager.getNullableDefault(ThrottleManager.class) != null) {
            log.info("Using Throttle interface for profiling");
            this.dccServices |= 4;
        }
        if (InstanceManager.getNullableDefault(PowerManager.class) != null) {
            this.pm = InstanceManager.getDefault(PowerManager.class);
            this.pm.addPropertyChangeListener(this);
        }
        JPanel basicPane = new JPanel();
        basicPane.setLayout(new BoxLayout(basicPane, 1));
        JPanel scalePanel = new JPanel();
        scalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SelectScale")));
        scalePanel.setLayout(new FlowLayout());
        this.scaleList.setToolTipText(Bundle.getMessage("SelectScaleToolTip"));
        String lastSelectedScale = this.prefs.getComboBoxLastSelection(this.selectedScalePref);
        if (lastSelectedScale != null && !lastSelectedScale.equals("")) {
            try {
                this.scaleList.setSelectedItem(lastSelectedScale);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                this.scaleList.setSelectedIndex(8);
            }
        } else {
            this.scaleList.setSelectedIndex(8);
        }
        if (this.scaleList.getSelectedIndex() > -1) {
            this.selectedScale = this.scales[this.scaleList.getSelectedIndex()];
        }
        this.scaleList.addActionListener(e -> {
            this.selectedScale = this.scales[this.scaleList.getSelectedIndex()];
            this.checkCustomScale();
        });
        this.scaleLabel.setText(Bundle.getMessage("Scale"));
        this.scaleLabel.setVisible(true);
        this.readerLabel.setText(Bundle.getMessage("UnknownReader"));
        this.readerLabel.setVisible(true);
        scalePanel.add(this.scaleLabel);
        scalePanel.add(this.scaleList);
        scalePanel.add(this.readerLabel);
        JPanel customScalePanel = new JPanel();
        customScalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CustomScale")));
        customScalePanel.setLayout(new FlowLayout());
        this.customScaleLabel.setText("1: ");
        this.customScaleLabel.setVisible(true);
        this.customScaleField.setVisible(true);
        try {
            this.customScaleField.setText(this.prefs.getProperty(this.customScalePref, "customScale").toString());
        }
        catch (NullPointerException npe) {
            this.customScaleField.setText("1");
        }
        this.checkCustomScale();
        this.getCustomScale();
        this.customScaleField.addActionListener(e -> this.getCustomScale());
        customScalePanel.add(this.customScaleLabel);
        customScalePanel.add(this.customScaleField);
        basicPane.add(scalePanel);
        basicPane.add(customScalePanel);
        JPanel speedPanel = new JPanel();
        speedPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("MeasuredSpeed")));
        speedPanel.setLayout(new BoxLayout(speedPanel, 0));
        this.displayCards.setLayout(new CardLayout());
        JPanel numericSpeedPanel = new JPanel();
        numericSpeedPanel.setLayout(new BoxLayout(numericSpeedPanel, 0));
        Font f = new Font("", 0, 96);
        this.speedTextField.setFont(f);
        this.speedTextField.setHorizontalAlignment(4);
        this.speedTextField.setColumns(3);
        this.speedTextField.setText("0.0");
        this.speedTextField.setVisible(true);
        this.speedTextField.setToolTipText(Bundle.getMessage("SpeedHere"));
        numericSpeedPanel.add(this.speedTextField);
        JPanel dialSpeedPanel = new JPanel();
        dialSpeedPanel.setLayout(new BoxLayout(dialSpeedPanel, 0));
        dialSpeedPanel.add(this.speedoDialDisplay);
        this.speedoDialDisplay.update(0.0f);
        this.displayCards.add((Component)dialSpeedPanel, "DIAL");
        this.displayCards.add((Component)numericSpeedPanel, "NUMERIC");
        CardLayout cl = (CardLayout)this.displayCards.getLayout();
        cl.show(this.displayCards, "DIAL");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.speedGroup.add(this.mphButton);
        this.speedGroup.add(this.kphButton);
        this.mphButton.setToolTipText(Bundle.getMessage("TTDisplayMPH"));
        this.kphButton.setToolTipText(Bundle.getMessage("TTDisplayKPH"));
        this.mphButton.setSelected(!this.prefs.getSimplePreferenceState(this.speedUnitsKphPref));
        this.kphButton.setSelected(this.prefs.getSimplePreferenceState(this.speedUnitsKphPref));
        this.displayGroup.add(this.numButton);
        this.displayGroup.add(this.dialButton);
        this.numButton.setToolTipText(Bundle.getMessage("TTDisplayNumeric"));
        this.dialButton.setToolTipText(Bundle.getMessage("TTDisplayDial"));
        this.numButton.setSelected(!this.prefs.getSimplePreferenceState(this.dialTypePref));
        this.dialButton.setSelected(this.prefs.getSimplePreferenceState(this.dialTypePref));
        buttonPanel.add(this.mphButton);
        buttonPanel.add(this.kphButton);
        buttonPanel.add(this.numButton);
        buttonPanel.add(this.dialButton);
        speedPanel.add(this.displayCards);
        speedPanel.add(buttonPanel);
        this.mphButton.addActionListener(e -> this.setUnits());
        this.kphButton.addActionListener(e -> this.setUnits());
        this.numButton.addActionListener(e -> this.setDial());
        this.dialButton.addActionListener(e -> this.setDial());
        basicPane.add(speedPanel);
        JPanel profileAndSpeedMatchingPane = new JPanel();
        profileAndSpeedMatchingPane.setLayout(new BorderLayout());
        JPanel addrPane = new JPanel();
        GridBagLayout gLayout = new GridBagLayout();
        GridBagConstraints gConstraints = new GridBagConstraints();
        gConstraints.insets = new Insets(3, 3, 3, 3);
        Border addrPaneBorder = BorderFactory.createEtchedBorder();
        TitledBorder addrPaneTitle = BorderFactory.createTitledBorder(addrPaneBorder, Bundle.getMessage("LocoSelection"));
        addrPane.setLayout(gLayout);
        addrPane.setBorder(addrPaneTitle);
        this.setButton = new JButton(Bundle.getMessage("ButtonSet"));
        this.setButton.addActionListener(e -> this.changeOfAddress());
        this.addrSelector.setAddress(null);
        this.rosterBox = new GlobalRosterEntryComboBox();
        this.rosterBox.setNonSelectedItem(Bundle.getMessage("NoLocoSelected"));
        this.rosterBox.setToolTipText(Bundle.getMessage("TTSelectLocoFromRoster"));
        this.rosterBox.addPropertyChangeListener("selectedRosterEntries", pce -> this.rosterItemSelected());
        this.readAddressButton.setToolTipText(Bundle.getMessage("ReadLoco"));
        addrPane.add((Component)this.addrSelector.getCombinedJPanel(), gConstraints);
        addrPane.add((Component)new JLabel(" "), gConstraints);
        addrPane.add((Component)this.setButton, gConstraints);
        addrPane.add((Component)new JLabel(" "), gConstraints);
        addrPane.add((Component)this.rosterBox, gConstraints);
        addrPane.add((Component)new JLabel(" "), gConstraints);
        addrPane.add((Component)this.readAddressButton, gConstraints);
        if ((this.dccServices & 1) != 1) {
            this.readAddressButton.setEnabled(false);
            this.readMomentumButton.setEnabled(false);
        } else {
            this.readAddressButton.setEnabled(true);
            this.readMomentumButton.setEnabled(true);
        }
        this.readAddressButton.addActionListener(e -> this.readAddress());
        JPanel momentumPane = new JPanel();
        momentumPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("MomentumTitle")));
        momentumPane.setLayout(new FlowLayout());
        momentumPane.add(this.accelerationLabel);
        momentumPane.add(this.accelerationField);
        momentumPane.add(this.decelerationLabel);
        momentumPane.add(this.decelerationField);
        momentumPane.add(this.readMomentumButton);
        momentumPane.add(this.setMomentumButton);
        this.readMomentumButton.addActionListener(e -> this.readMomentum());
        this.setMomentumButton.addActionListener(e -> this.setMomentum());
        JPanel profileAndSpeedMatchingNorthPane = new JPanel();
        profileAndSpeedMatchingNorthPane.setLayout(new BoxLayout(profileAndSpeedMatchingNorthPane, 1));
        profileAndSpeedMatchingNorthPane.add(addrPane);
        profileAndSpeedMatchingNorthPane.add(momentumPane);
        profileAndSpeedMatchingPane.add((Component)profileAndSpeedMatchingNorthPane, "North");
        JTabbedPane profileAndSpeedMatchingTabs = new JTabbedPane();
        GridBagConstraints row1 = new GridBagConstraints();
        row1.anchor = 17;
        row1.fill = 2;
        GridBagConstraints row2 = new GridBagConstraints();
        row2.gridy = 1;
        row2.anchor = 13;
        GridBagConstraints row3 = new GridBagConstraints();
        row3.gridy = 2;
        row3.anchor = 17;
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel profilePane = new JPanel();
        profilePane.setLayout(new BorderLayout());
        this.spFwd = new DccSpeedProfile(29);
        this.spRev = new DccSpeedProfile(29);
        this.spRef = new DccSpeedProfile(29);
        this.profileGraphPane = new GraphPane(this.spFwd, this.spRev, this.spRef);
        this.profileGraphPane.setPreferredSize(new Dimension(600, 300));
        this.profileGraphPane.setXLabel(Bundle.getMessage("SpeedStep"));
        this.profileGraphPane.setUnitsMph();
        profilePane.add((Component)this.profileGraphPane, "Center");
        JPanel profileButtonPane = new JPanel();
        profileButtonPane.setLayout(new FlowLayout());
        profileButtonPane.add(this.trackPowerButton);
        this.trackPowerButton.setToolTipText(Bundle.getMessage("TTPower"));
        profileButtonPane.add(this.startProfileButton);
        this.startProfileButton.setToolTipText(Bundle.getMessage("TTStartProfile"));
        profileButtonPane.add(this.stopProfileButton);
        this.stopProfileButton.setToolTipText(Bundle.getMessage("TTStopProfile"));
        profileButtonPane.add(this.exportProfileButton);
        this.exportProfileButton.setToolTipText(Bundle.getMessage("TTSaveProfile"));
        profileButtonPane.add(this.printProfileButton);
        this.printProfileButton.setToolTipText(Bundle.getMessage("TTPrintProfile"));
        profileButtonPane.add(this.resetGraphButton);
        this.resetGraphButton.setToolTipText(Bundle.getMessage("TTResetGraph"));
        profileButtonPane.add(this.loadProfileButton);
        this.loadProfileButton.setToolTipText(Bundle.getMessage("TTLoadProfile"));
        JPanel titlePane = new JPanel();
        titlePane.setLayout(new BoxLayout(titlePane, 0));
        titlePane.setBorder(new EmptyBorder(3, 0, 3, 0));
        this.printTitleText.setToolTipText(Bundle.getMessage("TTPrintTitle"));
        this.printTitleText.setText(Bundle.getMessage("TTText1"));
        titlePane.add(this.printTitleText);
        JPanel profileSouthPane = new JPanel();
        profileSouthPane.setLayout(new BoxLayout(profileSouthPane, 1));
        profileSouthPane.add(profileButtonPane);
        profileSouthPane.add(titlePane);
        profilePane.add((Component)profileSouthPane, "South");
        JPanel profileControlPane = new JPanel();
        profileControlPane.setLayout(new BoxLayout(profileControlPane, 1));
        this.dirFwdButton.setSelected(true);
        this.dirFwdButton.setToolTipText(Bundle.getMessage("TTMeasFwd"));
        this.dirRevButton.setToolTipText(Bundle.getMessage("TTMeasRev"));
        this.dirFwdButton.setForeground(Color.RED);
        this.dirRevButton.setForeground(Color.BLUE);
        profileControlPane.add(this.dirFwdButton);
        profileControlPane.add(this.dirRevButton);
        this.toggleGridButton.setSelected(true);
        profileControlPane.add(this.toggleGridButton);
        this.profileGraphPane.showGrid(this.toggleGridButton.isSelected());
        profilePane.add((Component)profileControlPane, "East");
        profileAndSpeedMatchingTabs.addTab("Speed Profile", profilePane);
        this.trackPowerButton.addActionListener(e -> this.trackPower());
        this.startProfileButton.addActionListener(e -> {
            this.getCustomScale();
            this.startProfile();
        });
        this.stopProfileButton.addActionListener(e -> this.stopProfileAndSpeedMatch());
        this.toggleGridButton.addActionListener(e -> {
            this.profileGraphPane.showGrid(this.toggleGridButton.isSelected());
            this.profileGraphPane.repaint();
        });
        this.exportProfileButton.addActionListener(e -> {
            if (this.dirFwdButton.isSelected() && this.dirRevButton.isSelected()) {
                DccSpeedProfile[] sp = new DccSpeedProfile[]{this.spFwd, this.spRev};
                DccSpeedProfile.export(sp, this.locomotiveAddress.getNumber(), this.profileGraphPane.getUnits());
            } else if (this.dirFwdButton.isSelected()) {
                DccSpeedProfile.export(this.spFwd, this.locomotiveAddress.getNumber(), "fwd", this.profileGraphPane.getUnits());
            } else if (this.dirRevButton.isSelected()) {
                DccSpeedProfile.export(this.spRev, this.locomotiveAddress.getNumber(), "rev", this.profileGraphPane.getUnits());
            }
        });
        this.printProfileButton.addActionListener(e -> this.profileGraphPane.printProfile(this.printTitleText.getText()));
        this.resetGraphButton.addActionListener(e -> {
            this.spFwd.clear();
            this.spRev.clear();
            this.spRef.clear();
            this.speedoDialDisplay.reset();
            this.profileGraphPane.repaint();
        });
        this.loadProfileButton.addActionListener(e -> {
            this.spRef.clear();
            int response = this.spRef.importDccProfile(this.profileGraphPane.getUnits());
            if (response == -1) {
                this.statusLabel.setText(Bundle.getMessage("StatFileError"));
            } else {
                this.statusLabel.setText(Bundle.getMessage("StatFileSuccess"));
            }
            this.profileGraphPane.repaint();
        });
        this.basicSpeedMatcherTypeGroup.add(this.basicSimpleCVSpeedMatchButton);
        this.basicSpeedMatcherTypeGroup.add(this.basicSpeedTableSpeedMatchButton);
        this.basicSpeedMatcherTypeGroup.add(this.basicESUSpeedMatchButton);
        this.basicSimpleCVSpeedMatchButton.setSelected(true);
        this.basicSpeedMatchReverseCheckbox.setSelected(true);
        this.basicSpeedMatchWarmUpCheckBox.setSelected(true);
        JPanel basicSpeedMatcherPane = new JPanel();
        basicSpeedMatcherPane.setLayout(new BorderLayout());
        JPanel basicSpeedMatchSettingsPane = new JPanel();
        basicSpeedMatchSettingsPane.setLayout(new BoxLayout(basicSpeedMatchSettingsPane, 3));
        JPanel basicSpeedMatchImportantInfoPane = new JPanel();
        basicSpeedMatchImportantInfoPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SpeedMatchDescTitle")));
        basicSpeedMatchImportantInfoPane.setLayout(new BoxLayout(basicSpeedMatchImportantInfoPane, 2));
        basicSpeedMatchImportantInfoPane.add(this.basicSpeedMatchInfo);
        basicSpeedMatchSettingsPane.add(basicSpeedMatchImportantInfoPane);
        JPanel basicSpeedMatchModePane = new JPanel();
        basicSpeedMatchModePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SpeedMatchModeTitle")));
        basicSpeedMatchModePane.setLayout(new FlowLayout());
        basicSpeedMatchModePane.add(this.basicSimpleCVSpeedMatchButton);
        basicSpeedMatchModePane.add(this.basicSpeedTableSpeedMatchButton);
        basicSpeedMatchModePane.add(this.basicESUSpeedMatchButton);
        basicSpeedMatchSettingsPane.add(basicSpeedMatchModePane);
        JPanel basicSpeedMatchOtherSettingsPane = new JPanel();
        basicSpeedMatchOtherSettingsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SpeedMatchOtherSettingTitle")));
        basicSpeedMatchOtherSettingsPane.setLayout(new GridBagLayout());
        basicSpeedMatchOtherSettingsPane.add((Component)this.basicSpeedMatchWarmUpCheckBox, row1);
        basicSpeedMatchOtherSettingsPane.add((Component)this.basicSpeedMatchWarmUpForwardLabel, row2);
        basicSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(5, 0)), row2);
        basicSpeedMatchOtherSettingsPane.add((Component)this.basicSpeedMatchWarmUpForwardSeconds, row2);
        basicSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(5, 0)), row2);
        basicSpeedMatchOtherSettingsPane.add((Component)this.basicSpeedMatchWarmUpForwardUnit, row2);
        basicSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(30, 0)), row2);
        basicSpeedMatchOtherSettingsPane.add((Component)this.basicSpeedMatchWarmUpReverseLabel, row2);
        basicSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(5, 0)), row2);
        basicSpeedMatchOtherSettingsPane.add((Component)this.basicSpeedMatchWarmUpReverseSeconds, row2);
        basicSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(5, 0)), row2);
        basicSpeedMatchOtherSettingsPane.add((Component)this.basicSpeedMatchWarmUpReverseUnit, row2);
        basicSpeedMatchOtherSettingsPane.add((Component)this.basicSpeedMatchReverseCheckbox, row3);
        basicSpeedMatchSettingsPane.add(basicSpeedMatchOtherSettingsPane);
        JPanel basicSpeedMatchSpeedPane = new JPanel();
        basicSpeedMatchSpeedPane.setLayout(new GridBagLayout());
        basicSpeedMatchSpeedPane.add((Component)this.basicSpeedMatchTargetStartSpeedLabel, gbc);
        basicSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(5, 0)), gbc);
        basicSpeedMatchSpeedPane.add((Component)this.basicSpeedMatchTargetStartSpeedField, gbc);
        basicSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(5, 0)), gbc);
        basicSpeedMatchSpeedPane.add((Component)this.basicSpeedMatchTargetStartSpeedUnit, gbc);
        basicSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(15, 0)), gbc);
        basicSpeedMatchSpeedPane.add((Component)this.basicSpeedMatchTargetHighSpeedLabel, gbc);
        basicSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(5, 0)), gbc);
        basicSpeedMatchSpeedPane.add((Component)this.basicSpeedMatchTargetHighSpeedField, gbc);
        basicSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(5, 0)), gbc);
        basicSpeedMatchSpeedPane.add((Component)this.basicSpeedMatchTargetHighSpeedUnit, gbc);
        basicSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(15, 0)), gbc);
        basicSpeedMatchSpeedPane.add((Component)this.basicSpeedMatchStartStopButton, gbc);
        basicSpeedMatcherPane.add((Component)basicSpeedMatchSettingsPane, "North");
        basicSpeedMatcherPane.add((Component)basicSpeedMatchSpeedPane, "Center");
        profileAndSpeedMatchingTabs.add(Bundle.getMessage("BasicSpeedMatchTab"), basicSpeedMatcherPane);
        this.basicSpeedMatchStartStopButton.addActionListener(e -> {
            if ((this.speedMatcher == null || this.speedMatcher.isSpeedMatcherIdle()) && this.profileState == ProfileState.IDLE) {
                int targetStartSpeed = this.startSpeedSM.getNumber().intValue();
                int targetHighSpeed = this.highSpeedSM.getNumber().intValue();
                BasicSpeedMatcherConfig.SpeedTable speedTableType = this.basicSpeedTableSpeedMatchButton.isSelected() ? BasicSpeedMatcherConfig.SpeedTable.ADVANCED : (this.basicESUSpeedMatchButton.isSelected() ? BasicSpeedMatcherConfig.SpeedTable.ESU : BasicSpeedMatcherConfig.SpeedTable.SIMPLE);
                boolean speedMatchReverse = this.basicSpeedMatchReverseCheckbox.isSelected();
                boolean warmUpLoco = this.basicSpeedMatchWarmUpCheckBox.isSelected();
                int warmUpForwardSeconds = this.basicSpeedMatchWarmUpForwardSecondsSM.getNumber().intValue();
                int warmUpReverseSeconds = this.basicSpeedMatchWarmUpReverseSecondsSM.getNumber().intValue();
                this.speedMatcher = BasicSpeedMatcherFactory.getSpeedMatcher(speedTableType, new BasicSpeedMatcherConfig(this.locomotiveAddress, targetStartSpeed, targetHighSpeed, this.mphButton.isSelected() ? Speed.Unit.MPH : Speed.Unit.KPH, speedMatchReverse, warmUpLoco ? warmUpForwardSeconds : 0, warmUpLoco ? warmUpReverseSeconds : 0, this.pm, this.statusLabel, this.basicSpeedMatchStartStopButton));
                if (!this.speedMatcher.startSpeedMatcher()) {
                    this.speedMatcher = null;
                }
            } else {
                this.stopProfileAndSpeedMatch();
            }
        });
        this.basicSpeedMatchWarmUpCheckBox.addActionListener(e -> {
            boolean enableWarmUp = this.basicSpeedMatchWarmUpCheckBox.isSelected();
            this.basicSpeedMatchWarmUpForwardLabel.setEnabled(enableWarmUp);
            this.basicSpeedMatchWarmUpForwardSeconds.setEnabled(enableWarmUp);
            this.basicSpeedMatchWarmUpForwardUnit.setEnabled(enableWarmUp);
            this.basicSpeedMatchWarmUpReverseLabel.setEnabled(enableWarmUp);
            this.basicSpeedMatchWarmUpReverseSeconds.setEnabled(enableWarmUp);
            this.basicSpeedMatchWarmUpReverseUnit.setEnabled(enableWarmUp);
        });
        this.speedStepScaleSpeedMatcherTypeGroup.add(this.speedStepScaleSpeedTableSpeedMatchButton);
        this.speedStepScaleSpeedMatcherTypeGroup.add(this.speedStepScaleESUSpeedMatchButton);
        this.speedStepScaleSpeedTableSpeedMatchButton.setSelected(true);
        this.speedStepScaleSpeedMatchReverseCheckbox.setSelected(true);
        this.speedStepScaleSpeedMatchWarmUpCheckBox.setSelected(true);
        JPanel speedStepScaleSpeedMatcherPane = new JPanel();
        speedStepScaleSpeedMatcherPane.setLayout(new BorderLayout());
        JPanel speedStepScaleSpeedMatchSettingsPane = new JPanel();
        speedStepScaleSpeedMatchSettingsPane.setLayout(new BoxLayout(speedStepScaleSpeedMatchSettingsPane, 3));
        JPanel speedStepScaleSpeedMatchImportantInfoPane = new JPanel();
        speedStepScaleSpeedMatchImportantInfoPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SpeedMatchDescTitle")));
        speedStepScaleSpeedMatchImportantInfoPane.setLayout(new BoxLayout(speedStepScaleSpeedMatchImportantInfoPane, 2));
        speedStepScaleSpeedMatchImportantInfoPane.add(this.speedStepScaleSpeedMatchInfo);
        speedStepScaleSpeedMatchSettingsPane.add(speedStepScaleSpeedMatchImportantInfoPane);
        JPanel speedStepScaleSpeedMatchModePane = new JPanel();
        speedStepScaleSpeedMatchModePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SpeedMatchModeTitle")));
        speedStepScaleSpeedMatchModePane.setLayout(new FlowLayout());
        speedStepScaleSpeedMatchModePane.add(this.speedStepScaleSpeedTableSpeedMatchButton);
        speedStepScaleSpeedMatchModePane.add(this.speedStepScaleESUSpeedMatchButton);
        speedStepScaleSpeedMatchSettingsPane.add(speedStepScaleSpeedMatchModePane);
        JPanel speedStepScaleSpeedMatchOtherSettingsPane = new JPanel();
        speedStepScaleSpeedMatchOtherSettingsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SpeedMatchOtherSettingTitle")));
        speedStepScaleSpeedMatchOtherSettingsPane.setLayout(new GridBagLayout());
        speedStepScaleSpeedMatchOtherSettingsPane.add((Component)this.speedStepScaleSpeedMatchWarmUpCheckBox, row1);
        speedStepScaleSpeedMatchOtherSettingsPane.add((Component)this.speedStepScaleSpeedMatchWarmUpForwardLabel, row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(5, 0)), row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add((Component)this.speedStepScaleSpeedMatchWarmUpForwardSeconds, row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(5, 0)), row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add((Component)this.speedStepScaleSpeedMatchWarmUpForwardUnit, row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(30, 0)), row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add((Component)this.speedStepScaleSpeedMatchWarmUpReverseLabel, row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(5, 0)), row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add((Component)this.speedStepScaleSpeedMatchWarmUpReverseSeconds, row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add(Box.createRigidArea(new Dimension(5, 0)), row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add((Component)this.speedStepScaleSpeedMatchWarmUpReverseUnit, row2);
        speedStepScaleSpeedMatchOtherSettingsPane.add((Component)this.speedStepScaleSpeedMatchReverseCheckbox, row3);
        speedStepScaleSpeedMatchSettingsPane.add(speedStepScaleSpeedMatchOtherSettingsPane);
        for (SpeedMatcher.SpeedTableStep tempStep = SpeedMatcher.SpeedTableStep.STEP1; tempStep != null; tempStep = tempStep.getNext()) {
            this.speedStepScaleSpeedMatchMaxSpeedField.addItem(new SpeedTableStepSpeed(tempStep));
        }
        this.speedStepScaleSpeedMatchMaxSpeedField.setSelectedIndex(12);
        JPanel speedStepScaleSpeedMatchSpeedPane = new JPanel();
        speedStepScaleSpeedMatchSpeedPane.setLayout(new GridBagLayout());
        speedStepScaleSpeedMatchSpeedPane.add((Component)this.speedStepScaleMaxSpeedTargetLabel, gbc);
        speedStepScaleSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(5, 0)), gbc);
        speedStepScaleSpeedMatchSpeedPane.add(this.speedStepScaleSpeedMatchMaxSpeedField, gbc);
        speedStepScaleSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(5, 0)), gbc);
        speedStepScaleSpeedMatchSpeedPane.add((Component)this.speedStepScaleSpeedMatchMaxSpeedUnit, gbc);
        speedStepScaleSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(15, 0)), gbc);
        speedStepScaleSpeedMatchSpeedPane.add((Component)this.speedStepScaleSpeedMatchStartStopButton, gbc);
        speedStepScaleSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(15, 0)), gbc);
        speedStepScaleSpeedMatchSpeedPane.add((Component)this.speedStepScaleMaxSpeedActualLabel, gbc);
        speedStepScaleSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(5, 0)), gbc);
        speedStepScaleSpeedMatchSpeedPane.add((Component)this.speedStepScaleMaxSpeedActualField, gbc);
        speedStepScaleSpeedMatchSpeedPane.add(Box.createRigidArea(new Dimension(5, 0)), gbc);
        speedStepScaleSpeedMatchSpeedPane.add((Component)this.speedStepScaleMaxSpeedActualUnit, gbc);
        speedStepScaleSpeedMatcherPane.add((Component)speedStepScaleSpeedMatchSettingsPane, "North");
        speedStepScaleSpeedMatcherPane.add((Component)speedStepScaleSpeedMatchSpeedPane, "Center");
        profileAndSpeedMatchingTabs.add(Bundle.getMessage("AdvancedSpeedMatchTab"), speedStepScaleSpeedMatcherPane);
        this.speedStepScaleSpeedMatchStartStopButton.addActionListener(e -> {
            if ((this.speedMatcher == null || this.speedMatcher.isSpeedMatcherIdle()) && this.profileState == ProfileState.IDLE) {
                SpeedTableStepSpeed targetMaxSpeedStep = (SpeedTableStepSpeed)this.speedStepScaleSpeedMatchMaxSpeedField.getSelectedItem();
                SpeedStepScaleSpeedMatcherConfig.SpeedTable speedTableType = this.speedStepScaleESUSpeedMatchButton.isSelected() ? SpeedStepScaleSpeedMatcherConfig.SpeedTable.ESU : SpeedStepScaleSpeedMatcherConfig.SpeedTable.ADVANCED;
                boolean speedMatchReverse = this.speedStepScaleSpeedMatchReverseCheckbox.isSelected();
                boolean warmUpLoco = this.speedStepScaleSpeedMatchWarmUpCheckBox.isSelected();
                int warmUpForwardSeconds = this.speedStepScaleSpeedMatchWarmUpForwardSecondsSM.getNumber().intValue();
                int warmUpReverseSeconds = this.speedStepScaleSpeedMatchWarmUpReverseSecondsSM.getNumber().intValue();
                this.speedMatcher = SpeedStepScaleSpeedMatcherFactory.getSpeedMatcher(speedTableType, new SpeedStepScaleSpeedMatcherConfig(this.locomotiveAddress, targetMaxSpeedStep, this.mphButton.isSelected() ? Speed.Unit.MPH : Speed.Unit.KPH, speedMatchReverse, warmUpLoco ? warmUpForwardSeconds : 0, warmUpLoco ? warmUpReverseSeconds : 0, this.pm, this.statusLabel, this.speedStepScaleMaxSpeedActualField, this.speedStepScaleSpeedMatchStartStopButton));
                if (!this.speedMatcher.startSpeedMatcher()) {
                    this.speedMatcher = null;
                }
            } else {
                this.stopProfileAndSpeedMatch();
            }
        });
        this.speedStepScaleSpeedMatchWarmUpCheckBox.addActionListener(e -> {
            boolean enableWarmUp = this.speedStepScaleSpeedMatchWarmUpCheckBox.isSelected();
            this.speedStepScaleSpeedMatchWarmUpForwardLabel.setEnabled(enableWarmUp);
            this.speedStepScaleSpeedMatchWarmUpForwardSeconds.setEnabled(enableWarmUp);
            this.speedStepScaleSpeedMatchWarmUpForwardUnit.setEnabled(enableWarmUp);
            this.speedStepScaleSpeedMatchWarmUpReverseLabel.setEnabled(enableWarmUp);
            this.speedStepScaleSpeedMatchWarmUpReverseSeconds.setEnabled(enableWarmUp);
            this.speedStepScaleSpeedMatchWarmUpReverseUnit.setEnabled(enableWarmUp);
        });
        profileAndSpeedMatchingPane.add((Component)profileAndSpeedMatchingTabs, "Center");
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BoxLayout(mainPane, 0));
        mainPane.add(basicPane);
        if ((this.dccServices & 4) == 4 || (this.dccServices & 2) == 2) {
            mainPane.add(profileAndSpeedMatchingPane);
        } else {
            log.info("{} Connection:{}", (Object)Bundle.getMessage("StatNoDCC"), (Object)this._memo.getUserName());
            this.statusLabel.setText(Bundle.getMessage("StatNoDCC"));
        }
        this.addHelpMenu("package.jmri.jmrix.bachrus.SpeedoConsoleFrame", true);
        JPanel statusWrapper = new JPanel();
        statusWrapper.setLayout(new BorderLayout());
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.add((Component)this.statusLabel, "West");
        statusPanel.setBorder(BorderFactory.createEtchedBorder(0));
        statusWrapper.add((Component)mainPane, "Center");
        statusWrapper.add((Component)statusPanel, "South");
        this.getContentPane().add(statusWrapper);
        this.tc = this._memo.getTrafficController();
        this.tc.addSpeedoListener(this);
        this.setUnits();
        this.setDial();
        this.pack();
        this.speedoDialDisplay.scaleFace();
    }

    @Override
    public synchronized void reply(SpeedoReply l) {
        this.count = l.getCount();
        this.series = l.getSeries();
        if (this.count > 0.0f) {
            switch (this.series) {
                case 4: {
                    this.circ = 12.5664f;
                    this.readerLabel.setText(Bundle.getMessage("Reader40"));
                    break;
                }
                case 5: {
                    this.circ = 18.8496f;
                    this.readerLabel.setText(Bundle.getMessage("Reader50"));
                    break;
                }
                case 6: {
                    this.circ = 50.2655f;
                    this.readerLabel.setText(Bundle.getMessage("Reader60"));
                    break;
                }
                case 103: {
                    this.circ = 21.519909f;
                    this.readerLabel.setText(Bundle.getMessage("Reader103"));
                    break;
                }
                case 200: {
                    this.circ = 12.5664f;
                    this.readerLabel.setText(Bundle.getMessage("Reader200"));
                    break;
                }
                default: {
                    this.speedTextField.setText(Bundle.getMessage("ReaderErr"));
                    log.error("Invalid reader type");
                }
            }
            this.calcSpeed();
        }
        if (!this.timerRunning) {
            this.startReplyTimer();
            this.startDisplayTimer();
            this.startFastDisplayTimer();
            this.timerRunning = true;
        } else {
            this.replyTimer.restart();
        }
    }

    protected void calcSpeed() {
        float thisScale;
        float f = thisScale = this.selectedScale == -1.0f ? (float)this.customScale : this.selectedScale;
        if (this.series == 103) {
            this.avSpeed = this.sampleSpeed = (float)((double)this.count / 8.0 * (double)this.circ * 3600.0 / 1000000.0 * (double)thisScale * 1.0);
            log.debug("New KPF-Zeller sample: {} Average: {}", (Object)Float.valueOf(this.sampleSpeed), (Object)Float.valueOf(this.avSpeed));
        } else if (this.series == 200) {
            this.avSpeed = this.sampleSpeed = this.count / 10.0f;
            log.debug("New SPC200R sample: {} Average: {}", (Object)Float.valueOf(this.sampleSpeed), (Object)Float.valueOf(this.avSpeed));
        } else if (this.series > 0 && this.series <= 6) {
            try {
                this.freq = 1500000.0f / this.count;
                this.sampleSpeed = this.freq / 24.0f * this.circ * thisScale * 3600.0f / 1000000.0f * 1.0f;
            }
            catch (ArithmeticException ae) {
                log.error("Exception calculating sampleSpeed", (Throwable)ae);
            }
            this.avFn(this.sampleSpeed);
            log.debug("New Bachrus sample: {} Average: {}", (Object)Float.valueOf(this.sampleSpeed), (Object)Float.valueOf(this.avSpeed));
            log.debug("Acc: {} range: {}", (Object)Float.valueOf(this.acc), (Object)this.range);
            this.switchRange();
        }
    }

    protected void avFn(float speed) {
        this.acc = this.acc - this.avSpeed + speed;
        this.avSpeed = this.acc / (float)FILTER_LENGTH[this.range];
    }

    protected void avClr() {
        this.acc = 0.0f;
        this.avSpeed = 0.0f;
    }

    protected void switchRange() {
        switch (this.range) {
            case 1: {
                if (!(this.sampleSpeed > 9.0f)) break;
                ++this.range;
                this.acc = this.acc * (float)FILTER_LENGTH[2] / (float)FILTER_LENGTH[1];
                break;
            }
            case 2: {
                if (this.sampleSpeed < 7.0f) {
                    --this.range;
                    this.acc = this.acc * (float)FILTER_LENGTH[1] / (float)FILTER_LENGTH[2];
                    break;
                }
                if (!(this.sampleSpeed > 31.0f)) break;
                ++this.range;
                this.acc = this.acc * (float)FILTER_LENGTH[3] / (float)FILTER_LENGTH[2];
                break;
            }
            case 3: {
                if (this.sampleSpeed < 29.0f) {
                    --this.range;
                    this.acc = this.acc * (float)FILTER_LENGTH[2] / (float)FILTER_LENGTH[3];
                    break;
                }
                if (!(this.sampleSpeed > 62.0f)) break;
                ++this.range;
                this.acc = this.acc * (float)FILTER_LENGTH[4] / (float)FILTER_LENGTH[3];
                break;
            }
            case 4: {
                if (!(this.sampleSpeed < 58.0f)) break;
                --this.range;
                this.acc = this.acc * (float)FILTER_LENGTH[3] / (float)FILTER_LENGTH[4];
                break;
            }
            default: {
                log.debug("range {} unsupported, range unchanged.", (Object)this.range);
            }
        }
    }

    protected void showSpeed() {
        float speedForText = this.currentSpeed;
        if (this.mphButton.isSelected()) {
            speedForText = Speed.kphToMph(speedForText);
        }
        if (this.series > 0) {
            if (this.currentSpeed < 0.0f || this.currentSpeed > 999.0f) {
                log.error("Calculated speed out of range: {}", (Object)Float.valueOf(this.currentSpeed));
                this.speedTextField.setText("999");
            } else if ((double)this.currentSpeed > (double)this.oldSpeed * 1.02 || (double)this.currentSpeed < (double)this.oldSpeed * 0.98) {
                this.speedTextField.setText(MessageFormat.format("{0,number,##0.0}", Float.valueOf(speedForText)));
                this.speedTextField.setHorizontalAlignment(4);
                this.oldSpeed = this.currentSpeed;
                this.speedoDialDisplay.update(this.currentSpeed);
            }
        }
    }

    protected void checkCustomScale() {
        if (this.selectedScale == -1.0f) {
            this.customScaleField.setEnabled(true);
        } else {
            this.customScaleField.setEnabled(false);
        }
    }

    protected void setDial() {
        CardLayout cl = (CardLayout)this.displayCards.getLayout();
        if (this.numButton.isSelected()) {
            this.display = DisplayType.NUMERIC;
            cl.show(this.displayCards, "NUMERIC");
        } else {
            this.display = DisplayType.DIAL;
            cl.show(this.displayCards, "DIAL");
        }
    }

    protected void setUnits() {
        if (this.mphButton.isSelected()) {
            this.profileGraphPane.setUnitsMph();
            this.basicSpeedMatchTargetStartSpeedUnit.setText(Bundle.getMessage("SpeedMatchMPHLabel"));
            this.basicSpeedMatchTargetHighSpeedUnit.setText(Bundle.getMessage("SpeedMatchMPHLabel"));
            this.speedStepScaleSpeedMatchMaxSpeedUnit.setText(Bundle.getMessage("SpeedMatchMPHLabel"));
            this.speedStepScaleMaxSpeedActualUnit.setText(Bundle.getMessage("SpeedMatchMPHLabel"));
        } else {
            this.profileGraphPane.setUnitsKph();
            this.basicSpeedMatchTargetStartSpeedUnit.setText(Bundle.getMessage("SpeedMatchKPHLabel"));
            this.basicSpeedMatchTargetHighSpeedUnit.setText(Bundle.getMessage("SpeedMatchKPHLabel"));
            this.speedStepScaleSpeedMatchMaxSpeedUnit.setText(Bundle.getMessage("SpeedMatchKPHLabel"));
            this.speedStepScaleMaxSpeedActualUnit.setText(Bundle.getMessage("SpeedMatchKPHLabel"));
        }
        this.profileGraphPane.repaint();
        if (this.mphButton.isSelected()) {
            this.speedoDialDisplay.setUnitsMph();
        } else {
            this.speedoDialDisplay.setUnitsKph();
        }
        this.speedoDialDisplay.update(this.currentSpeed);
        this.speedoDialDisplay.repaint();
    }

    protected void getCustomScale() {
        if (this.selectedScale == -1.0f) {
            try {
                this.customScale = Integer.parseUnsignedInt(this.customScaleField.getText());
            }
            catch (NumberFormatException ex) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("CustomScaleDialog"), Bundle.getMessage("CustomScaleTitle"), 0);
            }
        }
    }

    private synchronized void changeOfAddress() {
        if (this.addrSelector.getAddress() != null) {
            this.locomotiveAddress = this.addrSelector.getAddress();
            this.setTitle();
        } else {
            this.locomotiveAddress = new DccLocoAddress(0, true);
            this.setTitle();
        }
    }

    public void setRosterEntry(RosterEntry entry) {
        this.rosterBox.setSelectedItem(entry);
        this.addrSelector.setAddress(entry.getDccLocoAddress());
        this.rosterEntry = entry;
        this.changeOfAddress();
    }

    private void rosterItemSelected() {
        if (this.rosterBox.getSelectedRosterEntries().length != 0) {
            this.setRosterEntry(this.rosterBox.getSelectedRosterEntries()[0]);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setPowerStatus();
    }

    private void setPowerStatus() {
        if (this.pm == null) {
            return;
        }
        if (this.pm.getPower() == 2) {
            this.trackPowerButton.setText(Bundle.getMessage("PowerDown"));
        } else if (this.pm.getPower() == 4) {
            this.trackPowerButton.setText(Bundle.getMessage("PowerUp"));
        }
    }

    protected void trackPower() {
        try {
            if (this.pm.getPower() != 2) {
                this.pm.setPower(2);
            } else {
                this.stopProfileAndSpeedMatch();
                this.pm.setPower(4);
            }
        }
        catch (JmriException e) {
            log.error("Exception during power on: {}", (Object)e.toString());
        }
    }

    protected synchronized void startProfile() {
        if (this.locomotiveAddress.getNumber() > 0) {
            if ((this.dirFwdButton.isSelected() || this.dirRevButton.isSelected()) && (this.speedMatcher == null || this.speedMatcher.isSpeedMatcherIdle()) && this.profileState == ProfileState.IDLE) {
                this.profileTimer = new Timer(4000, e -> this.profileTimeout());
                this.profileTimer.setRepeats(false);
                this.profileState = ProfileState.WAIT_FOR_THROTTLE;
                this.statusLabel.setText(Bundle.getMessage("StatReqThrottle"));
                this.spFwd.clear();
                this.spRev.clear();
                this.profileDir = this.dirFwdButton.isSelected() ? ProfileDirection.FORWARD : ProfileDirection.REVERSE;
                this.resetGraphButton.setEnabled(false);
                this.profileGraphPane.repaint();
                this.profileTimer.start();
                log.info("Requesting throttle");
                boolean requestOK = InstanceManager.throttleManagerInstance().requestThrottle(this.locomotiveAddress, (ThrottleListener)this, true);
                if (!requestOK) {
                    log.error("Loco Address in use, throttle request failed.");
                }
            }
        } else {
            log.error("Attempt to profile loco address 0");
        }
    }

    protected synchronized void profileTimeout() {
        switch (this.profileState) {
            case WAIT_FOR_THROTTLE: {
                this.tidyUp();
                log.error("Timeout waiting for throttle");
                this.statusLabel.setText(Bundle.getMessage("StatusTimeout"));
                break;
            }
            case RUNNING: {
                if (this.profileDir == ProfileDirection.FORWARD) {
                    this.spFwd.setPoint(this.profileStep, this.avSpeed);
                    this.statusLabel.setText(Bundle.getMessage("Fwd", this.profileStep));
                } else {
                    this.spRev.setPoint(this.profileStep, this.avSpeed);
                    this.statusLabel.setText(Bundle.getMessage("Rev", this.profileStep));
                }
                this.profileGraphPane.repaint();
                if (this.profileStep == 29) {
                    if (this.profileDir == ProfileDirection.FORWARD && this.dirRevButton.isSelected()) {
                        this.profileDir = ProfileDirection.REVERSE;
                        this.throttle.setIsForward(false);
                        this.profileStep = 0;
                        this.avClr();
                        this.statusLabel.setText(Bundle.getMessage("StatCreateRev"));
                        break;
                    }
                    this.tidyUp();
                    this.statusLabel.setText(Bundle.getMessage("StatDone"));
                    break;
                }
                this.profileSpeed = this.profileStep == 28 ? 0.0f : (this.profileSpeed += this.throttleIncrement);
                this.throttle.setSpeedSetting(this.profileSpeed);
                ++this.profileStep;
                this.profileTimer.setDelay(7000 - this.range * 1000);
                break;
            }
            default: {
                log.error("Unexpected profile timeout");
                this.profileTimer.stop();
            }
        }
    }

    protected void tidyUp() {
        this.stopTimers();
        if (this.throttle != null) {
            this.throttle.setSpeedSetting(0.0f);
            InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
            this.throttle = null;
        }
        if (this.speedMatcher != null) {
            this.speedMatcher.stopSpeedMatcher();
            this.speedMatcher = null;
        }
        this.resetGraphButton.setEnabled(true);
        this.progState = ProgState.IDLE;
        this.profileState = ProfileState.IDLE;
    }

    protected synchronized void stopProfileAndSpeedMatch() {
        if (this.profileState != ProfileState.IDLE || !this.speedMatcher.isSpeedMatcherIdle()) {
            if (this.profileState != ProfileState.IDLE) {
                log.info("Profiling/Speed Matching stopped by user");
            }
            this.tidyUp();
        }
    }

    protected void stopTimers() {
        if (this.profileTimer != null) {
            this.profileTimer.stop();
        }
    }

    @Override
    public synchronized void notifyThrottleFound(DccThrottle t) {
        this.stopTimers();
        this.throttle = t;
        log.info("Throttle acquired");
        this.throttle.setSpeedStepMode(SpeedStepMode.NMRA_DCC_28);
        if (this.throttle.getSpeedStepMode() != SpeedStepMode.NMRA_DCC_28) {
            log.error("Failed to set 28 step mode");
            this.statusLabel.setText(Bundle.getMessage("ThrottleError28"));
            InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
            return;
        }
        try {
            this.pm.setPower(2);
        }
        catch (JmriException e) {
            log.error("Exception during power on: {}", (Object)e.toString());
            return;
        }
        this.throttleIncrement = this.throttle.getSpeedIncrement();
        if (this.profileState == ProfileState.WAIT_FOR_THROTTLE) {
            log.info("Starting profiling");
            this.profileState = ProfileState.RUNNING;
            this.profileSpeed = 0.0f;
            this.profileStep = 0;
            this.throttle.setSpeedSetting(this.profileSpeed);
            if (this.profileDir == ProfileDirection.FORWARD) {
                this.throttle.setIsForward(true);
                this.statusLabel.setText(Bundle.getMessage("StatCreateFwd"));
            } else {
                this.throttle.setIsForward(false);
                this.statusLabel.setText(Bundle.getMessage("StatCreateRev"));
            }
            this.profileTimer.setRepeats(true);
            this.profileTimer.start();
        } else {
            this.tidyUp();
        }
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
        InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
    }

    protected void startReplyTimer() {
        this.replyTimer = new Timer(4000, e -> this.replyTimeout());
        this.replyTimer.setRepeats(true);
        this.replyTimer.start();
    }

    protected void startDisplayTimer() {
        this.displayTimer = new Timer(500, e -> this.displayTimeout());
        this.displayTimer.setRepeats(true);
        this.displayTimer.start();
    }

    protected void startFastDisplayTimer() {
        this.fastDisplayTimer = new Timer(100, e -> this.fastDisplayTimeout());
        this.fastDisplayTimer.setRepeats(true);
        this.fastDisplayTimer.start();
    }

    protected synchronized void replyTimeout() {
        this.targetSpeed = 0.0f;
        this.avClr();
        this.oldSpeed = 0.0f;
        this.showSpeed();
    }

    protected synchronized void displayTimeout() {
        this.targetSpeed = this.avSpeed;
        this.incSpeed = (this.targetSpeed - this.currentSpeed) / 5.0f;
    }

    protected synchronized void fastDisplayTimeout() {
        this.currentSpeed = Math.abs(this.targetSpeed - this.currentSpeed) < Math.abs(this.incSpeed) ? this.targetSpeed : (this.currentSpeed += this.incSpeed);
        if (this.currentSpeed < 0.01f) {
            this.currentSpeed = 0.0f;
        }
        this.showSpeed();
        if (this.speedMatcher != null) {
            this.speedMatcher.updateCurrentSpeed(this.currentSpeed);
        }
    }

    protected synchronized void throttleTimeout() {
        InstanceManager.throttleManagerInstance().cancelThrottleRequest(this.locomotiveAddress, (ThrottleListener)this);
        this.profileState = ProfileState.IDLE;
        log.error("Timeout waiting for throttle");
    }

    protected void readAddress() {
        if ((this.speedMatcher == null || this.speedMatcher.isSpeedMatcherIdle()) && this.profileState == ProfileState.IDLE) {
            this.progState = ProgState.READ29;
            this.statusLabel.setText(Bundle.getMessage("ProgRd29"));
            this.startRead("29");
        }
    }

    protected void readMomentum() {
        if ((this.speedMatcher == null || this.speedMatcher.isSpeedMatcherIdle()) && this.profileState == ProfileState.IDLE) {
            this.progState = ProgState.READ3;
            this.statusLabel.setText(Bundle.getMessage("ProgReadAccel"));
            this.startRead("3");
        }
    }

    protected void setMomentum() {
        if ((this.speedMatcher == null || this.speedMatcher.isSpeedMatcherIdle()) && this.profileState == ProfileState.IDLE) {
            this.progState = ProgState.WRITE3;
            int acceleration = this.accelerationSM.getNumber().intValue();
            this.statusLabel.setText(Bundle.getMessage("ProgSetAccel", acceleration));
            this.startWrite("3", acceleration);
        }
    }

    protected void startRead(String cv) {
        try {
            this.prog.readCV(cv, this);
        }
        catch (ProgrammerException e) {
            log.error("Exception reading CV {}", (Object)cv, (Object)e);
        }
    }

    protected void startWrite(String cv, int value) {
        try {
            this.prog.writeCV(cv, value, this);
        }
        catch (ProgrammerException e) {
            log.error("Exception setting CV {} to {}", new Object[]{cv, value, e});
        }
    }

    @Override
    public void programmingOpReply(int value, int status) {
        if (status == 0) {
            switch (this.progState) {
                case IDLE: {
                    log.debug("unexpected reply in IDLE state");
                    break;
                }
                case READ29: {
                    if ((value & 0x20) == 0) {
                        this.progState = ProgState.READ1;
                        this.statusLabel.setText(Bundle.getMessage("ProgRdShort"));
                        this.startRead("1");
                        break;
                    }
                    this.progState = ProgState.READ17;
                    this.statusLabel.setText(Bundle.getMessage("ProgRdExtended"));
                    this.startRead("17");
                    break;
                }
                case READ1: {
                    this.readAddress = value;
                    this.addrSelector.setAddress(new DccLocoAddress(this.readAddress, false));
                    this.changeOfAddress();
                    this.progState = ProgState.IDLE;
                    break;
                }
                case READ3: {
                    this.accelerationSM.setValue(value);
                    this.progState = ProgState.READ4;
                    this.statusLabel.setText(Bundle.getMessage("ProgReadDecel"));
                    this.startRead("4");
                    break;
                }
                case READ4: {
                    this.decelerationSM.setValue(value);
                    this.progState = ProgState.IDLE;
                    this.statusLabel.setText(Bundle.getMessage("ProgRdComplete"));
                    break;
                }
                case READ17: {
                    this.readAddress = value;
                    this.progState = ProgState.READ18;
                    this.startRead("18");
                    break;
                }
                case READ18: {
                    this.readAddress = (this.readAddress & 0x3F) * 256 + value;
                    this.addrSelector.setAddress(new DccLocoAddress(this.readAddress, true));
                    this.changeOfAddress();
                    this.statusLabel.setText(Bundle.getMessage("ProgRdComplete"));
                    this.progState = ProgState.IDLE;
                    break;
                }
                case WRITE3: {
                    this.progState = ProgState.WRITE4;
                    int deceleration = this.decelerationSM.getNumber().intValue();
                    this.statusLabel.setText(Bundle.getMessage("ProgSetDecel", deceleration));
                    this.startWrite("4", deceleration);
                    break;
                }
                case WRITE4: {
                    this.statusLabel.setText(Bundle.getMessage("ProgRdComplete"));
                    this.progState = ProgState.IDLE;
                    break;
                }
                default: {
                    this.progState = ProgState.IDLE;
                    log.warn("Unhandled read state: {}", (Object)this.progState);
                    break;
                }
            }
        } else {
            log.error("Status not OK during {}: {}", (Object)this.progState.toString(), (Object)status);
            this.statusLabel.setText(Bundle.getMessage("ProgError"));
            this.progState = ProgState.IDLE;
            this.tidyUp();
        }
    }

    protected static enum ProgState {
        IDLE,
        READ1,
        READ3,
        READ4,
        READ17,
        READ18,
        READ29,
        WRITE3,
        WRITE4;

    }

    protected static enum ProfileDirection {
        FORWARD,
        REVERSE;

    }

    protected static enum ProfileState {
        IDLE,
        WAIT_FOR_THROTTLE,
        RUNNING;

    }

    protected static enum DisplayType {
        NUMERIC,
        DIAL;

    }
}

