/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus;

import java.io.DataInputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jmri.jmrix.bachrus.SpeedoInterface;
import jmri.jmrix.bachrus.SpeedoListener;
import jmri.jmrix.bachrus.SpeedoPortController;
import jmri.jmrix.bachrus.SpeedoReply;
import jmri.jmrix.bachrus.SpeedoSystemConnectionMemo;
import jmri.jmrix.purejavacomm.SerialPortEvent;
import jmri.jmrix.purejavacomm.SerialPortEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedoTrafficController
implements SpeedoInterface,
SerialPortEventListener {
    private SpeedoReply reply = new SpeedoReply();
    protected Vector<SpeedoListener> cmdListeners = new Vector();
    SpeedoListener lastSender = null;
    private SpeedoPortController controller = null;
    DataInputStream istream = null;
    OutputStream ostream = null;
    private boolean unsolicited;
    private static final Logger log = LoggerFactory.getLogger(SpeedoTrafficController.class);

    public SpeedoTrafficController(SpeedoSystemConnectionMemo adaptermemo) {
    }

    @Override
    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    @Override
    public synchronized void addSpeedoListener(SpeedoListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.cmdListeners.contains(l)) {
            this.cmdListeners.addElement(l);
        }
    }

    @Override
    public synchronized void removeSpeedoListener(SpeedoListener l) {
        if (this.cmdListeners.contains(l)) {
            this.cmdListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReply(SpeedoReply r) {
        Vector v;
        SpeedoTrafficController speedoTrafficController = this;
        synchronized (speedoTrafficController) {
            v = (Vector)this.cmdListeners.clone();
        }
        int cnt = v.size();
        for (int i = 0; i < cnt; ++i) {
            SpeedoListener client = (SpeedoListener)v.elementAt(i);
            try {
                if (this.lastSender == client) continue;
                client.reply(r);
                continue;
            }
            catch (Exception e) {
                log.warn("notify: During dispatch to {} Exception", (Object)client, (Object)e);
            }
        }
        if (this.lastSender != null) {
            this.lastSender.reply(r);
        }
    }

    public void connectPort(SpeedoPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
    }

    public void disconnectPort(SpeedoPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected LnPortController");
        }
        this.controller = null;
    }

    boolean endReply(SpeedoReply msg) {
        int ptr;
        int num = msg.getNumDataElements();
        int value = msg.getElement(0);
        if (value == 80 || value == 81 || value == 82 || value == 83 ? num != 7 : msg.getElement(ptr = num - 1) != 59) {
            return false;
        }
        this.unsolicited = true;
        return true;
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        block1 : switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                int replyCurrentSize;
                for (int i = replyCurrentSize = this.reply.getNumDataElements(); i < 32 - replyCurrentSize; ++i) {
                    try {
                        if (this.istream.available() == 0) break block1;
                        byte char1 = this.istream.readByte();
                        this.reply.setElement(i, char1);
                    }
                    catch (Exception e) {
                        log.debug("Exception handling reply cause {}", (Object)e.getCause(), (Object)e);
                    }
                    if (!this.endReply(this.reply)) continue;
                    this.sendreply();
                    break block1;
                }
                break;
            }
            default: {
                log.warn("Unhandled event type: {}", (Object)event.getEventType());
            }
        }
    }

    private void sendreply() {
        final SpeedoReply thisReply = this.reply;
        if (this.unsolicited) {
            thisReply.setUnsolicited();
        }
        final SpeedoTrafficController thisTc = this;
        Runnable r = new Runnable(){
            SpeedoReply msgForLater;
            SpeedoTrafficController myTc;
            {
                this.msgForLater = thisReply;
                this.myTc = thisTc;
            }

            @Override
            public void run() {
                this.myTc.notifyReply(this.msgForLater);
            }
        };
        SwingUtilities.invokeLater(r);
        this.reply = new SpeedoReply();
    }
}

