/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus.kpfserialdriver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import jmri.jmrix.bachrus.SpeedoPortController;
import jmri.jmrix.bachrus.SpeedoSystemConnectionMemo;
import jmri.jmrix.bachrus.SpeedoTrafficController;
import jmri.jmrix.purejavacomm.CommPortIdentifier;
import jmri.jmrix.purejavacomm.NoSuchPortException;
import jmri.jmrix.purejavacomm.PortInUseException;
import jmri.jmrix.purejavacomm.SerialPort;
import jmri.jmrix.purejavacomm.UnsupportedCommOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends SpeedoPortController {
    SerialPort activeSerialPort = null;
    private boolean opened = false;
    InputStream serialStream = null;
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new SpeedoSystemConnectionMemo());
        this.setManufacturer("KPF-Zeller");
        this.getSystemConnectionMemo().setSpeedoTrafficController(new SpeedoTrafficController(this.getSystemConnectionMemo()));
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.activeSerialPort.setSerialPortParams(9600, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.configureLeadsAndFlowControl(this.activeSerialPort, 0);
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialStream = this.activeSerialPort.getInputStream();
            SerialDriverAdapter.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            try {
                this.activeSerialPort.addEventListener(this.getSystemConnectionMemo().getTrafficController());
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
            this.setManufacturer("KPF-Zeller");
            this.activeSerialPort.notifyOnDataAvailable(true);
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    public void setHandshake(int mode) {
        try {
            this.activeSerialPort.setFlowControlMode(mode);
        }
        catch (UnsupportedCommOperationException ex) {
            log.error("Unexpected exception while setting COM port handshake mode", (Throwable)ex);
        }
    }

    @Override
    public void configure() {
        this.getSystemConnectionMemo().getTrafficController().connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"9,600 bps"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{9600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

