/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus.speedmatcher;

import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.Timer;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.PowerManager;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.bachrus.speedmatcher.Bundle;
import jmri.jmrix.bachrus.speedmatcher.SpeedMatcherConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpeedMatcher
implements ThrottleListener,
ProgListener {
    protected final int INITIAL_MOMENTUM = 0;
    protected final int REVERSE_TRIM_MAX = 255;
    protected final int REVERSE_TRIM_MIN = 1;
    protected final float ALLOWED_SPEED_MATCH_ERROR = 0.75f;
    protected int attempt = 0;
    protected float speedMatchError = 0.0f;
    protected int speedMatcherValueDelta;
    protected boolean trimReverseSpeed;
    protected int warmUpForwardSeconds = 240;
    protected int warmUpReverseSeconds = 120;
    protected int stepDuration = 0;
    protected float currentSpeedKPH = 0.0f;
    protected DccLocoAddress dccLocoAddress;
    protected AddressedProgrammer opsModeProgrammer = null;
    protected PowerManager powerManager = null;
    protected JLabel statusLabel;
    protected JButton startStopButton;
    protected ProgrammerState programmerState = ProgrammerState.IDLE;
    private DccThrottle throttle = null;
    private float throttleIncrement;
    private Timer speedMatchStateTimer;
    private static final Logger logger = LoggerFactory.getLogger(SpeedMatcher.class);

    public SpeedMatcher(SpeedMatcherConfig config) {
        this.dccLocoAddress = config.dccLocoAddress;
        this.powerManager = config.powerManager;
        this.trimReverseSpeed = config.trimReverseSpeed;
        this.warmUpForwardSeconds = config.warmUpForwardSeconds;
        this.warmUpReverseSeconds = config.warmUpReverseSeconds;
        this.statusLabel = config.statusLabel;
        this.startStopButton = config.startStopButton;
    }

    public abstract boolean startSpeedMatcher();

    public abstract void stopSpeedMatcher();

    public abstract boolean isSpeedMatcherIdle();

    public void updateCurrentSpeed(float currentSpeedKPH) {
        this.currentSpeedKPH = currentSpeedKPH;
    }

    protected abstract boolean validate();

    protected void cleanUpSpeedMatcher() {
        if (this.speedMatchStateTimer != null) {
            this.speedMatchStateTimer.stop();
        }
        if (this.throttle != null) {
            this.throttle.setSpeedSetting(0.0f);
            InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
            this.throttle = null;
        }
        if (this.opsModeProgrammer != null) {
            InstanceManager.getDefault(AddressedProgrammerManager.class).releaseAddressedProgrammer(this.opsModeProgrammer);
            this.opsModeProgrammer = null;
        }
        this.startStopButton.setText(Bundle.getMessage("SpeedMatchStartBtn"));
    }

    protected boolean initializeAndStartSpeedMatcher(ActionListener timerActionListener) {
        this.speedMatchStateTimer = new Timer(4000, timerActionListener);
        this.speedMatchStateTimer.setRepeats(false);
        if (!this.getOpsModeProgrammer()) {
            return false;
        }
        this.statusLabel.setText(Bundle.getMessage("StatRequestingThrottle"));
        logger.info("Requesting Throttle");
        this.speedMatchStateTimer.start();
        boolean throttleRequestOK = InstanceManager.throttleManagerInstance().requestThrottle(this.dccLocoAddress, (ThrottleListener)this, true);
        if (!throttleRequestOK) {
            logger.error("Loco Address in use, throttle request failed.");
            this.statusLabel.setText(Bundle.getMessage("StatThrottleReqFailed"));
        }
        return throttleRequestOK;
    }

    protected void startSpeedMatchStateTimer() {
        if (this.speedMatchStateTimer != null) {
            this.speedMatchStateTimer.start();
        }
    }

    protected void stopSpeedMatchStateTimer() {
        if (this.speedMatchStateTimer != null) {
            this.speedMatchStateTimer.stop();
        }
    }

    protected void setSpeedMatchStateTimerDuration(int timerDuration) {
        if (this.speedMatchStateTimer != null) {
            this.speedMatchStateTimer.setInitialDelay(timerDuration);
        }
    }

    protected void setThrottle(boolean isForward, int speedStep) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        logger.info("Set throttle to {} speed step {}", (Object)(isForward ? "forward" : "reverse"), (Object)speedStep);
        this.throttle.setIsForward(isForward);
        this.throttle.setSpeedSetting((float)speedStep * this.throttleIncrement);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void setSpeedMatchError(float speedTarget) {
        this.speedMatchError = speedTarget - this.currentSpeedKPH;
    }

    protected int getNextSpeedMatchValue(int lastValue, int max, int min) {
        int value;
        ++this.attempt;
        if (this.speedMatchError < 0.0f && this.speedMatcherValueDelta >= 0 || this.speedMatchError >= 0.0f && this.speedMatcherValueDelta < 0) {
            this.speedMatcherValueDelta = -this.speedMatcherValueDelta;
            if (this.attempt > 1) {
                this.speedMatcherValueDelta = this.speedMatcherValueDelta >= 0 ? Math.max(1, this.speedMatcherValueDelta / 3) : Math.min(-1, this.speedMatcherValueDelta / 3);
            }
        }
        if ((value = lastValue + this.speedMatcherValueDelta) > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    protected void resetSpeedMatcher(int initialValueDelta) {
        this.attempt = 0;
        this.speedMatcherValueDelta = initialValueDelta;
        this.speedMatchError = 0.0f;
    }

    protected synchronized void writeVStart(int value) {
        this.programmerState = ProgrammerState.WRITE2;
        this.writeCV(SpeedMatcherCV.VSTART, value);
    }

    protected synchronized void writeVMid(int value) {
        this.programmerState = ProgrammerState.WRITE6;
        this.writeCV(SpeedMatcherCV.VMID, value);
    }

    protected synchronized void writeVHigh(int value) {
        this.programmerState = ProgrammerState.WRITE5;
        this.writeCV(SpeedMatcherCV.VHIGH, value);
    }

    protected synchronized void writeMomentumAccel(int value) {
        this.programmerState = ProgrammerState.WRITE3;
        this.writeCV(SpeedMatcherCV.ACCEL, value);
    }

    protected synchronized void writeMomentumDecel(int value) {
        this.programmerState = ProgrammerState.WRITE4;
        this.writeCV(SpeedMatcherCV.DECEL, value);
    }

    protected synchronized void writeForwardTrim(int value) {
        this.programmerState = ProgrammerState.WRITE66;
        this.writeCV(SpeedMatcherCV.FORWARDTRIM, value);
    }

    protected synchronized void writeReverseTrim(int value) {
        this.programmerState = ProgrammerState.WRITE95;
        this.writeCV(SpeedMatcherCV.REVERSETRIM, value);
    }

    protected synchronized void writeSpeedTableStep(SpeedTableStep step, int value) {
        this.programmerState = ProgrammerState.WRITE_SPEED_TABLE_STEP;
        this.statusLabel.setText(Bundle.getMessage("ProgSetCV", step.getCV() + " (Speed Step " + String.valueOf(step.getSpeedStep()) + ")", value));
        this.startOpsModeWrite(step.getCV(), value);
    }

    private synchronized void writeCV(SpeedMatcherCV cv, int value) {
        this.statusLabel.setText(Bundle.getMessage("ProgSetCV", cv.getCVDisplayName(), value));
        this.startOpsModeWrite(cv.getCV(), value);
    }

    private void startOpsModeWrite(String cv, int value) {
        try {
            logger.info("Setting CV {} to {}", (Object)cv, (Object)value);
            this.opsModeProgrammer.writeCV(cv, value, this);
        }
        catch (ProgrammerException e) {
            logger.error("Exception writing CV {} {}", (Object)cv, (Object)e.toString());
        }
    }

    @Override
    public void programmingOpReply(int value, int status) {
        if (status == 0) {
            switch (this.programmerState) {
                case IDLE: {
                    logger.debug("unexpected reply in IDLE state");
                    break;
                }
                case WRITE2: 
                case WRITE3: 
                case WRITE4: 
                case WRITE5: 
                case WRITE6: 
                case WRITE66: 
                case WRITE95: 
                case WRITE_SPEED_TABLE_STEP: {
                    this.programmerState = ProgrammerState.IDLE;
                    break;
                }
                default: {
                    this.programmerState = ProgrammerState.IDLE;
                    logger.warn("Unhandled programmer state: {}", (Object)this.programmerState);
                    break;
                }
            }
        } else {
            logger.error("Status not OK during {}: {}", (Object)this.programmerState.toString(), (Object)status);
            this.statusLabel.setText("Error using programmer");
            this.programmerState = ProgrammerState.IDLE;
            this.cleanUpSpeedMatcher();
        }
    }

    private boolean getOpsModeProgrammer() {
        logger.info("Requesting Programmer");
        if (InstanceManager.getNullableDefault(AddressedProgrammerManager.class) != null && InstanceManager.getDefault(AddressedProgrammerManager.class).isAddressedModePossible(this.dccLocoAddress)) {
            this.opsModeProgrammer = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(this.dccLocoAddress);
        }
        if (this.opsModeProgrammer != null) {
            return true;
        }
        logger.error("Programmer request failed.");
        this.statusLabel.setText(Bundle.getMessage("StatProgrammerReqFailed"));
        return false;
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        this.stopSpeedMatchStateTimer();
        this.throttle = t;
        logger.info("Throttle acquired");
        this.throttle.setSpeedStepMode(SpeedStepMode.NMRA_DCC_28);
        if (this.throttle.getSpeedStepMode() != SpeedStepMode.NMRA_DCC_28) {
            logger.error("Failed to set 28 step mode");
            this.statusLabel.setText(Bundle.getMessage("ThrottleError28"));
            InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
            return;
        }
        try {
            this.powerManager.setPower(2);
        }
        catch (JmriException e) {
            logger.error("Exception during power on: {}", (Object)e.toString());
            return;
        }
        this.throttleIncrement = this.throttle.getSpeedIncrement();
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
        InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
    }

    protected static enum ProgrammerState {
        IDLE,
        WRITE2,
        WRITE3,
        WRITE4,
        WRITE5,
        WRITE6,
        WRITE66,
        WRITE95,
        WRITE_SPEED_TABLE_STEP;

    }

    protected static enum SpeedMatcherCV {
        VSTART(2, Bundle.getMessage("CVVStart")),
        VMID(6, Bundle.getMessage("CVVMid")),
        VHIGH(5, Bundle.getMessage("CVVHigh")),
        ACCEL(3, Bundle.getMessage("CVAccel")),
        DECEL(4, Bundle.getMessage("CVDecel")),
        FORWARDTRIM(66, Bundle.getMessage("CVFwdTrim")),
        REVERSETRIM(95, Bundle.getMessage("CVReverseTrim"));

        private final String name;
        private final String cv;

        private SpeedMatcherCV(int cv, String name) {
            this.cv = String.valueOf(cv);
            this.name = name;
        }

        public String getCV() {
            return this.cv;
        }

        public String getName() {
            return this.name;
        }

        public String getCVDisplayName() {
            return Bundle.getMessage("CVDisplayName", this.cv, this.name);
        }
    }

    public static enum SpeedTableStep {
        STEP1(1){

            @Override
            public SpeedTableStep getPrevious() {
                return null;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP2;
            }
        }
        ,
        STEP2(2){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP1;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP3;
            }
        }
        ,
        STEP3(3){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP2;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP4;
            }
        }
        ,
        STEP4(4){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP3;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP5;
            }
        }
        ,
        STEP5(5){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP4;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP6;
            }
        }
        ,
        STEP6(6){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP5;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP7;
            }
        }
        ,
        STEP7(7){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP6;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP8;
            }
        }
        ,
        STEP8(8){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP7;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP9;
            }
        }
        ,
        STEP9(9){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP8;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP10;
            }
        }
        ,
        STEP10(10){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP9;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP11;
            }
        }
        ,
        STEP11(11){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP10;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP12;
            }
        }
        ,
        STEP12(12){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP11;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP13;
            }
        }
        ,
        STEP13(13){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP12;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP14;
            }
        }
        ,
        STEP14(14){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP13;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP15;
            }
        }
        ,
        STEP15(15){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP14;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP16;
            }
        }
        ,
        STEP16(16){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP15;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP17;
            }
        }
        ,
        STEP17(17){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP16;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP18;
            }
        }
        ,
        STEP18(18){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP17;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP19;
            }
        }
        ,
        STEP19(19){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP18;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP20;
            }
        }
        ,
        STEP20(20){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP19;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP21;
            }
        }
        ,
        STEP21(21){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP20;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP22;
            }
        }
        ,
        STEP22(22){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP21;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP23;
            }
        }
        ,
        STEP23(23){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP22;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP24;
            }
        }
        ,
        STEP24(24){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP23;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP25;
            }
        }
        ,
        STEP25(25){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP24;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP26;
            }
        }
        ,
        STEP26(26){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP25;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP27;
            }
        }
        ,
        STEP27(27){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP26;
            }

            @Override
            public SpeedTableStep getNext() {
                return STEP28;
            }
        }
        ,
        STEP28(28){

            @Override
            public SpeedTableStep getPrevious() {
                return STEP27;
            }

            @Override
            public SpeedTableStep getNext() {
                return null;
            }
        };

        private final int speedStep;
        private final String cv;

        private SpeedTableStep(int speedStep) {
            this.speedStep = speedStep;
            this.cv = String.valueOf(speedStep + 66);
        }

        public int getSpeedStep() {
            return this.speedStep;
        }

        public String getCV() {
            return this.cv;
        }

        public abstract SpeedTableStep getNext();

        public abstract SpeedTableStep getPrevious();
    }
}

