/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus.speedmatcher.basic;

import jmri.DccThrottle;
import jmri.jmrix.bachrus.Speed;
import jmri.jmrix.bachrus.speedmatcher.SpeedMatcher;
import jmri.jmrix.bachrus.speedmatcher.basic.BasicSpeedMatcher;
import jmri.jmrix.bachrus.speedmatcher.basic.BasicSpeedMatcherConfig;
import jmri.jmrix.bachrus.speedmatcher.basic.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicESUTableSpeedMatcher
extends BasicSpeedMatcher {
    private final int INITIAL_VSTART = 1;
    private final int INITIAL_VHIGH = 255;
    private final int INITIAL_TRIM = 128;
    private final int STEP28_VALUE = 255;
    private final int STEP1_VALUE = 1;
    private final int VHIGH_MAX = 255;
    private final int VHIGH_MIN = 2;
    private final int STEP19_MIN = 19;
    private final int STEP10_MIN = 10;
    private final int VSTART_MIN = 1;
    private SpeedMatcher.SpeedTableStep initSpeedTableStep;
    private int initSpeedTableStepValue;
    private SpeedMatcher.SpeedTableStep interpolationSpeedTableStep;
    private int speedMatchCVValue = 255;
    private int lastSpeedMatchCVValue = 255;
    private int reverseTrimValue = 128;
    private int lastReverseTrimValue = 128;
    private final float targetVHighSpeedKPH;
    private final float targetStep19SpeedKPH;
    private final float targetStep10SpeedKPH;
    private final float targetVStartSpeedKPH;
    private int vHigh = 255;
    private int lastVHigh = 255;
    private int step19CVValue;
    private int step10CVValue;
    private int vStart;
    private int lastVStart = 1;
    private int vStartMax;
    private SpeedMatcherState speedMatcherState = SpeedMatcherState.IDLE;
    private static final Logger logger = LoggerFactory.getLogger(BasicESUTableSpeedMatcher.class);

    public BasicESUTableSpeedMatcher(BasicSpeedMatcherConfig config) {
        super(config);
        this.targetVHighSpeedKPH = this.targetTopSpeedKPH;
        this.targetStep19SpeedKPH = this.getSpeedForSpeedStep(SpeedMatcher.SpeedTableStep.STEP19, this.targetStartSpeedKPH, this.targetTopSpeedKPH);
        this.targetStep10SpeedKPH = this.getSpeedForSpeedStep(SpeedMatcher.SpeedTableStep.STEP10, this.targetStartSpeedKPH, this.targetTopSpeedKPH);
        this.targetVStartSpeedKPH = this.targetStartSpeedKPH;
    }

    @Override
    public boolean startSpeedMatcher() {
        if (!this.validate()) {
            return false;
        }
        this.speedMatchCVValue = 255;
        this.lastSpeedMatchCVValue = 255;
        this.reverseTrimValue = 128;
        this.lastReverseTrimValue = 128;
        this.speedMatcherState = SpeedMatcherState.WAIT_FOR_THROTTLE;
        if (!this.initializeAndStartSpeedMatcher(e -> this.speedMatchTimeout())) {
            this.cleanUpSpeedMatcher();
            return false;
        }
        this.startStopButton.setText(Bundle.getMessage("SpeedMatchStopBtn"));
        return true;
    }

    @Override
    public void stopSpeedMatcher() {
        if (!this.isSpeedMatcherIdle()) {
            logger.info("Speed matching manually stopped");
            this.userStop();
        } else {
            this.cleanUpSpeedMatcher();
        }
    }

    @Override
    public boolean isSpeedMatcherIdle() {
        return this.speedMatcherState == SpeedMatcherState.IDLE;
    }

    @Override
    protected void cleanUpSpeedMatcher() {
        this.speedMatcherState = SpeedMatcherState.IDLE;
        super.cleanUpSpeedMatcher();
    }

    private synchronized void speedMatchTimeout() {
        switch (this.speedMatcherState) {
            case WAIT_FOR_THROTTLE: {
                this.cleanUpSpeedMatcher();
                logger.error("Timeout waiting for throttle");
                this.statusLabel.setText(Bundle.getMessage("StatusTimeout"));
                break;
            }
            case INIT_THROTTLE: {
                this.setThrottle(true, 0);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_ACCEL);
                break;
            }
            case INIT_ACCEL: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeMomentumAccel(0);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_DECEL);
                break;
            }
            case INIT_DECEL: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeMomentumDecel(0);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_VSTART);
                break;
            }
            case INIT_VSTART: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeVStart(1);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_VHIGH);
                break;
            }
            case INIT_VHIGH: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeVHigh(255);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_SPEED_TABLE);
                break;
            }
            case INIT_SPEED_TABLE: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.initSpeedTableStepValue = 1;
                    this.initSpeedTableStep = SpeedMatcher.SpeedTableStep.STEP2;
                    this.stepDuration = 1;
                }
                if (this.initSpeedTableStep.getSpeedStep() > SpeedMatcher.SpeedTableStep.STEP18.getSpeedStep()) {
                    this.initSpeedTableStepValue = 255;
                }
                this.writeSpeedTableStep(this.initSpeedTableStep, this.initSpeedTableStepValue);
                this.initSpeedTableStep = this.initSpeedTableStep.getNext();
                if (this.initSpeedTableStep != SpeedMatcher.SpeedTableStep.STEP28) break;
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_FORWARD_TRIM);
                break;
            }
            case INIT_FORWARD_TRIM: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeForwardTrim(128);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_REVERSE_TRIM);
                break;
            }
            case INIT_REVERSE_TRIM: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeReverseTrim(128);
                this.initNextSpeedMatcherState(SpeedMatcherState.POST_INIT);
                break;
            }
            case POST_INIT: {
                this.statusLabel.setText(Bundle.getMessage("StatRestoreThrottle"));
                this.setThrottle(false, 0);
                this.setThrottle(true, 0);
                SpeedMatcherState nextState = this.warmUpForwardSeconds > 0 ? SpeedMatcherState.FORWARD_WARM_UP : SpeedMatcherState.FORWARD_SPEED_MATCH_VHIGH;
                this.initNextSpeedMatcherState(nextState, 30);
                break;
            }
            case FORWARD_WARM_UP: {
                this.statusLabel.setText(Bundle.getMessage("StatForwardWarmUp", this.warmUpForwardSeconds - this.stepDuration));
                if (this.stepDuration >= this.warmUpForwardSeconds) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH_VHIGH, 30);
                    break;
                }
                if (this.stepDuration == 0) {
                    this.setSpeedMatchStateTimerDuration(5000);
                    this.setThrottle(true, 28);
                }
                this.stepDuration += 5;
                break;
            }
            case FORWARD_SPEED_MATCH_VHIGH: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.statusLabel.setText(Bundle.getMessage("StatSettingSpeed", SpeedMatcher.SpeedMatcherCV.VHIGH.getName()));
                    logger.info("Setting CV {} to {} KPH ({} MPH)", new Object[]{SpeedMatcher.SpeedMatcherCV.VHIGH.getName(), String.valueOf(this.targetVHighSpeedKPH), String.valueOf(Speed.kphToMph(this.targetVHighSpeedKPH))});
                    this.setThrottle(true, 28);
                    this.setSpeedMatchStateTimerDuration(8000);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.targetVHighSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH_VSTART, 3);
                    break;
                }
                this.vHigh = this.getNextSpeedMatchValue(this.lastVHigh, 255, 2);
                if ((this.lastVHigh == 255 || this.lastVHigh == 2) && this.vHigh == this.lastVHigh) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedFail", SpeedMatcher.SpeedMatcherCV.VHIGH.getName()));
                    logger.info("Unable to achieve desired speed for CV {}", (Object)SpeedMatcher.SpeedMatcherCV.VHIGH.getName());
                    this.abort();
                    break;
                }
                this.lastVHigh = this.vHigh;
                this.writeVHigh(this.vHigh);
                break;
            }
            case FORWARD_SPEED_MATCH_VSTART: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.vStartMax = this.vHigh - 1;
                    this.statusLabel.setText(Bundle.getMessage("StatSettingSpeed", SpeedMatcher.SpeedMatcherCV.VSTART.getName()));
                    logger.info("Setting CV {} to {} KPH ({} MPH)", new Object[]{SpeedMatcher.SpeedMatcherCV.VSTART.getName(), String.valueOf(this.targetVStartSpeedKPH), String.valueOf(Speed.kphToMph(this.targetVStartSpeedKPH))});
                    this.setThrottle(true, 1);
                    this.setSpeedMatchStateTimerDuration(15000);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.targetVStartSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH_STEP19);
                    break;
                }
                this.vStart = this.getNextSpeedMatchValue(this.lastVStart, this.vStartMax, 1);
                if ((this.lastVStart == this.vStartMax || this.lastVStart == 1) && this.vStart == this.lastVStart) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedFail", SpeedMatcher.SpeedMatcherCV.VSTART.getName()));
                    logger.info("Unable to achieve desired speed for CV {}", (Object)SpeedMatcher.SpeedMatcherCV.VSTART.getName());
                    this.abort();
                    break;
                }
                this.lastVStart = this.vStart;
                this.writeVStart(this.vStart);
                break;
            }
            case FORWARD_SPEED_MATCH_STEP19: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.lastSpeedMatchCVValue = 255;
                }
                this.speedMatchSpeedTableStep(SpeedMatcher.SpeedTableStep.STEP19, this.targetStep19SpeedKPH, 255, 19, SpeedMatcherState.RE_INIT_SPEED_TABLE_MIDDLE_THIRD);
                this.step19CVValue = this.speedMatchCVValue;
                break;
            }
            case RE_INIT_SPEED_TABLE_MIDDLE_THIRD: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.initSpeedTableStep = SpeedMatcher.SpeedTableStep.STEP18;
                    this.stepDuration = 1;
                }
                this.writeSpeedTableStep(this.initSpeedTableStep, this.step19CVValue);
                if (this.initSpeedTableStep == SpeedMatcher.SpeedTableStep.STEP10) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH_STEP10);
                    break;
                }
                this.initSpeedTableStep = this.initSpeedTableStep.getPrevious();
                break;
            }
            case FORWARD_SPEED_MATCH_STEP10: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.lastSpeedMatchCVValue = this.step19CVValue;
                }
                this.speedMatchSpeedTableStep(SpeedMatcher.SpeedTableStep.STEP10, this.targetStep10SpeedKPH, this.step19CVValue - 9, 10, SpeedMatcherState.INTERPOLATE_SPEED_TABLE);
                this.step10CVValue = this.speedMatchCVValue;
                break;
            }
            case INTERPOLATE_SPEED_TABLE: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.setThrottle(true, 0);
                    this.interpolationSpeedTableStep = SpeedMatcher.SpeedTableStep.STEP27;
                    this.stepDuration = 1;
                }
                int interpolatedSpeedStepCVValue = this.getInterpolatedSpeedTableCVValue(this.interpolationSpeedTableStep);
                this.writeSpeedTableStep(this.interpolationSpeedTableStep, interpolatedSpeedStepCVValue);
                do {
                    this.interpolationSpeedTableStep = this.interpolationSpeedTableStep.getPrevious();
                } while (this.interpolationSpeedTableStep == SpeedMatcher.SpeedTableStep.STEP19 || this.interpolationSpeedTableStep == SpeedMatcher.SpeedTableStep.STEP10);
                if (this.interpolationSpeedTableStep != SpeedMatcher.SpeedTableStep.STEP1) break;
                this.initNextSpeedMatcherState(SpeedMatcherState.POST_INTERPOLATE);
                break;
            }
            case POST_INTERPOLATE: {
                this.statusLabel.setText(Bundle.getMessage("StatRestoreThrottle"));
                this.setThrottle(false, 0);
                this.setThrottle(true, 0);
                SpeedMatcherState nextState = this.trimReverseSpeed ? (this.warmUpReverseSeconds > 0 ? SpeedMatcherState.REVERSE_WARM_UP : SpeedMatcherState.REVERSE_SPEED_MATCH_TRIM) : SpeedMatcherState.COMPLETE;
                this.initNextSpeedMatcherState(nextState);
                break;
            }
            case REVERSE_WARM_UP: {
                this.statusLabel.setText(Bundle.getMessage("StatReverseWarmUp", this.warmUpReverseSeconds - this.stepDuration));
                if (this.stepDuration >= this.warmUpReverseSeconds) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.REVERSE_SPEED_MATCH_TRIM);
                    break;
                }
                if (this.stepDuration == 0) {
                    this.setSpeedMatchStateTimerDuration(5000);
                    this.setThrottle(false, 28);
                }
                this.stepDuration += 5;
                break;
            }
            case REVERSE_SPEED_MATCH_TRIM: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.statusLabel.setText(Bundle.getMessage("StatSettingReverseTrim"));
                    this.setThrottle(false, 28);
                    this.setSpeedMatchStateTimerDuration(8000);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.targetTopSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.COMPLETE);
                    break;
                }
                this.reverseTrimValue = this.getNextSpeedMatchValue(this.lastReverseTrimValue, 255, 1);
                if ((this.lastReverseTrimValue == 255 || this.lastReverseTrimValue == 1) && this.reverseTrimValue == this.lastReverseTrimValue) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetReverseTrimFail"));
                    logger.info("Unable to trim reverse to match forward");
                    this.abort();
                    break;
                }
                this.lastReverseTrimValue = this.reverseTrimValue;
                this.writeReverseTrim(this.reverseTrimValue);
                break;
            }
            case COMPLETE: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.statusLabel.setText(Bundle.getMessage("StatSpeedMatchComplete"));
                this.setThrottle(true, 0);
                this.initNextSpeedMatcherState(SpeedMatcherState.CLEAN_UP);
                break;
            }
            case USER_STOPPED: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.statusLabel.setText(Bundle.getMessage("StatUserStoppedSpeedMatch"));
                this.setThrottle(true, 0);
                this.initNextSpeedMatcherState(SpeedMatcherState.CLEAN_UP);
                break;
            }
            case CLEAN_UP: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.cleanUpSpeedMatcher();
                break;
            }
            default: {
                this.cleanUpSpeedMatcher();
                logger.error("Unexpected speed match timeout");
            }
        }
        if (this.speedMatcherState != SpeedMatcherState.IDLE) {
            this.startSpeedMatchStateTimer();
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        super.notifyThrottleFound(t);
        if (this.speedMatcherState == SpeedMatcherState.WAIT_FOR_THROTTLE) {
            logger.info("Starting speed matching");
            this.initNextSpeedMatcherState(SpeedMatcherState.INIT_THROTTLE);
            this.startSpeedMatchStateTimer();
        } else {
            this.cleanUpSpeedMatcher();
        }
    }

    private int getInterpolatedSpeedTableCVValue(SpeedMatcher.SpeedTableStep speedStep) {
        int minStepCVValue;
        int maxStepCVValue;
        SpeedMatcher.SpeedTableStep minStep;
        SpeedMatcher.SpeedTableStep maxStep;
        if (speedStep.getSpeedStep() >= SpeedMatcher.SpeedTableStep.STEP19.getSpeedStep()) {
            maxStep = SpeedMatcher.SpeedTableStep.STEP28;
            minStep = SpeedMatcher.SpeedTableStep.STEP19;
            maxStepCVValue = 255;
            minStepCVValue = this.step19CVValue;
        } else if (speedStep.getSpeedStep() >= SpeedMatcher.SpeedTableStep.STEP10.getSpeedStep()) {
            maxStep = SpeedMatcher.SpeedTableStep.STEP19;
            minStep = SpeedMatcher.SpeedTableStep.STEP10;
            maxStepCVValue = this.step19CVValue;
            minStepCVValue = this.step10CVValue;
        } else {
            maxStep = SpeedMatcher.SpeedTableStep.STEP10;
            minStep = SpeedMatcher.SpeedTableStep.STEP1;
            maxStepCVValue = this.step10CVValue;
            minStepCVValue = 1;
        }
        return Math.round((float)minStepCVValue + (float)(maxStepCVValue - minStepCVValue) / (float)(maxStep.getSpeedStep() - minStep.getSpeedStep()) * (float)(speedStep.getSpeedStep() - minStep.getSpeedStep()));
    }

    private void speedMatchSpeedTableStep(SpeedMatcher.SpeedTableStep speedStep, float targetSpeedKPH, int maxCVValue, int minCVValue, SpeedMatcherState nextState) {
        if (this.stepDuration == 0) {
            this.statusLabel.setText(Bundle.getMessage("StatSettingSpeed", speedStep.getCV() + " (Speed Step " + String.valueOf(speedStep.getSpeedStep()) + ")"));
            logger.info("Setting CV {} (speed step {}) to {} KPH ({} MPH)", new Object[]{speedStep.getCV(), speedStep.getSpeedStep(), String.valueOf(targetSpeedKPH), String.valueOf(Speed.kphToMph(targetSpeedKPH))});
            this.setThrottle(true, speedStep.getSpeedStep());
            this.setSpeedMatchStateTimerDuration(8000);
            this.stepDuration = 1;
        } else {
            this.setSpeedMatchError(targetSpeedKPH);
            if (Math.abs(this.speedMatchError) < 0.75f) {
                this.initNextSpeedMatcherState(nextState);
            } else {
                this.speedMatchCVValue = this.getNextSpeedMatchValue(this.lastSpeedMatchCVValue, maxCVValue, minCVValue);
                if ((this.speedMatchCVValue == maxCVValue || this.speedMatchCVValue == minCVValue) && this.speedMatchCVValue == this.lastSpeedMatchCVValue) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedFail", speedStep.getCV() + " (Speed Step " + String.valueOf(speedStep.getSpeedStep()) + ")"));
                    logger.info("Unable to achieve desired speed for CV {} (Speed Step {})", (Object)speedStep.getCV(), (Object)String.valueOf(speedStep.getSpeedStep()));
                    this.abort();
                    return;
                }
                this.lastSpeedMatchCVValue = this.speedMatchCVValue;
                this.writeSpeedTableStep(speedStep, this.speedMatchCVValue);
            }
        }
    }

    private void abort() {
        this.initNextSpeedMatcherState(SpeedMatcherState.CLEAN_UP);
    }

    private void userStop() {
        this.initNextSpeedMatcherState(SpeedMatcherState.USER_STOPPED);
    }

    protected void initNextSpeedMatcherState(SpeedMatcherState nextState) {
        this.initNextSpeedMatcherState(nextState, 10);
    }

    protected void initNextSpeedMatcherState(SpeedMatcherState nextState, int speedMatchValueDelta) {
        this.resetSpeedMatcher(speedMatchValueDelta);
        this.stepDuration = 0;
        this.speedMatcherState = nextState;
        this.setSpeedMatchStateTimerDuration(1800);
    }

    protected static enum SpeedMatcherState {
        IDLE,
        WAIT_FOR_THROTTLE,
        INIT_THROTTLE,
        INIT_ACCEL,
        INIT_DECEL,
        INIT_VSTART,
        INIT_VHIGH,
        INIT_SPEED_TABLE,
        INIT_FORWARD_TRIM,
        INIT_REVERSE_TRIM,
        POST_INIT,
        FORWARD_WARM_UP,
        FORWARD_SPEED_MATCH_VHIGH,
        FORWARD_SPEED_MATCH_VSTART,
        FORWARD_SPEED_MATCH_STEP19,
        RE_INIT_SPEED_TABLE_MIDDLE_THIRD,
        FORWARD_SPEED_MATCH_STEP10,
        INTERPOLATE_SPEED_TABLE,
        POST_INTERPOLATE,
        REVERSE_WARM_UP,
        REVERSE_SPEED_MATCH_TRIM,
        COMPLETE,
        USER_STOPPED,
        CLEAN_UP;

    }
}

