/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus.speedmatcher.basic;

import jmri.DccThrottle;
import jmri.jmrix.bachrus.Speed;
import jmri.jmrix.bachrus.speedmatcher.SpeedMatcher;
import jmri.jmrix.bachrus.speedmatcher.basic.BasicSpeedMatcher;
import jmri.jmrix.bachrus.speedmatcher.basic.BasicSpeedMatcherConfig;
import jmri.jmrix.bachrus.speedmatcher.basic.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSimpleCVSpeedMatcher
extends BasicSpeedMatcher {
    private final int INITIAL_VSTART = 1;
    private final int INITIAL_VMID = 2;
    private final int INITIAL_VHIGH = 255;
    private final int INITIAL_TRIM = 128;
    private final int VHIGH_MAX = 255;
    private final int VHIGH_MIN = 3;
    private final int VMID_MIN = 2;
    private final int VSTART_MIN = 1;
    private int vHigh = 255;
    private int lastVHigh = 255;
    private int vMid = 1;
    private int lastVMid = 1;
    private int vMidMax;
    private int vStart = 1;
    private int lastVStart = 1;
    private int vStartMax;
    private int reverseTrimValue = 128;
    private int lastReverseTrimValue = 128;
    private final float targetMidSpeedKPH;
    private SpeedMatcherState speedMatcherState = SpeedMatcherState.IDLE;
    private static final Logger logger = LoggerFactory.getLogger(BasicSimpleCVSpeedMatcher.class);

    public BasicSimpleCVSpeedMatcher(BasicSpeedMatcherConfig config) {
        super(config);
        this.targetMidSpeedKPH = this.targetStartSpeedKPH + (this.targetTopSpeedKPH - this.targetStartSpeedKPH) / 2.0f;
    }

    @Override
    public boolean startSpeedMatcher() {
        if (!this.validate()) {
            return false;
        }
        this.vStart = 1;
        this.lastVStart = 1;
        this.vMid = 1;
        this.lastVMid = 1;
        this.vHigh = 255;
        this.lastVHigh = 255;
        this.reverseTrimValue = 128;
        this.lastReverseTrimValue = 128;
        this.speedMatcherState = SpeedMatcherState.WAIT_FOR_THROTTLE;
        if (!this.initializeAndStartSpeedMatcher(e -> this.speedMatchTimeout())) {
            this.cleanUpSpeedMatcher();
            return false;
        }
        this.startStopButton.setText(Bundle.getMessage("SpeedMatchStopBtn"));
        return true;
    }

    @Override
    public void stopSpeedMatcher() {
        if (!this.isSpeedMatcherIdle()) {
            logger.info("Speed matching manually stopped");
            this.userStop();
        } else {
            this.cleanUpSpeedMatcher();
        }
    }

    @Override
    public boolean isSpeedMatcherIdle() {
        return this.speedMatcherState == SpeedMatcherState.IDLE;
    }

    @Override
    protected void cleanUpSpeedMatcher() {
        this.speedMatcherState = SpeedMatcherState.IDLE;
        super.cleanUpSpeedMatcher();
    }

    private synchronized void speedMatchTimeout() {
        switch (this.speedMatcherState) {
            case WAIT_FOR_THROTTLE: {
                this.cleanUpSpeedMatcher();
                logger.error("Timeout waiting for throttle");
                this.statusLabel.setText(Bundle.getMessage("StatusTimeout"));
                break;
            }
            case INIT_THROTTLE: {
                this.setThrottle(true, 0);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_ACCEL);
                break;
            }
            case INIT_ACCEL: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeMomentumAccel(0);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_DECEL);
                break;
            }
            case INIT_DECEL: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeMomentumDecel(0);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_VSTART);
                break;
            }
            case INIT_VSTART: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeVStart(1);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_VMID);
                break;
            }
            case INIT_VMID: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeVMid(2);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_VHIGH);
                break;
            }
            case INIT_VHIGH: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeVHigh(255);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_FORWARD_TRIM);
                break;
            }
            case INIT_FORWARD_TRIM: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeForwardTrim(128);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_REVERSE_TRIM);
                break;
            }
            case INIT_REVERSE_TRIM: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeReverseTrim(128);
                this.initNextSpeedMatcherState(SpeedMatcherState.POST_INIT);
                break;
            }
            case POST_INIT: {
                this.statusLabel.setText(Bundle.getMessage("StatRestoreThrottle"));
                this.setThrottle(false, 0);
                this.setThrottle(true, 0);
                SpeedMatcherState nextState = this.warmUpForwardSeconds > 0 ? SpeedMatcherState.FORWARD_WARM_UP : SpeedMatcherState.FORWARD_SPEED_MATCH_VHIGH;
                this.initNextSpeedMatcherState(nextState, 30);
                break;
            }
            case FORWARD_WARM_UP: {
                this.statusLabel.setText(Bundle.getMessage("StatForwardWarmUp", this.warmUpForwardSeconds - this.stepDuration));
                if (this.stepDuration >= this.warmUpForwardSeconds) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH_VHIGH, 30);
                    break;
                }
                if (this.stepDuration == 0) {
                    this.setSpeedMatchStateTimerDuration(5000);
                    this.setThrottle(true, 28);
                }
                this.stepDuration += 5;
                break;
            }
            case FORWARD_SPEED_MATCH_VHIGH: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.statusLabel.setText(Bundle.getMessage("StatSettingSpeed", "5 (vHigh)"));
                    logger.info("Setting CV 5 (vHigh) to {} KPH ({} MPH)", (Object)String.valueOf(this.targetTopSpeedKPH), (Object)String.valueOf(Speed.kphToMph(this.targetTopSpeedKPH)));
                    this.setThrottle(true, 28);
                    this.setSpeedMatchStateTimerDuration(8000);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.targetTopSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH_VMID);
                    break;
                }
                this.vHigh = this.getNextSpeedMatchValue(this.lastVHigh, 255, 3);
                if ((this.vHigh == 255 || this.vHigh == 3) && this.vHigh == this.lastVHigh) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedFail", "5 (vHigh)"));
                    logger.info("Unable to achieve desired speed for CV 5 (vHigh)");
                    this.abort();
                    break;
                }
                this.lastVHigh = this.vHigh;
                this.writeVHigh(this.vHigh);
                break;
            }
            case FORWARD_SPEED_MATCH_VMID: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.lastVMid = this.vMid = 1 + (this.vHigh - 1) / 2;
                    this.vMidMax = this.vHigh - 1;
                    this.writeVMid(this.vMid);
                    this.statusLabel.setText(Bundle.getMessage("StatSettingSpeed", "6 (vMid)"));
                    logger.info("Setting CV 6 (vMid) to {} KPH ({} MPH)", (Object)String.valueOf(this.targetMidSpeedKPH), (Object)String.valueOf(Speed.kphToMph(this.targetMidSpeedKPH)));
                    this.setSpeedMatchStateTimerDuration(8000);
                    this.setThrottle(true, 14);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.targetMidSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH_VSTART, 3);
                    break;
                }
                this.vMid = this.getNextSpeedMatchValue(this.lastVMid, this.vMidMax, 2);
                if ((this.vMid == this.vMidMax || this.vMid == 2) && this.vMid == this.lastVMid) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedFail", "6 (vMid)"));
                    logger.info("Unable to achieve desired speed for CV 6 (vMid)");
                    this.abort();
                    break;
                }
                this.lastVMid = this.vMid;
                this.writeVMid(this.vMid);
                break;
            }
            case FORWARD_SPEED_MATCH_VSTART: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.vStartMax = this.vMid - 1;
                    this.statusLabel.setText(Bundle.getMessage("StatSettingSpeed", "2 (vStart)"));
                    logger.info("Setting CV 2 (vStart) to {} KPH ({} MPH)", (Object)String.valueOf(this.targetStartSpeedKPH), (Object)String.valueOf(Speed.kphToMph(this.targetStartSpeedKPH)));
                    this.setThrottle(true, 1);
                    this.setSpeedMatchStateTimerDuration(15000);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.targetStartSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    SpeedMatcherState nextState = this.trimReverseSpeed ? (this.warmUpReverseSeconds > 0 ? SpeedMatcherState.REVERSE_WARM_UP : SpeedMatcherState.REVERSE_SPEED_MATCH_TRIM) : SpeedMatcherState.COMPLETE;
                    this.initNextSpeedMatcherState(nextState);
                    break;
                }
                this.vStart = this.getNextSpeedMatchValue(this.lastVStart, this.vStartMax, 1);
                if ((this.vStart == this.vStartMax || this.vStart == 1) && this.vStart == this.lastVStart) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedFail", "2 (vStart)"));
                    logger.info("Unable to achieve desired speed for CV 2 (vStart)");
                    this.abort();
                    break;
                }
                this.lastVStart = this.vStart;
                this.writeVStart(this.vStart);
                break;
            }
            case REVERSE_WARM_UP: {
                this.statusLabel.setText(Bundle.getMessage("StatReverseWarmUp", this.warmUpReverseSeconds - this.stepDuration));
                if (this.stepDuration >= this.warmUpReverseSeconds) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.REVERSE_SPEED_MATCH_TRIM);
                    break;
                }
                if (this.stepDuration == 0) {
                    this.setSpeedMatchStateTimerDuration(5000);
                    this.setThrottle(false, 28);
                }
                this.stepDuration += 5;
                break;
            }
            case REVERSE_SPEED_MATCH_TRIM: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.statusLabel.setText(Bundle.getMessage("StatSettingReverseTrim"));
                    this.setThrottle(false, 28);
                    this.setSpeedMatchStateTimerDuration(8000);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.targetTopSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.COMPLETE);
                    break;
                }
                this.reverseTrimValue = this.getNextSpeedMatchValue(this.lastReverseTrimValue, 255, 1);
                if ((this.lastReverseTrimValue == 255 || this.lastReverseTrimValue == 1) && this.reverseTrimValue == this.lastReverseTrimValue) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetReverseTrimFail"));
                    logger.info("Unable to trim reverse to match forward");
                    this.abort();
                    break;
                }
                this.lastReverseTrimValue = this.reverseTrimValue;
                this.writeReverseTrim(this.reverseTrimValue);
                break;
            }
            case COMPLETE: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.statusLabel.setText(Bundle.getMessage("StatSpeedMatchComplete"));
                this.setThrottle(true, 0);
                this.initNextSpeedMatcherState(SpeedMatcherState.CLEAN_UP);
                break;
            }
            case USER_STOPPED: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.statusLabel.setText(Bundle.getMessage("StatUserStoppedSpeedMatch"));
                this.setThrottle(true, 0);
                this.initNextSpeedMatcherState(SpeedMatcherState.CLEAN_UP);
                break;
            }
            case CLEAN_UP: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.cleanUpSpeedMatcher();
                break;
            }
            default: {
                this.cleanUpSpeedMatcher();
                logger.error("Unexpected speed match timeout");
            }
        }
        if (this.speedMatcherState != SpeedMatcherState.IDLE) {
            this.startSpeedMatchStateTimer();
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        super.notifyThrottleFound(t);
        if (this.speedMatcherState == SpeedMatcherState.WAIT_FOR_THROTTLE) {
            logger.info("Starting speed matching");
            this.initNextSpeedMatcherState(SpeedMatcherState.INIT_THROTTLE);
            this.startSpeedMatchStateTimer();
        } else {
            this.cleanUpSpeedMatcher();
        }
    }

    private void abort() {
        this.initNextSpeedMatcherState(SpeedMatcherState.CLEAN_UP);
    }

    private void userStop() {
        this.initNextSpeedMatcherState(SpeedMatcherState.USER_STOPPED);
    }

    protected void initNextSpeedMatcherState(SpeedMatcherState nextState) {
        this.initNextSpeedMatcherState(nextState, 10);
    }

    protected void initNextSpeedMatcherState(SpeedMatcherState nextState, int speedMatchValueDelta) {
        this.resetSpeedMatcher(speedMatchValueDelta);
        this.stepDuration = 0;
        this.speedMatcherState = nextState;
        this.setSpeedMatchStateTimerDuration(1800);
    }

    protected static enum SpeedMatcherState {
        IDLE,
        WAIT_FOR_THROTTLE,
        INIT_THROTTLE,
        INIT_ACCEL,
        INIT_DECEL,
        INIT_VSTART,
        INIT_VMID,
        INIT_VHIGH,
        INIT_FORWARD_TRIM,
        INIT_REVERSE_TRIM,
        POST_INIT,
        FORWARD_WARM_UP,
        FORWARD_SPEED_MATCH_VHIGH,
        FORWARD_SPEED_MATCH_VMID,
        FORWARD_SPEED_MATCH_VSTART,
        REVERSE_WARM_UP,
        REVERSE_SPEED_MATCH_TRIM,
        COMPLETE,
        USER_STOPPED,
        CLEAN_UP;

    }
}

