/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus.speedmatcher.basic;

import jmri.jmrix.bachrus.Speed;
import jmri.jmrix.bachrus.speedmatcher.SpeedMatcher;
import jmri.jmrix.bachrus.speedmatcher.basic.BasicSpeedMatcherConfig;
import jmri.jmrix.bachrus.speedmatcher.basic.Bundle;

public abstract class BasicSpeedMatcher
extends SpeedMatcher {
    protected float targetStartSpeedKPH;
    protected float targetTopSpeedKPH;

    public BasicSpeedMatcher(BasicSpeedMatcherConfig config) {
        super(config);
        if (config.speedUnit == Speed.Unit.MPH) {
            this.targetStartSpeedKPH = Speed.mphToKph(config.targetStartSpeed);
            this.targetTopSpeedKPH = Speed.mphToKph(config.targetTopSpeed);
        } else {
            this.targetStartSpeedKPH = config.targetStartSpeed;
            this.targetTopSpeedKPH = config.targetTopSpeed;
        }
    }

    @Override
    protected boolean validate() {
        if (this.dccLocoAddress.getNumber() <= 0) {
            this.statusLabel.setText(Bundle.getMessage("StatInvalidDCCAddress"));
            return false;
        }
        if (this.targetStartSpeedKPH < 1.0f) {
            this.statusLabel.setText(Bundle.getMessage("StatInvalidStartSpeed"));
            return false;
        }
        if (this.targetTopSpeedKPH <= this.targetStartSpeedKPH) {
            this.statusLabel.setText(Bundle.getMessage("StatInvalidTopSpeed"));
            return false;
        }
        return true;
    }

    protected float getSpeedForSpeedStep(SpeedMatcher.SpeedTableStep speedStep, float minSpeed, float maxSpeed) {
        return minSpeed + (maxSpeed - minSpeed) / 27.0f * (float)(speedStep.getSpeedStep() - 1);
    }
}

