/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus.speedmatcher.speedStepScale;

import java.util.Locale;
import jmri.DccThrottle;
import jmri.jmrix.bachrus.Speed;
import jmri.jmrix.bachrus.speedmatcher.SpeedMatcher;
import jmri.jmrix.bachrus.speedmatcher.speedStepScale.Bundle;
import jmri.jmrix.bachrus.speedmatcher.speedStepScale.SpeedStepScaleSpeedMatcher;
import jmri.jmrix.bachrus.speedmatcher.speedStepScale.SpeedStepScaleSpeedMatcherConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedStepScaleESUTableSpeedMatcher
extends SpeedStepScaleSpeedMatcher {
    private final int INITIAL_VSTART = 1;
    private final int INITIAL_VHIGH = 255;
    private final int INITIAL_STEP2 = 1;
    private final int INITIAL_TRIM = 128;
    private final int VHIGH_MAX = 255;
    private final int VHIGH_MIN = 2;
    private final int VSTART_MIN = 1;
    private final int TOP_SPEED_STEP_MAX = 255;
    private SpeedMatcher.SpeedTableStep initSpeedTableStep;
    private int initSpeedTableStepValue;
    private SpeedMatcher.SpeedTableStep speedMatchSpeedTableStep;
    private int speedMatchMaxSpeedStep;
    private float speedStepTargetSpeedKPH;
    private int vHigh = 255;
    private int lastVHigh = 255;
    private int vStart = 1;
    private int lastVStart = 1;
    private int vStartMax;
    private float targetVStartSpeedKPH;
    private int speedMatchCVValue = 255;
    private int lastSpeedMatchCVValue = 255;
    private int lastSpeedTableStepCVValue = 255;
    private int reverseTrimValue = 128;
    private int lastReverseTrimValue = 128;
    private SpeedMatcherState speedMatcherState = SpeedMatcherState.IDLE;
    private static final Logger logger = LoggerFactory.getLogger(SpeedStepScaleESUTableSpeedMatcher.class);

    public SpeedStepScaleESUTableSpeedMatcher(SpeedStepScaleSpeedMatcherConfig config) {
        super(config);
    }

    @Override
    public boolean startSpeedMatcher() {
        if (!this.validate()) {
            return false;
        }
        this.vHigh = 255;
        this.lastVHigh = 255;
        this.vStart = 1;
        this.lastVStart = 1;
        this.speedMatchCVValue = 255;
        this.lastSpeedMatchCVValue = 255;
        this.lastSpeedTableStepCVValue = 255;
        this.reverseTrimValue = 128;
        this.lastReverseTrimValue = 128;
        this.measuredMaxSpeedKPH = 0.0f;
        this.speedMatchMaxSpeedKPH = 0.0f;
        this.speedMatcherState = SpeedMatcherState.WAIT_FOR_THROTTLE;
        this.actualMaxSpeedField.setText("___");
        if (!this.initializeAndStartSpeedMatcher(e -> this.speedMatchTimeout())) {
            this.cleanUpSpeedMatcher();
            return false;
        }
        this.startStopButton.setText(Bundle.getMessage("SpeedMatchStopBtn"));
        return true;
    }

    @Override
    public void stopSpeedMatcher() {
        if (!this.isSpeedMatcherIdle()) {
            logger.info("Speed matching manually stopped");
            this.userStop();
        } else {
            this.cleanUpSpeedMatcher();
        }
    }

    @Override
    public boolean isSpeedMatcherIdle() {
        return this.speedMatcherState == SpeedMatcherState.IDLE;
    }

    @Override
    protected void cleanUpSpeedMatcher() {
        this.speedMatcherState = SpeedMatcherState.IDLE;
        super.cleanUpSpeedMatcher();
    }

    private synchronized void speedMatchTimeout() {
        switch (this.speedMatcherState) {
            case WAIT_FOR_THROTTLE: {
                this.cleanUpSpeedMatcher();
                logger.error("Timeout waiting for throttle");
                this.statusLabel.setText(Bundle.getMessage("StatusTimeout"));
                break;
            }
            case INIT_THROTTLE: {
                this.setThrottle(true, 0);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_ACCEL);
                break;
            }
            case INIT_ACCEL: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeMomentumAccel(0);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_DECEL);
                break;
            }
            case INIT_DECEL: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeMomentumDecel(0);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_VSTART);
                break;
            }
            case INIT_VSTART: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeVStart(1);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_VHIGH);
                break;
            }
            case INIT_VHIGH: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeVHigh(255);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_SPEED_TABLE);
                break;
            }
            case INIT_SPEED_TABLE: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.initSpeedTableStep = SpeedMatcher.SpeedTableStep.STEP2;
                    this.stepDuration = 1;
                }
                this.writeSpeedTableStep(this.initSpeedTableStep, this.getSpeedStepLinearValue(this.initSpeedTableStep.getSpeedStep()));
                this.initSpeedTableStep = this.initSpeedTableStep.getNext();
                if (this.initSpeedTableStep != SpeedMatcher.SpeedTableStep.STEP28) break;
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_FORWARD_TRIM);
                break;
            }
            case INIT_FORWARD_TRIM: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeForwardTrim(128);
                this.initNextSpeedMatcherState(SpeedMatcherState.INIT_REVERSE_TRIM);
                break;
            }
            case INIT_REVERSE_TRIM: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.writeReverseTrim(128);
                this.initNextSpeedMatcherState(SpeedMatcherState.POST_INIT);
                break;
            }
            case POST_INIT: {
                this.statusLabel.setText(Bundle.getMessage("StatRestoreThrottle"));
                this.setThrottle(false, 0);
                this.setThrottle(true, 0);
                SpeedMatcherState nextState = this.warmUpForwardSeconds > 0 ? SpeedMatcherState.FORWARD_WARM_UP : SpeedMatcherState.READ_MAX_SPEED;
                this.initNextSpeedMatcherState(nextState);
                break;
            }
            case FORWARD_WARM_UP: {
                this.statusLabel.setText(Bundle.getMessage("StatForwardWarmUp", this.warmUpForwardSeconds - this.stepDuration));
                if (this.stepDuration >= this.warmUpForwardSeconds) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.READ_MAX_SPEED);
                    break;
                }
                if (this.stepDuration == 0) {
                    this.setSpeedMatchStateTimerDuration(5000);
                    this.setThrottle(true, 28);
                }
                this.stepDuration += 5;
                break;
            }
            case READ_MAX_SPEED: {
                float speedMatchMaxSpeed;
                if (this.stepDuration == 0) {
                    this.statusLabel.setText("Recording locomotive's maximum speed");
                    this.setSpeedMatchStateTimerDuration(10000);
                    this.setThrottle(true, 28);
                    this.stepDuration = 1;
                    break;
                }
                this.measuredMaxSpeedKPH = this.currentSpeedKPH;
                String statusMessage = String.format(Locale.getDefault(), "Measured maximum speed = %.1f KPH (%.1f MPH)", Float.valueOf(this.measuredMaxSpeedKPH), Float.valueOf(Speed.kphToMph(this.measuredMaxSpeedKPH)));
                logger.info(statusMessage);
                if (this.measuredMaxSpeedKPH > this.targetMaxSpeedKPH) {
                    this.speedMatchMaxSpeedStep = this.targetMaxSpeedStep.getSpeedTableStep().getSpeedStep();
                    speedMatchMaxSpeed = this.targetMaxSpeedStep.getSpeed();
                    this.speedMatchMaxSpeedKPH = this.targetMaxSpeedKPH;
                } else {
                    float measuredMaxSpeed = this.speedUnit == Speed.Unit.MPH ? Speed.kphToMph(this.measuredMaxSpeedKPH) : this.measuredMaxSpeedKPH;
                    this.speedMatchMaxSpeedStep = SpeedStepScaleESUTableSpeedMatcher.getNextLowestSpeedTableStepForSpeed(measuredMaxSpeed);
                    speedMatchMaxSpeed = SpeedStepScaleESUTableSpeedMatcher.getSpeedForSpeedTableStep(this.speedMatchMaxSpeedStep);
                    this.speedMatchMaxSpeedKPH = this.speedUnit == Speed.Unit.MPH ? Speed.mphToKph(speedMatchMaxSpeed) : speedMatchMaxSpeed;
                }
                this.actualMaxSpeedField.setText(String.format(Locale.getDefault(), "%.1f", Float.valueOf(speedMatchMaxSpeed)));
                this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH_VHIGH, 30);
                break;
            }
            case FORWARD_SPEED_MATCH_VHIGH: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.statusLabel.setText(Bundle.getMessage("StatSettingSpeed", SpeedMatcher.SpeedMatcherCV.VHIGH.getName()));
                    logger.info("Setting CV {} to {} KPH ({} MPH)", new Object[]{SpeedMatcher.SpeedMatcherCV.VHIGH.getName(), String.valueOf(this.speedMatchMaxSpeedKPH), String.valueOf(Speed.kphToMph(this.speedMatchMaxSpeedKPH))});
                    this.setThrottle(true, 28);
                    this.setSpeedMatchStateTimerDuration(8000);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.speedMatchMaxSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH_VSTART, 3);
                    break;
                }
                this.vHigh = this.getNextSpeedMatchValue(this.lastVHigh, 255, 2);
                if ((this.lastVHigh == 255 || this.lastVHigh == 2) && this.vHigh == this.lastVHigh) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedFail", SpeedMatcher.SpeedMatcherCV.VHIGH.getName()));
                    logger.info("Unable to achieve desired speed for CV {}", (Object)SpeedMatcher.SpeedMatcherCV.VHIGH.getName());
                    this.abort();
                    break;
                }
                this.lastVHigh = this.vHigh;
                this.writeVHigh(this.vHigh);
                break;
            }
            case FORWARD_SPEED_MATCH_VSTART: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.vStartMax = this.vHigh - 1;
                    this.targetVStartSpeedKPH = this.getSpeedStepScaleSpeedInKPH(SpeedMatcher.SpeedTableStep.STEP1.getSpeedStep());
                    this.statusLabel.setText(Bundle.getMessage("StatSettingSpeed", SpeedMatcher.SpeedMatcherCV.VSTART.getName()));
                    logger.info("Setting CV {} to {} KPH ({} MPH)", new Object[]{SpeedMatcher.SpeedMatcherCV.VSTART.getName(), String.valueOf(this.targetVStartSpeedKPH), String.valueOf(Speed.kphToMph(this.targetVStartSpeedKPH))});
                    this.setThrottle(true, 1);
                    this.setSpeedMatchStateTimerDuration(15000);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.targetVStartSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    this.setThrottle(true, 28);
                    this.initNextSpeedMatcherState(SpeedMatcherState.RE_INIT_SPEED_TABLE);
                    break;
                }
                this.vStart = this.getNextSpeedMatchValue(this.lastVStart, this.vStartMax, 1);
                if ((this.lastVStart == this.vStartMax || this.lastVStart == 1) && this.vStart == this.lastVStart) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedFail", SpeedMatcher.SpeedMatcherCV.VSTART.getName()));
                    logger.info("Unable to achieve desired speed for CV {}", (Object)SpeedMatcher.SpeedMatcherCV.VSTART.getName());
                    this.abort();
                    break;
                }
                this.lastVStart = this.vStart;
                this.writeVStart(this.vStart);
                break;
            }
            case RE_INIT_SPEED_TABLE: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.initSpeedTableStepValue = 255;
                    this.initSpeedTableStep = SpeedMatcher.SpeedTableStep.STEP27;
                    this.stepDuration = 1;
                }
                this.writeSpeedTableStep(this.initSpeedTableStep, this.initSpeedTableStepValue);
                if (this.initSpeedTableStep.getSpeedStep() == this.speedMatchMaxSpeedStep) {
                    this.speedMatchSpeedTableStep = this.initSpeedTableStep = this.initSpeedTableStep.getPrevious();
                    this.initSpeedTableStepValue = 1;
                } else {
                    this.initSpeedTableStep = this.initSpeedTableStep.getPrevious();
                }
                if (this.initSpeedTableStep.getSpeedStep() >= 2) break;
                this.initNextSpeedMatcherState(SpeedMatcherState.FORWARD_SPEED_MATCH);
                break;
            }
            case FORWARD_SPEED_MATCH: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.speedMatchSpeedStepInner(this.lastSpeedTableStepCVValue, this.speedMatchSpeedTableStep.getSpeedStep(), SpeedMatcherState.POST_SPEED_MATCH);
                break;
            }
            case POST_SPEED_MATCH: {
                this.statusLabel.setText(Bundle.getMessage("StatRestoreThrottle"));
                this.setThrottle(false, 0);
                this.setThrottle(true, 0);
                SpeedMatcherState nextState = this.trimReverseSpeed ? (this.warmUpReverseSeconds > 0 ? SpeedMatcherState.REVERSE_WARM_UP : SpeedMatcherState.REVERSE_SPEED_MATCH_TRIM) : SpeedMatcherState.COMPLETE;
                this.initNextSpeedMatcherState(nextState);
                break;
            }
            case REVERSE_WARM_UP: {
                this.statusLabel.setText(Bundle.getMessage("StatReverseWarmUp", this.warmUpReverseSeconds - this.stepDuration));
                if (this.stepDuration >= this.warmUpReverseSeconds) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.REVERSE_SPEED_MATCH_TRIM);
                    break;
                }
                if (this.stepDuration == 0) {
                    this.setSpeedMatchStateTimerDuration(5000);
                    this.setThrottle(false, 28);
                }
                this.stepDuration += 5;
                break;
            }
            case REVERSE_SPEED_MATCH_TRIM: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                if (this.stepDuration == 0) {
                    this.statusLabel.setText(Bundle.getMessage("StatSettingReverseTrim"));
                    this.setThrottle(false, this.speedMatchMaxSpeedStep);
                    this.setSpeedMatchStateTimerDuration(8000);
                    this.stepDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.speedMatchMaxSpeedKPH);
                if (Math.abs(this.speedMatchError) < 0.75f) {
                    this.initNextSpeedMatcherState(SpeedMatcherState.COMPLETE);
                    break;
                }
                this.reverseTrimValue = this.getNextSpeedMatchValue(this.lastReverseTrimValue, 255, 1);
                if ((this.lastReverseTrimValue == 255 || this.lastReverseTrimValue == 1) && this.reverseTrimValue == this.lastReverseTrimValue) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetReverseTrimFail"));
                    logger.info("Unable to trim reverse to match forward");
                    this.abort();
                    break;
                }
                this.lastReverseTrimValue = this.reverseTrimValue;
                this.writeReverseTrim(this.reverseTrimValue);
                break;
            }
            case COMPLETE: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.statusLabel.setText(Bundle.getMessage("StatSpeedMatchComplete"));
                this.setThrottle(true, 0);
                this.initNextSpeedMatcherState(SpeedMatcherState.CLEAN_UP);
                break;
            }
            case USER_STOPPED: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.statusLabel.setText(Bundle.getMessage("StatUserStoppedSpeedMatch"));
                this.setThrottle(true, 0);
                this.initNextSpeedMatcherState(SpeedMatcherState.CLEAN_UP);
                break;
            }
            case CLEAN_UP: {
                if (this.programmerState != SpeedMatcher.ProgrammerState.IDLE) break;
                this.cleanUpSpeedMatcher();
                break;
            }
            default: {
                this.cleanUpSpeedMatcher();
                logger.error("Unexpected speed match timeout");
            }
        }
        if (this.speedMatcherState != SpeedMatcherState.IDLE) {
            this.startSpeedMatchStateTimer();
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        super.notifyThrottleFound(t);
        if (this.speedMatcherState == SpeedMatcherState.WAIT_FOR_THROTTLE) {
            logger.info("Starting speed matching");
            this.initNextSpeedMatcherState(SpeedMatcherState.INIT_THROTTLE);
            this.startSpeedMatchStateTimer();
        } else {
            this.cleanUpSpeedMatcher();
        }
    }

    private void speedMatchSpeedStepInner(int maxCVValue, int minCVValue, SpeedMatcherState nextState) {
        if (this.stepDuration == 0) {
            this.speedStepTargetSpeedKPH = this.getSpeedStepScaleSpeedInKPH(this.speedMatchSpeedTableStep.getSpeedStep());
            this.statusLabel.setText(Bundle.getMessage("StatSettingSpeed", this.speedMatchSpeedTableStep.getCV() + " (Speed Step " + String.valueOf(this.speedMatchSpeedTableStep.getSpeedStep()) + ")"));
            logger.info("Setting CV {} (speed step {}) to {} KPH ({} MPH)", new Object[]{this.speedMatchSpeedTableStep.getCV(), this.speedMatchSpeedTableStep.getSpeedStep(), String.valueOf(this.speedStepTargetSpeedKPH), String.valueOf(Speed.kphToMph(this.speedStepTargetSpeedKPH))});
            this.setThrottle(true, this.speedMatchSpeedTableStep.getSpeedStep());
            this.writeSpeedTableStep(this.speedMatchSpeedTableStep, this.speedMatchCVValue);
            this.setSpeedMatchStateTimerDuration(8000);
            this.stepDuration = 1;
        } else {
            this.setSpeedMatchError(this.speedStepTargetSpeedKPH);
            if (Math.abs(this.speedMatchError) < 0.75f) {
                this.lastSpeedTableStepCVValue = this.speedMatchCVValue;
                this.speedMatchSpeedTableStep = this.speedMatchSpeedTableStep.getPrevious();
                if (this.speedMatchSpeedTableStep != SpeedMatcher.SpeedTableStep.STEP1) {
                    this.initNextSpeedMatcherState(this.speedMatcherState);
                } else {
                    this.initNextSpeedMatcherState(nextState);
                }
            } else {
                this.speedMatchCVValue = this.getNextSpeedMatchValue(this.lastSpeedMatchCVValue, maxCVValue, minCVValue);
                if ((this.speedMatchCVValue == maxCVValue || this.speedMatchCVValue == minCVValue) && this.speedMatchCVValue == this.lastSpeedMatchCVValue) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedFail", this.speedMatchSpeedTableStep.getCV() + " (Speed Step " + String.valueOf(this.speedMatchSpeedTableStep.getSpeedStep()) + ")"));
                    logger.info("Unable to achieve desired speed for CV {} (Speed Step {})", (Object)this.speedMatchSpeedTableStep.getCV(), (Object)String.valueOf(this.speedMatchSpeedTableStep.getSpeedStep()));
                    this.abort();
                    return;
                }
                this.lastSpeedMatchCVValue = this.speedMatchCVValue;
                this.writeSpeedTableStep(this.speedMatchSpeedTableStep, this.speedMatchCVValue);
            }
        }
    }

    private void abort() {
        this.initNextSpeedMatcherState(SpeedMatcherState.CLEAN_UP);
    }

    private void userStop() {
        this.initNextSpeedMatcherState(SpeedMatcherState.USER_STOPPED);
    }

    protected void initNextSpeedMatcherState(SpeedMatcherState nextState) {
        this.initNextSpeedMatcherState(nextState, 10);
    }

    protected void initNextSpeedMatcherState(SpeedMatcherState nextState, int speedMatchValueDelta) {
        this.resetSpeedMatcher(speedMatchValueDelta);
        this.stepDuration = 0;
        this.speedMatcherState = nextState;
        this.setSpeedMatchStateTimerDuration(1800);
    }

    protected static enum SpeedMatcherState {
        IDLE,
        WAIT_FOR_THROTTLE,
        INIT_THROTTLE,
        INIT_ACCEL,
        INIT_DECEL,
        INIT_VSTART,
        INIT_VHIGH,
        INIT_SPEED_TABLE,
        INIT_FORWARD_TRIM,
        INIT_REVERSE_TRIM,
        POST_INIT,
        FORWARD_WARM_UP,
        READ_MAX_SPEED,
        FORWARD_SPEED_MATCH_VHIGH,
        FORWARD_SPEED_MATCH_VSTART,
        RE_INIT_SPEED_TABLE,
        FORWARD_SPEED_MATCH,
        POST_SPEED_MATCH,
        REVERSE_WARM_UP,
        REVERSE_SPEED_MATCH_TRIM,
        COMPLETE,
        USER_STOPPED,
        CLEAN_UP;

    }
}

