/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus.speedmatcher.speedStepScale;

import javax.swing.JLabel;
import jmri.jmrix.bachrus.Speed;
import jmri.jmrix.bachrus.speedmatcher.SpeedMatcher;
import jmri.jmrix.bachrus.speedmatcher.speedStepScale.Bundle;
import jmri.jmrix.bachrus.speedmatcher.speedStepScale.SpeedStepScaleSpeedMatcherConfig;
import jmri.jmrix.bachrus.speedmatcher.speedStepScale.SpeedTableStepSpeed;

public abstract class SpeedStepScaleSpeedMatcher
extends SpeedMatcher {
    protected final SpeedTableStepSpeed targetMaxSpeedStep;
    protected final float targetMaxSpeedKPH;
    protected final Speed.Unit speedUnit;
    protected final JLabel actualMaxSpeedField;
    protected float measuredMaxSpeedKPH = 0.0f;
    protected float speedMatchMaxSpeedKPH = 0.0f;

    public SpeedStepScaleSpeedMatcher(SpeedStepScaleSpeedMatcherConfig config) {
        super(config);
        this.actualMaxSpeedField = config.actualMaxSpeedField;
        this.speedUnit = config.speedUnit;
        this.targetMaxSpeedStep = config.targetMaxSpeedStep;
        this.targetMaxSpeedKPH = config.speedUnit == Speed.Unit.MPH ? Speed.mphToKph(this.targetMaxSpeedStep.getSpeed()) : this.targetMaxSpeedStep.getSpeed();
    }

    @Override
    protected boolean validate() {
        if (this.dccLocoAddress.getNumber() <= 0) {
            this.statusLabel.setText(Bundle.getMessage("StatInvalidDCCAddress"));
            return false;
        }
        if (this.targetMaxSpeedStep == null) {
            this.statusLabel.setText(Bundle.getMessage("StatInvalidMaxSpeed"));
            return false;
        }
        return true;
    }

    protected float getSpeedStepScaleSpeedInKPH(int speedStep) {
        float speedStepSpeed = SpeedStepScaleSpeedMatcher.getSpeedForSpeedTableStep(speedStep);
        if (this.speedUnit == Speed.Unit.MPH) {
            speedStepSpeed = Speed.mphToKph(speedStepSpeed);
        }
        speedStepSpeed = Math.min(speedStepSpeed, this.speedMatchMaxSpeedKPH);
        return speedStepSpeed;
    }

    protected int getSpeedStepLinearValue(int speedStep) {
        return (int)((float)speedStep / 28.0f * 255.0f);
    }

    public static float getSpeedForSpeedTableStep(int speedStep) {
        return (float)speedStep * 4.6296f - 3.6296f;
    }

    public static int getNextLowestSpeedTableStepForSpeed(float speed) {
        return (int)Math.floor((speed + 3.6296f) / 4.6296f);
    }
}

