/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmri.NamedBean;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.LcConfig;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBAddress {
    private String aString = null;
    private long nodeuid = 0L;
    private int addr = -1;
    private String addrType = "";
    private LcOutputType portType;
    private Node node = null;
    static final String addrRegex = "^(?:[xX]([0-9a-fA-F]+):|([a-zA-Z0-9_\\-\\.]+):|)([afptAFPT]{0,1})(\\d+)([SLVUMABPI]{0,1})$";
    private static volatile Pattern addrPattern = Pattern.compile("^(?:[xX]([0-9a-fA-F]+):|([a-zA-Z0-9_\\-\\.]+):|)([afptAFPT]{0,1})(\\d+)([SLVUMABPI]{0,1})$");
    private static final Map<Character, LcOutputType> portTypeList = BiDiBAddress.createPortTypeList();
    private static final Logger log = LoggerFactory.getLogger(BiDiBAddress.class);

    private static Map<Character, LcOutputType> createPortTypeList() {
        HashMap<Character, LcOutputType> l = new HashMap<Character, LcOutputType>();
        l.put(Character.valueOf('S'), LcOutputType.SWITCHPORT);
        l.put(Character.valueOf('L'), LcOutputType.LIGHTPORT);
        l.put(Character.valueOf('V'), LcOutputType.SERVOPORT);
        l.put(Character.valueOf('U'), LcOutputType.SOUNDPORT);
        l.put(Character.valueOf('M'), LcOutputType.MOTORPORT);
        l.put(Character.valueOf('A'), LcOutputType.ANALOGPORT);
        l.put(Character.valueOf('B'), LcOutputType.BACKLIGHTPORT);
        l.put(Character.valueOf('P'), LcOutputType.SWITCHPAIRPORT);
        l.put(Character.valueOf('I'), LcOutputType.INPUTPORT);
        return Collections.unmodifiableMap(l);
    }

    public BiDiBAddress(String systemName, char typeLetter, BiDiBSystemConnectionMemo memo) {
        this.aString = systemName.substring(memo.getSystemPrefix().length() + 1);
        log.debug("ctor: systemName: {}, typeLetter: {}, systemPrefix: {}", new Object[]{systemName, Character.valueOf(typeLetter), memo.getSystemPrefix()});
        this.parse(systemName, typeLetter, memo);
    }

    private void parse(String systemName, char typeLetter, BiDiBSystemConnectionMemo memo) {
        BiDiBTrafficController tc = memo.getBiDiBTrafficController();
        if (!this.aString.isEmpty() && systemName.charAt(memo.getSystemPrefix().length()) == typeLetter) {
            try {
                Node foundNode;
                Matcher matcher = addrPattern.matcher(this.aString);
                if (!matcher.matches()) {
                    log.trace("systemName {} does not match regular expression", (Object)systemName);
                    throw new NamedBean.BadSystemNameException(Locale.getDefault(), "InvalidSystemName", systemName, "");
                }
                if (matcher.group(1) != null) {
                    this.nodeuid = Long.parseLong(matcher.group(1), 16);
                } else if (matcher.group(2) != null) {
                    Node n = tc.getNodeByUserName(matcher.group(2));
                    if (n != null) {
                        this.nodeuid = n.getUniqueId() & 0xFFFFFFFFFFL;
                    } else {
                        throw new Exception("No such node: " + matcher.group(2));
                    }
                }
                this.addrType = matcher.group(3).toLowerCase();
                this.addr = Integer.parseInt(matcher.group(4));
                String t = matcher.group(5).toUpperCase();
                if (!t.isEmpty()) {
                    this.portType = portTypeList.get(Character.valueOf(t.charAt(0)));
                }
                if (this.nodeuid == 0L) {
                    foundNode = tc.getRootNode();
                    if (foundNode != null) {
                        this.nodeuid = foundNode.getUniqueId() & 0xFFFFFFFFFFL;
                    }
                } else {
                    log.trace("trying UID {}", (Object)ByteUtils.formatHexUniqueId((long)this.nodeuid));
                    foundNode = tc.getNodeByUniqueID(this.nodeuid);
                }
                log.trace("found node: {}", (Object)foundNode);
                if (foundNode != null) {
                    long uid = foundNode.getUniqueId();
                    if (typeLetter == 'S') {
                        switch (this.addrType) {
                            case "t": {
                                this.addrType = "f";
                                if (NodeUtils.hasFeedbackFunctions((long)uid)) break;
                                this.addrType = "";
                                break;
                            }
                            case "f": {
                                if (NodeUtils.hasFeedbackFunctions((long)uid)) break;
                                this.addrType = "";
                                break;
                            }
                            case "p": {
                                if (NodeUtils.hasSwitchFunctions((long)uid)) break;
                                this.addrType = "";
                                break;
                            }
                            case "": {
                                if (NodeUtils.hasFeedbackFunctions((long)uid)) {
                                    this.addrType = "f";
                                    break;
                                }
                                if (!NodeUtils.hasSwitchFunctions((long)uid)) break;
                                this.addrType = "p";
                                break;
                            }
                            default: {
                                this.addrType = "";
                            }
                        }
                        if (this.addrType.equals("p")) {
                            if (this.portType == null) {
                                this.portType = LcOutputType.INPUTPORT;
                            }
                            if (!this.portType.equals((Object)LcOutputType.INPUTPORT)) {
                                this.addrType = "";
                            }
                        }
                    } else if (typeLetter == 'R') {
                        if (this.addrType.isEmpty()) {
                            this.addrType = "f";
                        }
                        if (!this.addrType.equals("f")) {
                            this.addrType = "";
                        }
                    } else if (typeLetter == 'T') {
                        switch (this.addrType) {
                            case "a": {
                                if (NodeUtils.hasAccessoryFunctions((long)uid)) break;
                                this.addrType = "";
                                break;
                            }
                            case "p": {
                                if (NodeUtils.hasSwitchFunctions((long)uid)) break;
                                this.addrType = "";
                                break;
                            }
                            case "t": {
                                if (NodeUtils.hasCommandStationFunctions((long)uid)) break;
                                this.addrType = "";
                                break;
                            }
                            case "": {
                                if (NodeUtils.hasCommandStationFunctions((long)uid)) {
                                    this.addrType = "t";
                                    break;
                                }
                                if (NodeUtils.hasAccessoryFunctions((long)uid)) {
                                    this.addrType = "a";
                                    break;
                                }
                                if (!NodeUtils.hasSwitchFunctions((long)uid)) break;
                                this.addrType = "p";
                                break;
                            }
                            default: {
                                this.addrType = "";
                            }
                        }
                        if (this.addrType.equals("p") && this.portType != null && this.portType.equals((Object)LcOutputType.INPUTPORT)) {
                            this.addrType = "";
                        }
                    } else if (typeLetter == 'L') {
                        switch (this.addrType) {
                            case "p": {
                                if (NodeUtils.hasSwitchFunctions((long)uid)) break;
                                this.addrType = "";
                                break;
                            }
                            case "t": {
                                if (NodeUtils.hasCommandStationFunctions((long)uid)) break;
                                this.addrType = "";
                                break;
                            }
                            case "": {
                                if (NodeUtils.hasSwitchFunctions((long)uid)) {
                                    this.addrType = "p";
                                    break;
                                }
                                if (!NodeUtils.hasCommandStationFunctions((long)uid)) break;
                                this.addrType = "t";
                                break;
                            }
                            default: {
                                this.addrType = "";
                            }
                        }
                        if (this.addrType.equals("p") && this.portType != null && this.portType.equals((Object)LcOutputType.INPUTPORT)) {
                            this.addrType = "";
                        }
                    }
                    if (this.addrType.equals("p")) {
                        if (!foundNode.isPortFlatModelAvailable() && this.portType == null) {
                            this.portType = LcOutputType.SWITCHPORT;
                        }
                    } else if (this.portType != null) {
                        this.addrType = "";
                    }
                    if (this.addr >= 0 && !this.addrType.isEmpty()) {
                        this.node = foundNode;
                    }
                }
                if (!this.isValid()) {
                    throw new Exception("Invalid BiDiB address: " + systemName);
                }
            }
            catch (Exception e) {
                this.node = null;
            }
        }
        if (this.isValid()) {
            log.debug("BiDiB \"{}\" -> {}", (Object)systemName, (Object)this.toString());
        } else {
            log.warn("*** BiDiB system name \"{}\" is invalid", (Object)systemName);
        }
    }

    public static boolean isValidSystemNameFormat(String systemName, char typeLetter, BiDiBSystemConnectionMemo memo) {
        String aString = systemName.substring(memo.getSystemPrefix().length() + 1);
        if (addrPattern == null) {
            addrPattern = Pattern.compile(addrRegex);
            log.trace("regexp: {}", (Object)addrRegex);
        }
        if (!aString.isEmpty() && systemName.charAt(memo.getSystemPrefix().length()) == typeLetter) {
            Matcher matcher = addrPattern.matcher(aString);
            if (matcher.matches()) {
                return true;
            }
            log.trace("systemName {} does not match regular expression", (Object)systemName);
            return false;
        }
        return false;
    }

    public void invalidate() {
        log.warn("BiDiB address invalidated: {}", (Object)this);
        this.node = null;
        this.nodeuid = 0L;
    }

    public boolean isValid() {
        return this.node != null;
    }

    public boolean isPortAddr() {
        return this.addrType.equals("p");
    }

    public boolean isAccessoryAddr() {
        return this.addrType.equals("a");
    }

    public boolean isFeedbackAddr() {
        return this.addrType.equals("f");
    }

    public boolean isTrackAddr() {
        return this.addrType.equals("t");
    }

    public long getNodeUID() {
        return this.nodeuid;
    }

    public int getAddr() {
        return this.addr;
    }

    public String getAddrString() {
        return this.aString;
    }

    public Node getNode() {
        return this.node;
    }

    public byte[] getNodeAddr() {
        byte[] ret = new byte[]{};
        if (this.node != null) {
            ret = this.node.getAddr();
        }
        return ret;
    }

    public LcOutputType getPortType() {
        return this.portType;
    }

    protected String getAddrtype() {
        return this.addrType;
    }

    public boolean isPortTypeBasedModel() {
        return this.node != null && this.isPortAddr() && !this.node.isPortFlatModelAvailable();
    }

    public boolean isAddressEqual(BiDiBAddress other) {
        if (this.node == null || other.getNodeUID() != this.getNodeUID() || other.getAddr() != this.addr || !other.getAddrtype().equals(this.addrType)) {
            return false;
        }
        if (this.isPortAddr() && this.isPortTypeBasedModel()) {
            return other.getPortType() == this.portType;
        }
        return true;
    }

    public boolean isAddressEqual(LcConfig lcConfig) {
        return this.isAddressEqual(lcConfig.getBidibPort());
    }

    public boolean isAddressEqual(LcConfigX lcConfigX) {
        return this.isAddressEqual(lcConfigX.getBidibPort());
    }

    public boolean isAddressEqual(BidibPort bidibPort) {
        if (this.node == null || !this.isPortAddr()) {
            return false;
        }
        if (this.node.isPortFlatModelAvailable()) {
            return bidibPort.getPortNumber(PortModelEnum.flat_extended) == this.addr;
        }
        return bidibPort.getPortNumber(PortModelEnum.type) == this.addr && bidibPort.getPortType(PortModelEnum.type) == this.portType;
    }

    public BidibPort makeBidibPort() {
        if (this.node == null || !this.isPortAddr()) {
            return null;
        }
        return BidibPort.prepareBidibPort((PortModelEnum)PortModelEnum.getPortModel((Node)this.node), (LcOutputType)this.portType, (int)this.addr);
    }

    public static boolean isValidAddress(String systemName, char typeLetter, BiDiBSystemConnectionMemo memo) throws IllegalArgumentException {
        BiDiBAddress addr = new BiDiBAddress(systemName, typeLetter, memo);
        return addr.isValid();
    }

    public String toString() {
        Object s = "";
        if (this.isPortAddr()) {
            s = "(" + (this.isPortTypeBasedModel() ? "type-based" : "flat") + "),portType=" + this.portType;
        }
        return "BiDiBAdress[UID=" + ByteUtils.formatHexUniqueId((long)this.nodeuid) + ",addrType=" + this.addrType + ",addr=" + this.addr + (String)s + "]";
    }
}

