/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import jmri.implementation.AbstractVariableLight;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBLightManager;
import jmri.jmrix.bidib.BiDiBNamedBeanInterface;
import jmri.jmrix.bidib.BiDiBOutputMessageHandler;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.util.MathUtil;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBLight
extends AbstractVariableLight
implements BiDiBNamedBeanInterface {
    private BiDiBAddress addr;
    private final char typeLetter;
    private BiDiBTrafficController tc = null;
    protected BiDiBOutputMessageHandler messageHandler = null;
    private LcOutputType portType;
    private static final Logger log = LoggerFactory.getLogger(BiDiBLight.class);

    public BiDiBLight(String systemName, BiDiBLightManager mgr) {
        super(systemName);
        this.tc = mgr.getMemo().getBiDiBTrafficController();
        log.debug("New Light: {}", (Object)systemName);
        this.addr = new BiDiBAddress(systemName, mgr.typeLetter(), mgr.getMemo());
        log.info("New LIGHT created: {} -> {}", (Object)systemName, (Object)this.addr);
        this.typeLetter = mgr.typeLetter();
        this.init();
    }

    private void init() {
        this.createLightListener();
        if (this.addr.isValid() && this.addr.isPortAddr() && this.addr.isPortTypeBasedModel()) {
            this.portType = this.addr.getPortType();
        }
        this.messageHandler.sendQueryConfig();
    }

    @Override
    public BiDiBAddress getAddr() {
        return this.addr;
    }

    @Override
    public void finishLoad() {
        this.messageHandler.sendQuery();
    }

    @Override
    public void nodeNew() {
        this.addr = new BiDiBAddress(this.getSystemName(), this.typeLetter, this.tc.getSystemConnectionMemo());
        if (this.addr.isValid()) {
            log.info("new light address created: {} -> {}", (Object)this.getSystemName(), (Object)this.addr);
            this.messageHandler.sendQueryConfig();
            this.messageHandler.waitQueryConfig();
            log.debug("current state is {}", (Object)this.getState());
            this.setState(this.getCommandedState());
        }
    }

    @Override
    public void nodeLost() {
        this.notifyStateChange(this.mState, 1);
    }

    public BiDiBSystemConnectionMemo getMemo() {
        return this.tc.getSystemConnectionMemo();
    }

    public BiDiBAddress getAddress() {
        return this.addr;
    }

    @Override
    public void dispose() {
        if (this.messageHandler != null) {
            this.tc.removeMessageListener((MessageListener)this.messageHandler);
            this.messageHandler = null;
        }
        super.dispose();
    }

    public boolean isIntensityVariable() {
        if (this.portType != null) {
            switch (this.portType) {
                case LIGHTPORT: 
                case SERVOPORT: 
                case BACKLIGHTPORT: 
                case MOTORPORT: 
                case ANALOGPORT: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isTransitionAvailable() {
        return this.portType != LcOutputType.LIGHTPORT && this.isIntensityVariable();
    }

    @Override
    public synchronized void setState(int newState) {
        log.trace("BiDiBLight setState: new: {}, old: {}", (Object)newState, (Object)this.mState);
        if (newState != 2 && newState != 4) {
            throw new IllegalArgumentException("cannot set state value " + newState);
        }
        this.setTargetIntensity(newState == 2 ? this.mMaxIntensity : this.mMinIntensity);
    }

    @Override
    public void setTargetIntensity(double intensity) {
        log.trace("BiDiBLight setTargetIntensity: new: {}", (Object)intensity);
        if (this.portType == LcOutputType.LIGHTPORT) {
            this.sendIntensity(intensity);
            this.notifyTargetIntensityChange(intensity);
            int state = (int)(intensity * 100.0);
            if (state == 2 || state == 0) {
                this.notifyStateChange(this.mState, 4);
            } else {
                this.notifyStateChange(this.mState, 2);
            }
        } else {
            if (intensity < 0.0 || intensity > 1.0) {
                throw new IllegalArgumentException("Target intensity value " + intensity + " not in legal range");
            }
            if (intensity > this.mMaxIntensity) {
                intensity = this.mMaxIntensity;
            }
            if (intensity < this.mMinIntensity) {
                intensity = this.mMinIntensity;
            }
            if (this.getTransitionTime() > 0.0 && this.portType != LcOutputType.LIGHTPORT) {
                this.startTransition(intensity);
            } else {
                this.sendIntensity(intensity);
                this.notifyTargetIntensityChange(intensity);
                if (intensity >= this.mMaxIntensity) {
                    this.notifyStateChange(this.mState, 2);
                } else if (intensity <= this.mMinIntensity) {
                    this.notifyStateChange(this.mState, 4);
                } else {
                    this.notifyStateChange(this.mState, 8);
                }
            }
        }
    }

    protected void sendLcOutput(int portstat) {
        this.messageHandler.sendOutput(portstat);
    }

    @Override
    protected void sendIntensity(double intensity) {
        log.trace("sendIntensity: {}", (Object)intensity);
        if (this.portType == LcOutputType.LIGHTPORT) {
            this.sendLcOutput((int)(intensity * 100.0));
        } else if (this.isIntensityVariable()) {
            this.sendLcOutput((int)MathUtil.pin(intensity * 255.0, 0.0, 255.0));
        } else {
            this.sendLcOutput(intensity > this.mMinIntensity ? 1 : 0);
        }
    }

    public void receiveIntensity(int portstat) {
        log.trace("receiveIntensity: {}", (Object)portstat);
        if (this.portType == LcOutputType.LIGHTPORT) {
            double intensity = 0.0;
            switch (portstat) {
                case 0: {
                    intensity = 0.0;
                    break;
                }
                case 2: {
                    intensity = this.mMinIntensity;
                    break;
                }
                case 1: {
                    intensity = 1.0;
                    break;
                }
                case 3: {
                    intensity = this.mMaxIntensity;
                    break;
                }
                default: {
                    intensity = 0.0;
                }
            }
            this.notifyTargetIntensityChange(intensity);
            if (portstat == 2 || portstat == 0) {
                this.notifyStateChange(this.mState, 4);
            } else {
                this.notifyStateChange(this.mState, 2);
            }
        } else if (this.isIntensityVariable()) {
            double intensity = MathUtil.pin((double)portstat / 255.0, 0.0, 1.0);
            this.notifyTargetIntensityChange(intensity);
            this.notifyStateChange(this.mState, intensity <= this.mMinIntensity ? 4 : 2);
        } else {
            this.notifyTargetIntensityChange(portstat == 0 ? this.mMinIntensity : this.mMaxIntensity);
            this.notifyStateChange(this.mState, portstat == 0 ? 4 : 2);
        }
    }

    @Override
    protected void sendOnOffCommand(int newState) {
        log.trace("sendOnOffCommand: {}", (Object)newState);
    }

    @Override
    protected int getNumberOfSteps() {
        return 256;
    }

    private void createLightListener() {
        this.messageHandler = new BiDiBOutputMessageHandler(this, "LIGHT", this.tc){

            @Override
            public void newOutputState(int state) {
                log.debug("LIGHT new state: {}", (Object)state);
                BiDiBLight.this.receiveIntensity(state);
            }

            @Override
            public void outputWait(int time) {
                log.debug("LIGHT wait: {}", (Object)time);
                if (time > 0) {
                    BiDiBLight.this.notifyStateChange(BiDiBLight.this.getState(), 8);
                }
            }

            @Override
            public void errorState(int err) {
                log.warn("LIGHT error: {} addr: {}", (Object)err, (Object)BiDiBLight.this.addr);
                BiDiBLight.this.notifyStateChange(BiDiBLight.this.getState(), 8);
            }

            @Override
            public void newLcConfigX(LcConfigX lcConfigX, LcOutputType _lcType) {
                BiDiBLight.this.portType = _lcType;
            }
        };
        this.tc.addMessageListener((MessageListener)this.messageHandler);
    }
}

