/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Light;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBLight;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.Bundle;
import jmri.managers.AbstractLightManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBLightManager
extends AbstractLightManager {
    private BiDiBTrafficController tc = null;
    private boolean isLoading = false;
    private final ArrayList<BiDiBLight> pendingLights = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(BiDiBLightManager.class);

    public BiDiBLightManager(BiDiBSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getBiDiBTrafficController();
    }

    @Override
    public BiDiBSystemConnectionMemo getMemo() {
        return (BiDiBSystemConnectionMemo)this.memo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Light createNewLight(String systemName, String userName) {
        log.trace("createNewLight {} - {}", (Object)systemName, (Object)userName);
        try {
            this.validateSystemNameFormat(systemName);
        }
        catch (IllegalArgumentException e) {
            log.error("Error validating", (Throwable)e);
            throw e;
        }
        BiDiBLight lgt = new BiDiBLight(systemName, this);
        lgt.setUserName(userName);
        ArrayList<BiDiBLight> arrayList = this.pendingLights;
        synchronized (arrayList) {
            if (this.isLoading) {
                this.pendingLights.add(lgt);
            } else {
                lgt.finishLoad();
            }
        }
        return lgt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad() {
        log.debug("Light manager : start load");
        ArrayList<BiDiBLight> arrayList = this.pendingLights;
        synchronized (arrayList) {
            this.isLoading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad() {
        log.info("Light manager : finish load");
        ArrayList<BiDiBLight> arrayList = this.pendingLights;
        synchronized (arrayList) {
            this.pendingLights.forEach(s -> s.finishLoad());
            this.pendingLights.clear();
            this.isLoading = false;
        }
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        log.trace("createSystemName from {} - {}", (Object)curAddress, (Object)prefix);
        try {
            int i = 1;
            int curNum = Integer.parseInt(curAddress);
            for (Light lgt : this.getNamedBeanSet()) {
                if (i++ != curNum) continue;
                return lgt.getSystemName();
            }
        }
        catch (NumberFormatException ex) {
            throw new JmriException("Hardware Address passed " + curAddress + " should be a number");
        }
        return prefix + this.typeLetter() + curAddress;
    }

    @Override
    public String validateSystemNameFormat(String name, Locale locale) {
        log.trace("validateSystemNameFormat: name: {}, typeLetter: {}", (Object)name, (Object)Character.valueOf(this.typeLetter()));
        this.validateSystemNamePrefix(name, locale);
        if (!BiDiBAddress.isValidSystemNameFormat(name, this.typeLetter(), this.getMemo())) {
            throw new NamedBean.BadSystemNameException(Locale.getDefault(), "InvalidSystemName", name);
        }
        return name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        if (systemName.length() <= this.getSystemPrefix().length()) {
            return Manager.NameValidity.INVALID;
        }
        return Manager.NameValidity.VALID;
    }

    @Override
    public boolean validSystemNameConfig(String systemName) {
        return true;
    }

    @Override
    public boolean allowMultipleAdditions(String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }

    public void configAll() {
        log.trace("configAll tc: {}", (Object)this.tc);
        log.debug("LightManager config must be called after SensorManager config. If this changes in JMRI, sensor ports won't be checked!");
        this.tc.allPortConfigX();
    }
}

