/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.SignalMastManager;
import jmri.TurnoutManager;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBNamedBeanInterface;
import jmri.jmrix.bidib.BiDiBReporterManager;
import jmri.jmrix.bidib.BiDiBSensorManager;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeatureData;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBNodeInitializer
implements Runnable {
    private final Map<Long, Node> nodes;
    private final BidibInterface bidib;
    private final BiDiBTrafficController tc;
    private SimplePair currentNode;
    private Thread initThread;
    private final LinkedList<SimplePair> queue;
    private static final Logger log = LoggerFactory.getLogger(BiDiBNodeInitializer.class);

    public BiDiBNodeInitializer(BiDiBTrafficController tc, BidibInterface bidib, Map<Long, Node> nodes) {
        this.bidib = bidib;
        this.nodes = nodes;
        this.tc = tc;
        this.queue = new LinkedList();
        log.debug("BiDiB node initializer created");
    }

    public void initNode(Node node) throws ProtocolException {
        if (node != null) {
            BidibNode bidibNode = this.bidib.getNode(node);
            log.info("+++ found node: {}", (Object)node);
            int magic = bidibNode.getMagic(Integer.valueOf(0));
            log.debug("Node returned magic: 0x{}", (Object)ByteUtils.magicToHex((int)magic));
            if (magic == 45054) {
                Feature stringSize;
                block14: {
                    node.setStoredString(0, bidibNode.getString(0, 0).getValue());
                    node.setStoredString(1, bidibNode.getString(0, 1).getValue());
                    node.setProtocolVersion(bidibNode.getProtocolVersion());
                    node.setSoftwareVersion(bidibNode.getSwVersion());
                    log.info("Product name: {}", (Object)node.getStoredString(0));
                    log.info("User name: {}", (Object)node.getStoredString(1));
                    log.info("Protocol version: {}", (Object)node.getProtocolVersion());
                    log.info("Software version: {}", (Object)node.getSoftwareVersion());
                    try {
                        FeatureData features = bidibNode.getFeaturesAll();
                        log.info("featureCount: {}", (Object)features.getFeatureCount());
                        if (features.isStreamingSupport()) {
                            int k = 1;
                            for (Feature feature : features.getFeatures()) {
                                log.trace("feature #{}/{}", (Object)k++, (Object)features.getFeatureCount());
                                log.info("feature.type: {}, value: {}, name: {}", new Object[]{feature.getType(), feature.getValue(), feature.getFeatureName()});
                                node.setFeature(feature);
                            }
                            break block14;
                        }
                        int k = 1;
                        try {
                            Feature feature;
                            while ((feature = bidibNode.getNextFeature()) != null) {
                                log.trace("feature #{}/{}", (Object)k++, (Object)features.getFeatureCount());
                                log.info("feature.type: {}, value: {}, name: {}", new Object[]{feature.getType(), feature.getValue(), feature.getFeatureName()});
                                node.setFeature(feature);
                            }
                        }
                        catch (ProtocolException ex) {
                            log.debug("No more features.");
                        }
                    }
                    catch (ProtocolException ex) {
                        log.error("Features can't be loaded from node: {}", (Object)ex.getMessage());
                    }
                }
                log.info("Finished query features.");
                node.setFeature(new Feature(42, 0));
                Feature relevantPidBits = Feature.findFeature((Collection)node.getFeatures(), (int)253);
                if (relevantPidBits != null) {
                    node.setRelevantPidBits(relevantPidBits.getValue());
                }
                if ((stringSize = Feature.findFeature((Collection)node.getFeatures(), (int)252)) != null) {
                    node.setStringSize(stringSize.getValue());
                }
                Integer portcount = 0;
                Feature flatModel = Feature.findFeature((Collection)node.getFeatures(), (int)71);
                if (flatModel != null) {
                    portcount = flatModel.getValue() * 256;
                }
                if ((flatModel = Feature.findFeature((Collection)node.getFeatures(), (int)70)) != null) {
                    portcount = portcount + flatModel.getValue();
                }
                if (portcount > 0) {
                    node.setPortFlatModel(portcount);
                }
            }
            log.debug("+++ node init finished: {}", (Object)node);
        }
    }

    public void nodeLost(Node node) {
        log.error("BiDiB node lost! {}", (Object)node);
        this.startNodeUpdate(node, false);
    }

    public void nodeNew(Node node) {
        log.warn("New BiDiB node found {}", (Object)node);
        long uid = node.getUniqueId() & 0xFFFFFFFFFFL;
        this.nodes.put(uid, node);
        this.startNodeUpdate(node, true);
    }

    public void connectionLost() {
        if (!this.nodes.isEmpty()) {
            log.warn("remove all nodes from connection.");
            for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
                Node node = entry.getValue();
                this.startNodeUpdate(node, false);
            }
        }
    }

    public boolean connectionInit() {
        try {
            log.debug("get relevant node data");
            RootNode rootNode = this.bidib.getRootNode();
            int magic = rootNode.getMagic(Integer.valueOf(0));
            log.debug("Root Node returned magic: 0x{}", (Object)ByteUtils.magicToHex((int)magic));
            if (magic != 45054) {
                return false;
            }
            log.trace("root node: {}, node: {}", (Object)rootNode, (Object)rootNode.getMasterNode());
            int count = rootNode.getNodeCount();
            log.debug("node count: {}", (Object)count);
            byte[] nodeaddr = rootNode.getAddr();
            log.debug("node addr length: {}", (Object)nodeaddr.length);
            log.debug("node addr: {}", (Object)nodeaddr);
            for (int i = 0; i < nodeaddr.length; ++i) {
                log.debug("  byte {}: {}", (Object)i, (Object)nodeaddr[i]);
            }
            for (int index = 1; index <= count; ++index) {
                Node node = rootNode.getNextNode(null);
                this.initNode(node);
                long uid = node.getUniqueId() & 0xFFFFFFFFFFL;
                this.nodes.put(uid, node);
            }
            rootNode.sysEnable();
            log.info("--- node init finished ---");
            Node csnode = this.tc.getFirstCommandStationNode();
            if (csnode != null) {
                this.tc.sendBiDiBMessage((BidibCommandMessage)new CommandStationSetStateMessage(CommandStationState.QUERY), csnode);
            }
            return true;
        }
        catch (ProtocolException ex) {
            log.error("The connection was not unavailable: {}. Verify that the BiDiB device is connected.", (Object)ex.getMessage());
            return false;
        }
    }

    private <T> void nodeLost(SortedSet<T> beanSet, long uniqueId) {
        beanSet.forEach(nb -> {
            BiDiBAddress addr;
            if (nb instanceof BiDiBNamedBeanInterface && (addr = ((BiDiBNamedBeanInterface)nb).getAddr()).getNodeUID() == uniqueId) {
                log.trace("-invalidate {}", nb);
                addr.invalidate();
                ((BiDiBNamedBeanInterface)nb).nodeLost();
            }
        });
    }

    private void nodeLostBeans(long uniqueId) {
        long uid = uniqueId & 0xFFFFFFFFFFL;
        this.nodeLost(InstanceManager.getDefault(TurnoutManager.class).getNamedBeanSet(), uid);
        this.nodeLost(InstanceManager.getDefault(SensorManager.class).getNamedBeanSet(), uid);
        this.nodeLost(InstanceManager.getDefault(LightManager.class).getNamedBeanSet(), uid);
        this.nodeLost(InstanceManager.getDefault(ReporterManager.class).getNamedBeanSet(), uid);
        this.nodeLost(InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet(), uid);
        this.nodes.remove(uid);
    }

    private <T> void nodeNew(SortedSet<T> beanSet, Node node) {
        beanSet.forEach(nb -> {
            BiDiBAddress addr;
            if (nb instanceof BiDiBNamedBeanInterface && !(addr = ((BiDiBNamedBeanInterface)nb).getAddr()).isValid()) {
                log.trace("+new bean {}", nb);
                ((BiDiBNamedBeanInterface)nb).nodeNew();
            }
        });
    }

    private void nodeNewBeans(Node node) {
        BiDiBReporterManager br;
        try {
            this.tc.getBidib().getRootNode().sysEnable();
        }
        catch (ProtocolException e) {
            log.warn("failed to ENABLE node {}", (Object)node, (Object)e);
        }
        this.nodeNew(InstanceManager.getDefault(TurnoutManager.class).getNamedBeanSet(), this.currentNode.node);
        this.nodeNew(InstanceManager.getDefault(SensorManager.class).getNamedBeanSet(), this.currentNode.node);
        this.nodeNew(InstanceManager.getDefault(LightManager.class).getNamedBeanSet(), this.currentNode.node);
        this.nodeNew(InstanceManager.getDefault(ReporterManager.class).getNamedBeanSet(), this.currentNode.node);
        this.nodeNew(InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet(), this.currentNode.node);
        BiDiBSensorManager bs = (BiDiBSensorManager)this.tc.getSystemConnectionMemo().getSensorManager();
        if (bs != null) {
            bs.updateNodeFeedbacks(node);
        }
        if ((br = (BiDiBReporterManager)this.tc.getSystemConnectionMemo().getReporterManager()) != null) {
            br.updateNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNodeUpdate(Node node, boolean isNewNode) {
        LinkedList<SimplePair> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.isEmpty() || this.initThread == null || !this.initThread.isAlive()) {
                if (this.initThread != null) {
                    try {
                        this.initThread.join(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.initThread = new Thread((Runnable)this, "NodeInitThread");
                this.initThread.setPriority(1);
                this.queue.add(new SimplePair(node, isNewNode));
                this.initThread.start();
                log.debug("thread was started - return");
            } else {
                this.queue.add(new SimplePair(node, isNewNode));
                log.debug("thread running, just add node to queue and return");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug("starting thread for node initialization");
        while (true) {
            log.trace("-- loop, queue size: {}", (Object)this.queue.size());
            LinkedList<SimplePair> linkedList = this.queue;
            synchronized (linkedList) {
                log.trace("  currentNode: {}", (Object)this.currentNode);
                if (this.currentNode != null) {
                    this.queue.removeFirst();
                    this.currentNode = null;
                }
                this.currentNode = this.queue.peekFirst();
                if (this.currentNode == null) {
                    break;
                }
            }
            if (this.currentNode.isNewNode) {
                try {
                    this.initNode(this.currentNode.node);
                    this.nodeNewBeans(this.currentNode.node);
                }
                catch (Exception e) {
                    log.warn("error initializing node {}", (Object)this.currentNode.node, (Object)e);
                }
                continue;
            }
            this.nodeLostBeans(this.currentNode.node.getUniqueId());
        }
        log.debug("thread finished for node");
    }

    private static class SimplePair {
        public Node node;
        public boolean isNewNode;

        public SimplePair(Node node, boolean isNewNode) {
            this.node = node;
            this.isNewNode = isNewNode;
        }
    }
}

