/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.node.CommandStationNode;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.PomAcknowledge;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBOpsModeProgrammer
extends AbstractProgrammer
implements AddressedProgrammer {
    protected int mAddress;
    protected int progState = 0;
    protected int value;
    protected int cv;
    protected ProgListener progListener = null;
    protected static final int NOTPROGRAMMING = 0;
    protected static final int READREQUEST = 1;
    protected static final int WRITEREQUEST = 2;
    protected BiDiBTrafficController tc = null;
    MessageListener messageListener = null;
    protected Node node = null;
    private static final Logger log = LoggerFactory.getLogger(BiDiBOpsModeProgrammer.class);

    public BiDiBOpsModeProgrammer(int pAddress, BiDiBTrafficController controller) {
        this.tc = controller;
        this.node = this.tc.getFirstCommandStationNode();
        if (log.isDebugEnabled()) {
            log.debug("Creating Ops Mode Programmer for Address {}", (Object)pAddress);
        }
        this.mAddress = pAddress;
        this.createOpsModeProgrammerListener();
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.info("write ops mode: {}, CV={}, val={}", new Object[]{this.getMode().getStandardName(), CV, val});
        this.progListener = p;
        this.cv = CV;
        this.value = val;
        this.progState = 2;
        PomAddressData decoderAddress = new PomAddressData(this.mAddress, PomAddressTypeEnum.LOCOMOTIVE);
        this.restartTimer(5000);
        this.tc.addMessageListener(this.messageListener);
        CommandStationNode csNode = this.tc.getBidib().getCommandStationNode(this.node);
        log.debug("node: {}, csNode: {}", (Object)this.node, (Object)csNode);
        this.tc.checkProgMode(false, this.node);
        try {
            log.trace("start CS_POM asynchroneously, write value: {}", (Object)this.value);
            csNode.writePom(false, decoderAddress, CommandStationPom.WR_BYTE, this.cv, this.value);
        }
        catch (ProtocolException ex) {
            log.error("writePom async failed on node: {}, addr: {} - ", new Object[]{this.node, decoderAddress, ex});
            this.progState = 0;
            this.notifyProgListenerEnd(p, 0, PomAcknowledge.NOT_ACKNOWLEDGED);
        }
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.info("read ops mode: {}, CV={}", (Object)this.getMode().getStandardName(), (Object)CV);
        this.progListener = p;
        this.progState = 1;
        this.cv = CV;
        this.value = 42;
        PomAddressData decoderAddress = new PomAddressData(this.mAddress, PomAddressTypeEnum.LOCOMOTIVE);
        this.restartTimer(5000);
        this.tc.addMessageListener(this.messageListener);
        CommandStationNode csNode = this.tc.getBidib().getCommandStationNode(this.node);
        this.tc.checkProgMode(false, this.node);
        try {
            log.trace("start CS_POM asynchroneously");
            csNode.readPom(false, decoderAddress, CommandStationPom.RD_BYTE, this.cv);
        }
        catch (ProtocolException ex) {
            log.error("readPom async failed on node: {}, addr: {} - ", new Object[]{this.node, decoderAddress, ex});
            this.progState = 0;
            this.notifyProgListenerEnd(p, 0, PomAcknowledge.NOT_ACKNOWLEDGED);
        }
        log.trace("Return from readCV");
    }

    @Override
    public void confirmCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.info("confirmCV ops mode: {}, CV={}", (Object)this.getMode().getStandardName(), (Object)CV);
        this.readCV(CVname, p);
    }

    public void notifyProgListenerEnd(ProgListener p, int value, PomAcknowledge result) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {}", (Object)value);
        }
        this.stopTimer();
        this.tc.removeMessageListener(this.messageListener);
        this.progState = 0;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (result == PomAcknowledge.NOT_ACKNOWLEDGED) {
            this.notifyProgListenerEnd(p, value, 32);
        } else {
            this.notifyProgListenerEnd(p, value, 0);
        }
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        log.debug("canRead");
        if (this.tc.getNodeFeature(this.node, 14) != 0) {
            return true;
        }
        return true;
    }

    @Override
    public boolean getCanRead(String addr) {
        log.debug("canRead addr: {}", (Object)addr);
        return this.getCanRead();
    }

    @Override
    public boolean getLongAddress() {
        return true;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    @Override
    protected synchronized void timeout() {
        log.trace("** timeout **");
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            if (this.getCanRead()) {
                this.notifyProgListenerEnd(this.progListener, this.value, 128);
            } else {
                this.notifyProgListenerEnd(this.progListener, this.value, 0);
            }
        } else {
            this.tc.removeMessageListener(this.messageListener);
        }
    }

    private void createOpsModeProgrammerListener() {
        this.messageListener = new DefaultMessageListener(){

            public void csPomAcknowledge(byte[] address, int messageNum, PomAddressData addressData, PomAcknowledge state) {
                log.trace("csPomAcknowledge");
                if (BiDiBOpsModeProgrammer.this.progState != 0) {
                    log.debug("loco addr: {}, msg loco addr: {}", (Object)BiDiBOpsModeProgrammer.this.mAddress, (Object)addressData.getAddress());
                    if (BiDiBOpsModeProgrammer.this.mAddress == addressData.getAddress()) {
                        log.info("OPS PROGRAMMER CS_POM_ACC was signalled, node addr: {}, decoderAddress: {} {}, state: {}", new Object[]{address, addressData.getAddress(), addressData.getType(), state});
                    }
                    if (state == PomAcknowledge.NOT_ACKNOWLEDGED) {
                        log.warn("readPom was not acknowledged on node addr: {}, loco addr: {}", (Object)addressData.getAddress(), (Object)addressData.getAddress());
                        BiDiBOpsModeProgrammer.this.stopTimer();
                        BiDiBOpsModeProgrammer.this.progState = 0;
                        BiDiBOpsModeProgrammer.this.notifyProgListenerEnd(BiDiBOpsModeProgrammer.this.progListener, 0, PomAcknowledge.NOT_ACKNOWLEDGED);
                    } else if (BiDiBOpsModeProgrammer.this.progState == 2) {
                        log.debug("writePom finished - value: {}", (Object)BiDiBOpsModeProgrammer.this.value);
                        BiDiBOpsModeProgrammer.this.stopTimer();
                        BiDiBOpsModeProgrammer.this.progState = 0;
                        BiDiBOpsModeProgrammer.this.notifyProgListenerEnd(BiDiBOpsModeProgrammer.this.progListener, BiDiBOpsModeProgrammer.this.value, PomAcknowledge.ACKNOWLEDGED);
                    }
                }
                log.trace("return from csPomAcknowledge");
            }

            public void feedbackCv(byte[] address, int messageNum, PomAddressData decoderAddress, int cvNumber, int dat) {
                log.trace("feedbackCv");
                if (BiDiBOpsModeProgrammer.this.progState != 0) {
                    log.debug("loco addr: {}, msg loco addr: {}", (Object)BiDiBOpsModeProgrammer.this.mAddress, (Object)decoderAddress.getAddress());
                    if (BiDiBOpsModeProgrammer.this.mAddress == decoderAddress.getAddress() && BiDiBOpsModeProgrammer.this.cv == cvNumber) {
                        BiDiBOpsModeProgrammer.this.stopTimer();
                        BiDiBOpsModeProgrammer.this.progState = 0;
                        log.info("OPS PROGRAMMER BM_CV was signalled, node addr: {}, decoderAddress: {} {}, CV: {}, value: {}", new Object[]{address, decoderAddress.getAddress(), decoderAddress.getType(), cvNumber, dat});
                        BiDiBOpsModeProgrammer.this.value = dat;
                        BiDiBOpsModeProgrammer.this.notifyProgListenerEnd(BiDiBOpsModeProgrammer.this.progListener, BiDiBOpsModeProgrammer.this.value, PomAcknowledge.ACKNOWLEDGED);
                    }
                } else {
                    BiDiBOpsModeProgrammer.this.progState = 0;
                    BiDiBOpsModeProgrammer.this.tc.removeMessageListener(BiDiBOpsModeProgrammer.this.messageListener);
                }
                log.trace("return from feedbackCv");
            }

            public void feedbackXPom(byte[] address, int messageNum, AddressData decoderAddress, int cvNumber, int[] data) {
                log.trace("feedbackXPom");
                if (BiDiBOpsModeProgrammer.this.progState != 0) {
                    log.debug("loco addr: {}, msg loco addr: {}", (Object)BiDiBOpsModeProgrammer.this.mAddress, (Object)decoderAddress.getAddress());
                    if (BiDiBOpsModeProgrammer.this.mAddress == decoderAddress.getAddress() && BiDiBOpsModeProgrammer.this.cv == cvNumber) {
                        BiDiBOpsModeProgrammer.this.stopTimer();
                        BiDiBOpsModeProgrammer.this.progState = 0;
                        log.info("OPS PROGRAMMER BM_XCOM was signalled, node addr: {}, decoderAddress: {} {}, CV: {}, values: {}", new Object[]{address, decoderAddress.getAddress(), decoderAddress.getType(), cvNumber, data});
                        BiDiBOpsModeProgrammer.this.value = data[0];
                        BiDiBOpsModeProgrammer.this.notifyProgListenerEnd(BiDiBOpsModeProgrammer.this.progListener, BiDiBOpsModeProgrammer.this.value, PomAcknowledge.ACKNOWLEDGED);
                    }
                } else {
                    BiDiBOpsModeProgrammer.this.progState = 0;
                    BiDiBOpsModeProgrammer.this.tc.removeMessageListener(BiDiBOpsModeProgrammer.this.messageListener);
                }
            }
        };
    }
}

