/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.LinkedHashMap;
import java.util.Map;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBNamedBeanInterface;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.AccessoryStateOptions;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.LcConfig;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.enums.ActivateCoilEnum;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryMessage;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBOutputMessageHandler
extends DefaultMessageListener {
    private final BiDiBNamedBeanInterface nb;
    protected BiDiBTrafficController tc = null;
    protected String type;
    protected LcConfigX portConfigx;
    protected LcOutputType lcType;
    protected BidibRequestFactory requestFactory = null;
    final Object portConfigLock = new Object();
    private final Map<BiDiBAddress, Integer> csAccessoryAspectMap = new LinkedHashMap<BiDiBAddress, Integer>();
    private static final Logger log = LoggerFactory.getLogger(BiDiBOutputMessageHandler.class);

    BiDiBOutputMessageHandler(BiDiBNamedBeanInterface nb, String type, BiDiBTrafficController tc) {
        this.type = type;
        this.nb = nb;
        this.tc = tc;
        BiDiBAddress addr = nb.getAddr();
        if (addr.isValid() && tc != null) {
            this.lcType = addr.getPortType();
            this.requestFactory = tc.getBidib().getNode(addr.getNode()).getRequestFactory();
        }
    }

    public LcConfigX getConfigX() {
        return this.portConfigx;
    }

    public LcOutputType getLcType() {
        return this.lcType;
    }

    public void sendOutput(int portstat) {
        BiDiBAddress addr = this.nb.getAddr();
        log.trace("sendOutput: portstat: {}", (Object)portstat);
        if (addr.isValid()) {
            log.info("send output message to BiDiB: addr: {}, state: {}", (Object)addr, (Object)portstat);
            Node node = addr.getNode();
            if (addr.isPortAddr()) {
                if (this.portExists() && this.requestFactory != null) {
                    this.waitQueryConfig();
                    LcOutputMessage m = this.requestFactory.createLcOutputMessage(this.tc.getPortModel(node), this.lcType, addr.getAddr(), portstat);
                    this.tc.sendBiDiBMessage((BidibCommandMessage)m, node);
                }
            } else if (addr.isAccessoryAddr()) {
                if (this.accessoryExists()) {
                    this.tc.sendBiDiBMessage((BidibCommandMessage)new AccessorySetMessage(addr.getAddr(), portstat), node);
                }
            } else if (addr.isTrackAddr()) {
                this.tc.sendBiDiBMessage((BidibCommandMessage)new CommandStationAccessoryMessage(addr.getAddr(), AddressTypeEnum.ACCESSORY, TimingControlEnum.COIL_ON_OFF, ActivateCoilEnum.COIL_ON, portstat & 0x1F, TimeBaseUnitEnum.UNIT_100MS, 0), node);
                this.csAccessoryAspectMap.put(addr, portstat & 0x1F);
            } else {
                log.error("sending output message not supported for address type");
            }
        } else {
            log.warn("node is not available, UID: {}", (Object)ByteUtils.formatHexUniqueId((long)addr.getNodeUID()));
        }
    }

    public void sendQueryConfig() {
        BiDiBAddress addr = this.nb.getAddr();
        log.trace("queryOutput for addr: {}", (Object)addr);
        if (addr.isValid()) {
            log.debug("send query config message to BiDiB: addr: {}", (Object)addr);
            Node node = addr.getNode();
            if (addr.isPortAddr() && this.portExists() && this.requestFactory != null) {
                log.info("send port query config message to BiDiB: addr: {}", (Object)addr);
                Object m = node.getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_6) ? this.requestFactory.createLcConfigXGet(this.tc.getPortModel(node), this.lcType, addr.getAddr()) : this.requestFactory.createLcConfigGet(this.tc.getPortModel(node), this.lcType, addr.getAddr());
                this.portConfigx = null;
                this.tc.sendBiDiBMessage((BidibCommandMessage)m, node);
            }
        } else {
            log.warn("node is not available, UID: {}", (Object)ByteUtils.formatHexUniqueId((long)addr.getNodeUID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitQueryConfig() {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isValid() && addr.isPortAddr()) {
            Object object = this.portConfigLock;
            synchronized (object) {
                while (this.portConfigx == null) {
                    try {
                        log.debug("wait for config message from BiDiB: addr: {}", (Object)addr);
                        this.portConfigLock.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        log.warn("Wait for port config was interrupted.", (Throwable)ie);
                    }
                }
            }
        }
    }

    public void sendQuery() {
        BiDiBAddress addr = this.nb.getAddr();
        log.trace("queryOutput for addr: {}", (Object)addr);
        if (addr.isValid()) {
            log.info("send query output message to BiDiB: addr: {}", (Object)addr);
            Node node = addr.getNode();
            if (addr.isPortAddr()) {
                if (this.portExists() && this.requestFactory != null) {
                    this.waitQueryConfig();
                    Object m = node.getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_6) || this.lcType.getType() <= 7 ? this.requestFactory.createLcPortQuery(this.tc.getPortModel(node), this.lcType, addr.getAddr()) : this.requestFactory.createLcKey(addr.getAddr());
                    this.tc.sendBiDiBMessage((BidibCommandMessage)m, node);
                }
            } else if (addr.isAccessoryAddr()) {
                if (this.accessoryExists()) {
                    this.tc.sendBiDiBMessage((BidibCommandMessage)new AccessoryGetMessage(addr.getAddr()), node);
                }
            } else if (addr.isTrackAddr()) {
                log.info("query of a CS accessory is not possible.");
            } else if (addr.isFeedbackAddr()) {
                if (this.feedbackExists()) {
                    int a = addr.getAddr() / 8 * 8;
                    int b = (addr.getAddr() + 8) / 8 * 8;
                    log.debug("  requesting feedback from {} to {}", (Object)a, (Object)b);
                    this.tc.sendBiDiBMessage((BidibCommandMessage)new FeedbackGetRangeMessage(a, b), node);
                }
            } else {
                log.error("sending query output message not supported for address type, addr: {}", (Object)addr);
            }
        } else {
            log.warn("node is not available, UID: {}", (Object)ByteUtils.formatHexUniqueId((long)addr.getNodeUID()));
        }
    }

    private int getPortTypeCount(Node node, LcOutputType type) {
        int id;
        switch (type) {
            case SWITCHPORT: 
            case SWITCHPAIRPORT: {
                id = 52;
                break;
            }
            case LIGHTPORT: {
                id = 53;
                break;
            }
            case SERVOPORT: {
                id = 54;
                break;
            }
            case SOUNDPORT: {
                id = 55;
                break;
            }
            case MOTORPORT: {
                id = 56;
                break;
            }
            case ANALOGPORT: {
                id = 57;
                break;
            }
            case BACKLIGHTPORT: {
                id = 59;
                break;
            }
            case INPUTPORT: {
                id = 50;
                break;
            }
            default: {
                return 0;
            }
        }
        return this.tc.getNodeFeature(node, id);
    }

    private boolean portExists() {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isPortAddr()) {
            Node node = addr.getNode();
            if (addr.isPortTypeBasedModel() ? addr.getAddr() >= 0 && addr.getAddr() < this.getPortTypeCount(addr.getNode(), this.lcType) : addr.getAddr() >= 0 && addr.getAddr() < node.getPortFlatModel()) {
                return true;
            }
        }
        return false;
    }

    private boolean accessoryExists() {
        BiDiBAddress addr = this.nb.getAddr();
        return addr.isAccessoryAddr() && addr.getAddr() >= 0 && addr.getAddr() < this.tc.getNodeFeature(addr.getNode(), 40);
    }

    private boolean feedbackExists() {
        BiDiBAddress addr = this.nb.getAddr();
        return addr.isFeedbackAddr() && addr.getAddr() >= 0 && addr.getAddr() < this.tc.getNodeFeature(addr.getNode(), 0);
    }

    public void newOutputState(int state) {
    }

    public void errorState(int err) {
    }

    public void outputWait(int time) {
    }

    public void newLcConfigX(LcConfigX lcConfigX, LcOutputType lcType) {
    }

    public void accessoryState(byte[] address, int messageNum, AccessoryState accessoryState, AccessoryStateOptions accessoryStateOptions) {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isAccessoryAddr() && NodeUtils.isAddressEqual((byte[])addr.getNodeAddr(), (byte[])address) && addr.getAddr() == accessoryState.getAccessoryNumber()) {
            log.info("{} accessory state was signalled, state: {}, opts: {}, node: {}", new Object[]{this.type, accessoryState, accessoryStateOptions, addr});
            if (accessoryState.hasError()) {
                log.warn("Accessory state error: {}", (Object)accessoryState.getErrorInformation());
                this.errorState(accessoryState.getErrorCode());
            } else if (accessoryState.getWait() == 0) {
                this.newOutputState(accessoryState.getActiveAspect());
            } else {
                this.outputWait(accessoryState.getWait());
            }
        }
    }

    public void csAccessoryAcknowledge(byte[] address, int messageNum, int decoderAddress, AccessoryAcknowledge acknowledge) {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isTrackAddr() && NodeUtils.isAddressEqual((byte[])addr.getNodeAddr(), (byte[])address) && addr.getAddr() == decoderAddress) {
            log.info("{} CS accessory ackn was signalled, acknowledge: {}, decoderAddress: {}, node: {}", new Object[]{this.type, acknowledge, decoderAddress, addr});
            if (acknowledge == AccessoryAcknowledge.NOT_ACKNOWLEDGED) {
                log.warn("NOT acknowledged!");
                this.errorState(this.csAccessoryAspectMap.get(addr));
            } else if (acknowledge == AccessoryAcknowledge.DELAYED) {
                this.outputWait(0);
            } else {
                this.newOutputState(this.csAccessoryAspectMap.get(addr));
            }
        }
    }

    public void csAccessoryManual(byte[] address, int messageNum, AddressData decoderAddress, ActivateCoilEnum activate, int aspect) {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isAccessoryAddr() && NodeUtils.isAddressEqual((byte[])addr.getNodeAddr(), (byte[])address) && addr.getAddr() == decoderAddress.getAddress()) {
            log.info("{} accessory manual was signalled, activate coil: {}, aspect: {}, decoder address: {}, node: {}", new Object[]{this.type, activate.getType(), aspect, decoderAddress.getAddress(), addr});
            this.newOutputState(aspect);
        }
    }

    private void notifyLcConfigX(LcConfigX lcConfigX) {
        BiDiBAddress addr = this.nb.getAddr();
        log.trace("portConfigx: {}", (Object)lcConfigX);
        if (addr.getNode().isPortFlatModelAvailable()) {
            ReconfigPortConfigValue p = (ReconfigPortConfigValue)lcConfigX.getPortConfig().get((byte)-127);
            log.info("reconfig: {}, type: {}", (Object)p, (Object)p.getCurrentOutputType());
            if (this.lcType != p.getCurrentOutputType()) {
                log.warn("** reconfig: {}, type changed: {} -> {}", new Object[]{p, this.lcType, p.getCurrentOutputType()});
            }
            this.lcType = p.getCurrentOutputType();
        } else {
            this.lcType = lcConfigX.getOutputType(PortModelEnum.type);
        }
        this.newLcConfigX(lcConfigX, this.lcType);
    }

    public void lcStat(byte[] address, int messageNum, BidibPort bidibPort, int portStatus) {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isPortAddr() && NodeUtils.isAddressEqual((byte[])addr.getNodeAddr(), (byte[])address) && addr.isAddressEqual(bidibPort)) {
            log.info("{} LC status was signalled, state: {}, type: {}, node: {}", new Object[]{this.type, portStatus, this.lcType, addr});
            this.newOutputState(portStatus);
        }
    }

    public void lcWait(byte[] address, int messageNum, BidibPort bidibPort, int time) {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isPortAddr() && NodeUtils.isAddressEqual((byte[])addr.getNodeAddr(), (byte[])address) && addr.isAddressEqual(bidibPort)) {
            log.info("{} LC Wait was signalled, wait: {}, type: {}, node: {}", new Object[]{this.type, time, this.lcType, addr});
            this.outputWait(time);
        }
    }

    public void lcNa(byte[] address, int messageNum, BidibPort bidibPort, Integer errorCode) {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isPortAddr() && NodeUtils.isAddressEqual((byte[])addr.getNodeAddr(), (byte[])address) && addr.isAddressEqual(bidibPort)) {
            log.info("{} LC NA was signalled, error: {}, type: {}, node: {}", new Object[]{this.type, errorCode, this.lcType, addr});
            this.errorState(errorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lcConfig(byte[] address, int messageNum, LcConfig lcConfig) {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isPortAddr() && NodeUtils.isAddressEqual((byte[])addr.getNodeAddr(), (byte[])address) && addr.isAddressEqual(lcConfig)) {
            log.info("{} LC Config was signalled, config: {}, node: {}", new Object[]{this.type, lcConfig, addr});
            Object object = this.portConfigLock;
            synchronized (object) {
                this.portConfigx = this.tc.convertConfig2ConfigX(addr.getNode(), lcConfig);
                this.notifyLcConfigX(this.portConfigx);
                this.portConfigLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lcConfigX(byte[] address, int messageNum, LcConfigX lcConfigX) {
        BiDiBAddress addr = this.nb.getAddr();
        if (addr.isPortAddr() && NodeUtils.isAddressEqual((byte[])addr.getNodeAddr(), (byte[])address) && addr.isAddressEqual(lcConfigX)) {
            log.info("{} LC ConfigX was signalled, configx: {}, node: {}", new Object[]{this.type, lcConfigX, addr});
            Object object = this.portConfigLock;
            synchronized (object) {
                this.portConfigx = new LcConfigX(addr.makeBidibPort(), new LinkedHashMap());
                this.portConfigx.getPortConfig().putAll(lcConfigX.getPortConfig());
                this.notifyLcConfigX(this.portConfigx);
                this.portConfigLock.notifyAll();
            }
        }
    }
}

