/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.BoostOffMessage;
import org.bidib.jbidibc.messages.message.BoostOnMessage;
import org.bidib.jbidibc.messages.message.BoostQueryMessage;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBPowerManager
implements PowerManager {
    BiDiBTrafficController tc = null;
    String userName = "BiDiB";
    int power = 1;
    MessageListener messageListener = null;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(BiDiBPowerManager.class);

    public BiDiBPowerManager(BiDiBSystemConnectionMemo memo) {
        this.tc = memo.getBiDiBTrafficController();
        this.userName = memo.getUserName();
        this.createBoosterListener();
        this.tc.sendBiDiBMessage((BidibCommandMessage)new BoostQueryMessage(), this.tc.getFirstBoosterNode());
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        Node csnode = this.tc.getFirstCommandStationNode();
        if (v == 2) {
            this.tc.sendBiDiBMessage((BidibCommandMessage)new BoostOnMessage(0), this.tc.getRootNode());
            if (csnode != null) {
                this.tc.sendBiDiBMessage((BidibCommandMessage)new CommandStationSetStateMessage(CommandStationState.GO), this.tc.getFirstCommandStationNode());
            }
        } else if (v == 4) {
            if (csnode != null) {
                this.tc.sendBiDiBMessage((BidibCommandMessage)new CommandStationSetStateMessage(CommandStationState.OFF), csnode);
            }
            this.tc.sendBiDiBMessage((BidibCommandMessage)new BoostOffMessage(0), this.tc.getRootNode());
        }
        this.firePropertyChange("power", old, this.power);
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void dispose() throws JmriException {
        if (this.messageListener != null) {
            this.tc.removeMessageListener(this.messageListener);
            this.messageListener = null;
        }
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use PowerManager after dispose");
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    private void createBoosterListener() {
        this.messageListener = new DefaultMessageListener(){

            public void boosterState(byte[] address, int messageNum, BoosterState state, BoosterControl control) {
                Node node = BiDiBPowerManager.this.tc.getFirstBoosterNode();
                log.trace("booster state: msg addr: {}, booster: {}, state: {}, control: {}", new Object[]{ByteUtils.bytesToHex((byte[])address), node, state.getType(), control.getType()});
                if (NodeUtils.isAddressEqual((byte[])node.getAddr(), (byte[])address)) {
                    log.info("POWER booster state was signalled: {}, control: {}", (Object)state.getType(), (Object)control.getType());
                    int old = BiDiBPowerManager.this.power;
                    BiDiBPowerManager.this.power = BoosterState.isOnState((BoosterState)state) ? 2 : 4;
                    log.debug("change {} from {} to {}", new Object[]{"power", old, BiDiBPowerManager.this.power});
                    BiDiBPowerManager.this.firePropertyChange("power", old, BiDiBPowerManager.this.power);
                }
            }

            public void speed(byte[] address, int messageNum, AddressData addressData, int speed) {
            }
        };
        this.tc.addMessageListener(this.messageListener);
    }
}

