/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Meter;
import jmri.MeterManager;
import jmri.implementation.DefaultMeter;
import jmri.implementation.MeterUpdateTask;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.BoostQueryMessage;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBPredefinedMeters {
    private BiDiBTrafficController tc;
    private final BiDiBSystemConnectionMemo _memo;
    private final MeterUpdateTask updateTask;
    private final Map<Integer, Meter> currentMeters = new HashMap<Integer, Meter>();
    private final Map<Integer, Meter> voltageMeters = new HashMap<Integer, Meter>();
    private boolean enabled = false;
    private static final Logger log = LoggerFactory.getLogger(BiDiBPredefinedMeters.class);

    public BiDiBPredefinedMeters(BiDiBSystemConnectionMemo memo) {
        this._memo = memo;
        this.tc = this._memo.getBiDiBTrafficController();
        this.updateTask = new UpdateTask(-1);
        Map<Long, Node> nodes = this.tc.getNodeList();
        for (Map.Entry<Long, Node> entry : nodes.entrySet()) {
            Node node = entry.getValue();
            if (!NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) continue;
            log.trace("Booster - node addr: {}, node uid: {}", (Object)node.getAddr(), (Object)node);
            String sysname = String.format("X%010x", node.getUniqueId() & 0xFFFFFFFFFFL);
            DefaultMeter.DefaultCurrentMeter currentMeter = new DefaultMeter.DefaultCurrentMeter(memo.getSystemPrefix() + InstanceManager.getDefault(MeterManager.class).typeLetter() + sysname + ":BoosterCurrent", Meter.Unit.Milli, 0.0, 20224.0, 1.0, this.updateTask);
            this.currentMeters.put(NodeUtils.convertAddress((byte[])node.getAddr()), currentMeter);
            DefaultMeter.DefaultVoltageMeter voltageMeter = new DefaultMeter.DefaultVoltageMeter(memo.getSystemPrefix() + InstanceManager.getDefault(MeterManager.class).typeLetter() + sysname + ":BoosterVoltage", Meter.Unit.Milli, 0.0, 25000.0, 100.0, this.updateTask);
            this.voltageMeters.put(NodeUtils.convertAddress((byte[])node.getAddr()), voltageMeter);
            InstanceManager.getDefault(MeterManager.class).register(currentMeter);
            InstanceManager.getDefault(MeterManager.class).register(voltageMeter);
            log.debug("BiDiBPredefinedMeters constructor called");
        }
    }

    public void setBiDiBTrafficController(BiDiBTrafficController controller) {
        this.tc = controller;
    }

    private void disposeMeter(Meter meter) {
        this.updateTask.disable(meter);
        InstanceManager.getDefault(MeterManager.class).deregister(meter);
        this.updateTask.dispose(meter);
    }

    public void dispose() {
        for (Map.Entry<Integer, Meter> entry : this.currentMeters.entrySet()) {
            this.disposeMeter(entry.getValue());
        }
        for (Map.Entry<Integer, Meter> entry : this.voltageMeters.entrySet()) {
            this.disposeMeter(entry.getValue());
        }
    }

    private class UpdateTask
    extends MeterUpdateTask {
        MessageListener messageListener;

        public UpdateTask(int interval) {
            super(interval);
            this.messageListener = null;
            this.createBoosterDiagListener();
        }

        @Override
        public void enable() {
            BiDiBPredefinedMeters.this.enabled = true;
            BiDiBPredefinedMeters.this.tc.addMessageListener(this.messageListener);
            log.info("Enabled meter.");
            super.enable();
        }

        @Override
        public void disable() {
            if (!BiDiBPredefinedMeters.this.enabled) {
                return;
            }
            super.disable();
            BiDiBPredefinedMeters.this.enabled = false;
            BiDiBPredefinedMeters.this.tc.removeMessageListener(this.messageListener);
            log.info("Disabled meter.");
        }

        private void setCurrent(byte[] address, double value) throws JmriException {
            Meter meter = BiDiBPredefinedMeters.this.currentMeters.get(NodeUtils.convertAddress((byte[])address));
            log.trace("setCurrent - addr: {}, Meter: {}, value: {}", new Object[]{address, meter, value});
            if (meter != null) {
                meter.setCommandedAnalogValue(value);
            }
        }

        private void setVoltage(byte[] address, double value) throws JmriException {
            Meter meter = BiDiBPredefinedMeters.this.voltageMeters.get(NodeUtils.convertAddress((byte[])address));
            log.trace("setVoltage - addr: {}, Meter: {}, value: {}", new Object[]{address, meter, value});
            if (meter != null) {
                meter.setCommandedAnalogValue(value);
            }
        }

        @Override
        public void requestUpdateFromLayout() {
            Map<Long, Node> nodes = BiDiBPredefinedMeters.this.tc.getNodeList();
            for (Map.Entry<Long, Node> entry : nodes.entrySet()) {
                Node node = entry.getValue();
                if (!NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) continue;
                BiDiBPredefinedMeters.this.tc.sendBiDiBMessage((BidibCommandMessage)new BoostQueryMessage(), node);
            }
        }

        private void createBoosterDiagListener() {
            this.messageListener = new DefaultMessageListener(){

                public void boosterDiag(byte[] address, int messageNum, int current, int voltage, int temperature) {
                    log.info("METER booster diag was signalled: node addr: {}, current: {}, voltage: {}, temperature: {}", new Object[]{address, current, voltage, temperature});
                    try {
                        UpdateTask.this.setCurrent(address, (float)current * 1.0f);
                        UpdateTask.this.setVoltage(address, (float)voltage * 100.0f);
                    }
                    catch (JmriException e) {
                        log.error("exception thrown by setCurrent or setVoltage", (Throwable)e);
                    }
                }
            };
        }
    }
}

