/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgMessage;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBProgrammer
extends AbstractProgrammer {
    protected BiDiBTrafficController tc;
    protected Node progNode;
    private boolean isBoosterOn = false;
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int COMMANDSENT = 2;
    static final int COMMANDSENT_2 = 4;
    boolean _progRead = false;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    private static final Logger log = LoggerFactory.getLogger(BiDiBProgrammer.class);

    public BiDiBProgrammer(BiDiBTrafficController tc) {
        this.tc = tc;
        this.SHORT_TIMEOUT = 4000;
        this.progNode = tc.getCurrentGlobalProgrammerNode();
        log.debug("global programmer node: {}", (Object)this.progNode);
        if (this.getSupportedModes().size() > 0) {
            this.setMode(this.getSupportedModes().get(0));
        }
        this.createProgrammerListener();
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        if (this.tc == null) {
            log.warn("getSupportedModes called with null tc", (Throwable)new Exception("traceback"));
        }
        Objects.requireNonNull(this.tc, "TrafficController reference needed");
        ret.add(ProgrammingMode.DIRECTBYTEMODE);
        return ret;
    }

    @Override
    public boolean getCanWrite(String cv) {
        if (!this.getCanWrite()) {
            return false;
        }
        return Integer.parseInt(cv) <= 1024;
    }

    @Override
    @Nonnull
    public Programmer.WriteConfirmMode getWriteConfirmMode(String addr) {
        return Programmer.WriteConfirmMode.DecoderReply;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.info("write mode: {}, CV={}, val={}", new Object[]{this.getMode().getStandardName(), CV, val});
        if (log.isDebugEnabled()) {
            log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        if (!this.getCanWrite(CVname)) {
            throw new ProgrammerException("CV number not supported");
        }
        if (this.progNode == null) {
            throw new ProgrammerException("No Global Programmer node found!");
        }
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        this.sendBiDiBMessage((BidibCommandMessage)new CommandStationProgMessage(CommandStationPt.BIDIB_CS_PROG_WR_BYTE, this._cv, this._val));
    }

    @Override
    public void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.info("read mode: {}, CV={}", (Object)this.getMode().getStandardName(), (Object)CV);
        if (log.isDebugEnabled()) {
            log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        if (!this.getCanRead(CVname)) {
            throw new ProgrammerException("CV number not supported");
        }
        this._progRead = true;
        this.progState = 2;
        this._cv = CV;
        this.sendBiDiBMessage((BidibCommandMessage)new CommandStationProgMessage(CommandStationPt.BIDIB_CS_PROG_RD_BYTE, this._cv, 0));
    }

    private void sendBiDiBMessage(BidibCommandMessage message) {
        this.progNode = this.tc.getCurrentGlobalProgrammerNode();
        if (this.progNode != null) {
            if (this.isBoosterOn) {
                this.startLongTimer();
                this.tc.sendBiDiBMessage(message, this.progNode);
            } else {
                this.progState = 0;
                this.notifyProgListenerEnd(this._val, 32);
            }
        } else {
            this.progState = 0;
            this.notifyProgListenerEnd(this._val, 8);
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    private void createProgrammerListener() {
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            public void csProgState(byte[] address, int messageNum, CommandStationProgState commandStationProgState, int remainingTime, int cvNumber, int cvData) {
                if (BiDiBProgrammer.this.progState == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("reply in NOTPROGRAMMING state");
                    }
                } else if (BiDiBProgrammer.this.progState == 2) {
                    log.debug("node addr: {}, msg node addr: {}", (Object)BiDiBProgrammer.this.progNode.getAddr(), (Object)address);
                    if (NodeUtils.isAddressEqual((byte[])BiDiBProgrammer.this.progNode.getAddr(), (byte[])address) && BiDiBProgrammer.this._cv == cvNumber) {
                        log.info("GLOBAL PROGRAMMER CS_PROG_STATE was signalled, node addr: {}, state: {}, CV: {}, value: {}, remaining time: {}", new Object[]{address, commandStationProgState.getType(), cvNumber, cvData, remainingTime});
                        if ((commandStationProgState.getType() & 0x80) != 0) {
                            BiDiBProgrammer.this.stopTimer();
                            BiDiBProgrammer.this.progState = 0;
                            if ((commandStationProgState.getType() & 0x40) == 0) {
                                log.debug(" prog ok");
                                if (BiDiBProgrammer.this._progRead) {
                                    BiDiBProgrammer.this._val = cvData;
                                }
                                BiDiBProgrammer.this.notifyProgListenerEnd(BiDiBProgrammer.this._val, 0);
                            } else if (commandStationProgState == CommandStationProgState.PROG_NO_LOCO) {
                                log.debug(" error: no loco detected");
                                BiDiBProgrammer.this.notifyProgListenerEnd(BiDiBProgrammer.this._val, 2);
                            } else if (commandStationProgState == CommandStationProgState.PROG_STOPPED) {
                                log.debug(" error: user aborted");
                                BiDiBProgrammer.this.notifyProgListenerEnd(BiDiBProgrammer.this._val, 16);
                            } else if (commandStationProgState == CommandStationProgState.PROG_NO_ANSWER) {
                                log.debug(" error: no answer");
                                if (BiDiBProgrammer.this._progRead && (cvNumber == 8 || cvNumber == 7)) {
                                    if (cvNumber == 8) {
                                        BiDiBProgrammer.this._val = 145;
                                    }
                                    if (cvNumber == 7) {
                                        BiDiBProgrammer.this._val = 26;
                                    }
                                    BiDiBProgrammer.this.notifyProgListenerEnd(BiDiBProgrammer.this._val, 0);
                                } else {
                                    BiDiBProgrammer.this._val = 0;
                                    log.warn(" error: no answer, CV probably not implemented");
                                    BiDiBProgrammer.this.notifyProgListenerEnd(BiDiBProgrammer.this._val, 32);
                                }
                            } else if (commandStationProgState == CommandStationProgState.PROG_SHORT) {
                                log.warn(" error: programming short");
                                BiDiBProgrammer.this.notifyProgListenerEnd(BiDiBProgrammer.this._val, 256);
                            } else if (commandStationProgState == CommandStationProgState.PROG_VERIFY_FAILED) {
                                log.warn(" error: verify failed");
                                BiDiBProgrammer.this.notifyProgListenerEnd(BiDiBProgrammer.this._val, 64);
                            } else {
                                log.warn(" error: unknown error");
                                BiDiBProgrammer.this.notifyProgListenerEnd(BiDiBProgrammer.this._val, 1);
                            }
                        } else {
                            log.debug(" not finished...");
                        }
                    }
                }
            }

            public void boosterState(byte[] address, int messageNum, BoosterState state, BoosterControl control) {
                Node node = BiDiBProgrammer.this.tc.getNodeByAddr(address);
                log.info("BOOSTER STATE was signalled: {}, control: {}", (Object)state.getType(), (Object)control.getType());
                if (node != null && node == BiDiBProgrammer.this.progNode) {
                    BiDiBProgrammer.this.isBoosterOn = (state.getType() & 0x80) == 128;
                }
            }
        };
        this.tc.addMessageListener((MessageListener)messageListener);
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            this.cleanup();
            this.notifyProgListenerEnd(this._val, 128);
            this.tc.checkProgMode(false, this.progNode);
            this.tc.setCurrentGlobalProgrammerNode(null);
        }
    }

    void cleanup() {
    }

    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }
}

