/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.Programmer;
import jmri.jmrix.bidib.BiDiBOpsModeProgrammer;
import jmri.jmrix.bidib.BiDiBProgrammer;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.managers.DefaultProgrammerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBProgrammerManager
extends DefaultProgrammerManager {
    BiDiBTrafficController tc;
    BiDiBSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(BiDiBProgrammerManager.class);

    public BiDiBProgrammerManager(@Nonnull BiDiBSystemConnectionMemo memo) {
        super(BiDiBProgrammerManager.checkGlobalProgrammerAvailable(memo.getBiDiBTrafficController()) ? new BiDiBProgrammer(memo.getBiDiBTrafficController()) : null, memo);
        this.tc = memo.getBiDiBTrafficController();
        this.memo = memo;
        log.trace("BiDiBProgrammerManager({}) with {}", (Object)memo, (Object)BiDiBProgrammerManager.checkGlobalProgrammerAvailable(memo.getBiDiBTrafficController()));
        Objects.requireNonNull(memo, "require BiDiBSystemConnectionMemo");
    }

    @Override
    public boolean isAddressedModePossible() {
        Objects.requireNonNull(this.memo, "require BiDiBSystemConnectionMemo");
        return this.tc.getFirstCommandStationNode() != null;
    }

    @Override
    public boolean isGlobalProgrammerAvailable() {
        Objects.requireNonNull(this.tc, "require BiDiBTrafficController");
        return BiDiBProgrammerManager.checkGlobalProgrammerAvailable(this.tc);
    }

    private static boolean checkGlobalProgrammerAvailable(@Nonnull BiDiBTrafficController tc) {
        return tc.getCurrentGlobalProgrammerNode() != null;
    }

    @Override
    public Programmer getGlobalProgrammer() {
        if (!this.isGlobalProgrammerAvailable()) {
            return null;
        }
        return super.getGlobalProgrammer();
    }

    @Override
    public AddressedProgrammer getAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return new BiDiBOpsModeProgrammer(pAddress, this.tc);
    }

    @Override
    public AddressedProgrammer reserveAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return null;
    }

    @Override
    public void releaseGlobalProgrammer(@Nonnull Programmer p) {
        log.debug("release global programmer: {}", (Object)p);
    }

    @Override
    public void releaseAddressedProgrammer(@Nonnull AddressedProgrammer p) {
        log.debug("release addressed programmer: {}", (Object)p);
    }
}

