/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.List;
import jmri.InstanceManager;
import jmri.RailCom;
import jmri.RailComManager;
import jmri.implementation.AbstractRailComReporter;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBNamedBeanInterface;
import jmri.jmrix.bidib.BiDiBReporterManager;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.OccupationState;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBReporter
extends AbstractRailComReporter
implements BiDiBNamedBeanInterface {
    BiDiBAddress addr;
    private final char typeLetter;
    private BiDiBTrafficController tc = null;
    MessageListener messageListener = null;
    private static final Logger log = LoggerFactory.getLogger(BiDiBReporter.class);

    public BiDiBReporter(String systemName, BiDiBReporterManager mgr) {
        super(systemName);
        this.tc = mgr.getMemo().getBiDiBTrafficController();
        log.debug("New Reporter: {}", (Object)systemName);
        this.addr = new BiDiBAddress(systemName, mgr.typeLetter(), mgr.getMemo());
        log.info("New REPORTER created: {} -> {}", (Object)systemName, (Object)this.addr);
        this.typeLetter = mgr.typeLetter();
        this.createReporterListener();
    }

    @Override
    public BiDiBAddress getAddr() {
        return this.addr;
    }

    @Override
    public void nodeNew() {
        this.addr = new BiDiBAddress(this.getSystemName(), this.typeLetter, this.tc.getSystemConnectionMemo());
        if (this.addr.isValid()) {
            log.info("new reporter address created: {} -> {}", (Object)this.getSystemName(), (Object)this.addr);
        }
    }

    @Override
    public void nodeLost() {
        this.notify_loco(null);
    }

    public void notify_loco(RailCom tag) {
        super.notify(tag);
    }

    private void createReporterListener() {
        this.messageListener = new DefaultMessageListener(){

            public void address(byte[] address, int messageNum, int detectorNumber, List<AddressData> addressData) {
                if (NodeUtils.isAddressEqual((byte[])BiDiBReporter.this.addr.getNodeAddr(), (byte[])address) && BiDiBReporter.this.addr.getAddr() == detectorNumber) {
                    log.info("REPORTER address was signalled, locos: {}, BM Number: {}, node: {}", new Object[]{addressData, detectorNumber, BiDiBReporter.this.addr});
                    if (addressData.size() > 0) {
                        for (AddressData l : addressData) {
                            log.debug("loco addr: {}", (Object)l);
                            if (l.getAddress() > 0) {
                                RailCom tag = (RailCom)InstanceManager.getDefault(RailComManager.class).provideIdTag("" + l.getAddress());
                                BiDiBReporter.this.notify_loco(tag);
                                continue;
                            }
                            BiDiBReporter.this.notify_loco(null);
                        }
                    } else {
                        BiDiBReporter.this.notify_loco(null);
                    }
                }
            }

            public void occupation(byte[] address, int messageNum, int detectorNumber, OccupationState occupationState, Integer timestamp) {
                if (NodeUtils.isAddressEqual((byte[])BiDiBReporter.this.addr.getNodeAddr(), (byte[])address) && BiDiBReporter.this.addr.getAddr() == detectorNumber && occupationState == OccupationState.FREE) {
                    log.info("REPORTER occupation free signalled, state: {}, BM Number: {}, node: {}", new Object[]{occupationState, detectorNumber, BiDiBReporter.this.addr});
                    BiDiBReporter.this.notify_loco(null);
                }
            }

            public void occupancyMultiple(byte[] address, int messageNum, int baseAddress, int detectorCount, byte[] detectorData) {
                log.trace("occupation: node UID: {}, node addr: {}, address: {}, baseAddress: {}, detectorCount: {}, occ states: {}", new Object[]{BiDiBReporter.this.addr.getNodeUID(), BiDiBReporter.this.addr.getNodeAddr(), address, baseAddress, detectorCount, detectorData});
                if (NodeUtils.isAddressEqual((byte[])BiDiBReporter.this.addr.getNodeAddr(), (byte[])address) && !BiDiBReporter.this.addr.isPortAddr() && BiDiBReporter.this.addr.getAddr() >= baseAddress && BiDiBReporter.this.addr.getAddr() < baseAddress + detectorCount) {
                    int relAddr = BiDiBReporter.this.addr.getAddr() - baseAddress;
                    byte b = detectorData[relAddr / 8];
                    boolean isOccupied = (b & 1 << relAddr % 8) != 0;
                    log.info("REPORTER multi occupation was signalled, state: {}, BM addr: {}, node: {}", new Object[]{isOccupied ? "OCCUPIED" : "FREE", BiDiBReporter.this.addr.getAddr(), BiDiBReporter.this.addr});
                    if (!isOccupied) {
                        BiDiBReporter.this.notify_loco(null);
                    }
                }
            }
        };
        this.tc.addMessageListener(this.messageListener);
    }

    @Override
    public void dispose() {
        if (this.messageListener != null) {
            this.tc.removeMessageListener(this.messageListener);
            this.messageListener = null;
        }
        super.dispose();
    }
}

