/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.Locale;
import java.util.Map;
import jmri.NamedBean;
import jmri.Reporter;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBReporter;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.Bundle;
import jmri.managers.AbstractReporterManager;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.FeedbackGetAddressRangeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBReporterManager
extends AbstractReporterManager {
    private static final Logger log = LoggerFactory.getLogger(BiDiBReporterManager.class);

    public BiDiBReporterManager(BiDiBSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public BiDiBSystemConnectionMemo getMemo() {
        return (BiDiBSystemConnectionMemo)this.memo;
    }

    @Override
    public Reporter createNewReporter(String systemName, String userName) {
        BiDiBReporter r = new BiDiBReporter(systemName, this);
        r.setUserName(userName);
        this.register(r);
        return r;
    }

    @Override
    public String validateSystemNameFormat(String name, Locale locale) {
        log.trace("validateSystemNameFormat: name: {}, typeLetter: {}", (Object)name, (Object)Character.valueOf(this.typeLetter()));
        this.validateSystemNamePrefix(name, locale);
        if (!BiDiBAddress.isValidSystemNameFormat(name, this.typeLetter(), this.getMemo())) {
            throw new NamedBean.BadSystemNameException(Locale.getDefault(), "InvalidSystemName", name);
        }
        return name;
    }

    public void updateNode(Node node) {
        BiDiBTrafficController tc = this.getMemo().getBiDiBTrafficController();
        if (tc.getNodeFeature(node, 9) > 0) {
            log.trace("node can detect addresse: {}", (Object)node);
            log.info("Requesting all adresses");
            tc.sendBiDiBMessage((BidibCommandMessage)new FeedbackGetAddressRangeMessage(0, 128), node);
            log.info("Requesting adress of global detector");
            tc.sendBiDiBMessage((BidibCommandMessage)new FeedbackGetAddressRangeMessage(255, 0), node);
        }
    }

    public void updateAll() {
        BiDiBTrafficController tc = this.getMemo().getBiDiBTrafficController();
        Map<Long, Node> nodeList = tc.getNodeList();
        nodeList.forEach((uid, node) -> this.updateNode((Node)node));
    }

    @Override
    public String getEntryToolTip() {
        String entryToolTip = Bundle.getMessage("AddReporterEntryToolTip");
        return entryToolTip;
    }
}

