/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import jmri.implementation.AbstractSensor;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBNamedBeanInterface;
import jmri.jmrix.bidib.BiDiBOutputMessageHandler;
import jmri.jmrix.bidib.BiDiBSensorManager;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.OccupationState;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBSensor
extends AbstractSensor
implements BiDiBNamedBeanInterface {
    private BiDiBAddress addr;
    private final char typeLetter;
    private BiDiBTrafficController tc = null;
    private BiDiBOutputMessageHandler messageHandler = null;
    LcOutputType lcType;
    private static final Logger log = LoggerFactory.getLogger(BiDiBSensor.class);

    public BiDiBSensor(String systemName, BiDiBSensorManager mgr) {
        super(systemName);
        this.tc = mgr.getMemo().getBiDiBTrafficController();
        log.debug("New Sensor: {}", (Object)systemName);
        this.addr = new BiDiBAddress(systemName, mgr.typeLetter(), mgr.getMemo());
        log.info("New SENSOR created: {} -> {}", (Object)systemName, (Object)this.addr);
        this.typeLetter = mgr.typeLetter();
        this.createSensorListener();
        this.messageHandler.sendQueryConfig();
    }

    @Override
    public BiDiBAddress getAddr() {
        return this.addr;
    }

    @Override
    public void finishLoad() {
        this.messageHandler.sendQuery();
    }

    @Override
    public void nodeNew() {
        this.addr = new BiDiBAddress(this.getSystemName(), this.typeLetter, this.tc.getSystemConnectionMemo());
        if (this.addr.isValid()) {
            log.info("new sensor address created: {} -> {}", (Object)this.getSystemName(), (Object)this.addr);
            if (this.addr.isPortAddr()) {
                this.messageHandler.sendQueryConfig();
                this.messageHandler.waitQueryConfig();
            }
            if (!this.addr.isFeedbackAddr()) {
                this.messageHandler.sendQuery();
            }
        }
    }

    @Override
    public void nodeLost() {
        this.setOwnState(1);
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this.addr.isValid()) {
            log.info("Query sensor status from BiDiB: addr: {}", (Object)this.addr);
            this.messageHandler.sendQuery();
        }
    }

    @Override
    public void dispose() {
        if (this.messageHandler != null) {
            this.tc.removeMessageListener((MessageListener)this.messageHandler);
            this.messageHandler = null;
        }
        super.dispose();
    }

    private void createSensorListener() {
        this.messageHandler = new BiDiBOutputMessageHandler(this, "SENSOR", this.tc){

            public void occupation(byte[] address, int messageNum, int detectorNumber, OccupationState occupationState, Integer timestamp) {
                if (NodeUtils.isAddressEqual((byte[])BiDiBSensor.this.addr.getNodeAddr(), (byte[])address) && !BiDiBSensor.this.addr.isPortAddr() && BiDiBSensor.this.addr.getAddr() == detectorNumber) {
                    log.info("SENSOR occupation was signalled, state: {}, BM Number: {}, node: {}", new Object[]{occupationState, detectorNumber, BiDiBSensor.this.addr});
                    if (occupationState == OccupationState.OCCUPIED) {
                        BiDiBSensor.this.setOwnState(2);
                    } else {
                        BiDiBSensor.this.setOwnState(4);
                    }
                }
            }

            public void occupancyMultiple(byte[] address, int messageNum, int baseAddress, int detectorCount, byte[] detectorData) {
                if (NodeUtils.isAddressEqual((byte[])BiDiBSensor.this.addr.getNodeAddr(), (byte[])address) && !BiDiBSensor.this.addr.isPortAddr() && BiDiBSensor.this.addr.getAddr() >= baseAddress && BiDiBSensor.this.addr.getAddr() < baseAddress + detectorCount) {
                    int relAddr = BiDiBSensor.this.addr.getAddr() - baseAddress;
                    byte b = detectorData[relAddr / 8];
                    boolean isOccupied = (b & 1 << relAddr % 8) != 0;
                    log.info("SENSOR multi occupation was signalled, state: {}, BM addr: {}, node: {}", new Object[]{isOccupied ? "OCCUPIED" : "FREE", BiDiBSensor.this.addr.getAddr(), BiDiBSensor.this.addr});
                    if (isOccupied) {
                        BiDiBSensor.this.setOwnState(2);
                    } else {
                        BiDiBSensor.this.setOwnState(4);
                    }
                }
            }

            @Override
            public void newOutputState(int state) {
                int newState = state == 0 ? 4 : 2;
                log.debug("SENSOR new state: {}", (Object)newState);
                BiDiBSensor.this.setOwnState(newState);
            }

            @Override
            public void outputWait(int time) {
                log.debug("SENSOR wait: {}", (Object)time);
            }

            @Override
            public void errorState(int err) {
                log.warn("SENSOR error: {} addr: {}", (Object)err, (Object)BiDiBSensor.this.addr);
                BiDiBSensor.this.setOwnState(8);
            }
        };
        this.tc.addMessageListener((MessageListener)this.messageHandler);
    }
}

