/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBSensor;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.Bundle;
import jmri.managers.AbstractSensorManager;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBSensorManager
extends AbstractSensorManager {
    private boolean isLoading = false;
    private final ArrayList<BiDiBSensor> pendingSensors = new ArrayList();
    private final Map<Node, Integer> pendingNodeMinAddr = new HashMap<Node, Integer>();
    private final Map<Node, Integer> pendingNodeMaxAddr = new HashMap<Node, Integer>();
    private static final Logger log = LoggerFactory.getLogger(BiDiBSensorManager.class);

    public BiDiBSensorManager(BiDiBSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public BiDiBSystemConnectionMemo getMemo() {
        return (BiDiBSystemConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sensor createNewSensor(String systemName, String userName) {
        log.trace("createNewSensor {} - {}", (Object)systemName, (Object)userName);
        try {
            this.validateSystemNameFormat(systemName);
        }
        catch (IllegalArgumentException e) {
            log.error("Illegal address", (Throwable)e);
            throw e;
        }
        BiDiBSensor s = new BiDiBSensor(systemName, this);
        s.setUserName(userName);
        ArrayList<BiDiBSensor> arrayList = this.pendingSensors;
        synchronized (arrayList) {
            if (this.isLoading) {
                this.pendingSensors.add(s);
                if (s.getAddr().isFeedbackAddr()) {
                    BiDiBAddress a = s.getAddr();
                    Node node = a.getNode();
                    if (!this.pendingNodeMinAddr.containsKey(node) || a.getAddr() < this.pendingNodeMinAddr.get(node)) {
                        this.pendingNodeMinAddr.put(node, a.getAddr());
                    }
                    if (!this.pendingNodeMaxAddr.containsKey(node) || a.getAddr() > this.pendingNodeMaxAddr.get(node)) {
                        this.pendingNodeMaxAddr.put(node, a.getAddr());
                    }
                }
            } else {
                s.finishLoad();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad() {
        log.debug("Sensor manager : start load");
        ArrayList<BiDiBSensor> arrayList = this.pendingSensors;
        synchronized (arrayList) {
            this.isLoading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad() {
        log.info("Sensor manager : finish load");
        ArrayList<BiDiBSensor> arrayList = this.pendingSensors;
        synchronized (arrayList) {
            this.pendingSensors.forEach(s -> {
                if (!s.getAddr().isFeedbackAddr()) {
                    s.finishLoad();
                }
            });
            this.pendingNodeMinAddr.forEach((node, min) -> this.updateNodeFeedbacks((Node)node, (int)min, this.pendingNodeMaxAddr.get(node)));
            this.pendingNodeMinAddr.clear();
            this.pendingNodeMaxAddr.clear();
            this.pendingSensors.clear();
            this.isLoading = false;
        }
    }

    public void updateNodeFeedbacks(Node node) {
        this.updateNodeFeedbacks(node, 0, 128);
    }

    public void updateNodeFeedbacks(Node node, int min, int max) {
        BiDiBTrafficController tc = this.getMemo().getBiDiBTrafficController();
        int bmSize = tc.getNodeFeature(node, 0);
        if (bmSize > 0) {
            int first = min / 8 * 8;
            if (max > bmSize - 1) {
                max = bmSize - 1;
            }
            int end = (max + 8) / 8 * 8;
            log.debug("sensor finish load: node: {}, requesting feedback from {} to {}", new Object[]{node, first, end});
            tc.sendBiDiBMessage((BidibCommandMessage)new FeedbackGetRangeMessage(first, end), node);
        }
    }

    @Override
    public String createSystemName(String curAddress, String prefix) throws JmriException {
        log.trace("createSystemName from {} - {}", (Object)curAddress, (Object)prefix);
        try {
            int i = 1;
            int curNum = Integer.parseInt(curAddress);
            for (Sensor s : this.getNamedBeanSet()) {
                if (i++ != curNum) continue;
                return s.getSystemName();
            }
        }
        catch (NumberFormatException ex) {
            throw new JmriException("Hardware Address passed " + curAddress + " should be a number");
        }
        return prefix + this.typeLetter() + curAddress;
    }

    @Override
    public boolean allowMultipleAdditions(String systemName) {
        return true;
    }

    @Override
    public String validateSystemNameFormat(String name, Locale locale) {
        log.trace("validateSystemNameFormat: name: {}, typeLetter: {}", (Object)name, (Object)Character.valueOf(this.typeLetter()));
        this.validateSystemNamePrefix(name, locale);
        if (!BiDiBAddress.isValidSystemNameFormat(name, this.typeLetter(), this.getMemo())) {
            throw new NamedBean.BadSystemNameException(Locale.getDefault(), "InvalidSystemName", name);
        }
        return name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        log.trace("validSystemNameFormat: systemNname: {}", (Object)systemName);
        if (systemName.length() <= this.getSystemPrefix().length()) {
            return Manager.NameValidity.INVALID;
        }
        return Manager.NameValidity.VALID;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

