/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SystemConnectionMemo;
import jmri.implementation.AbstractSignalMast;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBNamedBeanInterface;
import jmri.jmrix.bidib.BiDiBOutputMessageHandler;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBSignalMast
extends AbstractSignalMast
implements BiDiBNamedBeanInterface {
    BiDiBTrafficController tc;
    BiDiBOutputMessageHandler messageHandler = null;
    BiDiBAddress addr;
    private char typeLetter;
    int commandedAspect = -1;
    protected String mastType = BiDiBSignalMast.getNamePrefix();
    protected HashMap<String, Integer> appearanceToOutput = new HashMap();
    int unLitId = 31;
    private static final Logger log = LoggerFactory.getLogger(BiDiBSignalMast.class);

    public BiDiBSignalMast(String sys, String user) {
        super(sys, user);
        this.configureFromName(sys);
    }

    public BiDiBSignalMast(String sys) {
        super(sys);
        this.configureFromName(sys);
    }

    public BiDiBSignalMast(String sys, String user, String mastSubType) {
        super(sys, user);
        this.mastType = mastSubType;
        this.configureFromName(sys);
    }

    public static String getNamePrefix() {
        return "F$bsm";
    }

    private void configureFromName(String systemName) {
        DefaultSystemConnectionMemo memo = null;
        String[] parts = systemName.split(":", 3);
        if (parts.length < 3) {
            log.error("SignalMast system name needs at least three parts: {}", (Object)systemName);
            throw new IllegalArgumentException("System name needs at least three parts: " + systemName);
        }
        if (!parts[0].endsWith(this.mastType)) {
            log.warn("First part of SignalMast system name is incorrect {} : {}", (Object)systemName, (Object)this.mastType);
        } else {
            String systemPrefix = parts[0].substring(0, parts[0].indexOf("$") - 1);
            List<SystemConnectionMemo> memoList = InstanceManager.getList(SystemConnectionMemo.class);
            for (SystemConnectionMemo m : memoList) {
                if (!m.getSystemPrefix().equals(systemPrefix)) continue;
                if (m instanceof BiDiBSystemConnectionMemo) {
                    this.tc = ((BiDiBSystemConnectionMemo)m).getBiDiBTrafficController();
                    memo = (BiDiBSystemConnectionMemo)m;
                    break;
                }
                log.error("Can't create mast \"{}\" because system \"{}}\" is not BiDiBSystemConnectionMemo but rather {}", new Object[]{systemName, systemPrefix, m.getClass()});
                break;
            }
            if (this.tc == null) {
                log.error("No BiDiB connection found for system prefix \"{}\", so mast \"{}\" will not function", (Object)systemPrefix, (Object)systemName);
            }
        }
        String system = parts[1];
        String mast = parts[2];
        mast = mast.substring(0, mast.indexOf("("));
        log.trace("In configureFromName setMastType to {}", (Object)mast);
        this.setMastType(mast);
        if (memo != null) {
            char accessoryTypeLetter = 'T';
            String accessorySystemName = memo.getSystemPrefix() + accessoryTypeLetter + parts[2].substring(parts[2].indexOf("(") + 1, parts[2].indexOf(")"));
            this.addr = new BiDiBAddress(accessorySystemName, accessoryTypeLetter, (BiDiBSystemConnectionMemo)memo);
            log.info("New SIGNALMAST created: {} {} -> {}", new Object[]{systemName, accessorySystemName, this.addr});
            this.typeLetter = accessoryTypeLetter;
        }
        this.configureSignalSystemDefinition(system);
        this.configureAspectTable(system, mast);
        this.createSignalMastListener();
        this.messageHandler.sendQueryConfig();
    }

    public void setOutputForAppearance(String appearance, int number) {
        log.debug("setOutputForAppearance: {} -> {}", (Object)appearance, (Object)number);
        if (this.appearanceToOutput.containsKey(appearance)) {
            log.debug("Appearance {} is already defined as {}", (Object)appearance, (Object)this.appearanceToOutput.get(appearance));
            this.appearanceToOutput.remove(appearance);
        }
        this.appearanceToOutput.put(appearance, number);
    }

    public int getOutputForAppearance(String appearance) {
        if (!this.appearanceToOutput.containsKey(appearance)) {
            log.error("Trying to get appearance {} but it has not been configured", (Object)appearance);
            return -1;
        }
        return this.appearanceToOutput.get(appearance);
    }

    @Override
    public void setAspect(@Nonnull String aspect) {
        if (this.appearanceToOutput.containsKey(aspect) && this.appearanceToOutput.get(aspect) != -1) {
            this.sendMessage(this.appearanceToOutput.get(aspect));
        } else {
            log.warn("Trying to set aspect ({}) that has not been configured on mast {}", (Object)aspect, (Object)this.getDisplayName());
        }
        String oldAspect = this.aspect;
        this.aspect = null;
        this.firePropertyChange("Aspect", oldAspect, aspect);
    }

    @Override
    public void setLit(boolean newLit) {
        if (!this.allowUnLit() || newLit == this.getLit()) {
            return;
        }
        if (newLit) {
            String a = this.getAspect();
            if (a != null) {
                this.setAspect(a);
            }
            super.setLit(newLit);
        } else {
            this.sendMessage(this.unLitId);
        }
    }

    public void queryAccessory() {
        this.messageHandler.sendQuery();
    }

    protected void sendMessage(int aspect) {
        log.debug("Signal Mast set aspect: {}, addr: {}", (Object)aspect, (Object)this.addr);
        if (this.addr.isValid()) {
            int state;
            if (this.addr.isPortAddr()) {
                state = aspect == 0 ? 0 : 1;
                switch (this.messageHandler.getLcType()) {
                    case LIGHTPORT: {
                        state = aspect == 0 ? 2 : 3;
                        break;
                    }
                    case SERVOPORT: 
                    case ANALOGPORT: 
                    case BACKLIGHTPORT: {
                        state = aspect == 0 ? 0 : 255;
                        break;
                    }
                    case MOTORPORT: {
                        state = aspect == 0 ? 0 : 126;
                        break;
                    }
                    case INPUTPORT: {
                        log.warn("output to INPUT port is not possible, addr: {}", (Object)this.addr);
                        return;
                    }
                }
            } else {
                state = aspect;
            }
            this.messageHandler.sendOutput(state);
            this.commandedAspect = aspect;
        }
    }

    public void setUnlitId(int i) {
        this.unLitId = i;
    }

    public int getUnlitId() {
        return this.unLitId;
    }

    public String getAccessoryAddress() {
        if (this.addr.isValid()) {
            return this.addr.getAddrString();
        }
        return "";
    }

    public BiDiBTrafficController getTrafficController() {
        return this.tc;
    }

    @Override
    public BiDiBAddress getAddr() {
        return this.addr;
    }

    @Override
    public void nodeNew() {
        this.addr = new BiDiBAddress(this.getSystemName(), this.typeLetter, this.tc.getSystemConnectionMemo());
        if (this.addr.isValid()) {
            log.info("new signal mast address created: {} -> {}", (Object)this.getSystemName(), (Object)this.addr);
            log.debug("current aspect is {}, commanded aspect {}", (Object)this.getAspect(), (Object)this.commandedAspect);
            if (this.addr.isPortAddr()) {
                this.messageHandler.sendQueryConfig();
                this.messageHandler.waitQueryConfig();
            }
            this.sendMessage(this.commandedAspect);
        }
    }

    @Override
    public void nodeLost() {
        super.setLit(false);
    }

    @Override
    public void dispose() {
        if (this.messageHandler != null) {
            this.tc.removeMessageListener((MessageListener)this.messageHandler);
            this.messageHandler = null;
        }
        super.dispose();
    }

    public static String isAccessoryAddressUsed(BiDiBAddress address) {
        for (SignalMast mast : InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet()) {
            if (!(mast instanceof BiDiBSignalMast) || !((BiDiBSignalMast)mast).getAddr().isAddressEqual(address)) continue;
            return ((BiDiBSignalMast)mast).getDisplayName();
        }
        return null;
    }

    private void newKnownAspect(int aspectNum) {
        for (Map.Entry<String, Integer> entry : this.appearanceToOutput.entrySet()) {
            if (entry.getValue() != aspectNum) continue;
            if (aspectNum == this.unLitId) {
                super.setLit(false);
                continue;
            }
            log.debug(" setAspect to {}", (Object)entry.getKey());
            super.setAspect(entry.getKey());
            super.setLit(true);
        }
    }

    private void createSignalMastListener() {
        this.messageHandler = new BiDiBOutputMessageHandler(this, "SIGNALMAST", this.tc){

            @Override
            public void newOutputState(int state) {
                int newAspect = BiDiBSignalMast.this.addr.isPortAddr() ? (BiDiBSignalMast.this.messageHandler.getLcType() == LcOutputType.LIGHTPORT ? (state == 2 || state == 0 ? 0 : BiDiBSignalMast.this.commandedAspect) : (state == 0 ? 0 : BiDiBSignalMast.this.commandedAspect)) : state;
                log.debug("SIGNALMAST new aspect: {}", (Object)newAspect);
                BiDiBSignalMast.this.newKnownAspect(newAspect);
            }

            @Override
            public void outputWait(int time) {
                log.debug("SIGNALMAST wait: {}", (Object)time);
            }

            @Override
            public void errorState(int err) {
                log.warn("SIGNALMAST error: {} addr: {}", (Object)err, (Object)BiDiBSignalMast.this.addr);
                String oldAspect = BiDiBSignalMast.this.aspect;
                BiDiBSignalMast.this.aspect = null;
                BiDiBSignalMast.this.firePropertyChange("Aspect", oldAspect, BiDiBSignalMast.this.aspect);
            }
        };
        this.tc.addMessageListener((MessageListener)this.messageHandler);
    }
}

