/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.ConsistManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBLightManager;
import jmri.jmrix.bidib.BiDiBPowerManager;
import jmri.jmrix.bidib.BiDiBPredefinedMeters;
import jmri.jmrix.bidib.BiDiBProgrammerManager;
import jmri.jmrix.bidib.BiDiBReporterManager;
import jmri.jmrix.bidib.BiDiBSensorManager;
import jmri.jmrix.bidib.BiDiBThrottleManager;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.BiDiBTurnoutManager;
import jmri.jmrix.bidib.swing.BiDiBComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.managers.AbstractMeterManager;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBSystemConnectionMemo
extends DefaultSystemConnectionMemo {
    ComponentFactory cf = null;
    private BiDiBTrafficController tc;
    protected BiDiBPredefinedMeters predefinedMeters;
    private static final Logger log = LoggerFactory.getLogger(BiDiBSystemConnectionMemo.class);

    public BiDiBSystemConnectionMemo(@Nonnull BiDiBTrafficController tc) {
        super("B", "BiDiB");
        log.trace("**** ctor 1 BiDiBSystemConnectionMemo");
        this.tc = tc;
        tc.setSystemConnectionMemo(this);
        this.register();
        InstanceManager.store(this, BiDiBSystemConnectionMemo.class);
        this.cf = new BiDiBComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created BiDiBSystemConnectionMemo");
    }

    public BiDiBSystemConnectionMemo() {
        super("B", "BiDiB");
        log.trace("**** ctor 2 BiDiBSystemConnectionMemo");
        this.register();
        InstanceManager.store(this, BiDiBSystemConnectionMemo.class);
        this.cf = new BiDiBComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created BiDiBSystemConnectionMemo");
    }

    public BiDiBTrafficController getBiDiBTrafficController() {
        log.trace("getBiDiBTrafficController");
        if (this.tc == null) {
            this.setBiDiBTrafficController(new BiDiBTrafficController(null));
            log.debug("Auto create of BiDiBTrafficController for initial configuration");
        }
        return this.tc;
    }

    public void setBiDiBTrafficController(@Nonnull BiDiBTrafficController tc) {
        this.tc = tc;
        tc.setSystemConnectionMemo(this);
    }

    public void configureManagers() {
        if (this.tc.getCurrentGlobalProgrammerNode() != null) {
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        if (this.tc.getFirstCommandStationNode() != null) {
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
            InstanceManager.setThrottleManager(this.getThrottleManager());
            InstanceManager.store(this.getCommandStation(), CommandStation.class);
        }
        if (this.tc.getFirstBoosterNode() != null) {
            InstanceManager.store(this.getPowerManager(), PowerManager.class);
            this.createPredefinedMeters();
        }
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        InstanceManager.setSensorManager(this.getSensorManager());
        InstanceManager.setReporterManager(this.getReporterManager());
        InstanceManager.setLightManager(this.getLightManager());
    }

    public void postConfigure() {
    }

    public BiDiBProgrammerManager getProgrammerManager() {
        log.trace("getProgrammerManager");
        if (this.getDisabled()) {
            return null;
        }
        return (BiDiBProgrammerManager)this.classObjectMap.computeIfAbsent(BiDiBProgrammerManager.class, c -> {
            BiDiBProgrammerManager programmerManager = new BiDiBProgrammerManager(this);
            log.debug("programmer manager created: {}", (Object)programmerManager);
            return programmerManager;
        });
    }

    public void setProgrammerManager(BiDiBProgrammerManager p) {
        this.store(p, BiDiBProgrammerManager.class);
    }

    public ThrottleManager getThrottleManager() {
        log.trace("getThrottleManager");
        if (this.getDisabled()) {
            return null;
        }
        return (ThrottleManager)this.classObjectMap.computeIfAbsent(ThrottleManager.class, c -> {
            BiDiBThrottleManager throttleManager = new BiDiBThrottleManager(this);
            log.debug("throttle manager created: {}", (Object)throttleManager);
            return throttleManager;
        });
    }

    public void setThrottleManager(ThrottleManager t) {
        this.store(t, ThrottleManager.class);
    }

    public PowerManager getPowerManager() {
        log.trace("getPowerManager");
        if (this.getDisabled()) {
            return null;
        }
        return (PowerManager)this.classObjectMap.computeIfAbsent(PowerManager.class, c -> {
            BiDiBPowerManager powerManager = new BiDiBPowerManager(this);
            log.debug("power manager created: {}", (Object)powerManager);
            return powerManager;
        });
    }

    public void setPowerManager(@Nonnull PowerManager p) {
        this.store(p, PowerManager.class);
    }

    public SensorManager getSensorManager() {
        log.trace("getSensorManager");
        if (this.getDisabled()) {
            return null;
        }
        return (SensorManager)this.classObjectMap.computeIfAbsent(SensorManager.class, c -> {
            BiDiBSensorManager sensorManager = new BiDiBSensorManager(this);
            log.debug("sensor manager created: {}", (Object)sensorManager);
            return sensorManager;
        });
    }

    public void setSensorManager(@Nonnull SensorManager s) {
        this.store(s, SensorManager.class);
    }

    public ReporterManager getReporterManager() {
        log.trace("getReporterManager");
        if (this.getDisabled()) {
            return null;
        }
        return (ReporterManager)this.classObjectMap.computeIfAbsent(ReporterManager.class, c -> {
            BiDiBReporterManager reporterManager = new BiDiBReporterManager(this);
            log.debug("reporter manager created: {}", (Object)reporterManager);
            return reporterManager;
        });
    }

    public void setReporterManager(@Nonnull ReporterManager s) {
        this.store(s, ReporterManager.class);
    }

    public TurnoutManager getTurnoutManager() {
        log.trace("getTurnoutManager");
        if (this.getDisabled()) {
            return null;
        }
        return (TurnoutManager)this.classObjectMap.computeIfAbsent(TurnoutManager.class, c -> {
            BiDiBTurnoutManager turnoutManager = new BiDiBTurnoutManager(this);
            log.debug("turnout manager created: {}", (Object)turnoutManager);
            return turnoutManager;
        });
    }

    public void setTurnoutManager(@Nonnull TurnoutManager t) {
        this.store(t, TurnoutManager.class);
    }

    public LightManager getLightManager() {
        log.trace("getLightManager");
        if (this.getDisabled()) {
            return null;
        }
        return (LightManager)this.classObjectMap.computeIfAbsent(LightManager.class, c -> {
            BiDiBLightManager lightManager = new BiDiBLightManager(this);
            log.debug("light manager created: {}", (Object)lightManager);
            return lightManager;
        });
    }

    public void setLightManager(@Nonnull LightManager l) {
        this.store(l, LightManager.class);
    }

    public BiDiBPredefinedMeters createPredefinedMeters() {
        if (this.getDisabled()) {
            return null;
        }
        if (this.predefinedMeters == null) {
            InstanceManager.setMeterManager(new AbstractMeterManager(this));
            this.predefinedMeters = new BiDiBPredefinedMeters(this);
        }
        return this.predefinedMeters;
    }

    public CommandStation getCommandStation() {
        log.trace("getCommandStation");
        if (this.getDisabled() || this.tc.getFirstCommandStationNode() == null) {
            return null;
        }
        return (CommandStation)this.classObjectMap.computeIfAbsent(CommandStation.class, c -> this.tc);
    }

    @Override
    public boolean provides(Class<?> type) {
        log.trace("check for {}", type);
        if (this.getDisabled() || this.tc == null) {
            return false;
        }
        if (type.equals(GlobalProgrammerManager.class)) {
            BiDiBProgrammerManager p = this.getProgrammerManager();
            if (p == null) {
                return false;
            }
            return p.isGlobalProgrammerAvailable();
        }
        if (type.equals(AddressedProgrammerManager.class)) {
            BiDiBProgrammerManager p = this.getProgrammerManager();
            if (p == null) {
                return false;
            }
            return p.isAddressedModePossible();
        }
        if (type.equals(ThrottleManager.class)) {
            return this.tc.getFirstCommandStationNode() != null;
        }
        if (type.equals(PowerManager.class)) {
            return this.tc.getFirstBoosterNode() != null;
        }
        if (type.equals(ReporterManager.class)) {
            return true;
        }
        if (type.equals(SensorManager.class)) {
            return true;
        }
        if (type.equals(TurnoutManager.class)) {
            return true;
        }
        if (type.equals(LightManager.class)) {
            return true;
        }
        if (type.equals(ConsistManager.class)) {
            return false;
        }
        if (type.equals(CommandStation.class)) {
            return this.tc.getFirstCommandStationNode() != null;
        }
        return super.provides(type);
    }

    @Override
    public <T> T get(Class<T> T) {
        if (this.getDisabled()) {
            return null;
        }
        log.trace("get {}", T);
        if (T.equals(GlobalProgrammerManager.class)) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(AddressedProgrammerManager.class)) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(ThrottleManager.class)) {
            return (T)this.getThrottleManager();
        }
        if (T.equals(PowerManager.class)) {
            return (T)this.getPowerManager();
        }
        if (T.equals(SensorManager.class)) {
            return (T)this.getSensorManager();
        }
        if (T.equals(ReporterManager.class)) {
            return (T)this.getReporterManager();
        }
        if (T.equals(TurnoutManager.class)) {
            return (T)this.getTurnoutManager();
        }
        if (T.equals(LightManager.class)) {
            return (T)this.getLightManager();
        }
        if (T.equals(ConsistManager.class)) {
            return null;
        }
        if (T.equals(CommandStation.class)) {
            return (T)this.getCommandStation();
        }
        return super.get(T);
    }

    @Override
    @Nonnull
    protected ResourceBundle getActionModelResourceBundle() {
        log.debug("getActionModelResourceBundle");
        return ResourceBundle.getBundle("jmri.jmrix.bidib.BiDiBActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        log.info("---- dispose -----");
        InstanceManager.deregister(this, BiDiBSystemConnectionMemo.class);
        if (this.predefinedMeters != null) {
            this.predefinedMeters.dispose();
        }
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        super.dispose();
        this.tc = null;
    }
}

