/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.BitSet;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.messages.DriveState;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.enums.DriveAcknowledge;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveMessage;
import org.bidib.jbidibc.messages.message.CommandStationQueryMessage;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBThrottle
extends AbstractThrottle {
    private final BitSet activeFunctions;
    private final BitSet functions;
    private float oldSpeed = 0.0f;
    private BiDiBTrafficController tc = null;
    MessageListener messageListener = null;
    protected Node node = null;
    private boolean sendDeregister = false;
    DccLocoAddress locoAddress;
    private static final Logger log = LoggerFactory.getLogger(BiDiBThrottle.class);

    public BiDiBThrottle(BiDiBSystemConnectionMemo memo, DccLocoAddress locoAddress) {
        super(memo);
        this.tc = memo.getBiDiBTrafficController();
        this.node = this.tc.getFirstCommandStationNode();
        log.trace("++ctor");
        this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_128);
        this.speedSetting = 0.0f;
        this.locoAddress = locoAddress;
        this.isForward = true;
        this.activeFunctions = new BitSet(29);
        this.functions = new BitSet(29);
        for (int bitIndex = 0; bitIndex < this.activeFunctions.size(); ++bitIndex) {
            this.activeFunctions.set(bitIndex, true);
            this.functions.set(bitIndex, false);
        }
        this.createThrottleListener();
        this.requestState();
    }

    public void requestState() {
        log.debug("request csState for addr {}", (Object)this.locoAddress);
        this.tc.sendBiDiBMessage((BidibCommandMessage)new CommandStationQueryMessage(CsQueryTypeEnum.LOCO_LIST, this.locoAddress.getNumber()), this.node);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.locoAddress;
    }

    @Override
    protected void sendFunctionGroup1() {
        log.trace("sendFunctionGroup1");
        this.sendDriveCommand(false);
    }

    @Override
    protected void sendFunctionGroup2() {
        log.trace("sendFunctionGroup2");
        this.sendDriveCommand(false);
    }

    @Override
    protected void sendFunctionGroup3() {
        log.trace("sendFunctionGroup3");
        this.sendDriveCommand(false);
    }

    @Override
    protected void sendFunctionGroup4() {
        log.trace("sendFunctionGroup4");
        this.sendDriveCommand(false);
    }

    @Override
    protected void sendFunctionGroup5() {
        log.trace("sendFunctionGroup5");
        this.sendDriveCommand(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public void setSpeedSetting(float speed) {
        BiDiBThrottle biDiBThrottle = this;
        synchronized (biDiBThrottle) {
            this.oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            if (this.sendDriveCommand(true)) {
                if (log.isDebugEnabled()) {
                    log.debug("setSpeedSetting= {}", (Object)Float.valueOf(speed));
                }
                this.speedSetting = this.oldSpeed;
                super.setSpeedSetting(speed);
            } else {
                this.speedSetting = this.oldSpeed;
            }
        }
    }

    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        if (this.sendDriveCommand(false)) {
            if (log.isDebugEnabled()) {
                log.debug("setIsForward= {}", (Object)forward);
            }
            if (old != forward) {
                this.isForward = old;
                super.setIsForward(forward);
            }
        } else {
            this.isForward = old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendDriveCommand(boolean isSpeedSet) {
        Integer speed;
        SpeedStepsEnum mode;
        int addr;
        BiDiBThrottle biDiBThrottle = this;
        synchronized (biDiBThrottle) {
            if (!isSpeedSet && this.speedSetting < 0.0f) {
                this.speedSetting = 0.0f;
            }
            addr = this.locoAddress.getNumber();
            switch (this.speedStepMode) {
                case NMRA_DCC_14: {
                    mode = SpeedStepsEnum.DCC14;
                    break;
                }
                case NMRA_DCC_28: {
                    mode = SpeedStepsEnum.DCC28;
                    break;
                }
                default: {
                    mode = SpeedStepsEnum.DCC128;
                }
            }
            speed = this.intSpeed(this.speedSetting);
        }
        DirectionEnum dir = this.isForward ? DirectionEnum.FORWARD : DirectionEnum.BACKWARD;
        for (int i = 0; i <= 28; ++i) {
            this.functions.set(i, this.getFunction(i));
        }
        BitSet curActiveFunctions = (BitSet)this.activeFunctions.clone();
        if (this.sendDeregister) {
            this.sendDeregister = false;
            curActiveFunctions.clear();
            speed = null;
            log.info("deregister loco reuqested ({})", (Object)addr);
        }
        log.debug("sendBiDiBMessage: addr: {}, mode: {}, direction: {}, speed: {}, active functions: {}, enabled functions: {}", new Object[]{addr, mode, dir, speed, curActiveFunctions.toByteArray(), this.functions.toByteArray()});
        this.tc.sendBiDiBMessage((BidibCommandMessage)new CommandStationDriveMessage(addr, mode, speed, dir, curActiveFunctions, this.functions), this.node);
        return true;
    }

    protected void receiveFunctions(byte[] functions) {
        this.updateFunction(0, (functions[0] & 0x10) != 0);
        this.updateFunction(1, (functions[0] & 1) != 0);
        this.updateFunction(2, (functions[0] & 2) != 0);
        this.updateFunction(3, (functions[0] & 4) != 0);
        this.updateFunction(4, (functions[0] & 8) != 0);
        this.updateFunction(5, (functions[1] & 1) != 0);
        this.updateFunction(6, (functions[1] & 2) != 0);
        this.updateFunction(7, (functions[1] & 4) != 0);
        this.updateFunction(8, (functions[1] & 8) != 0);
        this.updateFunction(9, (functions[1] & 0x10) != 0);
        this.updateFunction(10, (functions[1] & 0x20) != 0);
        this.updateFunction(11, (functions[1] & 0x40) != 0);
        this.updateFunction(12, (functions[1] & 0x80) != 0);
        this.updateFunction(13, (functions[2] & 1) != 0);
        this.updateFunction(14, (functions[2] & 2) != 0);
        this.updateFunction(15, (functions[2] & 4) != 0);
        this.updateFunction(16, (functions[2] & 8) != 0);
        this.updateFunction(17, (functions[2] & 0x10) != 0);
        this.updateFunction(18, (functions[2] & 0x20) != 0);
        this.updateFunction(19, (functions[2] & 0x40) != 0);
        this.updateFunction(20, (functions[2] & 0x80) != 0);
        this.updateFunction(21, (functions[3] & 1) != 0);
        this.updateFunction(22, (functions[3] & 2) != 0);
        this.updateFunction(23, (functions[3] & 4) != 0);
        this.updateFunction(24, (functions[3] & 8) != 0);
        this.updateFunction(25, (functions[3] & 0x10) != 0);
        this.updateFunction(26, (functions[3] & 0x20) != 0);
        this.updateFunction(27, (functions[3] & 0x40) != 0);
        this.updateFunction(28, (functions[3] & 0x80) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveSpeedSetting(int speed) {
        BiDiBThrottle biDiBThrottle = this;
        synchronized (biDiBThrottle) {
            this.oldSpeed = this.speedSetting;
            float newSpeed = this.floatSpeed(speed, 127);
            log.trace("  set speed: old: {}, new: {} {}", new Object[]{Float.valueOf(this.oldSpeed), Float.valueOf(newSpeed), speed});
            super.setSpeedSetting(newSpeed);
        }
    }

    protected void receiveIsForward(boolean forward) {
        boolean old = this.isForward;
        log.trace("  set isForward: old: {}, new: {}", (Object)old, (Object)forward);
        if (old != forward) {
            super.setIsForward(forward);
        }
    }

    public float floatSpeed(int speed, int steps) {
        if (speed == 1) {
            return -1.0f;
        }
        if (speed == 0) {
            return 0.0f;
        }
        float value = (float)(speed - 1) / (float)(steps - 1);
        log.trace("speed: {}, steps: {}, float value: {}", new Object[]{speed, steps, Float.valueOf(value)});
        if ((double)value > 1.0) {
            return 1.0f;
        }
        if ((double)value < 0.0) {
            return 0.0f;
        }
        return value;
    }

    protected void driveReceive(byte[] address, DriveState driveState) {
        if (NodeUtils.isAddressEqual((byte[])this.node.getAddr(), (byte[])address) && this.locoAddress.getNumber() == driveState.getAddress()) {
            log.info("THROTTLE csDrive was signalled, node addr: {}, loco addr: {}, state: {}", new Object[]{address, driveState.getAddress(), driveState});
            this.receiveSpeedSetting(driveState.getSpeed());
            this.receiveIsForward(driveState.getDirection() == DirectionEnum.FORWARD);
            this.receiveFunctions(driveState.getFunctions());
        }
    }

    private void createThrottleListener() {
        this.messageListener = new DefaultMessageListener(){

            public void csDriveAcknowledge(byte[] address, int messageNum, int dccAddress, DriveAcknowledge state, Integer acknowledgedMessageNumber) {
                if (NodeUtils.isAddressEqual((byte[])BiDiBThrottle.this.node.getAddr(), (byte[])address) && BiDiBThrottle.this.locoAddress.getNumber() == dccAddress) {
                    log.debug("THROTTLE: drive ackn was signalled, acknowledge: {}, dccAddress: {}, node: {}", new Object[]{state, dccAddress, BiDiBThrottle.this.node});
                    if (state == DriveAcknowledge.NOT_ACKNOWLEDGED) {
                        log.warn("setDrive was not acknowledged on node: {}, Lok addr: {}", (Object)address, (Object)dccAddress);
                    }
                }
            }

            public void csDriveState(byte[] address, int messageNum, int opCode, DriveState driveState) {
                log.trace("csDriveState: node addr: {}, opCode: {}, DriveState: {}", new Object[]{address, opCode, driveState});
                if (NodeUtils.isAddressEqual((byte[])BiDiBThrottle.this.node.getAddr(), (byte[])address) && BiDiBThrottle.this.locoAddress.getNumber() == driveState.getAddress()) {
                    BiDiBThrottle.this.driveReceive(address, driveState);
                }
            }

            public void csDriveManual(byte[] address, int messageNum, DriveState driveState) {
                if (NodeUtils.isAddressEqual((byte[])BiDiBThrottle.this.node.getAddr(), (byte[])address) && BiDiBThrottle.this.locoAddress.getNumber() == driveState.getAddress()) {
                    log.debug("THROTTLE: Drive Manual was signalled, DriveState: {}, node: {}", (Object)driveState, (Object)BiDiBThrottle.this.node);
                    BiDiBThrottle.this.driveReceive(address, driveState);
                }
            }
        };
        this.tc.addMessageListener(this.messageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void throttleDispose() {
        log.trace("dispose throttle addr {}", (Object)this.locoAddress);
        BiDiBThrottle biDiBThrottle = this;
        synchronized (biDiBThrottle) {
            if (this.speedSetting < 0.0f) {
                this.sendDeregister = true;
                this.speedSetting = 0.0f;
                this.sendDriveCommand(false);
            }
        }
        this.active = false;
        this.finishRecord();
    }
}

