/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumSet;
import java.util.HashMap;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBThrottle;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBThrottleManager
extends AbstractThrottleManager {
    protected HashMap<LocoAddress, BiDiBThrottle> throttles = new HashMap();
    BiDiBTrafficController tc = null;
    String prefix = "";
    private static final Logger log = LoggerFactory.getLogger(BiDiBThrottleManager.class);

    public BiDiBThrottleManager(BiDiBSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getBiDiBTrafficController();
        this.prefix = memo.getSystemPrefix();
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Cast safe by design")
    public void requestThrottleSetup(LocoAddress a, boolean control) {
        DccLocoAddress address = (DccLocoAddress)a;
        log.debug("request BiDiBThrottle for {}", (Object)address);
        if (this.throttles.containsKey(address)) {
            log.debug("BiDiB throttle found.");
            BiDiBThrottle throttle = this.throttles.get(address);
            this.notifyThrottleKnown(throttle, address);
            throttle.requestState();
        } else {
            log.debug("create new BiDiB throttle.");
            BiDiBThrottle throttle = new BiDiBThrottle((BiDiBSystemConnectionMemo)this.adapterMemo, address);
            this.throttles.put(address, throttle);
            this.notifyThrottleKnown(throttle, address);
        }
    }

    @Override
    protected boolean singleUse() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address >= 0 && address <= 10239;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address >= 1 && address <= 127;
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28, SpeedStepMode.NMRA_DCC_14);
    }

    @Override
    public void dispatchThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("BiDiBThrottleManager.dispatchThrottle: {}, {}", (Object)t, (Object)l);
        super.dispatchThrottle(t, l);
    }

    @Override
    public void releaseThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("BiDiBThrottleManager.releaseThrottle: {}, {}", (Object)t, (Object)l);
        super.releaseThrottle(t, l);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Cast safe by design")
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l)) {
            BiDiBThrottle bt = (BiDiBThrottle)t;
            bt.throttleDispose();
            return true;
        }
        return false;
    }
}

