/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Timer;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.ShutDownManager;
import jmri.implementation.AbstractShutDownTask;
import jmri.jmrix.PortAdapter;
import jmri.jmrix.bidib.BiDiBNodeInitializer;
import jmri.jmrix.bidib.BiDiBPortController;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.netbidib.NetBiDiBPairingRequestDialog;
import jmri.util.TimerUtil;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.BidibNodeAccessor;
import org.bidib.jbidibc.core.node.BoosterNode;
import org.bidib.jbidibc.core.node.CommandStationNode;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.BoosterStateData;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.LcConfig;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LocalPingMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.jbidibc.simulation.comm.SimulationBidib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
public class BiDiBTrafficController
implements CommandStation {
    public static final String ASYNCCONNECTIONINIT = "jmri-async-init";
    public static final String ISNETBIDIB = "jmri-is-netbidib";
    private final BidibInterface bidib;
    private final Set<TransferListener> transferListeners = new LinkedHashSet<TransferListener>();
    private final Set<MessageListener> messageListeners = new LinkedHashSet<MessageListener>();
    private final Set<NodeListener> nodeListeners = new LinkedHashSet<NodeListener>();
    private final AtomicBoolean stallLock = new AtomicBoolean();
    private TimerTask watchdogTimer = null;
    private final AtomicBoolean watchdogStatus = new AtomicBoolean();
    private final CountDownLatch continueLock = new CountDownLatch(1);
    private NetBiDiBPairingRequestDialog pairingDialog = null;
    private PairingResult curPairingResult = PairingResult.UNPAIRED;
    private boolean isAsyncInit = false;
    private boolean isNetBiDiB = false;
    private boolean connectionIsReady = false;
    private final BiDiBNodeInitializer nodeInitializer;
    private BiDiBPortController portController;
    private final Set<ActionListener> connectionChangedListeners = new LinkedHashSet<ActionListener>();
    protected final TreeMap<Long, Node> nodes = new TreeMap();
    private Node cachedCommandStationNode = null;
    private final AtomicBoolean mIsProgMode = new AtomicBoolean();
    protected volatile CommandStationState mSavedMode;
    private Node currentGlobalProgrammerNode = null;
    private final Timer progTimer = new Timer(200, e -> this.progTimeout());
    private final Timer localPingTimer = new Timer(4000, e -> this.localPingTimeout());
    private final Timer delayedCloseTimer;
    private final Map<Long, String> debugStringBuffer = new HashMap<Long, String>();
    Node debugSavedNode;
    BiDiBSystemConnectionMemo mMemo = null;
    private static final Logger log = LoggerFactory.getLogger(BiDiBTrafficController.class);

    public BiDiBTrafficController(BidibInterface b) {
        this.bidib = b;
        this.delayedCloseTimer = new Timer(1000, e -> this.bidib.close());
        this.delayedCloseTimer.setRepeats(false);
        log.debug("BiDiBTrafficController created");
        this.mSavedMode = CommandStationState.OFF;
        this.setWatchdogTimer(false);
        this.progTimer.setRepeats(false);
        this.mIsProgMode.set(false);
        this.nodeInitializer = new BiDiBNodeInitializer(this, this.bidib, this.nodes);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Cast safe by design")
    public Context connnectPort(PortAdapter p) {
        this.portController = (BiDiBPortController)p;
        Context context = this.portController.getContext();
        this.isAsyncInit = (Boolean)context.get(ASYNCCONNECTIONINIT, Boolean.class, (Object)false);
        this.isNetBiDiB = (Boolean)context.get(ISNETBIDIB, Boolean.class, (Object)false);
        this.stallLock.set(false);
        this.messageListeners.add((MessageListener)new DefaultMessageListener(){

            public void error(byte[] address, int messageNum, int errorCode, byte[] reasonData) {
                log.debug("Node error event: addr: {}, msg num: {}, error code: {}, data: {}", new Object[]{address, messageNum, errorCode, reasonData});
                if (errorCode == 1) {
                    log.info("error: {}", (Object)new String(reasonData));
                }
            }

            @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="info message contains context information")
            public void nodeString(byte[] address, int messageNum, int namespace, int stringId, String value) {
                if (namespace == 1) {
                    Node node = BiDiBTrafficController.this.getNodeByAddr(address);
                    String uid = ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
                    long key = node.getUniqueId() & 0xFFFFFFFFFFL | (long)stringId << 40;
                    String prefix = "===== BiDiB";
                    if (value.charAt(value.length() - 1) == '\n') {
                        Object txt = "";
                        if (BiDiBTrafficController.this.debugStringBuffer.containsKey(key)) {
                            txt = BiDiBTrafficController.this.debugStringBuffer.get(key);
                            BiDiBTrafficController.this.debugStringBuffer.remove(key);
                        }
                        txt = (String)txt + value.replace("\n", "");
                        switch (stringId) {
                            case 0: {
                                log.info("{} {} stdout: {}", new Object[]{prefix, uid, txt});
                                break;
                            }
                            case 1: {
                                log.info("{} {} stderr: {}", new Object[]{prefix, uid, txt});
                                break;
                            }
                            case 2: {
                                log.warn("{} {}: {}", new Object[]{prefix, uid, txt});
                                break;
                            }
                            case 3: {
                                log.info("{} {}: {}", new Object[]{prefix, uid, txt});
                                break;
                            }
                            case 4: {
                                log.debug("{} {}: {}", new Object[]{prefix, uid, txt});
                                break;
                            }
                            case 5: {
                                log.trace("{} {}: {}", new Object[]{prefix, uid, txt});
                                break;
                            }
                        }
                    } else {
                        log.trace("incomplete debug string received: [{}]", (Object)value);
                        String txt = "";
                        if (BiDiBTrafficController.this.debugStringBuffer.containsKey(key)) {
                            txt = BiDiBTrafficController.this.debugStringBuffer.get(key);
                        }
                        BiDiBTrafficController.this.debugStringBuffer.put(key, txt + value);
                    }
                }
            }

            public void nodeLost(byte[] address, int messageNum, Node node) {
                log.debug("Node lost event: {}", (Object)node);
                BiDiBTrafficController.this.nodeInitializer.nodeLost(node);
            }

            public void nodeNew(byte[] address, int messageNum, Node node) {
                log.debug("Node new event: {}", (Object)node);
                BiDiBTrafficController.this.nodeInitializer.nodeNew(node);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stall(byte[] address, int messageNum, boolean stall) {
                log.trace("message listener stall! {} node: {}", (Object)stall, (Object)BiDiBTrafficController.this.getNodeByAddr(address));
                AtomicBoolean atomicBoolean = BiDiBTrafficController.this.stallLock;
                synchronized (atomicBoolean) {
                    if (log.isDebugEnabled()) {
                        Node node = BiDiBTrafficController.this.getNodeByAddr(address);
                        log.debug("stall - msg num: {}, new state: {}, node: {}, ", new Object[]{messageNum, stall, node});
                    }
                    if (stall != BiDiBTrafficController.this.stallLock.get()) {
                        BiDiBTrafficController.this.stallLock.set(stall);
                        if (!stall) {
                            log.debug("stall - wake send");
                            BiDiBTrafficController.this.stallLock.notifyAll();
                        }
                    }
                }
            }

            public void localPong(byte[] address, int messageNum) {
                if (log.isTraceEnabled()) {
                    Node node = BiDiBTrafficController.this.getNodeByAddr(address);
                    log.trace("local pong - msg num: {}, node: {}, ", (Object)messageNum, (Object)node);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void csState(byte[] address, int messageNum, CommandStationState commandStationState) {
                boolean newState;
                Node node = BiDiBTrafficController.this.getNodeByAddr(address);
                log.debug("CS STATE event: {} on node {}, current watchdog status: {}", new Object[]{commandStationState, node, BiDiBTrafficController.this.watchdogStatus.get()});
                AtomicBoolean atomicBoolean = BiDiBTrafficController.this.mIsProgMode;
                synchronized (atomicBoolean) {
                    if (CommandStationState.isPtProgState((CommandStationState)commandStationState)) {
                        BiDiBTrafficController.this.mIsProgMode.set(true);
                    } else {
                        BiDiBTrafficController.this.mIsProgMode.set(false);
                        BiDiBTrafficController.this.mSavedMode = commandStationState;
                    }
                }
                boolean bl = newState = commandStationState == CommandStationState.GO;
                if (node == BiDiBTrafficController.this.getFirstCommandStationNode() && newState != BiDiBTrafficController.this.watchdogStatus.get()) {
                    log.trace("watchdog: new state: {}, current state: {}", (Object)newState, (Object)BiDiBTrafficController.this.watchdogStatus.get());
                    BiDiBTrafficController.this.setWatchdogTimer(newState);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void csProgState(byte[] address, int messageNum, CommandStationProgState commandStationProgState, int remainingTime, int cvNumber, int cvData) {
                Timer timer = BiDiBTrafficController.this.progTimer;
                synchronized (timer) {
                    if ((commandStationProgState.getType() & 0x80) != 0) {
                        BiDiBTrafficController.this.progTimer.restart();
                        log.trace("PROG finished, progTimer (re)started.");
                    } else {
                        BiDiBTrafficController.this.progTimer.stop();
                        log.trace("PROG pending, progTimer stopped.");
                    }
                }
            }

            public void boosterState(byte[] address, int messageNum, BoosterState state, BoosterControl control) {
                Node node = BiDiBTrafficController.this.getNodeByAddr(address);
                log.info("BOOSTER STATE & CONTROL was signalled: {}, control: {}", (Object)state.getType(), (Object)control.getType());
                if (node != BiDiBTrafficController.this.getFirstCommandStationNode() && node == BiDiBTrafficController.this.currentGlobalProgrammerNode && control != BoosterControl.LOCAL) {
                    BiDiBTrafficController.this.currentGlobalProgrammerNode = null;
                }
            }
        });
        this.transferListeners.add(new TransferListener(){

            public void sendStopped() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sendStarted() {
                log.debug("sendStarted");
                AtomicBoolean atomicBoolean = BiDiBTrafficController.this.stallLock;
                synchronized (atomicBoolean) {
                    if (BiDiBTrafficController.this.stallLock.get()) {
                        try {
                            log.debug("sendStarted is stalled - waiting...");
                            BiDiBTrafficController.this.stallLock.wait(1000L);
                            log.debug("sendStarted stall condition has been released");
                        }
                        catch (InterruptedException e) {
                            log.warn("waited too long for releasing stall condition - continue...");
                            BiDiBTrafficController.this.stallLock.set(false);
                        }
                    }
                }
            }

            public void receiveStopped() {
            }

            public void receiveStarted() {
            }

            public void ctsChanged(boolean cts, boolean manualEvent) {
                log.trace("ctsChanged");
            }
        });
        ConnectionListener connectionListener = new ConnectionListener(){

            public void opened(String port) {
                log.debug("opened port {}", (Object)port);
                if (!BiDiBTrafficController.this.isAsyncInit) {
                    BiDiBTrafficController.this.connectionIsReady = true;
                    BiDiBTrafficController.this.nodeInitializer.connectionInit();
                    BiDiBTrafficController.this.continueLock.countDown();
                }
            }

            public void closed(String port) {
                log.debug("closed port {}", (Object)port);
                if (BiDiBTrafficController.this.bidib.getRootNode() != null && BiDiBTrafficController.this.bidib.getRootNode().isLocalPingEnabled()) {
                    log.debug("Stop local ping");
                    BiDiBTrafficController.this.bidib.getRootNode().stopLocalPingWorker();
                }
                BiDiBTrafficController.this.connectionIsReady = false;
                BiDiBTrafficController.this.nodeInitializer.connectionLost();
                BiDiBTrafficController.this.continueLock.countDown();
                BiDiBTrafficController.this.fireConnectionChanged("closed");
            }

            public void stall(boolean stall) {
                log.info("connection stall! {}", (Object)stall);
            }

            public void status(String messageKey, Context context) {
                log.trace("status - message key {}", (Object)messageKey);
            }

            public void pairingFinished(PairingResult pairingResult, long uniqueId) {
                log.debug("** pairingFinished - result: {}, uniqueId: {}", (Object)pairingResult, (Object)ByteUtils.convertUniqueIdToString((byte[])ByteUtils.convertLongToUniqueId((long)uniqueId)));
                BiDiBTrafficController.this.curPairingResult = pairingResult;
                if (!BiDiBTrafficController.this.curPairingResult.equals((Object)PairingResult.PAIRED)) {
                    log.warn("Unpaired!");
                    BiDiBTrafficController.this.connectionIsReady = false;
                    BiDiBTrafficController.this.nodeInitializer.connectionLost();
                    if (BiDiBTrafficController.this.continueLock.getCount() == 0L && BiDiBTrafficController.this.bidib.isOpened()) {
                        BiDiBTrafficController.this.delayedCloseTimer.start();
                    }
                    BiDiBTrafficController.this.continueLock.countDown();
                }
            }

            public void actionRequired(String messageKey, Context context) {
                log.info("actionRequired - messageKey: {}, context: {}", (Object)messageKey, (Object)context);
                if (messageKey.equals("pairing-state") && context.get("PAIRING_STATE") == PairingStateEnum.Unpaired) {
                    log.debug("**** send pairing request ****");
                    log.trace("context: {}", (Object)context);
                    BiDiBTrafficController.this.bidib.signalUserAction("pairingRequest", context);
                    BiDiBTrafficController.this.pairingDialog = new NetBiDiBPairingRequestDialog(context, BiDiBTrafficController.this.portController, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            log.debug("pairingDialog cancelled: {}", (Object)ae);
                            BiDiBTrafficController.this.curPairingResult = PairingResult.UNPAIRED;
                            BiDiBTrafficController.this.continueLock.countDown();
                        }
                    });
                    BiDiBTrafficController.this.pairingDialog.show();
                }
            }

            public void logonReceived(int localNodeAddr, long uniqueId) {
                log.debug("+++++ logonReceived - localNodeAddr: {}, uniqueId: {}", (Object)localNodeAddr, (Object)ByteUtils.convertUniqueIdToString((byte[])ByteUtils.convertLongToUniqueId((long)uniqueId)));
                BiDiBTrafficController.this.connectionIsReady = true;
                if (BiDiBTrafficController.this.bidib.getRootNode().getMasterNode().isDetached()) {
                    BiDiBTrafficController.this.bidib.getRootNode().getMasterNode().setDetached(false);
                }
                BiDiBTrafficController.this.nodeInitializer.connectionInit();
                BiDiBTrafficController.this.continueLock.countDown();
                BiDiBTrafficController.this.startLocalPing();
                BiDiBTrafficController.this.fireConnectionChanged("logon");
            }

            public void logoffReceived(long uniqueId) {
                log.debug("----- logoffReceived - uniqueId: {}", (Object)ByteUtils.convertUniqueIdToString((byte[])ByteUtils.convertLongToUniqueId((long)uniqueId)));
                BiDiBTrafficController.this.connectionIsReady = false;
                BiDiBTrafficController.this.connectionLost();
                BiDiBTrafficController.this.continueLock.countDown();
                BiDiBTrafficController.this.fireConnectionChanged("logoff");
            }
        };
        String portName = this.portController.getRealPortName();
        log.info("Open BiDiB connection on \"{}\"", (Object)portName);
        try {
            if (!this.bidib.isOpened()) {
                this.bidib.setResponseTimeout(1600);
                this.bidib.open(portName, connectionListener, this.nodeListeners, this.messageListeners, this.transferListeners, context);
            } else {
                this.portController.registerAllListeners(connectionListener, this.nodeListeners, this.messageListeners, this.transferListeners);
            }
            log.debug("the connection is now opened: {}", (Object)this.bidib.isOpened());
            if (this.isAsyncInit) {
                NetBidibLinkData clientLinkData = (NetBidibLinkData)context.get("netBidibClientLinkData", NetBidibLinkData.class, null);
                long timeout = clientLinkData.getRequestedPairingTimeout().intValue();
                boolean success = this.continueLock.await(timeout + 10L, TimeUnit.SECONDS);
                if (this.pairingDialog != null) {
                    this.pairingDialog.dispose();
                    this.pairingDialog = null;
                }
                if (!success || !this.curPairingResult.equals((Object)PairingResult.PAIRED)) {
                    if (this.bidib.isOpened()) {
                        if (!success) {
                            log.warn("pairing or login timed out! Root node cannot be initialized - closing connection");
                        } else {
                            log.warn("pairing or login failed! Root node cannot be initialized - closing connection");
                        }
                        this.bidib.close();
                    }
                    return null;
                }
            } else {
                boolean success = this.continueLock.await(30L, TimeUnit.SECONDS);
                if (!success) {
                    log.warn("node init timeout!");
                }
            }
            if (!this.bidib.isOpened() || !this.connectionIsReady) {
                log.info("connection is not ready - not initialized.");
                return null;
            }
            log.info("registering shutdown task");
            AbstractShutDownTask shutDownTask = new AbstractShutDownTask("BiDiB Shutdown Task"){

                @Override
                public void run() {
                    log.info("Shutdown Task - Terminate {}", (Object)BiDiBTrafficController.this.getUserName());
                    BiDiBTrafficController.this.terminate();
                    log.info("Shutdown task finished {}", (Object)BiDiBTrafficController.this.getUserName());
                }
            };
            InstanceManager.getDefault(ShutDownManager.class).register(shutDownTask);
            return context;
        }
        catch (PortNotFoundException ex) {
            log.error("The provided port was not found: {}. Verify that the BiDiB device is connected.", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Execute command failed: ", (Throwable)ex);
        }
        return null;
    }

    public boolean isConnectionReady() {
        return this.connectionIsReady;
    }

    public boolean isNetBiDiB() {
        return this.isNetBiDiB;
    }

    public void connectionLost() {
        this.connectionIsReady = false;
        this.nodeInitializer.connectionLost();
    }

    public boolean isDetached() {
        if (this.bidib != null) {
            try {
                RootNode rootNode = this.bidib.getRootNode();
                return rootNode.getMasterNode().isDetached();
            }
            catch (Exception e) {
                log.trace("cannot determine detached flag: {}", (Object)e.toString());
            }
        }
        return false;
    }

    public void setLogon(boolean logon) {
        Long uid;
        try {
            NetBidibLinkData providedClientLinkData = (NetBidibLinkData)this.portController.getContext().get("netBidibClientLinkData", NetBidibLinkData.class, null);
            uid = providedClientLinkData.getUniqueId() & 0xFFFFFFFFFFL;
        }
        catch (Exception e) {
            log.error("cannot determine our own Unique ID: {}", (Object)e.toString());
            return;
        }
        if (logon) {
            this.bidib.attach(uid);
        } else {
            this.connectionLost();
            this.bidib.detach(uid);
            this.bidib.getRootNode().getMasterNode().setDetached(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionChangedListener(ActionListener l) {
        Set<ActionListener> set = this.connectionChangedListeners;
        synchronized (set) {
            this.connectionChangedListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionChangedListener(ActionListener l) {
        Set<ActionListener> set = this.connectionChangedListeners;
        synchronized (set) {
            this.connectionChangedListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionChanged(String cmd) {
        List safeListeners;
        Set<ActionListener> set = this.connectionChangedListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.connectionChangedListeners);
        }
        for (ActionListener l : safeListeners) {
            l.actionPerformed(new ActionEvent(this, 1001, cmd));
        }
    }

    public void startLocalPing() {
        log.debug("Start the netBiDiB local ping worker on the rootNode.");
        try {
            if (this.bidib != null) {
                this.bidib.getRootNode().setLocalPingEnabled(true);
                this.bidib.getRootNode().startLocalPingWorker(true, localPingResult -> {
                    if (localPingResult.equals(Boolean.FALSE)) {
                        log.warn("The local pong was not received! Close connection");
                        this.delayedCloseTimer.start();
                    }
                });
            }
        }
        catch (Exception ex) {
            log.warn("Start the local ping worker failed.", (Throwable)ex);
        }
    }

    public void TEST(boolean a) {
        Node node;
        log.debug("TEST {}", (Object)a);
        String nodename = "XXXX";
        Node node2 = node = a ? this.debugSavedNode : this.getNodeByUserName(nodename);
        if (node != null) {
            if (a) {
                this.nodeInitializer.nodeNew(node);
            } else {
                this.debugSavedNode = node;
                this.nodeInitializer.nodeLost(node);
            }
        }
    }

    public BidibInterface getBidib() {
        return this.bidib;
    }

    public Map<Long, Node> getNodeList() {
        return this.nodes;
    }

    public Node getNodeByUniqueID(long uniqueId) {
        return this.nodes.get(uniqueId);
    }

    public Node getNodeByAddr(byte[] addr) {
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            Node node = entry.getValue();
            if (!NodeUtils.isAddressEqual((byte[])node.getAddr(), (byte[])addr)) continue;
            return node;
        }
        return null;
    }

    public Node getNodeByUserName(String userName) {
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            Node node = entry.getValue();
            if (!node.getStoredString(1).equals(userName)) continue;
            return node;
        }
        return null;
    }

    public Node getRootNode() {
        byte[] addr = new byte[]{0};
        return this.getNodeByAddr(addr);
    }

    public boolean isGlobalProgrammerNode(Node node) {
        if (NodeUtils.hasCommandStationFunctions((long)node.getUniqueId()) && NodeUtils.hasCommandStationProgrammingFunctions((long)node.getUniqueId()) && NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) {
            log.trace("node supports command station, programming and booster functions: {}", (Object)node);
            if (node == this.getFirstCommandStationNode() || this.hasLocalDccEnabled(node)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getFirstGlobalProgrammerNode() {
        for (Map.Entry entry : this.nodes.descendingMap().entrySet()) {
            Node node = (Node)entry.getValue();
            if (!this.isGlobalProgrammerNode(node)) continue;
            Timer timer = this.progTimer;
            synchronized (timer) {
                log.debug("global programmer found: {}", (Object)node);
                this.progTimer.restart();
                return node;
            }
        }
        return null;
    }

    public boolean setCurrentGlobalProgrammerNode(Node node) {
        if (node == null || this.isGlobalProgrammerNode(node)) {
            this.currentGlobalProgrammerNode = node;
            return true;
        }
        return false;
    }

    public Node getCurrentGlobalProgrammerNode() {
        if (this.currentGlobalProgrammerNode == null) {
            this.currentGlobalProgrammerNode = this.getFirstGlobalProgrammerNode();
        }
        return this.currentGlobalProgrammerNode;
    }

    private boolean hasLocalDccEnabled(Node node) {
        if (this.bidib instanceof SimulationBidib) {
            return true;
        }
        boolean hasLocalDCC = false;
        BoosterNode bnode = this.getBidib().getBoosterNode(node);
        if (bnode != null) {
            try {
                BoosterStateData bdata = bnode.queryState();
                log.trace("Booster state data: {}", (Object)bdata);
                if (bdata.getControl() == BoosterControl.LOCAL) {
                    hasLocalDCC = true;
                }
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
        }
        log.debug("node has local DCC enabled: {}, {}", (Object)hasLocalDCC, (Object)node);
        return hasLocalDCC;
    }

    public Node getFirstCommandStationNode() {
        if (this.cachedCommandStationNode == null) {
            for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
                Node node = entry.getValue();
                if (!NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) continue;
                log.trace("node has command station functions: {}", (Object)node);
                this.cachedCommandStationNode = node;
                break;
            }
        }
        return this.cachedCommandStationNode;
    }

    public Node getFirstBoosterNode() {
        Node node = this.getFirstCommandStationNode();
        log.trace("getFirstBoosterNode: CS is {}", (Object)node);
        if (node != null && NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) {
            log.trace("CS node also has booster functions: {}", (Object)node);
            return node;
        }
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            node = entry.getValue();
            if (!NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) continue;
            log.trace("node has booster functions: {}", (Object)node);
            return node;
        }
        return null;
    }

    public Node getFirstOutputNode() {
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            Node node = entry.getValue();
            if (!NodeUtils.hasAccessoryFunctions((long)node.getUniqueId()) && !NodeUtils.hasSwitchFunctions((long)node.getUniqueId())) continue;
            log.trace("node has output functions (accessories or ports): {}", (Object)node);
            return node;
        }
        return null;
    }

    public boolean hasAccessoryNode() {
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            Node node = entry.getValue();
            if (!NodeUtils.hasAccessoryFunctions((long)node.getUniqueId())) continue;
            log.trace("node has accessory functions: {}", (Object)node);
            return true;
        }
        return false;
    }

    public Feature findNodeFeature(Node node, int requestedFeatureId) {
        return Feature.findFeature((Collection)node.getFeatures(), (int)requestedFeatureId);
    }

    public int getNodeFeature(Node node, int requestedFeatureId) {
        Feature f = Feature.findFeature((Collection)node.getFeatures(), (int)requestedFeatureId);
        if (f == null) {
            return 0;
        }
        return f.getValue();
    }

    public PortModelEnum getPortModel(Node node) {
        if (PortModelEnum.getPortModel((Node)node) == PortModelEnum.type) {
            return PortModelEnum.type;
        }
        if (node.getPortFlatModel() >= 256) {
            return PortModelEnum.flat_extended;
        }
        return PortModelEnum.flat;
    }

    public void addMessageListener(MessageListener messageListener) {
        if (this.bidib != null) {
            log.trace("addMessageListener called!");
            BidibMessageProcessor rcv = this.bidib.getBidibMessageProcessor();
            if (rcv != null) {
                rcv.addMessageListener(messageListener);
            }
        }
    }

    public void removeMessageListener(MessageListener messageListener) {
        if (this.bidib != null) {
            log.trace("removeMessageListener called!");
            BidibMessageProcessor rcv = this.bidib.getBidibMessageProcessor();
            if (rcv != null) {
                rcv.removeMessageListener(messageListener);
            }
        }
    }

    public void addRawMessageListener(RawMessageListener rawMessageListener) {
        if (this.bidib != null) {
            this.bidib.addRawMessageListener(rawMessageListener);
        }
    }

    public void removeRawMessageListener(RawMessageListener rawMessageListener) {
        if (this.bidib != null) {
            this.bidib.removeRawMessageListener(rawMessageListener);
        }
    }

    private int getTypeCount(Node node, LcOutputType type) {
        int id;
        switch (type) {
            case SWITCHPORT: 
            case SWITCHPAIRPORT: {
                id = 52;
                break;
            }
            case LIGHTPORT: {
                id = 53;
                break;
            }
            case SERVOPORT: {
                id = 54;
                break;
            }
            case SOUNDPORT: {
                id = 55;
                break;
            }
            case MOTORPORT: {
                id = 56;
                break;
            }
            case ANALOGPORT: {
                id = 57;
                break;
            }
            case BACKLIGHTPORT: {
                id = 59;
                break;
            }
            case INPUTPORT: {
                id = 50;
                break;
            }
            default: {
                return 0;
            }
        }
        return this.getNodeFeature(node, id);
    }

    public void allPortConfigX() {
        log.debug("{}: get alle LC ConfigX", (Object)this.getUserName());
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            Node node = entry.getValue();
            if (!NodeUtils.hasSwitchFunctions((long)node.getUniqueId())) continue;
            this.getAllPortConfigX(node, null);
        }
    }

    public List<LcConfigX> getAllPortConfigX(Node node, LcOutputType type) {
        List<LcConfigX> portConfigXList = null;
        try {
            if (node.getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_5)) {
                if (node.isPortFlatModelAvailable()) {
                    int numPorts = node.getPortFlatModel();
                    if (numPorts > 0) {
                        this.bidib.getNode(node).getAllConfigX(this.getPortModel(node), type, Integer.valueOf(0), Integer.valueOf(numPorts));
                    }
                } else {
                    for (LcOutputType t : LcOutputType.values()) {
                        int numPorts;
                        if (type != null && type != t || !t.hasPortStatus() || t.getType() > 15 || (numPorts = this.getTypeCount(node, t)) <= 0) continue;
                        this.bidib.getNode(node).getAllConfigX(this.getPortModel(node), t, Integer.valueOf(0), Integer.valueOf(numPorts));
                    }
                }
            } else {
                for (LcOutputType t : LcOutputType.values()) {
                    int numPorts;
                    if (type != null && type != t || !t.hasPortStatus() || t.getType() > 15 || (numPorts = this.getTypeCount(node, t)) <= 0) continue;
                    int[] plist = new int[numPorts];
                    for (int i = 0; i < numPorts; ++i) {
                        plist[i] = i;
                    }
                    this.bidib.getNode(node).getConfigBulk(PortModelEnum.type, t, plist);
                }
            }
        }
        catch (ProtocolException e) {
            log.error("getAllConfigX message failed:", (Throwable)e);
        }
        return portConfigXList;
    }

    public LcConfigX getPortConfigX(Node node, int portAddr, LcOutputType type) {
        try {
            if (node.getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_5)) {
                if (node.isPortFlatModelAvailable()) {
                    this.bidib.getNode(node).getConfigXBulk(this.getPortModel(node), type, 2, new int[]{portAddr});
                } else {
                    for (LcOutputType t : LcOutputType.values()) {
                        if (type != null && type != t || !t.hasPortStatus() || t.getType() > 15) continue;
                        this.bidib.getNode(node).getConfigXBulk(this.getPortModel(node), t, 2, new int[]{portAddr});
                    }
                }
            } else {
                for (LcOutputType t : LcOutputType.values()) {
                    if (type != null && type != t || !t.hasPortStatus() || t.getType() > 15) continue;
                    this.bidib.getNode(node).getConfigBulk(PortModelEnum.type, t, new int[]{portAddr});
                }
            }
        }
        catch (ProtocolException e) {
            log.error("getConfigXBulk message failed", (Throwable)e);
        }
        return null;
    }

    public LcConfigX convertConfig2ConfigX(Node node, LcConfig lcConfig) {
        PortModelEnum model;
        HashMap<Byte, Object> portConfigValues = new HashMap<Byte, Object>();
        if (node.isPortFlatModelAvailable()) {
            model = PortModelEnum.flat;
            byte portType = lcConfig.getOutputType(model).getType();
            int portMap = 1 << portType;
            ReconfigPortConfigValue pcfg = new ReconfigPortConfigValue((int)portType, portMap);
            portConfigValues.put((byte)-127, pcfg);
        } else {
            model = PortModelEnum.type;
        }
        BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)model, (LcOutputType)lcConfig.getOutputType(model), (int)lcConfig.getOutputNumber(model));
        switch (lcConfig.getOutputType(model)) {
            case SWITCHPORT: {
                if (this.getNodeFeature(node, 67) <= 0) break;
                byte ioCtrl = ByteUtils.getLowByte((int)lcConfig.getValue1());
                byte ticks = ByteUtils.getLowByte((int)lcConfig.getValue2());
                byte switchControl = 34;
                switch (ioCtrl) {
                    case 0: {
                        ticks = 0;
                        switchControl = 16;
                        break;
                    }
                    case 1: {
                        switchControl = 16;
                        break;
                    }
                    case 2: {
                        switchControl = 1;
                        break;
                    }
                    case 3: {
                        ticks = 0;
                        break;
                    }
                    default: {
                        ticks = 0;
                    }
                }
                BytePortConfigValue pcfgTicks = new BytePortConfigValue(Byte.valueOf(ticks));
                BytePortConfigValue pcfgSwitchControl = new BytePortConfigValue(Byte.valueOf(switchControl));
                portConfigValues.put((byte)11, pcfgTicks);
                portConfigValues.put(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL, pcfgSwitchControl);
                break;
            }
            case LIGHTPORT: {
                BytePortConfigValue pcfgLevelPortOff = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue1())));
                BytePortConfigValue pcfgLevelPortOn = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue2())));
                BytePortConfigValue pcfgDimmDown = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue3())));
                BytePortConfigValue pcfgDimmUp = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue4())));
                portConfigValues.put((byte)2, pcfgLevelPortOff);
                portConfigValues.put((byte)1, pcfgLevelPortOn);
                portConfigValues.put((byte)4, pcfgDimmDown);
                portConfigValues.put((byte)3, pcfgDimmUp);
                break;
            }
            case SERVOPORT: {
                BytePortConfigValue pcfgServoAdjL = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue1())));
                BytePortConfigValue pcfgServoAdjH = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue2())));
                BytePortConfigValue pcfgServoSpeed = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue3())));
                portConfigValues.put((byte)7, pcfgServoAdjL);
                portConfigValues.put((byte)8, pcfgServoAdjH);
                portConfigValues.put((byte)9, pcfgServoSpeed);
                break;
            }
            case BACKLIGHTPORT: {
                BytePortConfigValue pcfgDimmDown2 = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue1())));
                BytePortConfigValue pcfgDimmUp2 = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue2())));
                BytePortConfigValue pcfgOutputMap = new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lcConfig.getValue3())));
                portConfigValues.put((byte)4, pcfgDimmDown2);
                portConfigValues.put((byte)3, pcfgDimmUp2);
                portConfigValues.put((byte)6, pcfgOutputMap);
                break;
            }
            case INPUTPORT: {
                byte ioCtrl = ByteUtils.getLowByte((int)lcConfig.getValue1());
                byte inputControl = 1;
                switch (ioCtrl) {
                    case 4: {
                        inputControl = 2;
                        break;
                    }
                    case 5: {
                        inputControl = 3;
                        break;
                    }
                }
                BytePortConfigValue pcfgInputControl = new BytePortConfigValue(Byte.valueOf(inputControl));
                portConfigValues.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, pcfgInputControl);
                break;
            }
        }
        LcConfigX configX = new LcConfigX(bidibPort, portConfigValues);
        return configX;
    }

    public void allPortLcStat() {
        log.debug("{}: get alle LC stat", (Object)this.getUserName());
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            Node node = entry.getValue();
            if (!NodeUtils.hasSwitchFunctions((long)node.getUniqueId())) continue;
            this.portLcStat(node, 65535);
        }
    }

    public void portLcStat(Node node, int typemask) {
        block4: {
            int numPorts;
            BidibRequestFactory rf;
            block6: {
                block5: {
                    if (!NodeUtils.hasSwitchFunctions((long)node.getUniqueId())) break block4;
                    rf = this.getBidib().getRootNode().getRequestFactory();
                    if (!node.getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_6)) break block5;
                    LcPortQueryAllMessage m = rf.createPortQueryAll(typemask, 0, 65535);
                    this.sendBiDiBMessage((BidibCommandMessage)m, node);
                    break block4;
                }
                if (!node.isPortFlatModelAvailable()) break block6;
                int numPorts2 = node.getPortFlatModel();
                for (int addr = 0; addr < numPorts2; ++addr) {
                    LcPortQueryMessage m = rf.createLcPortQuery(this.getPortModel(node), null, addr);
                    this.sendBiDiBMessage((BidibCommandMessage)m, node);
                }
                break block4;
            }
            for (LcOutputType t : LcOutputType.values()) {
                int tmask = 1 << t.getType();
                if ((tmask & typemask) == 0 || !t.hasPortStatus() || t.getType() > 7) continue;
                numPorts = this.getTypeCount(node, t);
                for (int addr = 0; addr < numPorts; ++addr) {
                    LcPortQueryMessage m = rf.createLcPortQuery(this.getPortModel(node), t, addr);
                    this.sendBiDiBMessage((BidibCommandMessage)m, node);
                }
            }
            LcOutputType t = LcOutputType.INPUTPORT;
            int tmask = 1 << t.getType();
            if ((tmask & typemask) == 0) break block4;
            numPorts = this.getTypeCount(node, t);
            for (int addr = 0; addr < numPorts; ++addr) {
                LcKeyMessage m = rf.createLcKey(addr);
                this.sendBiDiBMessage((BidibCommandMessage)m, node);
            }
        }
    }

    public void allAccessoryState() {
        log.debug("{}: get alle accessories", (Object)this.getUserName());
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            Node node = entry.getValue();
            if (!NodeUtils.hasAccessoryFunctions((long)node.getUniqueId())) continue;
            this.accessoryState(node);
        }
    }

    public void accessoryState(Node node) {
        int accSize = this.getNodeFeature(node, 40);
        if (NodeUtils.hasAccessoryFunctions((long)node.getUniqueId()) && accSize > 0) {
            log.info("Requesting accessory status on node {}", (Object)node);
            for (int addr = 0; addr < accSize; ++addr) {
                this.sendBiDiBMessage((BidibCommandMessage)new AccessoryGetMessage(addr), node);
            }
        }
    }

    public void allFeedback() {
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            Node node = entry.getValue();
            if (!NodeUtils.hasFeedbackFunctions((long)node.getUniqueId())) continue;
            this.feedback(node);
        }
    }

    public void feedback(Node node) {
        int bmSize = this.getNodeFeature(node, 0);
        if (NodeUtils.hasFeedbackFunctions((long)node.getUniqueId()) && bmSize > 0) {
            log.info("Requesting feedback status on node {}", (Object)node);
            this.sendBiDiBMessage((BidibCommandMessage)new FeedbackGetRangeMessage(0, bmSize), node);
        }
    }

    public void sendBiDiBMessage(BidibCommandMessage m, Node node) {
        if (node == null) {
            log.error("node is undefined! - can't send message.");
            return;
        }
        log.trace("sendBiDiBMessage: {} on node {}", (Object)m, (Object)node);
        if (this.checkProgMode(m.getType() == 111, node) >= 0) {
            try {
                log.trace("  bidib node: {}", (Object)this.getBidib().getNode(node));
                BidibNodeAccessor.sendNoWait((BidibNode)this.getBidib().getNode(node), (BidibCommand)m);
            }
            catch (ProtocolException e) {
                log.error("sending BiDiB message failed", (Throwable)e);
            }
        } else {
            log.error("switching to or from PROG mode (global programmer) failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int checkProgMode(boolean needProgMode, Node node) {
        Node progNode;
        CommandStationState neededMode;
        log.trace("checkProgMode: needProgMode: {}, node: {}", (Object)needProgMode, (Object)node);
        int hasChanged = 0;
        CommandStationState commandStationState = neededMode = needProgMode ? CommandStationState.PROG : this.mSavedMode;
        if (needProgMode != this.mIsProgMode.get() && node == (progNode = this.getCurrentGlobalProgrammerNode())) {
            Node csNode = this.getFirstCommandStationNode();
            log.debug("use global programmer node: {}", (Object)progNode);
            CommandStationNode progCsNode = this.getBidib().getCommandStationNode(progNode);
            if (progCsNode == null) {
                this.currentGlobalProgrammerNode = null;
                hasChanged = -1;
            } else {
                log.debug("change command station mode to PROG? {}", (Object)needProgMode);
                if (needProgMode && node == csNode) {
                    this.setWatchdogTimer(false);
                }
                try {
                    CommandStationState CurrentMode = progCsNode.setState(neededMode);
                    AtomicBoolean atomicBoolean = this.mIsProgMode;
                    synchronized (atomicBoolean) {
                        if (!needProgMode) {
                            this.mSavedMode = CurrentMode;
                        }
                        this.mIsProgMode.set(needProgMode);
                    }
                    hasChanged = 1;
                }
                catch (ProtocolException e) {
                    log.error("sending MSG_CS_STATE message failed", (Throwable)e);
                    this.currentGlobalProgrammerNode = null;
                    hasChanged = -1;
                }
                log.trace("new saved mode: {}, is ProgMode: {}", (Object)this.mSavedMode, (Object)this.mIsProgMode);
            }
        }
        if (!this.mIsProgMode.get()) {
            Timer timer = this.progTimer;
            synchronized (timer) {
                if (this.progTimer.isRunning()) {
                    this.progTimer.stop();
                    log.trace("progTimer stopped.");
                }
            }
            this.setCurrentGlobalProgrammerNode(null);
        }
        return hasChanged;
    }

    private void progTimeout() {
        log.trace("timeout - stop global programmer PROG mode - reset to {}", (Object)this.mSavedMode);
        this.checkProgMode(false, this.getCurrentGlobalProgrammerNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWatchdogTimer(boolean state) {
        AtomicBoolean atomicBoolean = this.watchdogStatus;
        synchronized (atomicBoolean) {
            Node csnode = this.getFirstCommandStationNode();
            long timeout = 0L;
            log.trace("setWatchdogTimer {} on node {}", (Object)state, (Object)csnode);
            if (csnode != null) {
                timeout = (long)this.getNodeFeature(csnode, 101) * 100L;
                log.trace("FEATURE_GEN_WATCHDOG in ms: {}", (Object)timeout);
                timeout = timeout < 2000L ? (timeout /= 2L) : (timeout -= 1000L);
            }
            if (timeout > 0L && state) {
                log.debug("set watchdog TRUE, timeout: {} ms", (Object)timeout);
                this.watchdogStatus.set(true);
                if (this.watchdogTimer != null) {
                    this.watchdogTimer.cancel();
                }
                this.watchdogTimer = new WatchdogTimerTask();
                TimerUtil.schedule(this.watchdogTimer, timeout, timeout);
            } else {
                log.debug("set watchdog FALSE, requested state: {}, timeout", (Object)state);
                this.watchdogStatus.set(false);
                if (this.watchdogTimer != null) {
                    this.watchdogTimer.cancel();
                }
                this.watchdogTimer = null;
            }
        }
    }

    private void localPingTimeout() {
        log.trace("send local ping");
        if (this.connectionIsReady) {
            this.sendBiDiBMessage((BidibCommandMessage)new LocalPingMessage(), this.getFirstCommandStationNode());
        } else {
            this.localPingTimer.stop();
        }
    }

    public BiDiBSystemConnectionMemo getSystemConnectionMemo() {
        return this.mMemo;
    }

    public void setSystemConnectionMemo(BiDiBSystemConnectionMemo m) {
        this.mMemo = m;
    }

    @Override
    public String getSystemPrefix() {
        if (this.mMemo != null) {
            return this.mMemo.getSystemPrefix();
        }
        return "";
    }

    @Override
    public String getUserName() {
        if (this.mMemo != null) {
            return this.mMemo.getUserName();
        }
        return "";
    }

    @Override
    public boolean sendPacket(byte[] packet, int repeats) {
        log.debug("sendPacket: {}, prefix: {}", (Object)packet, (Object)this.mMemo.getSystemPrefix());
        if (packet != null && packet.length >= 4) {
            log.debug("Addr: {}, addr type: {}, aspect: {}, repeats: {}", new Object[]{NmraPacket.extractAddressType(packet), NmraPacket.extractAddressNumber(packet), packet[2], repeats});
            log.warn("sendPacket is not supported for BiDiB so far");
        }
        return false;
    }

    protected void terminate() {
        log.debug("Cleanup starts {}", (Object)this);
        if (this.bidib == null || !this.bidib.isOpened()) {
            return;
        }
        Node node = this.getCurrentGlobalProgrammerNode();
        if (node != null) {
            this.checkProgMode(false, node);
        }
        this.setWatchdogTimer(false);
        try {
            log.info("sending sysDisable to {}", (Object)this.getRootNode());
            this.bidib.getRootNode().sysDisable();
        }
        catch (ProtocolException e) {
            log.error("unable to disable node", (Throwable)e);
        }
        log.debug("Cleanup ends");
    }

    private class WatchdogTimerTask
    extends TimerTask {
        private WatchdogTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AtomicBoolean atomicBoolean = BiDiBTrafficController.this.watchdogStatus;
            synchronized (atomicBoolean) {
                if (BiDiBTrafficController.this.watchdogStatus.get()) {
                    BiDiBTrafficController.this.sendBiDiBMessage((BidibCommandMessage)new CommandStationSetStateMessage(CommandStationState.GO), BiDiBTrafficController.this.getFirstCommandStationNode());
                }
            }
        }
    }
}

