/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBNamedBeanInterface;
import jmri.jmrix.bidib.BiDiBOutputMessageHandler;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.BiDiBTurnoutManager;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.simulation.comm.SimulationBidib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBTurnout
extends AbstractTurnout
implements BiDiBNamedBeanInterface {
    BiDiBAddress addr;
    private final char typeLetter;
    static String[] modeNames = null;
    static int[] modeValues = null;
    private BiDiBTrafficController tc = null;
    private BiDiBOutputMessageHandler messageHandler = null;
    private static final Logger log = LoggerFactory.getLogger(BiDiBTurnout.class);

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Write safe by design")
    public BiDiBTurnout(String systemName, BiDiBTurnoutManager mgr) {
        super(systemName);
        this.tc = mgr.getMemo().getBiDiBTrafficController();
        this.addr = new BiDiBAddress(systemName, mgr.typeLetter(), mgr.getMemo());
        log.info("New TURNOUT created: {} -> {}", (Object)systemName, (Object)this.addr);
        this.typeLetter = mgr.typeLetter();
        if (this._validFeedbackNames.length != this._validFeedbackModes.length) {
            log.error("int and string feedback arrays different length");
        }
        modeNames = new String[this._validFeedbackNames.length + 1];
        modeValues = new int[this._validFeedbackNames.length + 1];
        for (int i = 0; i < this._validFeedbackNames.length; ++i) {
            BiDiBTurnout.modeNames[i] = this._validFeedbackNames[i];
            BiDiBTurnout.modeValues[i] = this._validFeedbackModes[i];
        }
        BiDiBTurnout.modeNames[this._validFeedbackNames.length] = "MONITORING";
        BiDiBTurnout.modeValues[this._validFeedbackNames.length] = 8;
        this._validFeedbackTypes |= 8;
        this._validFeedbackNames = modeNames;
        this._validFeedbackModes = modeValues;
        this._activeFeedbackType = 8;
        this.createTurnoutListener();
        this.messageHandler.sendQueryConfig();
    }

    @Override
    public BiDiBAddress getAddr() {
        return this.addr;
    }

    @Override
    public void finishLoad() {
        this.sendQuery();
    }

    @Override
    public void nodeNew() {
        this.addr = new BiDiBAddress(this.getSystemName(), this.typeLetter, this.tc.getSystemConnectionMemo());
        if (this.addr.isValid()) {
            log.info("new turnout address created: {} -> {}", (Object)this.getSystemName(), (Object)this.addr);
            this.messageHandler.sendQueryConfig();
            this.messageHandler.waitQueryConfig();
            log.debug("current known state is {}, commanded state is {}", (Object)this.getKnownState(), (Object)this.getCommandedState());
            this.forwardCommandChangeToLayout(this.getCommandedState());
        }
    }

    @Override
    public void nodeLost() {
        this.newKnownState(1);
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void forwardCommandChangeToLayout(int s) {
        if (this.tc.getBidib() instanceof SimulationBidib && this.addr.getAddrString().equals("Xfb7600C602:a0")) {
            this.tc.TEST((s & 4) != 0);
        }
        log.trace("forwardCommandChangeToLayout: {}, addr: {}", (Object)s, (Object)this.addr);
        if ((s & 1) == 0) {
            if ((s & 2) != 0) {
                if ((s & 4) != 0) {
                    log.error("Cannot command both CLOSED and THROWN {}", (Object)s);
                } else {
                    this.sendMessage(true ^ this.getInverted());
                }
            } else {
                this.sendMessage(false ^ this.getInverted());
            }
        }
    }

    @Override
    public void requestUpdateFromLayout() {
        log.trace("requestUpdateFromLayout");
        if (this._activeFeedbackType == 8) {
            this.sendQuery();
        }
        super.requestUpdateFromLayout();
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
    }

    public void sendQuery() {
        this.messageHandler.sendQuery();
    }

    protected void sendMessage(boolean closed) {
        int state;
        int n = state = closed ? 0 : 1;
        if (this.addr.isPortAddr()) {
            switch (this.messageHandler.getLcType()) {
                case LIGHTPORT: {
                    state = closed ? 2 : 3;
                    break;
                }
                case SERVOPORT: 
                case ANALOGPORT: 
                case BACKLIGHTPORT: {
                    state = closed ? 0 : 255;
                    break;
                }
                case MOTORPORT: {
                    state = closed ? 0 : 126;
                    break;
                }
                case INPUTPORT: {
                    log.warn("output to INPUT port is not possible, addr: {}", (Object)this.addr);
                    return;
                }
            }
        }
        if (this.getFeedbackMode() == 8) {
            this.newKnownState(8);
        }
        this.messageHandler.sendOutput(state);
    }

    private void createTurnoutListener() {
        this.messageHandler = new BiDiBOutputMessageHandler(this, "TURNOUT", this.tc){

            @Override
            public void newOutputState(int state) {
                int newState;
                int n = newState = state == 0 ? 2 : 4;
                if (BiDiBTurnout.this.addr.isPortAddr() && this.getLcType() == LcOutputType.LIGHTPORT && state == 2) {
                    newState = 2;
                }
                if (BiDiBTurnout.this.getInverted()) {
                    newState = newState == 4 ? 2 : 4;
                }
                log.debug("TURNOUT new state: {} addr: {}", (Object)newState, (Object)BiDiBTurnout.this.addr);
                BiDiBTurnout.this.newKnownState(newState);
            }

            @Override
            public void outputWait(int time) {
                log.debug("TURNOUT wait: {} addr: {}", (Object)time, (Object)BiDiBTurnout.this.addr);
            }

            @Override
            public void errorState(int err) {
                log.warn("TURNOUT error: {} addr: {}", (Object)err, (Object)BiDiBTurnout.this.addr);
                BiDiBTurnout.this.newKnownState(8);
            }
        };
        this.tc.addMessageListener((MessageListener)this.messageHandler);
    }

    @Override
    public void dispose() {
        if (this.messageHandler != null) {
            this.tc.removeMessageListener((MessageListener)this.messageHandler);
            this.messageHandler = null;
        }
        super.dispose();
    }
}

