/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib;

import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTurnout;
import jmri.jmrix.bidib.Bundle;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBTurnoutManager
extends AbstractTurnoutManager {
    private boolean isLoading = false;
    private final ArrayList<BiDiBTurnout> pendingTurnouts = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(BiDiBTurnoutManager.class);

    public BiDiBTurnoutManager(BiDiBSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public BiDiBSystemConnectionMemo getMemo() {
        return (BiDiBSystemConnectionMemo)this.memo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Turnout createNewTurnout(String systemName, String userName) {
        log.trace("createNewTurnout {} - {}", (Object)systemName, (Object)userName);
        try {
            this.validateSystemNameFormat(systemName);
        }
        catch (IllegalArgumentException e) {
            log.error("failed to validate:", (Throwable)e);
            throw e;
        }
        BiDiBTurnout t = new BiDiBTurnout(systemName, this);
        t.setUserName(userName);
        ArrayList<BiDiBTurnout> arrayList = this.pendingTurnouts;
        synchronized (arrayList) {
            if (this.isLoading) {
                this.pendingTurnouts.add(t);
            } else {
                t.finishLoad();
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad() {
        ArrayList<BiDiBTurnout> arrayList = this.pendingTurnouts;
        synchronized (arrayList) {
            this.isLoading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad() {
        log.info("Turnout manager : finish load");
        ArrayList<BiDiBTurnout> arrayList = this.pendingTurnouts;
        synchronized (arrayList) {
            this.pendingTurnouts.forEach(t -> t.finishLoad());
            this.pendingTurnouts.clear();
            this.isLoading = false;
        }
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        log.trace("createSystemName from {} - {}", (Object)curAddress, (Object)prefix);
        try {
            int i = 1;
            int curNum = Integer.parseInt(curAddress);
            for (Turnout t : this.getNamedBeanSet()) {
                if (i++ != curNum) continue;
                return t.getSystemName();
            }
        }
        catch (NumberFormatException ex) {
            throw new JmriException("Hardware Address passed " + curAddress + " should be a number");
        }
        return prefix + this.typeLetter() + curAddress;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        log.trace("validSystemNameFormat");
        return Manager.NameValidity.VALID;
    }

    @Override
    public String validateSystemNameFormat(String name, Locale locale) {
        log.trace("validateSystemNameFormat: name: {}, typeLetter: {}", (Object)name, (Object)Character.valueOf(this.typeLetter()));
        this.validateSystemNamePrefix(name, locale);
        if (!BiDiBAddress.isValidSystemNameFormat(name, this.typeLetter(), this.getMemo())) {
            throw new NamedBean.BadSystemNameException(Locale.getDefault(), "InvalidSystemName", name);
        }
        return name;
    }

    @Override
    public String getEntryToolTip() {
        String entryToolTip = Bundle.getMessage("AddOutputEntryToolTip");
        return entryToolTip;
    }
}

