/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.netbidib;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrix.AbstractNetworkConnectionConfig;
import jmri.jmrix.NetworkPortAdapter;
import jmri.jmrix.PortAdapter;
import jmri.jmrix.bidib.netbidib.Bundle;
import jmri.jmrix.bidib.netbidib.NetBiDiBAdapter;
import jmri.util.ThreadingUtil;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfig
extends AbstractNetworkConnectionConfig
implements ActionListener {
    public static final String NAME = "netBiDiB";
    private final JComboBox<String> deviceListField = new JComboBox();
    private final JLabel deviceListFieldLabel = new JLabel(Bundle.getMessage("NetBiDiBConnectionAvailableDevices"));
    private final JButton deviceListRefreshButton = new JButton("Refresh");
    private final JButton pairingButton = new JButton("Pairing");
    private final JButton logoffButton = new JButton("Logoff");
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfig.class);

    public ConnectionConfig() {
    }

    public ConnectionConfig(NetworkPortAdapter p) {
        super(p);
        log.info("NetworkPortAdapter opening.");
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    protected void setInstance() {
        if (this.adapter == null) {
            this.adapter = new NetBiDiBAdapter();
            this.adapter.setPort(62875);
            this.adapter.setHostName("localhost");
        }
    }

    private void getDeviceListData() {
        if (this.adapter.getMdnsConfigure()) {
            this.adapter.autoConfigure();
        }
        Map<Long, String> devlist = ((NetBiDiBAdapter)this.adapter).getDeviceListEntries();
        this.deviceListField.setEnabled(false);
        this.deviceListField.removeAllItems();
        for (Map.Entry<Long, String> entry : devlist.entrySet()) {
            Long uid = entry.getKey();
            log.trace("get device list entry for uid {}: [{}]", (Object)ByteUtils.getUniqueIdAsString((Long)uid), (Object)devlist.get(uid));
            this.deviceListField.addItem(devlist.get(uid));
        }
        this.deviceListField.setEnabled(true);
        String item = devlist.get(((NetBiDiBAdapter)this.adapter).getUniqueId());
        if (item != null) {
            this.deviceListField.setSelectedItem(item);
        } else if (devlist.size() > 0) {
            this.deviceListField.setSelectedIndex(0);
        }
    }

    @Override
    public void loadDetails(JPanel details) {
        log.trace("load Details");
        super.loadDetails(details);
        ((NetBiDiBAdapter)this.adapter).addConnectionChangedListener(this);
        this.portFieldLabel.setText("TCP Port");
        this.outputIntervalLabel.setVisible(false);
        this.outputIntervalSpinner.setVisible(false);
        this.outputIntervalReset.setVisible(false);
        this.getDeviceListData();
        this.deviceListField.addActionListener(e -> {
            log.trace("devlist selection event {}", (Object)e.paramString());
            if (this.deviceListField.isEnabled() && this.deviceListField.getSelectedIndex() >= 0) {
                log.debug("device list item selected: [{}] {}", (Object)this.deviceListField.getSelectedIndex(), this.deviceListField.getSelectedItem());
                ((NetBiDiBAdapter)this.adapter).selectDeviceListItem(this.deviceListField.getSelectedIndex());
                this.hostNameField.setText(this.adapter.getHostName());
                this.portField.setText(String.valueOf(this.adapter.getPort()));
                log.debug("selected Unique UID: {},adName field: {}", (Object)this.adapter.getAdvertisementName(), (Object)this.adNameField.getText());
                this.adNameField.setText(this.adapter.getAdvertisementName());
            }
        });
        this.deviceListRefreshButton.addActionListener(e -> {
            log.trace("devlist refresh event {}", (Object)e.paramString());
            this.getDeviceListData();
            this.showAdvancedItems();
        });
        this.pairingButton.addActionListener(e -> {
            log.trace("pairing button event {}", (Object)e.paramString());
            NetBiDiBAdapter a = (NetBiDiBAdapter)this.adapter;
            a.setPaired(!a.isConnectionReady(), pe -> {
                log.trace("pairing action finished event {}", (Object)pe.paramString());
                this.getDeviceListData();
                this.showAdvancedItems();
            });
        });
        this.logoffButton.addActionListener(e -> {
            log.trace("logoff button event {}", (Object)e.paramString());
            NetBiDiBAdapter a = (NetBiDiBAdapter)this.adapter;
            a.setLogon(a.isDetached());
            this.showAdvancedItems();
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Update connection panel {}", (Object)e.paramString());
        ThreadingUtil.runOnGUIEventually(() -> {
            log.trace("update GUI");
            this.getDeviceListData();
            this.showAdvancedItems();
        });
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Cast safe by design")
    public int addStandardDetails(PortAdapter adapter, boolean incAdvanced, int i) {
        log.trace("add Details to JPanel");
        if (this.showAutoConfig.isSelected()) {
            this.cR.gridy = i;
            this.cL.gridy = i++;
            JPanel deviceListPanel = new JPanel();
            deviceListPanel.add(this.deviceListField);
            deviceListPanel.add(this.deviceListRefreshButton);
            this.gbLayout.setConstraints(this.deviceListFieldLabel, this.cL);
            this.gbLayout.setConstraints(deviceListPanel, this.cR);
            this._details.add(this.deviceListFieldLabel);
            this._details.add(deviceListPanel);
        }
        i = super.addStandardDetails(adapter, incAdvanced, i);
        boolean connectionIsOpened = ((NetBiDiBAdapter)adapter).isOpened();
        if (this.showAdvanced.isSelected() || !connectionIsOpened) {
            if (connectionIsOpened) {
                this.pairingButton.setText(Bundle.getMessage("netBiDiBPairingButtonUnpair"));
            } else {
                this.pairingButton.setText(Bundle.getMessage("netBiDiBPairingButtonPair"));
            }
            this.cR.gridy = i;
            this.cL.gridy = i++;
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.pairingButton);
            buttonPanel.add(this.logoffButton);
            this.gbLayout.setConstraints(buttonPanel, this.cR);
            this._details.add(buttonPanel);
        }
        this.logoffButton.setEnabled(connectionIsOpened);
        if (((NetBiDiBAdapter)adapter).isDetached()) {
            this.logoffButton.setText(Bundle.getMessage("netBiDiBLogoffButtonLogon"));
        } else {
            this.logoffButton.setText(Bundle.getMessage("netBiDiBLogoffButtonLogoff"));
        }
        return i;
    }

    @Override
    public void setAutoNetworkConfig() {
        log.trace("setAutoNetworkConfig: {}", (Object)this.showAutoConfig.isSelected());
        super.setAutoNetworkConfig();
        this.hostNameField.setEnabled(!this.showAutoConfig.isSelected());
        this.hostNameFieldLabel.setEnabled(!this.showAutoConfig.isSelected());
        this.getDeviceListData();
        this.showAdvancedItems();
    }

    @Override
    public boolean isHostNameAdvanced() {
        return this.showAutoConfig.isSelected();
    }

    @Override
    public boolean isAutoConfigPossible() {
        return true;
    }

    @Override
    public void dispose() {
        ((NetBiDiBAdapter)this.adapter).removeConnectionChangedListener(this);
        super.dispose();
    }
}

