/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.netbidib;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmdns.ServiceInfo;
import javax.swing.Timer;
import jmri.jmrix.bidib.BiDiBNetworkPortController;
import jmri.jmrix.bidib.BiDiBPortController;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.netbidib.Bundle;
import jmri.jmrix.bidib.netbidib.NetBiDiBPairingRequestDialog;
import jmri.util.FileUtil;
import jmri.util.zeroconf.ZeroConfClient;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.enums.NetBidibRole;
import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.client.BidibNetAddress;
import org.bidib.jbidibc.netbidib.client.NetBidibClient;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.jbidibc.netbidib.pairingstore.LocalPairingStore;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStoreEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBiDiBAdapter
extends BiDiBNetworkPortController {
    public static final String NET_BIDIB_DEFAULT_PAIRING_STORE_FILE = "preference:netBiDiBPairingStore.bidib";
    static final String OPTION_DEVICE_LIST = "AvailableDeviceList";
    static final String OPTION_UNIQUE_ID = "UniqueID";
    static final int BIDIB_JMRI_PID = 254;
    private final Map<Long, NetBiDiDDevice> deviceList = new LinkedHashMap<Long, NetBiDiDDevice>();
    private boolean mDNSConfigure = false;
    private final Timer delayedCloseTimer;
    private PairingStore pairingStore = null;
    private NetBiDiBPairingRequestDialog pairingDialog = null;
    private ActionListener pairingListener = null;
    private Long uniqueId = null;
    long timeout;
    private ZeroConfClient mdnsClient = null;
    private final BiDiBPortController portController = this;
    private static final Logger log = LoggerFactory.getLogger(NetBiDiBAdapter.class);

    public NetBiDiBAdapter() {
        this.setManufacturer("BiDiB");
        this.delayedCloseTimer = new Timer(1000, e -> this.bidib.close());
        this.delayedCloseTimer.setRepeats(false);
        try {
            this.pairingStore = new LocalPairingStore(FileUtil.getFile(NET_BIDIB_DEFAULT_PAIRING_STORE_FILE));
        }
        catch (FileNotFoundException ex) {
            log.warn("pairing store file is invalid: {}", (Object)ex.getMessage());
        }
    }

    public void deviceListAddFromPairingStore() {
        this.pairingStore.load();
        List entries = this.pairingStore.getPairingStoreEntries();
        for (PairingStoreEntry pe : entries) {
            log.debug("Pairing store entry: {}", (Object)pe);
            Long uid = ByteUtils.parseHexUniqueId((String)pe.getUid()) & 0xFFFFFFFFFFL;
            NetBiDiDDevice dev = this.deviceList.get(uid);
            if (dev == null) continue;
            dev.setPaired(pe.isPaired());
            this.deviceList.put(uid, dev);
        }
    }

    @Override
    public void connect(String host, int port) throws IOException {
        this.setHostName(host);
        this.setPort(port);
        this.connect();
    }

    @Override
    public void connect() {
        log.debug("connect() starts to {}:{}", (Object)this.getHostName(), (Object)this.getPort());
        this.opened = false;
        this.prepareOpenContext();
        this.bidib = NetBidibClient.createInstance((Context)this.getContext());
        BiDiBTrafficController tc = new BiDiBTrafficController(this.bidib);
        this.getSystemConnectionMemo().setBiDiBTrafficController(tc);
        log.debug("memo: {}, netBiDiB: {}", (Object)this.getSystemConnectionMemo(), (Object)this.bidib);
        this.context = tc.connnectPort(this);
        this.opened = false;
        if (this.context != null) {
            this.opened = true;
        } else {
            log.warn("No device found on port {} ({}})", (Object)this.getCurrentPortName(), (Object)this.getCurrentPortName());
        }
    }

    private void prepareOpenContext() {
        if (this.getContext() == null) {
            this.context = new DefaultContext();
        }
        Context ctx = this.getContext();
        try {
            LocalPairingStore pairingStore = new LocalPairingStore(FileUtil.getFile(NET_BIDIB_DEFAULT_PAIRING_STORE_FILE));
            pairingStore.load();
            ctx.register("pairingStore", (Object)pairingStore);
        }
        catch (FileNotFoundException ex) {
            log.warn("pairing store file is invalid: {}", (Object)ex.getMessage());
        }
        NetBidibLinkData providedClientLinkData = (NetBidibLinkData)ctx.get("netBidibClientLinkData", NetBidibLinkData.class, null);
        if (providedClientLinkData == null) {
            NetBidibLinkData localClientLinkData = new NetBidibLinkData(NetBidibLinkData.PartnerType.LOCAL);
            localClientLinkData.setRequestorName("BiDiB-JMRI-Client");
            localClientLinkData.setUniqueId(this.getNetBidibUniqueId());
            localClientLinkData.setProdString("JMRI");
            localClientLinkData.setRequestedPairingTimeout(Integer.valueOf(20));
            try {
                String myHostName = InetAddress.getLocalHost().getHostName();
                log.debug("setting netBiDiB username to local hostname: {}", (Object)myHostName);
                localClientLinkData.setUserString(myHostName);
            }
            catch (UnknownHostException ex) {
                log.warn("Cannot determine local host name: {}", (Object)ex.toString());
            }
            localClientLinkData.setProtocolVersion(ProtocolVersion.VERSION_0_8);
            localClientLinkData.setNetBidibRole(NetBidibRole.INTERFACE);
            log.info("Register the created client link data in the create context: {}", (Object)localClientLinkData);
            ctx.register("netBidibClientLinkData", (Object)localClientLinkData);
        }
        ctx.register("jmri-async-init", (Object)true);
        ctx.register("jmri-is-netbidib", (Object)true);
        log.debug("Context: {}", (Object)ctx);
    }

    @Override
    public void configure() {
        log.debug("configure");
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    protected void closeConnection() {
        BiDiBTrafficController tc = this.getSystemConnectionMemo().getBiDiBTrafficController();
        if (tc != null) {
            tc.getBidib().close();
        }
    }

    @Override
    public void registerAllListeners(ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners) {
        NetBidibClient b = (NetBidibClient)this.bidib;
        b.setConnectionListener(connectionListener);
        b.registerListeners(nodeListeners, messageListeners, transferListeners);
    }

    public Long getNetBidibUniqueId() {
        byte[] uniqueId = new byte[]{0, 0, 13, ByteUtils.getLowByte((int)254), ByteUtils.getHighByte((int)254), 0, -24};
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface networkInterface = nis.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                byte[] hardwareAddress = networkInterface.getHardwareAddress();
                if (hardwareAddress != null) {
                    CharSequence[] hexadecimal = new String[hardwareAddress.length];
                    for (int i = 0; i < hardwareAddress.length; ++i) {
                        hexadecimal[i] = String.format("%02X", hardwareAddress[i]);
                    }
                    String macAddress = String.join((CharSequence)"", hexadecimal);
                    log.debug("MAC address used to generate an UID: {} from interface {}", (Object)macAddress, (Object)networkInterface.getDisplayName());
                    int hashCode = macAddress.hashCode();
                    uniqueId = new byte[]{0, 0, 13, ByteUtils.getLowByte((int)254), ByteUtils.getHighByte((int)254), ByteUtils.getHighByte((int)hashCode), ByteUtils.getLowByte((int)hashCode)};
                    log.info("Generated netBiDiB uniqueId from the MAC address: {}", (Object)ByteUtils.convertUniqueIdToString((byte[])uniqueId));
                    break;
                }
                log.warn("No hardware address for localhost available. Use default netBiDiB uniqueId.");
            }
        }
        catch (Exception ex) {
            log.warn("Generate the netBiDiB uniqueId from the MAC address failed.", (Throwable)ex);
        }
        return ByteUtils.convertUniqueIdToLong((byte[])uniqueId);
    }

    @Override
    public DataInputStream getInputStream() {
        return null;
    }

    @Override
    public DataOutputStream getOutputStream() {
        return null;
    }

    @Override
    public void setMdnsConfigure(boolean autoconfig) {
        log.debug("Setting netBiDiB adapter autoconfiguration to: {}", (Object)autoconfig);
        this.mDNSConfigure = autoconfig;
    }

    @Override
    public boolean getMdnsConfigure() {
        return this.mDNSConfigure;
    }

    @Override
    public void autoConfigure() {
        log.info("Configuring BiDiB interface via JmDNS");
        log.debug("current host address: {} {}, port: {}, UniqueID: {}", new Object[]{this.getHostAddress(), this.getHostName(), this.getPort(), ByteUtils.formatHexUniqueId((Long)this.getUniqueId())});
        String serviceType = Bundle.getMessage("defaultMDNSServiceType");
        log.debug("Listening for mDNS service: {}", (Object)serviceType);
        if (this.getUniqueId() != null) {
            log.info("try to find mDNS announcement for unique id: {} (IP: {})", (Object)ByteUtils.getUniqueIdAsString((Long)this.getUniqueId()), (Object)this.getHostName());
        }
        if (this.mdnsClient == null) {
            this.mdnsClient = new ZeroConfClient();
            this.mdnsClient.startServiceListener(serviceType);
            this.timeout = this.mdnsClient.getTimeout();
        }
        List<Object> infoList = new ArrayList();
        this.mdnsClient.setTimeout(0L);
        long startTime = System.currentTimeMillis();
        Long foundUniqueId = null;
        while (System.currentTimeMillis() < startTime + this.timeout) {
            try {
                infoList = this.mdnsClient.getServices(serviceType);
                log.debug("mDNS: \n{}", infoList);
            }
            catch (Exception e) {
                log.error("Error getting mDNS services list: {}", (Object)e.toString());
            }
            this.deviceList.clear();
            for (ServiceInfo serviceInfo : infoList) {
                log.trace("key: {}", (Object)serviceInfo.getKey());
                log.trace("server: {}", (Object)serviceInfo.getServer());
                log.trace("qualified name: {}", (Object)serviceInfo.getQualifiedName());
                log.trace("type: {}", (Object)serviceInfo.getType());
                log.trace("subtype: {}", (Object)serviceInfo.getSubtype());
                log.trace("app: {}, proto: {}", (Object)serviceInfo.getApplication(), (Object)serviceInfo.getProtocol());
                log.trace("name: {}, port: {}", (Object)serviceInfo.getName(), (Object)serviceInfo.getPort());
                log.trace("inet addresses: {}", new ArrayList<InetAddress>(Arrays.asList(serviceInfo.getInetAddresses())));
                log.trace("hostnames: {}", new ArrayList<String>(Arrays.asList(serviceInfo.getHostAddresses())));
                log.trace("urls: {}", new ArrayList<String>(Arrays.asList(serviceInfo.getURLs())));
                Enumeration propList = serviceInfo.getPropertyNames();
                while (propList.hasMoreElements()) {
                    String prop = (String)propList.nextElement();
                    log.trace("service info property {}: {}", (Object)prop, (Object)serviceInfo.getPropertyString(prop));
                }
                Long uid = ByteUtils.parseHexUniqueId((String)serviceInfo.getPropertyString("uid")) & 0xFFFFFFFFFFL;
                NetBiDiDDevice dev = this.deviceList.getOrDefault(uid, new NetBiDiDDevice());
                dev.setAddress(serviceInfo.getInetAddresses()[0]);
                dev.setPort(serviceInfo.getPort());
                dev.setUniqueId(uid);
                dev.setProductName(serviceInfo.getPropertyString("prod"));
                dev.setUserName(serviceInfo.getPropertyString("user"));
                this.deviceList.put(uid, dev);
                log.info("Found announcement: {}", (Object)dev.getString());
                if (this.getUniqueId() == null) {
                    try {
                        InetAddress curHostAddr = InetAddress.getByName(this.getHostName());
                        if (dev.getAddress().equals(curHostAddr)) {
                            this.setUniqueId(dev.getUniqueId());
                        }
                    }
                    catch (UnknownHostException e) {
                        log.trace("No known hostname {}", (Object)this.getHostName());
                    }
                }
                if (!uid.equals(this.getUniqueId())) continue;
                this.setHostName(dev.getAddress().getHostAddress());
                this.setPort(dev.getPort());
                foundUniqueId = uid;
            }
            if (foundUniqueId != null) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (foundUniqueId == null) {
            if (this.getUniqueId() != null) {
                log.warn("no mDNS announcement found for requested unique id {} - last known IP: {}", (Object)ByteUtils.formatHexUniqueId((Long)this.getUniqueId()), (Object)this.getHostName());
            }
        } else {
            log.info("using mDNS announcement: {}", (Object)this.deviceList.get(foundUniqueId).getString());
        }
        this.deviceListAddFromPairingStore();
    }

    @Override
    public String getAdvertisementName() {
        return ByteUtils.getUniqueIdAsStringCompact((Long)this.getUniqueId());
    }

    @Override
    public void setAdvertisementName(String AdName) {
        this.setUniqueId(ByteUtils.parseHexUniqueId((String)AdName.replaceAll("[VP]", "")));
    }

    @Override
    public String getServiceType() {
        return Bundle.getMessage("defaultMDNSServiceType");
    }

    public Map<Long, String> getDeviceListEntries() {
        LinkedHashMap<Long, String> stringList = new LinkedHashMap<Long, String>();
        for (NetBiDiDDevice dev : this.deviceList.values()) {
            stringList.put(dev.getUniqueId(), dev.getString());
        }
        return stringList;
    }

    public void selectDeviceListItem(int i) {
        if (i >= 0 && i < this.deviceList.size()) {
            ArrayList<Map.Entry<Long, NetBiDiDDevice>> entryList = new ArrayList<Map.Entry<Long, NetBiDiDDevice>>(this.deviceList.entrySet());
            NetBiDiDDevice dev = (NetBiDiDDevice)((Map.Entry)entryList.get(i)).getValue();
            log.trace("index {}: uid: {}, entry: {}", new Object[]{i, ByteUtils.formatHexUniqueId((Long)((Long)((Map.Entry)entryList.get(i)).getKey())), ((NetBiDiDDevice)((Map.Entry)entryList.get(i)).getValue()).getString()});
            this.setHostName(dev.getAddress().getHostAddress());
            this.setPort(dev.getPort());
            this.setUniqueId(dev.getUniqueId());
        }
    }

    public Long getUniqueId() {
        Node rootNode;
        if (this.uniqueId == null && this.bidib != null && this.bidib.isOpened() && !this.isDetached() && (rootNode = this.getSystemConnectionMemo().getBiDiBTrafficController().getRootNode()) != null && rootNode.getUniqueId() != 0L) {
            this.uniqueId = rootNode.getUniqueId() & 0xFFFFFFFFFFL;
        }
        return this.uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.uniqueId = uniqueId;
    }

    public boolean isConnectionReady() {
        BiDiBTrafficController tc;
        BiDiBSystemConnectionMemo memo = this.getSystemConnectionMemo();
        if (memo != null && (tc = memo.getBiDiBTrafficController()) != null) {
            return tc.isConnectionReady();
        }
        return false;
    }

    public void setPaired(boolean paired, ActionListener l) {
        this.pairingListener = l;
        if (!paired) {
            NetBiDiDDevice dev;
            if (this.bidib != null && this.bidib.isOpened()) {
                this.bidib.close();
            }
            if ((dev = this.deviceList.get(this.getUniqueId())) != null) {
                dev.setPaired(false);
            }
            this.pairingStore.load();
            List entries = this.pairingStore.getPairingStoreEntries();
            for (PairingStoreEntry pe : entries) {
                log.debug("Pairing store entry: {}", (Object)pe);
                Long uid = ByteUtils.parseHexUniqueId((String)pe.getUid());
                if ((uid & 0xFFFFFFFFFFL) != this.getUniqueId()) continue;
                this.pairingStore.setPaired(uid.longValue(), false);
            }
            this.pairingStore.store();
            if (this.pairingListener != null) {
                this.pairingListener.actionPerformed(new ActionEvent(this, 1001, ""));
            }
        } else {
            this.prepareOpenContext();
            if (this.bidib == null) {
                log.info("create netBiDiB instance");
                this.bidib = NetBidibClient.createInstance((Context)this.getContext());
            }
            if (this.bidib.isOpened()) {
                log.warn("Pairing request - BiDiB instance is already opened. This should never happen.");
                return;
            }
            ConnectionListener connectionListener = new ConnectionListener(){

                public void opened(String port) {
                    log.debug("opened port {}", (Object)port);
                }

                public void closed(String port) {
                    log.debug("closed port {}", (Object)port);
                    if (NetBiDiBAdapter.this.pairingDialog != null) {
                        NetBiDiBAdapter.this.pairingDialog.hide();
                        NetBiDiBAdapter.this.pairingDialog = null;
                    }
                    if (NetBiDiBAdapter.this.pairingListener != null) {
                        NetBiDiBAdapter.this.pairingListener.actionPerformed(new ActionEvent(this, 1001, ""));
                    }
                }

                public void status(String messageKey, Context context) {
                }

                public void pairingFinished(PairingResult pairingResult, long uniqueId) {
                    log.debug("** pairingFinished - result: {}, uniqueId: {}", (Object)pairingResult, (Object)ByteUtils.convertUniqueIdToString((byte[])ByteUtils.convertLongToUniqueId((long)uniqueId)));
                    if (NetBiDiBAdapter.this.bidib.isOpened()) {
                        NetBiDiBAdapter.this.delayedCloseTimer.start();
                    }
                }

                public void actionRequired(String messageKey, Context context) {
                    log.info("actionRequired - messageKey: {}, context: {}", (Object)messageKey, (Object)context);
                    if (messageKey.equals("pairing-state") && context.get("PAIRING_STATE") == PairingStateEnum.Unpaired) {
                        log.trace("**** send pairing request ****");
                        log.trace("context: {}", (Object)context);
                        NetBiDiBAdapter.this.bidib.signalUserAction("pairingRequest", context);
                        NetBiDiBAdapter.this.pairingDialog = new NetBiDiBPairingRequestDialog(context, NetBiDiBAdapter.this.portController, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                log.debug("pairingDialog cancelled: {}", (Object)ae);
                                NetBiDiBAdapter.this.delayedCloseTimer.start();
                            }
                        });
                        NetBiDiBAdapter.this.pairingDialog.show();
                    }
                }
            };
            String portName = this.getRealPortName();
            log.info("Open BiDiB connection for pairting on \"{}\"", (Object)portName);
            this.bidib = NetBidibClient.createInstance((Context)this.getContext());
            try {
                this.bidib.setResponseTimeout(1600);
                this.bidib.open(portName, connectionListener, null, null, null, this.context);
            }
            catch (Exception e) {
                log.error("Execute command failed: ", (Throwable)e);
            }
        }
    }

    public boolean isOpened() {
        if (this.bidib != null) {
            return this.bidib.isOpened();
        }
        return false;
    }

    public boolean isDetached() {
        return this.getSystemConnectionMemo().getBiDiBTrafficController().isDetached();
    }

    public void setLogon(boolean logon) {
        this.getSystemConnectionMemo().getBiDiBTrafficController().setLogon(logon);
    }

    public void addConnectionChangedListener(ActionListener l) {
        this.getSystemConnectionMemo().getBiDiBTrafficController().addConnectionChangedListener(l);
    }

    public void removeConnectionChangedListener(ActionListener l) {
        this.getSystemConnectionMemo().getBiDiBTrafficController().removeConnectionChangedListener(l);
    }

    protected static class NetBiDiDDevice {
        private PairingStoreEntry pairingStoreEntry = new PairingStoreEntry();
        private BidibNetAddress bidibAddress = null;

        public PairingStoreEntry getPairingStoreEntry() {
            return this.pairingStoreEntry;
        }

        public void setPairingStoreEntry(PairingStoreEntry pairingStoreEntry) {
            this.pairingStoreEntry = pairingStoreEntry;
        }

        public Long getUniqueId() {
            return ByteUtils.parseHexUniqueId((String)this.pairingStoreEntry.getUid()) & 0xFFFFFFFFFFL;
        }

        public void setUniqueId(Long uid) {
            this.pairingStoreEntry.setUid(ByteUtils.formatHexUniqueId((Long)uid));
        }

        public void setAddressAndPort(String addr, String port) {
            int portAsInt;
            InetAddress address = null;
            try {
                address = InetAddress.getLocalHost();
                address = InetAddress.getByName(addr);
            }
            catch (UnknownHostException e) {
                log.error("unable to resolve remote server address {}:", (Object)e.toString());
            }
            try {
                portAsInt = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                portAsInt = 0;
            }
            this.bidibAddress = new BidibNetAddress(address, portAsInt);
        }

        public InetAddress getAddress() {
            return this.bidibAddress == null ? InetAddress.getLoopbackAddress() : this.bidibAddress.getAddress();
        }

        public int getPort() {
            return this.bidibAddress == null ? 0 : this.bidibAddress.getPortNumber();
        }

        public void setAddress(InetAddress addr) {
            this.bidibAddress = addr == null ? null : new BidibNetAddress(addr, this.getPort());
        }

        public void setPort(int port) {
            this.bidibAddress = new BidibNetAddress(this.getAddress(), port);
        }

        public String getProductName() {
            return this.pairingStoreEntry.getProductName();
        }

        public void setProductName(String productName) {
            this.pairingStoreEntry.setProductName(productName);
        }

        public String getUserName() {
            return this.pairingStoreEntry.getUserName();
        }

        public void setUserName(String userName) {
            this.pairingStoreEntry.setUserName(userName);
        }

        public boolean isPaired() {
            return this.pairingStoreEntry.isPaired();
        }

        public void setPaired(boolean paired) {
            this.pairingStoreEntry.setPaired(paired);
        }

        public String getString() {
            String s = this.pairingStoreEntry.getUserName() + " (" + this.pairingStoreEntry.getProductName() + ", " + ByteUtils.getUniqueIdAsString((Long)this.getUniqueId());
            if (this.bidibAddress != null) {
                s = s + ", " + this.bidibAddress.getAddress().toString();
                if (this.getPort() != 0) {
                    s = s + ":" + String.valueOf(this.getPort());
                }
            }
            if (this.pairingStoreEntry.isPaired()) {
                s = s + ", paired";
            }
            s = s + ")";
            return s;
        }
    }
}

