/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.netbidib;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBiDiBLogonAction
extends AbstractAction {
    private String logon;
    private String logoff;
    private BiDiBTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(NetBiDiBLogonAction.class);

    public NetBiDiBLogonAction() {
        log.warn("no connection");
    }

    public NetBiDiBLogonAction(BiDiBSystemConnectionMemo memo, String logon, String logoff) {
        super(logoff);
        this.logon = logon;
        this.logoff = logoff;
        this.tc = memo.getBiDiBTrafficController();
        log.debug("create NetBiDiBLogonAction for {} - \"{}\" \"{}\"", new Object[]{memo.getUserName(), logon, logoff});
        if (this.tc != null) {
            this.tc.addConnectionChangedListener(this);
            this.setEnabled(this.tc.getBidib().isOpened());
            this.putValue("Name", this.tc.isDetached() ? logon : logoff);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("NetBiDiBLogonAction actionPerformed {}", (Object)e.paramString());
        if (this.tc != null && this.tc.isNetBiDiB() && this.tc.getBidib() != null) {
            if (this.tc.getBidib().isOpened()) {
                if (e.getActionCommand().equals(this.logon)) {
                    log.info("local node logon requested from menu");
                    this.tc.setLogon(true);
                } else if (e.getActionCommand().equals(this.logoff)) {
                    log.info("local node logoff requested from menu");
                    this.tc.setLogon(false);
                } else {
                    log.info("connection changed: {}", (Object)e.getActionCommand());
                }
                this.setEnabled(true);
                this.putValue("Name", this.tc.isDetached() ? this.logon : this.logoff);
            } else {
                this.setEnabled(false);
                this.putValue("Name", this.logoff);
            }
        }
    }
}

