/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.netbidib;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import jmri.jmrix.bidib.BiDiBPortController;
import jmri.jmrix.bidib.netbidib.Bundle;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBiDiBPairingRequestDialog {
    private final Context context;
    private final BiDiBPortController portController;
    private final Long uniqueId;
    private Integer remainingTimeout;
    private JOptionPane optionPane;
    private final JDialog dialog = new JDialog();
    private final ActionListener actionListener;
    private final Timer updateTimer = new Timer(1000, e -> this.updateDialog());
    private static final Logger log = LoggerFactory.getLogger(NetBiDiBPairingRequestDialog.class);

    public NetBiDiBPairingRequestDialog(Context context, BiDiBPortController portController, ActionListener listener) {
        this.context = context;
        this.portController = portController;
        this.actionListener = listener;
        this.uniqueId = (Long)context.get("DESCRIPTOR_UID", Long.class, null);
        this.remainingTimeout = (Integer)context.get("PAIRING_TIMEOUT", Integer.class, (Object)30);
    }

    public void show() {
        Object[] options = new String[]{Bundle.getMessage("netBiDiBPairingDialogCancel")};
        String title = Bundle.getMessage("netBiDiBPairingDialogTitle");
        this.optionPane = new JOptionPane(this.makeMessageText(), -1, 1, null, options, null);
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (NetBiDiBPairingRequestDialog.this.dialog.isVisible() && e.getSource() == NetBiDiBPairingRequestDialog.this.optionPane && prop.equals("value")) {
                    log.trace("propertychange new value: {}", e.getNewValue());
                    NetBiDiBPairingRequestDialog.this.onCancel();
                }
            }
        });
        this.dialog.setTitle(title);
        this.dialog.setModal(false);
        this.dialog.setContentPane(this.optionPane);
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                log.debug("user closes window.");
                NetBiDiBPairingRequestDialog.this.onCancel();
            }
        });
        this.updateTimer.setRepeats(true);
        this.updateTimer.start();
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void dispose() {
        this.updateTimer.stop();
        this.dialog.dispose();
    }

    public void hide() {
        this.updateTimer.stop();
        this.dialog.setVisible(false);
    }

    private void onCancel() {
        log.info("User cancelled netBiDiB pairing");
        this.dispose();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "Cancel"));
        }
    }

    private void updateDialog() {
        this.remainingTimeout = this.remainingTimeout - 1;
        if (this.remainingTimeout > 0) {
            this.optionPane.setMessage(this.makeMessageText());
        } else {
            this.dispose();
        }
    }

    private String makeMessageText() {
        String remoteLinkData = Bundle.getMessage("netBiDiBPairingDialogText") + "\n";
        remoteLinkData = remoteLinkData + "\n" + Bundle.getMessage("netBiDiBPairingDialogTime") + ": " + this.remainingTimeout.toString() + Bundle.getMessage("netBiDiBPairingDialogSecondsShort");
        remoteLinkData = remoteLinkData + "\n" + Bundle.getMessage("netBiDiBPairingDialogProdName") + ": " + this.context.get("DESCRIPTOR_PROD_STRING", String.class, (Object)"");
        remoteLinkData = remoteLinkData + "\n" + Bundle.getMessage("netBiDiBPairingDialogUserName") + ": " + this.context.get("DESCRIPTOR_USER_STRING", String.class, (Object)"");
        remoteLinkData = remoteLinkData + "\n" + Bundle.getMessage("netBiDiBPairingDialogPortName") + ": " + this.portController.getRealPortName();
        remoteLinkData = remoteLinkData + "\n" + Bundle.getMessage("netBiDiBPairingDialogUniqueID") + ": " + ByteUtils.getUniqueIdAsString((Long)this.uniqueId);
        return remoteLinkData;
    }
}

