/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.serialdriver;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.jmrix.AbstractSerialConnectionConfig;
import jmri.jmrix.SerialPortAdapter;
import jmri.jmrix.bidib.serialdriver.Bundle;
import jmri.jmrix.bidib.serialdriver.SerialDriverAdapter;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfig
extends AbstractSerialConnectionConfig {
    public static final String NAME = Bundle.getMessage("TypeSerial");
    protected JCheckBox useAutoScan = new JCheckBox(Bundle.getMessage("SerialConnectionUseAutoscan"));
    protected JLabel rootNodeLabel = new JLabel(Bundle.getMessage("UniqueIDHex") + ":");
    protected JTextField rootNodeField = new JTextField(16);
    protected JLabel portNameFilterLabel = new JLabel(Bundle.getMessage("SerialConnectionPortNameFilter") + ":");
    protected JTextField portNameFilterField = new JTextField(15);
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfig.class);

    public ConnectionConfig(SerialPortAdapter p) {
        super(p);
    }

    public ConnectionConfig() {
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    protected void setInstance() {
        log.debug("BiDiB Serial ConnectionConfig.setInstance: {}", (Object)this.adapter);
        if (this.adapter == null) {
            this.adapter = new SerialDriverAdapter();
            log.debug("-- adapter created: {}", (Object)this.adapter);
        }
    }

    @Override
    public Vector<String> getPortNames() {
        Vector<String> portNameVector = new Vector<String>();
        try {
            List<String> portNameList = ((SerialDriverAdapter)this.adapter).getPortIdentifiers();
            for (String portName : portNameList) {
                portNameVector.addElement(portName);
            }
        }
        catch (Exception ex) {
            log.error("Serial adapter not set: ", (Throwable)ex);
        }
        log.trace("getPortNames done {}", portNameVector);
        return portNameVector;
    }

    @Override
    protected void checkInitDone() {
        super.checkInitDone();
        log.debug("checkInitDone");
        if (this.adapter.getSystemConnectionMemo() != null) {
            SerialDriverAdapter a = (SerialDriverAdapter)this.adapter;
            this.rootNodeField.setText(ByteUtils.formatHexUniqueId((Long)a.getRootNodeUid()));
            this.portNameFilterField.setText(a.getPortNameFilter());
            this.useAutoScan.setSelected(a.getUseAutoScan());
            if (a.getUseAutoScan()) {
                this.rootNodeField.setEnabled(true);
                this.portBox.setEnabled(false);
            } else {
                this.rootNodeField.setEnabled(false);
                this.portBox.setEnabled(true);
            }
            this.portBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    log.debug("portBox action!");
                    ConnectionConfig.this.portBoxChanged(e);
                }
            });
            this.rootNodeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    log.debug("rootNodeUID action!");
                    ConnectionConfig.this.rootNodeUidChanged(e);
                }
            });
            this.rootNodeField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    log.debug("rootNodeUID focus lost!");
                    ConnectionConfig.this.rootNodeUidChanged(e);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.portNameFilterField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    log.debug("portNameFilter action!");
                    ConnectionConfig.this.portNameFilterChanged(e);
                }
            });
            this.portNameFilterField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    log.debug("portNameFilter focus lost!");
                    ConnectionConfig.this.portNameFilterChanged(e);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.useAutoScan.addItemListener(e -> {
                log.debug("useAutoScan changed!");
                a.setUseAutoScan(this.useAutoScan.isSelected());
                this.rootNodeField.setEnabled(this.useAutoScan.isSelected());
                this.portBox.setEnabled(!this.useAutoScan.isSelected());
            });
            this.baudBox.setEnabled(false);
        }
    }

    private void portBoxChanged(AWTEvent e) {
        SerialDriverAdapter a = (SerialDriverAdapter)this.adapter;
        String fieldtext = ((JComboBox)e.getSource()).getSelectedItem().toString();
        log.debug("portBox selected: {}", (Object)fieldtext);
        if (!a.getUseAutoScan()) {
            Long uid = a.checkPort(fieldtext);
            if (uid == null) {
                a.setRootNodeUid(null);
                this.rootNodeField.setText("");
            } else {
                a.setRootNodeUid(uid);
                this.rootNodeField.setText(ByteUtils.formatHexUniqueId((Long)a.getRootNodeUid()));
            }
        }
    }

    private void rootNodeUidChanged(AWTEvent e) {
        SerialDriverAdapter a = (SerialDriverAdapter)this.adapter;
        String fieldtext = ((JTextField)e.getSource()).getText();
        if (!fieldtext.isEmpty()) {
            try {
                if (a.getUseAutoScan()) {
                    Long uid = ByteUtils.parseHexUniqueId((String)fieldtext);
                    String err = a.findPortbyUniqueID(uid);
                    if (err == null) {
                        log.info("found port name for UID {} is {}", (Object)ByteUtils.formatHexUniqueId((Long)a.getRootNodeUid()), (Object)a.getCurrentPortName());
                        a.setRootNodeUid(uid);
                        this.rootNodeField.setText(ByteUtils.formatHexUniqueId((Long)a.getRootNodeUid()));
                        this.rootNodeField.setForeground(Color.black);
                        this.portBox.setSelectedItem(a.getCurrentPortName());
                    } else {
                        log.warn(err);
                        this.rootNodeField.setForeground(Color.red);
                    }
                }
            }
            catch (NumberFormatException ex) {
                a.setRootNodeUid(null);
                this.rootNodeField.setText("");
                log.warn("Exception:", (Throwable)ex);
            }
        }
    }

    private void portNameFilterChanged(AWTEvent e) {
        SerialDriverAdapter a = (SerialDriverAdapter)this.adapter;
        String fieldtext = ((JTextField)e.getSource()).getText();
        a.setPortNameFilter(fieldtext);
        this.refreshPortBox();
    }

    @Override
    protected void showAdvancedItems() {
        super.showAdvancedItems();
        log.debug("showAdvancedItems");
        if (this.adapter.getSystemConnectionMemo() != null) {
            this.cR.gridy += 2;
            this.cL.gridy += 2;
            this.gbLayout.setConstraints(this.rootNodeLabel, this.cL);
            this.gbLayout.setConstraints(this.rootNodeField, this.cR);
            this._details.add(this.rootNodeLabel);
            this._details.add(this.rootNodeField);
            this.cR.gridy += 2;
            this.cL.gridy += 2;
            this.gbLayout.setConstraints(this.useAutoScan, this.cL);
            this.useAutoScan.setFont(this.useAutoScan.getFont().deriveFont(9.0f));
            this.useAutoScan.setForeground(Color.blue);
            this._details.add(this.useAutoScan);
            this.cR.gridy += 2;
            this.cL.gridy += 2;
            this.gbLayout.setConstraints(this.portNameFilterLabel, this.cL);
            this.gbLayout.setConstraints(this.portNameFilterField, this.cR);
            this._details.add(this.portNameFilterLabel);
            this._details.add(this.portNameFilterField);
        }
        if (this._details.getParent() != null) {
            this._details.getParent().revalidate();
            this._details.getParent().repaint();
        }
    }

    @Override
    public void updateAdapter() {
        super.updateAdapter();
        log.debug("updateAdapter");
        SerialDriverAdapter a = (SerialDriverAdapter)this.adapter;
        if (this.adapter.getSystemConnectionMemo() != null) {
            a.setUseAutoScan(this.useAutoScan.isSelected());
            a.setRootNodeUid(ByteUtils.parseHexUniqueId((String)this.rootNodeField.getText()));
            a.setPortNameFilter(this.portNameFilterField.getText());
        }
    }
}

