/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.serialdriver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jmri.jmrix.bidib.BiDiBSerialPortController;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.serialdriver.Bundle;
import jmri.util.SystemType;
import org.bidib.jbidibc.core.BidibFactory;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.jserialcomm.JSerialCommSerialBidib;
import org.bidib.jbidibc.jserialcomm.PortIdentifierUtils;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends BiDiBSerialPortController {
    private static final boolean useJSerailComm = true;
    private static final boolean usePurjavacomm = false;
    private static final boolean useScm = false;
    private static final Map<String, Long> connectionRootNodeList = new HashMap<String, Long>();
    protected String portNameFilter = "";
    protected Long rootNodeUid;
    protected boolean useAutoScan = false;
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud115200"), Bundle.getMessage("Baud19200")};
    protected int[] validSpeedValues = new int[]{115200, 19200};
    protected String selectedSpeed = this.validSpeeds[0];
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");

    public SerialDriverAdapter() {
        this.setManufacturer("BiDiB");
        this.configureBaudRate(this.validSpeeds[0]);
        if (SystemType.isLinux()) {
            this.portNameFilter = "ttyUSB*";
        }
        List<String> portList = this.getPortIdentifiers();
        log.info("portList: {}", portList);
    }

    public String getPortNameFilter() {
        return this.portNameFilter;
    }

    public void setPortNameFilter(String filter) {
        this.portNameFilter = filter;
    }

    public Long getRootNodeUid() {
        return this.rootNodeUid;
    }

    public void setRootNodeUid(Long uid) {
        this.rootNodeUid = uid;
    }

    public boolean getUseAutoScan() {
        return this.useAutoScan;
    }

    public void setUseAutoScan(boolean flag) {
        this.useAutoScan = flag;
    }

    @Override
    public String getRealPortName() {
        return SerialDriverAdapter.getRealPortName(this.getCurrentPortName());
    }

    public static String getCanonicalPortName(String portName) {
        File file = new File(portName);
        if (file.exists()) {
            try {
                portName = file.getCanonicalPath();
                log.debug("Canonical port name: {}", (Object)portName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return portName;
    }

    public static String getRealPortName(String portName) {
        if (SystemType.isLinux()) {
            portName = "/dev/" + (String)portName;
        }
        return SerialDriverAdapter.getCanonicalPortName((String)portName);
    }

    @Override
    public String openPort(String portName, String appName) {
        Long uid;
        String err;
        log.debug("openPort called for {}, driver: {}, expected UID: {}", new Object[]{portName, this.getRealPortName(), ByteUtils.formatHexUniqueId((Long)this.rootNodeUid)});
        MSG_RAW_LOGGER.debug("RAW> create BiDiB Instance for port {}", (Object)this.getCurrentPortName());
        if (this.useAutoScan && (err = this.findPortbyUniqueID(this.rootNodeUid)) != null) {
            if (this.bidib != null) {
                this.bidib.close();
                this.bidib = null;
            }
            return err;
        }
        log.debug("port table: {}", connectionRootNodeList);
        if (this.bidib == null) {
            this.context = this.getContext();
            this.bidib = SerialDriverAdapter.createSerialBidib(this.context);
        }
        BiDiBTrafficController tc = new BiDiBTrafficController(this.bidib);
        log.debug("memo: {}", (Object)this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().setBiDiBTrafficController(tc);
        this.context = tc.connnectPort(this);
        if (this.context != null) {
            this.opened = true;
            uid = tc.getRootNode().getUniqueId() & 0xFFFFFFFFFFL;
            if (this.context.get("serial.baudrate") != null) {
                log.debug("opened with baud rate {}", this.context.get("serial.baudrate"));
                this.configureBaudRateFromNumber(this.context.get("serial.baudrate").toString());
            }
            if (this.rootNodeUid != null && !uid.equals(this.rootNodeUid)) {
                this.opened = false;
                connectionRootNodeList.remove(this.getRealPortName());
                tc.getBidib().close();
                return "Device found on port " + this.getRealPortName() + "(" + this.getCurrentPortName() + ") has Unique ID " + ByteUtils.formatHexUniqueId((Long)uid) + ", but should be " + ByteUtils.formatHexUniqueId((Long)this.rootNodeUid);
            }
        } else {
            this.opened = false;
            connectionRootNodeList.put(this.getRealPortName(), null);
            return "No device found on port " + this.getCurrentPortName() + "(" + this.getCurrentPortName() + ")";
        }
        connectionRootNodeList.put(this.getRealPortName(), tc.getRootNode().getUniqueId() & 0xFFFFFFFFFFL);
        this.setRootNodeUid(uid);
        return null;
    }

    @Override
    public void configure() {
        log.debug("configure");
        this.getSystemConnectionMemo().configureManagers();
    }

    private static BidibInterface createSerialBidib(Context context) {
        return BidibFactory.createBidib((String)JSerialCommSerialBidib.class.getName(), (Context)context);
    }

    @Override
    public void registerAllListeners(ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners) {
        JSerialCommSerialBidib b = (JSerialCommSerialBidib)this.bidib;
        b.setConnectionListener(connectionListener);
        b.registerListeners(nodeListeners, messageListeners, transferListeners);
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> ret = null;
        List list = null;
        list = PortIdentifierUtils.getPortIdentifiers();
        if (list != null) {
            ret = new ArrayList<String>();
            String portPrefix = this.portNameFilter.replaceAll("\\*", "");
            log.trace("port name filter: {}", (Object)portPrefix);
            for (String s : list) {
                if (!s.startsWith(portPrefix)) continue;
                ret.add(s);
            }
        }
        return ret;
    }

    public String findPortbyUniqueID(Long requid) {
        Long uid;
        String port = this.getKownPortName(requid);
        if (port == null && !this.getCurrentPortName().isEmpty() && !connectionRootNodeList.containsKey(this.getRealPortName()) && (uid = this.checkPort(this.getCurrentPortName())) != null && uid.equals(requid)) {
            port = this.getCurrentPortName();
        }
        if (port == null) {
            port = this.scanPorts(requid, this.portNameFilter);
        }
        if (port == null) {
            if (this.bidib != null) {
                this.bidib.close();
                this.bidib = null;
            }
            if (requid != null) {
                return "No Device found for BiDiB Unique ID " + ByteUtils.formatHexUniqueId((Long)requid);
            }
            if (!this.getCurrentPortName().isEmpty()) {
                return "No Device found on port " + this.getCurrentPortName();
            }
            return "port name or Unique ID not specified!";
        }
        this.setPort(port);
        return null;
    }

    private String scanPorts(Long requid, String portNameFilter) {
        log.trace("scanPorts for UID {}, filter: {}", (Object)ByteUtils.formatHexUniqueId((Long)requid), (Object)portNameFilter);
        List<String> portNameList = this.getPortIdentifiers();
        for (String portName : portNameList) {
            log.trace("check port {}", (Object)portName);
            if (connectionRootNodeList.containsKey(SerialDriverAdapter.getRealPortName(portName))) continue;
            log.debug("BIDIB: try port {}", (Object)portName);
            Long uid = this.checkPort(portName);
            if (!uid.equals(requid)) continue;
            return portName;
        }
        return null;
    }

    public Long checkPort(String portName) {
        Long uid = null;
        try {
            this.context = new DefaultContext();
            log.trace("checkPort: port name: {}, real port name: {}", (Object)portName, (Object)SerialDriverAdapter.getRealPortName(portName));
            if (this.bidib != null) {
                this.bidib.close();
                this.bidib = null;
            }
            this.bidib = SerialDriverAdapter.createSerialBidib(this.context);
            String realPortName = SerialDriverAdapter.getRealPortName(portName);
            this.bidib.open(realPortName, null, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), this.context);
            RootNode rootNode = this.bidib.getRootNode();
            uid = rootNode.getUniqueId() & 0xFFFFFFFFFFL;
            log.info("root node UID: {}", (Object)ByteUtils.formatHexUniqueId((Long)uid));
            connectionRootNodeList.put(realPortName, uid);
        }
        catch (PortNotOpenedException ex) {
            log.warn("port not opened: {}", (Object)portName);
        }
        catch (PortNotFoundException ex) {
            log.warn("port not found 1: {}", (Object)portName);
        }
        catch (Exception ex) {
            log.warn("port not found 2: {}", (Object)portName);
        }
        if (uid != null) {
            this.bidib.close();
            this.bidib = null;
        }
        return uid;
    }

    public String getKownPortName(Long reqUid) {
        for (Map.Entry<String, Long> entry : connectionRootNodeList.entrySet()) {
            Long uid = entry.getValue();
            if (!uid.equals(reqUid)) continue;
            File f = new File(entry.getKey());
            String portName = f.getName();
            return portName;
        }
        return null;
    }

    @Override
    public DataInputStream getInputStream() {
        return null;
    }

    @Override
    public DataOutputStream getOutputStream() {
        return null;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }
}

