/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Set;
import jmri.jmrix.bidib.BiDiBSerialPortController;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.util.FileUtil;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.simulation.SimulationInterface;
import org.bidib.jbidibc.simulation.comm.SimulationBidib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBSimulatorAdapter
extends BiDiBSerialPortController {
    protected String simulationFile = "simulation.xml";
    protected String loadedSimulationFilename = null;
    protected String absoluteSimulationFile = null;
    private static final Logger log = LoggerFactory.getLogger(BiDiBSimulatorAdapter.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");

    public String getSimulationFile() {
        return this.simulationFile;
    }

    public void setSimulationFile(String f) {
        if (this.loadedSimulationFilename == null) {
            this.loadedSimulationFilename = f;
        }
        this.simulationFile = f;
    }

    @Override
    public boolean isDirty() {
        log.debug("isDirty");
        if (super.isDirty()) {
            return true;
        }
        return !this.simulationFile.equals(this.loadedSimulationFilename);
    }

    @Override
    public boolean isRestartRequired() {
        log.debug("isRestartRequired");
        return super.isRestartRequired();
    }

    @Override
    public String getCurrentPortName() {
        if (this.absoluteSimulationFile == null) {
            return this.getSimulationFile();
        }
        return this.absoluteSimulationFile;
    }

    @Override
    public String getRealPortName() {
        File f = new File(FileUtil.getExternalFilename("profile:" + this.getSimulationFile()));
        return f.getAbsolutePath();
    }

    @Override
    public String openPort(String fileName, String appName) {
        log.debug("simulation openPort: {}", (Object)fileName);
        return null;
    }

    @Override
    public void configure() {
        log.debug("configure");
        MSG_RAW_LOGGER.debug("RAW> create BiDiB Instance");
        this.bidib = SimulationBidib.createInstance((Context)this.getContext());
        BiDiBTrafficController tc = new BiDiBTrafficController(this.bidib);
        log.debug("memo: {}, bidib simulator: {}", (Object)this.getSystemConnectionMemo(), (Object)this.bidib);
        this.getSystemConnectionMemo().setBiDiBTrafficController(tc);
        this.context = tc.connnectPort(this);
        this.opened = false;
        if (this.context != null) {
            this.opened = true;
        } else {
            log.warn("Simulation cannot be opened: {} ({}})", (Object)this.getCurrentPortName(), (Object)this.getCurrentPortName());
        }
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public void registerAllListeners(ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners) {
        SimulationInterface b = (SimulationInterface)this.bidib;
        b.setConnectionListener(connectionListener);
        b.registerListeners(nodeListeners, messageListeners, transferListeners);
    }

    @Override
    public DataInputStream getInputStream() {
        return null;
    }

    @Override
    public DataOutputStream getOutputStream() {
        return null;
    }

    @Override
    public boolean status() {
        return this.opened;
    }
}

