/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.simulator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.AbstractSimulatorConnectionConfig;
import jmri.jmrix.SerialPortAdapter;
import jmri.jmrix.bidib.simulator.BiDiBSimulatorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfig
extends AbstractSimulatorConnectionConfig {
    protected JLabel simulationFileLabel = new JLabel("Simulation File:");
    protected JTextField simulationFileField = new JTextField(10);
    String manufacturerName = "BiDiB";
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfig.class);

    public ConnectionConfig(SerialPortAdapter p) {
        super(p);
        log.debug("ConnectionConfig, p: {}", (Object)p);
    }

    public ConnectionConfig() {
        log.debug("ConnectionConfig");
    }

    @Override
    public String name() {
        log.debug("get name");
        return "BiDiB Simulator";
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerName;
    }

    @Override
    public void setManufacturer(String manu) {
        log.debug("set manufacturer: {}", (Object)manu);
        this.manufacturerName = manu;
    }

    @Override
    protected void setInstance() {
        log.debug("BiDiB Simulator ConnectionConfig.setInstance: {}", (Object)this.adapter);
        if (this.adapter == null) {
            this.adapter = new BiDiBSimulatorAdapter();
            log.debug("-- adapter created: {}", (Object)this.adapter);
        }
    }

    @Override
    public void loadDetails(JPanel details) {
        log.debug("loadDetails");
        super.loadDetails(details);
    }

    @Override
    protected void checkInitDone() {
        super.checkInitDone();
        log.debug("checkInitDone");
        if (this.adapter.getSystemConnectionMemo() != null) {
            this.simulationFileField.setText(((BiDiBSimulatorAdapter)this.adapter).getSimulationFile());
            this.simulationFileField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((BiDiBSimulatorAdapter)ConnectionConfig.this.adapter).setSimulationFile(ConnectionConfig.this.simulationFileField.getText());
                    ConnectionConfig.this.simulationFileField.setText(((BiDiBSimulatorAdapter)ConnectionConfig.this.adapter).getSimulationFile());
                }
            });
            this.simulationFileField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    ((BiDiBSimulatorAdapter)ConnectionConfig.this.adapter).setSimulationFile(ConnectionConfig.this.simulationFileField.getText());
                    ConnectionConfig.this.simulationFileField.setText(((BiDiBSimulatorAdapter)ConnectionConfig.this.adapter).getSimulationFile());
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
    }

    @Override
    protected void showAdvancedItems() {
        super.showAdvancedItems();
        log.debug("showAdvancedItems");
        if (this.adapter.getSystemConnectionMemo() != null) {
            this.cR.gridy += 2;
            this.cL.gridy += 2;
            this.gbLayout.setConstraints(this.simulationFileLabel, this.cL);
            this.gbLayout.setConstraints(this.simulationFileField, this.cR);
            this._details.add(this.simulationFileLabel);
            this._details.add(this.simulationFileField);
        }
        if (this._details.getParent() != null) {
            this._details.getParent().revalidate();
            this._details.getParent().repaint();
        }
    }

    @Override
    public void updateAdapter() {
        super.updateAdapter();
        log.debug("updateAdapter");
        if (this.adapter.getSystemConnectionMemo() != null) {
            ((BiDiBSimulatorAdapter)this.adapter).setSimulationFile(this.simulationFileField.getText());
        }
    }
}

