/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.simulator.configurexml;

import java.util.List;
import jmri.jmrix.SerialPortAdapter;
import jmri.jmrix.bidib.simulator.BiDiBSimulatorAdapter;
import jmri.jmrix.bidib.simulator.ConnectionConfig;
import jmri.jmrix.configurexml.AbstractConnectionConfigXml;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigXml
extends AbstractConnectionConfigXml {
    protected SerialPortAdapter adapter;
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigXml.class);

    @Override
    public Element store(Object o) {
        log.debug("store");
        this.getInstance(o);
        Element e = new Element("connection");
        this.storeCommon(e, this.adapter);
        if (this.adapter.getCurrentPortName() != null) {
            e.setAttribute("simulationFile", ((BiDiBSimulatorAdapter)this.adapter).getSimulationFile());
        } else {
            e.setAttribute("simulationFile", "noneSelected");
        }
        e.setAttribute("class", this.getClass().getName());
        this.extendElement(e);
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        boolean result = true;
        this.getInstance();
        log.debug("load, adapter: {}", (Object)this.adapter);
        List al = perNode.getAttributes();
        log.debug("load: attr list: {}", (Object)al);
        String simulationFile = perNode.getAttribute("simulationFile").getValue();
        ((BiDiBSimulatorAdapter)this.adapter).setSimulationFile(simulationFile);
        this.loadCommon(shared, perNode, this.adapter);
        this.register();
        if (this.adapter.getDisabled()) {
            this.unpackElement(shared, perNode);
            return result;
        }
        this.adapter.configure();
        this.unpackElement(shared, perNode);
        return result;
    }

    @Override
    protected void getInstance() {
        log.debug("BiDiB ConnectionConfigXml.getInstance: {}", (Object)this.adapter);
        if (this.adapter == null) {
            this.adapter = new BiDiBSimulatorAdapter();
            log.debug("-- adapter created: {}", (Object)this.adapter);
        }
    }

    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }

    @Override
    protected void dispose() {
        this.adapter.dispose();
    }
}

