/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.swing;

import javax.swing.JMenu;
import javax.swing.JSeparator;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.netbidib.NetBiDiBLogonAction;
import jmri.jmrix.bidib.swing.BiDiBNamedPaneAction;
import jmri.jmrix.bidib.swing.Bundle;
import jmri.jmrix.bidib.tcpserver.TcpServerAction;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class BiDiBMenu
extends JMenu {
    Item[] panelItems = new Item[]{new Item(Bundle.getMessage("BiDiBMonPaneTitle"), "jmri.jmrix.bidib.swing.mon.BiDiBMonPane")};

    public BiDiBMenu(BiDiBSystemConnectionMemo memo) {
        if (memo != null) {
            this.setText(memo.getUserName());
        } else {
            this.setText(Bundle.getMessage("MenuBiDiB"));
        }
        JmriJFrameInterface wi = new JmriJFrameInterface();
        for (Item item : this.panelItems) {
            if (item == null || memo == null) {
                this.add(new JSeparator());
                continue;
            }
            this.add(new BiDiBNamedPaneAction(item.name, wi, item.load, memo));
        }
        if (memo != null) {
            this.add(new JSeparator());
            this.add(new TcpServerAction(memo, Bundle.getMessage("MenuItemStartBiDiBOverTCPServer"), Bundle.getMessage("MenuItemStopBiDiBOverTCPServer")));
            if (memo.getBiDiBTrafficController() != null && memo.getBiDiBTrafficController().isNetBiDiB()) {
                this.add(new NetBiDiBLogonAction(memo, Bundle.getMessage("MenuItemLocalLogon"), Bundle.getMessage("MenuItemLocalLogoff")));
            }
        }
    }

    static class Item {
        String name;
        String load;

        Item(String name, String load) {
            this.name = name;
            this.load = load;
        }
    }
}

