/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.SignalAppearanceMap;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SignalSystem;
import jmri.SystemConnectionMemo;
import jmri.jmrit.beantable.signalmast.SignalMastAddPane;
import jmri.jmrix.bidib.BiDiBAddress;
import jmri.jmrix.bidib.BiDiBSignalMast;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.swing.Bundle;
import jmri.util.ConnectionNameFromSystemName;
import jmri.util.javaworld.GridLayout2;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBSignalMastAddPane
extends SignalMastAddPane {
    JScrollPane bidibMastScroll;
    JPanel bidibMastPanel = new JPanel();
    JLabel systemPrefixBoxLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BiDiBConnectionLabel")));
    JComboBox<String> systemPrefixBox = new JComboBox();
    JLabel bidibAccesoryAddressLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BiDiBMastAddress")));
    JTextField bidibAccesoryAddressField = new JTextField(20);
    JCheckBox allowUnLit = new JCheckBox();
    JTextField unLitAspectField = new JTextField(5);
    LinkedHashMap<String, BiDiBAspectPanel> bidibAspect = new LinkedHashMap(12);
    BiDiBSignalMast currentMast = null;
    SignalSystem sigsys;
    private static final Logger log = LoggerFactory.getLogger(BiDiBSignalMastAddPane.class);

    public BiDiBSignalMastAddPane() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setAlignmentX(0.0f);
        this.add(p);
        this.bidibMastScroll = new JScrollPane(this.bidibMastPanel);
        this.bidibMastScroll.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.bidibMastScroll);
    }

    @Override
    @Nonnull
    public String getPaneName() {
        return Bundle.getMessage("BiDiBSignalMastPane");
    }

    protected void addUsableConnections() {
        this.systemPrefixBox.removeAllItems();
        List<SystemConnectionMemo> connList = InstanceManager.getList(SystemConnectionMemo.class);
        if (!connList.isEmpty()) {
            for (int x = 0; x < connList.size(); ++x) {
                SystemConnectionMemo memo = connList.get(x);
                if (!(memo instanceof BiDiBSystemConnectionMemo) || memo.getDisabled()) continue;
                this.systemPrefixBox.addItem(memo.getUserName());
            }
        } else {
            this.systemPrefixBox.addItem("None");
        }
    }

    @Override
    public void setAspectNames(@Nonnull SignalAppearanceMap map, @Nonnull SignalSystem sigSystem) {
        log.trace("setAspectNames(...) start");
        this.bidibAspect.clear();
        Enumeration<String> aspects = map.getAspects();
        this.sigsys = map.getSignalSystem();
        while (aspects.hasMoreElements()) {
            String aspect = aspects.nextElement();
            BiDiBAspectPanel aPanel = new BiDiBAspectPanel(aspect);
            this.bidibAspect.put(aspect, aPanel);
            log.trace(" in loop, bidibAspect: {} ", (Object)map.getProperty(aspect, "dccAspect"));
            aPanel.setAspectId((String)sigSystem.getProperty(aspect, "dccAspect"));
        }
        this.addUsableConnections();
        this.bidibMastPanel.removeAll();
        this.bidibMastPanel.add(this.systemPrefixBoxLabel);
        this.bidibMastPanel.add(this.systemPrefixBox);
        this.bidibMastPanel.add(this.bidibAccesoryAddressLabel);
        this.bidibAccesoryAddressField.setText("");
        this.bidibMastPanel.add(this.bidibAccesoryAddressField);
        for (Map.Entry<String, BiDiBAspectPanel> entry : this.bidibAspect.entrySet()) {
            log.trace("   aspect: {}", (Object)entry.getKey());
            this.bidibMastPanel.add(entry.getValue().getPanel());
        }
        this.bidibMastPanel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BiDiBMastCopyAspectId"))));
        this.bidibMastPanel.add(this.copyFromMastSelection());
        this.bidibMastPanel.setLayout(new GridLayout2(0, 2));
        this.bidibMastPanel.revalidate();
        this.bidibMastScroll.revalidate();
        log.trace("setAspectNames(...) end");
    }

    @Override
    public boolean canHandleMast(@Nonnull SignalMast mast) {
        return mast.getClass().getCanonicalName().equals(BiDiBSignalMast.class.getCanonicalName());
    }

    @Override
    public void setMast(SignalMast mast) {
        log.debug("setMast({}) start", (Object)mast);
        if (mast == null) {
            this.currentMast = null;
            log.debug("setMast() end early with null");
            return;
        }
        if (!(mast instanceof BiDiBSignalMast)) {
            log.error("mast was wrong type: {} {}", (Object)mast.getSystemName(), (Object)mast.getClass().getName());
            log.debug("setMast({}) end early: wrong type", (Object)mast);
            return;
        }
        this.currentMast = (BiDiBSignalMast)mast;
        SignalAppearanceMap appMap = mast.getAppearanceMap();
        if (appMap != null) {
            Enumeration<String> aspects = appMap.getAspects();
            while (aspects.hasMoreElements()) {
                String key = aspects.nextElement();
                BiDiBAspectPanel aspectPanel = this.bidibAspect.get(key);
                aspectPanel.setAspectDisabled(this.currentMast.isAspectDisabled(key));
                if (this.currentMast.isAspectDisabled(key)) continue;
                aspectPanel.setAspectId(this.currentMast.getOutputForAppearance(key));
            }
        }
        this.addUsableConnections();
        this.bidibAccesoryAddressField.setText(this.currentMast.getAccessoryAddress());
        this.systemPrefixBox.setSelectedItem(this.currentMast.getTrafficController().getUserName());
        this.systemPrefixBoxLabel.setEnabled(false);
        this.systemPrefixBox.setEnabled(false);
        this.bidibAccesoryAddressLabel.setEnabled(false);
        this.bidibAccesoryAddressField.setEnabled(false);
        log.debug("setMast({}) end", (Object)mast);
    }

    static boolean validateAspectId(@Nonnull String strAspect) {
        int aspect;
        try {
            aspect = Integer.parseInt(strAspect.trim());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("BiDiBMastAspectNumber"));
            return false;
        }
        if (aspect < 0 || aspect > 31) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("BiDiBMastAspectOutOfRange"));
            log.error("invalid aspect {}", (Object)aspect);
            return false;
        }
        return true;
    }

    @Nonnull
    protected String getNamePrefix() {
        return BiDiBSignalMast.getNamePrefix() + ":";
    }

    protected BiDiBSignalMast constructMast(@Nonnull String name) {
        return new BiDiBSignalMast(name);
    }

    @Override
    public boolean createMast(@Nonnull String sigsysname, @Nonnull String mastname, @Nonnull String username) {
        log.debug("createMast({},{},{} start)", new Object[]{sigsysname, mastname, username});
        if (this.currentMast == null) {
            log.trace("Creating new mast");
            if (!this.validateBiDiBAddress()) {
                log.trace("validateBiDiBAddress failed, return from createMast");
                return false;
            }
            Object systemNameText = ConnectionNameFromSystemName.getPrefixFromName((String)this.systemPrefixBox.getSelectedItem());
            if (systemNameText == null || ((String)systemNameText).isEmpty()) {
                systemNameText = "B";
            }
            systemNameText = (String)systemNameText + this.getNamePrefix();
            String name = (String)systemNameText + sigsysname + ":" + mastname.substring(11, mastname.length() - 4);
            name = name + "(" + this.bidibAccesoryAddressField.getText() + ")";
            this.currentMast = this.constructMast(name);
            InstanceManager.getDefault(SignalMastManager.class).register(this.currentMast);
        }
        for (Map.Entry<String, BiDiBAspectPanel> entry : this.bidibAspect.entrySet()) {
            this.bidibMastPanel.add(entry.getValue().getPanel());
            this.currentMast.setOutputForAppearance(entry.getKey(), entry.getValue().getAspectId());
            if (entry.getValue().isAspectDisabled()) {
                this.currentMast.setAspectDisabled(entry.getKey());
                continue;
            }
            this.currentMast.setAspectEnabled(entry.getKey());
        }
        if (!username.equals("")) {
            this.currentMast.setUserName(username);
        }
        log.debug("createMast({},{} end)", (Object)sigsysname, (Object)mastname);
        return true;
    }

    private boolean validateBiDiBAddress() {
        if (this.bidibAccesoryAddressField.getText().equals("")) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("BiDiBMastAddressBlank"));
            return false;
        }
        char accessoryTypeLetter = 'T';
        BiDiBSystemConnectionMemo memo = (BiDiBSystemConnectionMemo)ConnectionNameFromSystemName.getSystemConnectionMemoFromUserName((String)this.systemPrefixBox.getSelectedItem());
        if (memo == null) {
            return false;
        }
        String accessorySystemName = memo.getSystemPrefix() + accessoryTypeLetter + this.bidibAccesoryAddressField.getText().trim();
        log.trace("validate Accessory Systemname: {}", (Object)accessorySystemName);
        if (!BiDiBAddress.isValidSystemNameFormat(accessorySystemName, accessoryTypeLetter, memo)) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("BiDiBMastAddressInvalid"));
            return false;
        }
        BiDiBAddress addr = new BiDiBAddress(accessorySystemName, accessoryTypeLetter, memo);
        if (BiDiBSignalMast.isAccessoryAddressUsed(addr) != null) {
            String msg = Bundle.getMessage("BiDiBMastAddressAssigned", this.bidibAccesoryAddressField.getText(), BiDiBSignalMast.isAccessoryAddressUsed(addr));
            JmriJOptionPane.showMessageDialog(null, msg);
            return false;
        }
        return true;
    }

    @Nonnull
    JComboBox<String> copyFromMastSelection() {
        JComboBox<String> mastSelect = new JComboBox<String>();
        for (SignalMast mast : InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet()) {
            if (!(mast instanceof BiDiBSignalMast)) continue;
            mastSelect.addItem(mast.getDisplayName());
        }
        if (mastSelect.getItemCount() == 0) {
            mastSelect.setEnabled(false);
        } else {
            mastSelect.insertItemAt("", 0);
            mastSelect.setSelectedIndex(0);
            mastSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox eb = (JComboBox)e.getSource();
                    String sourceMast = (String)eb.getSelectedItem();
                    if (sourceMast != null && !sourceMast.equals("")) {
                        BiDiBSignalMastAddPane.this.copyFromAnotherBiDiBMastAspect(sourceMast);
                    }
                }
            });
        }
        return mastSelect;
    }

    void copyFromAnotherBiDiBMastAspect(@Nonnull String strMast) {
        BiDiBSignalMast mast = (BiDiBSignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(strMast);
        if (mast == null) {
            log.error("can't copy from another mast because {} doesn't exist", (Object)strMast);
            return;
        }
        Vector<String> validAspects = mast.getValidAspects();
        for (Map.Entry<String, BiDiBAspectPanel> entry : this.bidibAspect.entrySet()) {
            if (validAspects.contains(entry.getKey()) || mast.isAspectDisabled(entry.getKey())) {
                entry.getValue().setAspectId(mast.getOutputForAppearance(entry.getKey()));
                entry.getValue().setAspectDisabled(mast.isAspectDisabled(entry.getKey()));
                continue;
            }
            log.info("Can't get aspect \"{}\" from head \"{}\", leaving unchanged", (Object)entry.getKey(), (Object)mast);
        }
    }

    static class BiDiBAspectPanel {
        String aspect = "";
        JCheckBox disabledCheck = new JCheckBox(Bundle.getMessage("DisableAspect"));
        JLabel aspectLabel = new JLabel(Bundle.getMessage("BiDiBMastSetAspectId") + ":");
        JTextField aspectId = new JTextField(5);
        JPanel panel;

        BiDiBAspectPanel(String aspect) {
            this.aspect = aspect;
        }

        void setAspectDisabled(boolean boo) {
            this.disabledCheck.setSelected(boo);
            if (boo) {
                this.aspectLabel.setEnabled(false);
                this.aspectId.setEnabled(false);
            } else {
                this.aspectLabel.setEnabled(true);
                this.aspectId.setEnabled(true);
            }
        }

        boolean isAspectDisabled() {
            return this.disabledCheck.isSelected();
        }

        int getAspectId() {
            try {
                String value = this.aspectId.getText();
                return Integer.parseInt(value);
            }
            catch (Exception ex) {
                log.error("failed to convert aspect number");
                return -1;
            }
        }

        void setAspectId(int i) {
            this.aspectId.setText("" + i);
        }

        void setAspectId(String s) {
            this.aspectId.setText(s);
        }

        JPanel getPanel() {
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new BoxLayout(this.panel, 1));
                JPanel dccDetails = new JPanel();
                dccDetails.add(this.aspectLabel);
                dccDetails.add(this.aspectId);
                this.panel.add(dccDetails);
                this.panel.add(this.disabledCheck);
                TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
                border.setTitle(this.aspect);
                this.panel.setBorder(border);
                this.aspectId.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (aspectId.getText().equals("")) {
                            return;
                        }
                        if (!BiDiBSignalMastAddPane.validateAspectId(aspectId.getText())) {
                            aspectId.requestFocusInWindow();
                        }
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                    }
                });
                this.disabledCheck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.setAspectDisabled(disabledCheck.isSelected());
                    }
                });
            }
            return this.panel;
        }
    }

    public static class SignalMastAddPaneProvider
    extends SignalMastAddPane.SignalMastAddPaneProvider {
        @Override
        @Nonnull
        public String getPaneName() {
            return Bundle.getMessage("BiDiBSignalMastPane");
        }

        @Override
        @Nonnull
        public SignalMastAddPane getNewPane() {
            return new BiDiBSignalMastAddPane();
        }
    }
}

