/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.swing.mon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.swing.BiDiBPanelInterface;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.CRC8;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.BidibResponseFactory;
import org.bidib.jbidibc.messages.message.BoostDiagnosticResponse;
import org.bidib.jbidibc.messages.message.BoostStatResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveManualResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.message.CommandStationStateResponse;
import org.bidib.jbidibc.messages.message.FeatureCountResponse;
import org.bidib.jbidibc.messages.message.FeatureResponse;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackCurrentResponse;
import org.bidib.jbidibc.messages.message.FeedbackCvResponse;
import org.bidib.jbidibc.messages.message.FeedbackDynStateResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackGetAddressRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.FeedbackSpeedResponse;
import org.bidib.jbidibc.messages.message.LcConfigGetMessage;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.message.NodeTabCountResponse;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBMonPane
extends AbstractMonPane
implements BiDiBPanelInterface {
    final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.bidib.swing.BiDiBSwingBundle");
    protected BiDiBTrafficController tc = null;
    protected BiDiBSystemConnectionMemo memo = null;
    protected RawMessageListener rawMessageListener = null;
    private final BidibResponseFactory responseFactory = new BidibResponseFactory();
    private String output;
    private final Map<Long, String> debugStringBuffer = new HashMap<Long, String>();
    private final UserPreferencesManager pm;
    final JCheckBox suppressDiagMessagesCheckBox = new JCheckBox();
    final String suppressDiagMessagesCheck = this.getClass().getName() + ".SuppressDiagMessages";
    private static final Logger log = LoggerFactory.getLogger(BiDiBMonPane.class);

    public BiDiBMonPane() {
        this.pm = InstanceManager.getDefault(UserPreferencesManager.class);
    }

    @Override
    public String getTitle() {
        return this.rb.getString("BiDiBMonPaneTitle");
    }

    @Override
    public void dispose() {
        log.debug("Stopping BiDiB Monitor Panel");
        if (this.rawMessageListener != null) {
            this.tc.removeRawMessageListener(this.rawMessageListener);
            this.rawMessageListener = null;
        }
        this.pm.setSimplePreferenceState(this.suppressDiagMessagesCheck, this.suppressDiagMessagesCheckBox.isSelected());
        super.dispose();
    }

    @Override
    public void init() {
    }

    @Override
    protected void addCustomControlPanes(JPanel parent) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.suppressDiagMessagesCheckBox.setText(this.rb.getString("CheckBoxSuppressDiagMessages"));
        this.suppressDiagMessagesCheckBox.setVisible(true);
        this.suppressDiagMessagesCheckBox.setSelected(this.pm.getSimplePreferenceState(this.suppressDiagMessagesCheck));
        p.add(this.suppressDiagMessagesCheckBox);
        parent.add(p);
        super.addCustomControlPanes(parent);
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof BiDiBSystemConnectionMemo) {
            this.initComponents((BiDiBSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(BiDiBSystemConnectionMemo memo) {
        log.debug("Starting BiDiB Monitor Panel");
        this.memo = memo;
        this.tc = memo.getBiDiBTrafficController();
        this.createMonListener();
    }

    private boolean suppressMessage(BidibMessageInterface message) {
        if (this.suppressDiagMessagesCheckBox.isSelected()) {
            int type = ByteUtils.getInt((byte)message.getType());
            switch (type) {
                case 98: 
                case 113: 
                case 166: 
                case 167: 
                case 170: 
                case 178: 
                case 225: 
                case 241: {
                    return true;
                }
            }
        }
        return false;
    }

    private void log1Message(BidibMessageInterface message, String line) {
        Node node = this.tc.getNodeByAddr(message.getAddr());
        this.output = node != null ? this.output + String.format(" %010X (%s)", node.getUniqueId() & 0xFFFFFFFFFFL, node.getStoredString(1)) + ": " : this.output + NodeUtils.formatAddress((byte[])message.getAddr()) + ": ";
        if (this.rawCheckBox.isSelected()) {
            this.output = this.output + "[" + ByteUtils.bytesToHex((byte[])message.getContent()) + "] " + message.toString() + "  ";
        }
        this.output = this.output + line + "\n";
    }

    protected void logMessage(String prefix, byte[] data, List<BidibMessageInterface> messages, List<String> lines) {
        this.output = prefix + " ";
        if (messages.size() != 1) {
            if (this.rawCheckBox.isSelected()) {
                this.output = this.output + "[" + ByteUtils.bytesToHex((byte[])data) + "] ";
            }
            this.output = this.output + messages.size() + " Messages:\n";
        }
        if (messages.size() == 1) {
            log.debug("Monitor: show message: {}", (Object)((BidibMessage)messages.get(0)).getName());
            if (this.suppressMessage(messages.get(0))) {
                return;
            }
            this.log1Message(messages.get(0), lines.get(0));
        } else {
            for (int i = 0; i < messages.size(); ++i) {
                this.output = this.output + "        ";
                this.log1Message(messages.get(i), lines.get(i));
            }
        }
        this.nextLine(this.output, null);
    }

    private String evaluateMessage(BidibMessageInterface message) {
        AccessoryStateResponse m;
        Object line = "";
        Node node = this.tc.getNodeByAddr(message.getAddr());
        PortModelEnum portModel = PortModelEnum.type;
        if (node != null) {
            portModel = this.tc.getPortModel(node);
        }
        int type = ByteUtils.getInt((byte)message.getType());
        block0 : switch (type) {
            case 184: {
                m = (AccessoryStateResponse)message;
                if (m.getAccessoryState().getExecute() == 0) {
                    line = "accessory number: " + m.getAccessoryState().getAccessoryNumber() + ", aspect: " + m.getAccessoryState().getActiveAspect();
                    break;
                }
                line = (String)line + m.getAccessoryState().toString();
                break;
            }
            case 178: {
                m = (BoostDiagnosticResponse)message;
                line = "Voltage: " + m.getVoltage() + " mV, Current: " + m.getCurrent() + " mA, Temperature: " + m.getTemperature() + " \u00b0C";
                break;
            }
            case 176: {
                m = (BoostStatResponse)message;
                line = "Booster State " + m.getState() + ", control: " + m.getControl();
                break;
            }
            case 163: {
                m = (FeedbackAddressResponse)message;
                line = "mnum: " + m.getDetectorNumber();
                line = (String)line + ", locos: ";
                List addrList = m.getAddresses();
                if (addrList.size() <= 0) break;
                for (AddressData addressData : addrList) {
                    line = (String)line + addressData + " ";
                }
                break;
            }
            case 167: {
                m = (FeedbackCurrentResponse)message;
                line = "mnum: " + m.getLocalDetectorAddress() + "current: " + m.getCurrent() + " mA";
                break;
            }
            case 170: {
                m = (FeedbackDynStateResponse)message;
                line = "mnum: " + m.getDetectorNumber() + ", decoder: " + m.getAddress() + " ";
                int dynNumber = m.getDynNumber();
                switch (dynNumber) {
                    case 1: {
                        String dynText = this.rb.getString("BmDynState1");
                        line = (String)line + dynText + ": " + m.getDynValue() + "%";
                        break;
                    }
                    case 2: {
                        String dynText = this.rb.getString("BmDynState2");
                        line = (String)line + dynText + ": " + m.getDynValue() + " \u00b0C";
                        break;
                    }
                    case 3: {
                        String dynText = this.rb.getString("BmDynState3");
                        line = (String)line + dynText + ": " + m.getDynValue() + "%";
                        break;
                    }
                    case 4: {
                        String dynText = this.rb.getString("BmDynState4");
                        line = (String)line + dynText + ": " + m.getDynValue() + "%";
                        break;
                    }
                    case 5: {
                        String dynText = this.rb.getString("BmDynState5");
                        line = (String)line + dynText + ": " + m.getDynValue() + "%";
                        break;
                    }
                    case 6: {
                        String dynText = this.rb.getString("BmDynState6");
                        line = (String)line + dynText + ": " + m.getDynValue() + " mm";
                        if (m.getTimestamp() == null) break block0;
                        dynText = this.rb.getString("BmDynStateTimeStamp");
                        line = (String)line + ", " + dynText + ": " + m.getTimestamp();
                        break;
                    }
                    default: {
                        log.error("Unexpected case: {}", (Object)dynNumber);
                        break;
                    }
                }
                break;
            }
            case 161: {
                m = (FeedbackFreeResponse)message;
                line = "mnum: " + m.getDetectorNumber();
                break;
            }
            case 160: {
                m = (FeedbackOccupiedResponse)message;
                line = "mnum: " + m.getDetectorNumber();
                break;
            }
            case 162: {
                m = (FeedbackMultipleResponse)message;
                line = "mnum: " + m.getBaseAddress() + ", size: " + m.getSize();
                line = (String)line + ", state bits: ";
                byte[] stateBits = m.getDetectorData();
                if (stateBits.length <= 0) break;
                for (byte f : stateBits) {
                    line = (String)line + String.format("0x%02X ", f & 0xFF);
                }
                break;
            }
            case 166: {
                m = (FeedbackSpeedResponse)message;
                AddressData addressData = m.getAddress();
                line = "Decoder: " + addressData + ", speed: " + m.getSpeed();
                break;
            }
            case 165: {
                m = (FeedbackCvResponse)message;
                line = m.getAddress().toString() + ", CV" + m.getCvNumber() + " = " + m.getDat();
                break;
            }
            case 234: {
                m = (CommandStationDriveStateResponse)message;
                AddressTypeEnum addressTypeEnum = AddressTypeEnum.LOCOMOTIVE_BACKWARD;
                if ((m.getSpeed() & 0x80) == 128) {
                    addressTypeEnum = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                }
                AddressData addressData = new AddressData(m.getDecoderAddress(), addressTypeEnum);
                line = "Decoder: " + addressData + ", speed: " + (m.getSpeed() & 0x7F);
                line = (String)line + ", function bits: ";
                byte[] functionBits = m.getDriveState().getFunctions();
                if (functionBits.length <= 0) break;
                for (byte f : functionBits) {
                    line = (String)line + String.format("0x%02X ", f & 0xFF);
                }
                break;
            }
            case 229: {
                m = (CommandStationDriveManualResponse)message;
                AddressTypeEnum addressTypeEnum = AddressTypeEnum.LOCOMOTIVE_BACKWARD;
                if ((m.getSpeed() & 0x80) == 128) {
                    addressTypeEnum = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                }
                AddressData addressData = new AddressData(m.getAddress(), addressTypeEnum);
                line = "Decoder: " + addressData + ", speed: " + (m.getSpeed() & 0x7F);
                line = (String)line + ", function bits: ";
                byte[] functionBits = m.getDriveState().getFunctions();
                if (functionBits.length <= 0) break;
                for (byte f : functionBits) {
                    line = (String)line + String.format("0x%02X ", f & 0xFF);
                }
                break;
            }
            case 225: {
                m = (CommandStationStateResponse)message;
                line = "CS state " + m.getState();
                break;
            }
            case 228: {
                m = (CommandStationPomAcknowledgeResponse)message;
                line = "Addr: " + m.getAddress().toString() + ", Ack: " + m.getAcknState().toString();
                break;
            }
            case 239: {
                m = (CommandStationProgStateResponse)message;
                line = m.getState() + " CV" + m.getCvNumber();
                if (m.getState() == CommandStationProgState.PROG_OKAY) {
                    line = (String)line + " = " + m.getCvData();
                }
                line = (String)line + ", remaining time: " + m.getRemainingTime() * 100 + "ms";
                break;
            }
            case 192: {
                m = (LcStatResponse)message;
                line = "port " + m.getPortNumber(portModel) + " (" + this.makePortTypeString(portModel, m.getPortType(portModel)) + "), state: " + (m.getPortStatus() & 0xFF);
                break;
            }
            case 193: {
                m = (LcNotAvailableResponse)message;
                line = "port " + m.getPortNumber(portModel) + " (" + this.makePortTypeString(portModel, m.getPortType(portModel)) + "), error code: " + m.getErrorCode();
                break;
            }
            case 136: {
                m = (NodeTabCountResponse)message;
                line = "count: " + m.getCount();
                break;
            }
            case 146: {
                m = (FeatureCountResponse)message;
                line = "count: " + m.getCount();
                break;
            }
            case 144: {
                m = (FeatureResponse)message;
                Feature f = m.getFeature();
                line = f.getFeatureName() + " (" + f.getType() + ") = " + f.getValue();
                break;
            }
            case 149: {
                m = (StringResponse)message;
                if (m.getStringData().getNamespace() == 1) {
                    String prefix = "===== device";
                    int stringId = m.getStringData().getIndex();
                    String value = m.getStringData().getValue();
                    if (node == null) {
                        log.error("Found node null in MSG_STRING");
                        break;
                    }
                    long key = node.getUniqueId() & 0xFFFFFFFFFFL | (long)stringId << 40;
                    if (value.charAt(value.length() - 1) == '\n') {
                        Object txt = "";
                        if (this.debugStringBuffer.containsKey(key)) {
                            txt = this.debugStringBuffer.get(key);
                            this.debugStringBuffer.remove(key);
                        }
                        txt = (String)txt + value.replace("\n", "");
                        Object line2 = "";
                        switch (stringId) {
                            case 0: {
                                line2 = (String)line2 + prefix + " stdout: " + (String)txt;
                                break;
                            }
                            case 1: {
                                line2 = (String)line2 + prefix + " stderr: " + (String)txt;
                                break;
                            }
                            case 2: {
                                if (!log.isWarnEnabled()) break;
                                line2 = (String)line2 + prefix + " WARN: " + (String)txt;
                                break;
                            }
                            case 3: {
                                if (!log.isInfoEnabled()) break;
                                line2 = (String)line2 + prefix + " INFO: " + (String)txt;
                                break;
                            }
                            case 4: {
                                if (!log.isDebugEnabled()) break;
                                line2 = (String)line2 + prefix + " DEBUG: " + (String)txt;
                                break;
                            }
                            case 5: {
                                if (!log.isTraceEnabled()) break;
                                line2 = (String)line2 + prefix + " TRACE: " + (String)txt;
                                break;
                            }
                        }
                        if (((String)line2).isEmpty()) break;
                        line = line2;
                        break;
                    }
                    String txt = "";
                    if (this.debugStringBuffer.containsKey(key)) {
                        txt = this.debugStringBuffer.get(key);
                    }
                    this.debugStringBuffer.put(key, txt + value);
                    break;
                }
                if (m.getStringData().getIndex() == 0) {
                    line = "Product Name: " + m.getStringData().getValue();
                    break;
                }
                if (m.getStringData().getIndex() == 1) {
                    line = "Username: " + m.getStringData().getValue();
                    break;
                }
                line = "index: " + m.getStringData().getIndex() + ", value: " + m.getStringData().getValue();
                break;
            }
            case 57: {
                m = (AccessoryGetMessage)message;
                line = "accessory number: " + m.getAccessoryNumber();
                break;
            }
            case 56: {
                m = (AccessorySetMessage)message;
                line = "accessory number: " + m.getAccessoryNumber() + ", set aspect to " + m.getAspect();
                break;
            }
            case 101: {
                m = (CommandStationAccessoryMessage)message;
                line = "CS accessory decoder address: " + m.getDecoderAddress() + ", set aspect to " + m.getAspect();
                break;
            }
            case 100: {
                m = (CommandStationDriveMessage)message;
                line = "CS decoder address: " + m.getDecoderAddress() + ", speed: " + m.getSpeed();
                line = (String)line + ", function bits: ";
                int[] functionBits = m.getFunctionBits();
                if (functionBits.length <= 0) break;
                for (int f : functionBits) {
                    line = (String)line + String.format("0x%02X ", f & 0xFF);
                }
                break;
            }
            case 98: {
                m = (CommandStationSetStateMessage)message;
                line = "CS set state to " + m.getState();
                break;
            }
            case 103: {
                m = (CommandStationPomMessage)message;
                line = "OpCode " + ByteUtils.byteToHex((int)m.getOpCode()) + ", Addr: " + m.getDecoderAddress().toString() + ", CV" + m.getCvNumber();
                int op = m.getOpCode();
                if (op == 0 || op == 1 || op == 129) break;
                line = (String)line + " = " + ByteUtils.getCvXValue((byte[])m.getData(), (int)9, (int)(m.getData().length - 9));
                break;
            }
            case 111: {
                m = (CommandStationProgMessage)message;
                line = m.getOpCode() + " CV" + m.getCvNumber();
                if (m.getOpCode() != CommandStationPt.BIDIB_CS_PROG_RDWR_BIT && m.getOpCode() != CommandStationPt.BIDIB_CS_PROG_WR_BYTE) break;
                line = (String)line + " = " + m.getCvData();
                break;
            }
            case 36: {
                m = (FeedbackGetAddressRangeMessage)message;
                line = "get feedback status from number " + m.getBegin() + " to " + m.getEnd();
                break;
            }
            case 66: {
                m = (LcConfigGetMessage)message;
                line = "get port config for port " + m.toString();
                break;
            }
            case 64: {
                m = (LcOutputMessage)message;
                line = "output to port " + m.getOutputNumber(portModel) + " (" + this.makePortTypeString(portModel, m.getOutputType(portModel)) + "), state: " + (m.getOutputStatus() & 0xFF);
                break;
            }
        }
        m = (BidibMessage)message;
        if (type != 149 || !((String)line).isEmpty()) {
            return ((String)line).isEmpty() ? m.getName() : m.getName() + ": " + (String)line;
        }
        return "";
    }

    private String makePortModelString(PortModelEnum portModel) {
        String portModelName = "unknown";
        switch (portModel) {
            case type: {
                portModelName = "type-based";
                break;
            }
            case flat: {
                portModelName = "flat";
                break;
            }
            case flat_extended: {
                portModelName = "flat-extended";
                break;
            }
        }
        return portModelName;
    }

    private String makePortTypeString(PortModelEnum portModel, LcOutputType portType) {
        Object ret = this.makePortModelString(portModel);
        if (portModel == PortModelEnum.type) {
            ret = (String)ret + ", " + portType;
        }
        return ret;
    }

    private List<BidibMessageInterface> splitBidibMessages(byte[] data, boolean checkCRC) throws ProtocolException {
        log.trace("splitMessages: {}", (Object)ByteUtils.bytesToHex((byte[])data));
        int index = 0;
        LinkedList<BidibMessageInterface> result = new LinkedList<BidibMessageInterface>();
        while (index < data.length) {
            int size = ByteUtils.getInt((byte)data[index]) + 1;
            log.trace("Current size: {}", (Object)size);
            if (size <= 0) {
                throw new ProtocolException("cannot split messages, array size is " + size);
            }
            byte[] message = new byte[size];
            try {
                System.arraycopy(data, index, message, 0, message.length);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                log.warn("Failed to copy, msg.len: {}, size: {}, output.len: {}, index: {}, output: {}", new Object[]{message.length, size, data.length, index, ByteUtils.bytesToHex((byte[])data)});
                throw new ProtocolException("Copy message data to buffer failed.");
            }
            result.add(this.responseFactory.create(message));
            if (!checkCRC || (index += size) != data.length - 1) continue;
            int crc = 0;
            int crcIndex = 0;
            for (crcIndex = 0; crcIndex < data.length - 1; ++crcIndex) {
                crc = CRC8.getCrcValue((int)((data[crcIndex] ^ crc) & 0xFF));
            }
            if (crc == (data[crcIndex] & 0xFF)) break;
            throw new ProtocolException("CRC failed: should be " + crc + " but was " + (data[crcIndex] & 0xFF));
        }
        return result;
    }

    private void createMonListener() {
        this.rawMessageListener = new RawMessageListener(){

            public void notifyReceived(byte[] data) {
                log.debug("MON received message");
                ArrayList<String> lines = new ArrayList<String>();
                ArrayList<BidibMessageInterface> messages = new ArrayList<BidibMessageInterface>();
                try {
                    List<BidibMessageInterface> commandMessages = BiDiBMonPane.this.splitBidibMessages(data, true);
                    for (BidibMessageInterface message : commandMessages) {
                        String line = BiDiBMonPane.this.evaluateMessage(message);
                        if (line.isEmpty()) continue;
                        messages.add(message);
                        lines.add(line);
                    }
                    if (messages.size() > 0) {
                        BiDiBMonPane.this.logMessage("<<", data, messages, lines);
                    }
                }
                catch (ProtocolException ex) {
                    log.warn("CRC failed.", (Throwable)ex);
                }
            }

            public void notifySend(byte[] data) {
                log.debug("MON sending message");
                ArrayList<String> lines = new ArrayList<String>();
                ArrayList<BidibMessageInterface> messages = new ArrayList<BidibMessageInterface>();
                BidibRequestFactory requestFactory = BiDiBMonPane.this.tc.getBidib().getRootNode().getRequestFactory();
                requestFactory.setEscapeMagic(!BiDiBMonPane.this.tc.isNetBiDiB());
                try {
                    List commandMessages = requestFactory.create(data);
                    for (BidibMessageInterface message : commandMessages) {
                        messages.add(message);
                        String line = BiDiBMonPane.this.evaluateMessage(message);
                        lines.add(line);
                    }
                    BiDiBMonPane.this.logMessage(">>", data, messages, lines);
                }
                catch (ProtocolException ex) {
                    log.error("Illegal BiDiB Message to send: {}", (Object)data, (Object)ex);
                }
            }
        };
        this.tc.addRawMessageListener(this.rawMessageListener);
    }
}

