/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.tcpserver;

import java.util.LinkedList;
import java.util.List;
import org.bidib.jbidibc.messages.CRC8;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibResponseFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPort;
import org.bidib.jbidibc.net.serialovertcp.NetMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiBMessageReceiver
implements RawMessageListener {
    private final NetMessageHandler serverMessageHandler;
    private final NetBidibPort port;
    private final BidibResponseFactory responseFactory = new BidibResponseFactory();
    private static final Logger log = LoggerFactory.getLogger(BiDiBMessageReceiver.class);

    public BiDiBMessageReceiver(NetMessageHandler netServerMessageHandler, NetBidibPort netPort) {
        this.serverMessageHandler = netServerMessageHandler;
        this.port = netPort;
    }

    private List<BidibMessageInterface> splitBidibMessages(byte[] data, boolean checkCRC) throws ProtocolException {
        log.trace("splitMessages: {}", (Object)ByteUtils.bytesToHex((byte[])data));
        int index = 0;
        LinkedList<BidibMessageInterface> result = new LinkedList<BidibMessageInterface>();
        while (index < data.length) {
            int size = ByteUtils.getInt((byte)data[index]) + 1;
            log.trace("Current size: {}", (Object)size);
            if (size <= 0) {
                throw new ProtocolException("cannot split messages, array size is " + size);
            }
            byte[] message = new byte[size];
            try {
                System.arraycopy(data, index, message, 0, message.length);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                log.warn("Failed to copy, msg.len: {}, size: {}, output.len: {}, index: {}, output: {}", new Object[]{message.length, size, data.length, index, ByteUtils.bytesToHex((byte[])data)});
                throw new ProtocolException("Copy message data to buffer failed.");
            }
            result.add(this.responseFactory.create(message));
            if (!checkCRC || (index += size) != data.length - 1) continue;
            int crc = 0;
            int crcIndex = 0;
            for (crcIndex = 0; crcIndex < data.length - 1; ++crcIndex) {
                crc = CRC8.getCrcValue((int)((data[crcIndex] ^ crc) & 0xFF));
            }
            if (crc == (data[crcIndex] & 0xFF)) break;
            throw new ProtocolException("CRC failed: should be " + crc + " but was " + (data[crcIndex] & 0xFF));
        }
        return result;
    }

    public void notifyReceived(byte[] data) {
        log.debug("BiDiBMessageReceiver received message: {}", (Object)ByteUtils.bytesToHex((byte[])data));
        try {
            List<BidibMessageInterface> commandMessages = this.splitBidibMessages(data, true);
            for (BidibMessageInterface message : commandMessages) {
                log.trace("send message {}", (Object)message);
                this.serverMessageHandler.send(this.port, message.getContent());
            }
        }
        catch (ProtocolException e) {
            log.warn("Protocol error while parsing incoming message from BiDiB connection", (Throwable)e);
        }
    }

    public void notifySend(byte[] data) {
    }
}

