/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.tcpserver;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.tcpserver.BiDiBMessageReceiver;
import jmri.jmrix.bidib.tcpserver.ServerMessageReceiver;
import jmri.jmrix.bidib.tcpserver.TcpServerNetMessageHandler;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPort;
import org.bidib.jbidibc.net.serialovertcp.NetBidibServerPlainTcpPort;
import org.bidib.jbidibc.net.serialovertcp.NetMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetPlainTcpBidib {
    private final BiDiBTrafficController tc;
    private Thread portWorker;
    private NetMessageHandler netServerMessageHandler;
    private NetBidibPort netBidibTcpPort;
    private BiDiBMessageReceiver bidibMessageReveiver;
    private final AtomicBoolean isStarted = new AtomicBoolean();
    private final Object stopSync = new Object();
    private static final Logger log = LoggerFactory.getLogger(NetPlainTcpBidib.class);

    public NetPlainTcpBidib(BiDiBTrafficController tc) {
        this.tc = tc;
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public void start(int portNumber) {
        log.info("Start the TCP server.");
        try {
            this.netServerMessageHandler = this.createServerMessageHandler();
            log.info("Create a NetBidibTcpPort with the portnumber: {}", (Object)portNumber);
            this.netBidibTcpPort = new NetBidibServerPlainTcpPort(portNumber, null, this.netServerMessageHandler);
            log.info("Prepare and start the port worker for netBidibPortSimulator: {}", (Object)this.netBidibTcpPort);
            this.portWorker = new Thread((Runnable)this.netBidibTcpPort);
            this.portWorker.start();
            this.bidibMessageReveiver = new BiDiBMessageReceiver(this.netServerMessageHandler, this.netBidibTcpPort);
            this.tc.addRawMessageListener(this.bidibMessageReveiver);
            this.isStarted.set(true);
        }
        catch (Exception ex) {
            log.warn("Start the TCP server failed.", (Throwable)ex);
            this.isStarted.set(false);
        }
    }

    protected NetMessageHandler createServerMessageHandler() {
        ServerMessageReceiver serverMessageReceiver = new ServerMessageReceiver(this.tc){

            @Override
            public void publishResponse(ByteArrayOutputStream output) throws ProtocolException {
                log.info("Publish the response. Prepare message to send to host using netSimulationMessageHandler: {}", (Object)NetPlainTcpBidib.this.netServerMessageHandler);
            }

            public void removeNodeListener(NodeListener nodeListener) {
            }
        };
        TcpServerNetMessageHandler netMessageHandler = new TcpServerNetMessageHandler(serverMessageReceiver);
        log.info("Created the server netMessageHandler: {}", (Object)netMessageHandler);
        return netMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.info("Stop the TCP server.");
        if (this.netBidibTcpPort != null) {
            log.info("Stop the port.");
            this.netBidibTcpPort.stop();
            if (this.portWorker != null) {
                Object object = this.stopSync;
                synchronized (object) {
                    try {
                        this.portWorker.join(5000L);
                    }
                    catch (InterruptedException ex) {
                        log.warn("Wait for termination of port worker failed.", (Throwable)ex);
                    }
                    this.portWorker = null;
                }
            }
            this.isStarted.set(false);
            this.netBidibTcpPort = null;
        }
        if (this.bidibMessageReveiver != null) {
            this.tc.removeRawMessageListener(this.bidibMessageReveiver);
            this.bidibMessageReveiver = null;
        }
        log.info("Stop the TCP server finished.");
    }
}

