/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.tcpserver;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import jmri.jmrix.bidib.BiDiBTrafficController;
import jmri.jmrix.bidib.tcpserver.ServerBidibMessageProcessor;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerMessageReceiver
implements ServerBidibMessageProcessor,
MessageReceiver {
    private final BiDiBTrafficController tc;
    private BidibRequestFactory requestFactory;
    protected AtomicBoolean running = new AtomicBoolean();
    boolean escapeHot = false;
    private final Object accessLock = new Object();
    private static final Logger log = LoggerFactory.getLogger(ServerMessageReceiver.class);

    public ServerMessageReceiver(BiDiBTrafficController tc) {
        this.tc = tc;
        log.info("Server connected to {}", (Object)tc.getUserName());
        this.running.set(true);
    }

    private synchronized BidibRequestFactory getRequestFactory() {
        if (this.requestFactory == null) {
            this.requestFactory = new BidibRequestFactory();
        }
        return this.requestFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enable() {
        log.info("enable is called.");
        Object object = this.accessLock;
        synchronized (object) {
            this.escapeHot = false;
        }
        this.running.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        log.info("Disable is called.");
        this.running.set(false);
        Object object = this.accessLock;
        synchronized (object) {
            this.escapeHot = false;
        }
    }

    public void receive(ByteArrayOutputStream output) {
        if (!this.running.get()) {
            log.warn("Receiver is not running. Discard messages.");
            return;
        }
        log.info("Receive data: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
        try {
            ArrayList commands = new ArrayList();
            this.getRequestFactory().createFromRaw(output.toByteArray(), commands);
            if (CollectionUtils.isNotEmpty(commands)) {
                for (BidibMessageInterface bidibCommand : commands) {
                    log.info("Process the current bidibCommand: {}", (Object)bidibCommand);
                    this.tc.sendBiDiBMessage((BidibCommandMessage)bidibCommand, this.tc.getNodeByAddr(bidibCommand.getAddr()));
                }
            } else {
                log.warn("No commands in packet received.");
            }
        }
        catch (ProtocolException ex) {
            log.warn("Create BiDiB message failed.", (Throwable)ex);
        }
    }

    @Override
    public abstract void publishResponse(ByteArrayOutputStream var1) throws ProtocolException;

    public void processMessages(ByteArrayOutputStream output) throws ProtocolException {
        log.warn("processMessages() is not implemented in SimulationMessageReceiver.");
    }

    public String getErrorInformation() {
        return null;
    }

    public void addMessageListener(MessageListener messageListener) {
    }

    public void removeMessageListener(MessageListener messageListener) {
    }

    public void addNodeListener(NodeListener nodeListener) {
    }

    public void cleanup() {
    }
}

