/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.tcpserver;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.util.Properties;
import java.util.ResourceBundle;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.tcpserver.NetPlainTcpBidib;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.zeroconf.ZeroConfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServer {
    final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.bidib.swing.BiDiBSwingBundle");
    private final BiDiBSystemConnectionMemo memo;
    NetPlainTcpBidib netPlainTcpBidib;
    ServerSocket serverSocket;
    boolean settingsLoaded = false;
    boolean settingsChanged = false;
    Runnable shutDownTask;
    ZeroConfService service = null;
    private boolean autoStart = false;
    static final String AUTO_START_KEY = "AutoStart";
    static final String PORT_NUMBER_KEY = "PortNumber";
    static final String SETTINGS_FILE_NAME = "BiDiBOverTcpSettings.ini";
    private int portNumber = 62875;
    private static final Logger log = LoggerFactory.getLogger(TcpServer.class);

    public TcpServer(BiDiBSystemConnectionMemo memo) {
        this.memo = memo;
        log.debug("BiDiB TcpServer created for {}", (Object)memo.getUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        if (!this.settingsLoaded) {
            this.settingsLoaded = true;
            Properties settings = new Properties();
            String settingsFileName = FileUtil.getUserFilesPath() + SETTINGS_FILE_NAME;
            try {
                log.debug("TcpServer: opening settings file {}", (Object)settingsFileName);
                try (FileInputStream settingsStream = new FileInputStream(settingsFileName);){
                    settings.load(settingsStream);
                }
                String val = settings.getProperty(AUTO_START_KEY, "0");
                this.autoStart = val.equals("1");
                val = settings.getProperty(PORT_NUMBER_KEY, Integer.toString(62875));
                this.portNumber = Integer.parseInt(val, 10);
            }
            catch (FileNotFoundException ex) {
                log.debug("TcpServer: loadSettings file not found");
            }
            catch (IOException ex) {
                log.debug("TcpServer: loadSettings exception: ", (Throwable)ex);
            }
            this.updateServerStateListener();
        }
    }

    public void saveSettings() {
        String settingsFileName = FileUtil.getUserFilesPath() + SETTINGS_FILE_NAME;
        log.debug("TcpServer: saving settings file {}", (Object)settingsFileName);
        try (FileOutputStream outStream = new FileOutputStream(settingsFileName);
             PrintStream settingsStream = new PrintStream(outStream);){
            settingsStream.println("# BiDiBOverTcp Configuration Settings");
            settingsStream.println("AutoStart = " + (this.autoStart ? "1" : "0"));
            settingsStream.println("PortNumber = " + this.portNumber);
            settingsStream.flush();
            settingsStream.close();
            this.settingsChanged = false;
        }
        catch (IOException ex) {
            log.warn("TcpServer: saveSettings exception: ", (Throwable)ex);
        }
        this.updateServerStateListener();
    }

    public boolean getAutoStart() {
        this.loadSettings();
        return this.autoStart;
    }

    public void setAutoStart(boolean start) {
        this.loadSettings();
        this.autoStart = start;
        this.settingsChanged = true;
        this.updateServerStateListener();
    }

    public int getPortNumber() {
        this.loadSettings();
        return this.portNumber;
    }

    public void setPortNumber(int port) {
        this.loadSettings();
        if (port >= 1024 && port <= 65535) {
            this.portNumber = port;
            this.settingsChanged = true;
            this.updateServerStateListener();
        }
    }

    public boolean isEnabled() {
        return this.netPlainTcpBidib != null && this.netPlainTcpBidib.isStarted();
    }

    public boolean isSettingChanged() {
        return this.settingsChanged;
    }

    public void enable() {
        if (this.netPlainTcpBidib == null || !this.netPlainTcpBidib.isStarted()) {
            log.info("Starting new BiDiBOverTcpServer listener on port {}", (Object)this.portNumber);
            if (this.netPlainTcpBidib == null) {
                this.netPlainTcpBidib = new NetPlainTcpBidib(this.memo.getBiDiBTrafficController());
            }
            this.netPlainTcpBidib.start(this.portNumber);
            if (this.netPlainTcpBidib.isStarted()) {
                this.updateServerStateListener();
                if (this.shutDownTask == null) {
                    this.shutDownTask = this::disable;
                }
                if (this.shutDownTask != null) {
                    InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
                }
            } else {
                JmriJOptionPane.showMessageDialog(null, this.rb.getString("BiDiBOverTCPServerConnectError"), "TCP over BiDiB Server", 0);
            }
        }
    }

    public void disable() {
        if (this.netPlainTcpBidib != null) {
            log.info("Stopping BiDiBOverTcpServer listener.");
            this.netPlainTcpBidib.stop();
            this.netPlainTcpBidib = null;
            this.updateServerStateListener();
        }
        if (this.shutDownTask != null) {
            InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
        }
    }

    public void updateServerStateListener() {
    }

    public void updateClientStateListener() {
    }

    public BiDiBSystemConnectionMemo getSystemConnectionMemo() {
        return this.memo;
    }
}

