/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.tcpserver;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import jmri.jmrix.bidib.BiDiBSystemConnectionMemo;
import jmri.jmrix.bidib.tcpserver.TcpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerAction
extends AbstractAction {
    final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.bidib.swing.BiDiBSwingBundle");
    private String enable;
    private String disable;
    private TcpServer server = null;
    private static final Logger log = LoggerFactory.getLogger(TcpServerAction.class);

    public TcpServerAction() {
        log.warn("TcpServer cannot be started on startup because upstream connection is not known. Use the BiDiB connection type menu instead.");
    }

    public TcpServerAction(BiDiBSystemConnectionMemo memo, String enable, String disable) {
        super(enable);
        this.enable = enable;
        this.disable = disable;
        log.debug("create TcpServerAction for {} - \"{}\" \"{}\"", new Object[]{memo.getUserName(), enable, disable});
        this.server = new TcpServer(memo);
        log.debug("TCP Server is enabled by default: {}", (Object)this.server.isEnabled());
        this.putValue("Name", this.server.isEnabled() ? disable : enable);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("TcpServerAction actionPerformed {}", (Object)e);
        if (this.server != null) {
            log.trace("TcpServer: {} for {}, enabled: {}", new Object[]{this.server, this.server.getSystemConnectionMemo().getUserName(), this.server.isEnabled()});
            String text = (String)this.getValue("Name");
            log.trace("menu text was: {}", (Object)text);
            if (this.server.isEnabled()) {
                this.server.disable();
            } else {
                this.server.enable();
            }
            this.putValue("Name", this.server.isEnabled() ? this.disable : this.enable);
        } else {
            log.debug("TcpServer is not created.");
        }
    }
}

