/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bidib.tcpserver;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.net.serialovertcp.DataPacket;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPort;
import org.bidib.jbidibc.net.serialovertcp.NetMessageHandler;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerNetMessageHandler
implements NetMessageHandler {
    private final MessageReceiver messageReceiverDelegate;
    private static final Logger log = LoggerFactory.getLogger(TcpServerNetMessageHandler.class);

    public TcpServerNetMessageHandler(MessageReceiver messageReceiverDelegate) {
        this.messageReceiverDelegate = messageReceiverDelegate;
    }

    public void receive(DataPacket packet) {
        log.debug("Received a packet from address: {}, port: {}, data: {}", new Object[]{packet.getAddress(), packet.getPort(), ByteUtils.bytesToHex((byte[])packet.getData())});
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(packet.getData(), 0, packet.getData().length);
        log.info("Forward received message to messageReceiverDelegate: {}, output: {}", (Object)this.messageReceiverDelegate, (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
        try {
            this.messageReceiverDelegate.receive(output);
        }
        catch (Exception ex) {
            log.warn("Process messages failed.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void send(NetBidibPort port, byte[] data) {
        log.trace("Send message to port: {}, message: {}", (Object)port, (Object)ByteUtils.bytesToHex((byte[])data));
        ByteArrayOutputStream output = new ByteArrayOutputStream(100);
        ByteArrayOutputStream input = new ByteArrayOutputStream(100);
        try {
            input.write(data);
            SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)input, (OutputStream)output);
            log.trace("Send, after encoding: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
            port.send(output.toByteArray(), null, 0);
        }
        catch (Exception e) {
            log.warn("no data sent", (Throwable)e);
        }
    }

    public void acceptClient(String remoteHost) {
        log.info("Accept client with address: {}", (Object)remoteHost);
    }

    public void cleanup(String remoteHost) {
        log.info("Cleanup client with address: {}", (Object)remoteHost);
    }
}

