/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.can.CanInterface;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCanTrafficController
extends AbstractMRTrafficController
implements CanInterface {
    private static final Logger log = LoggerFactory.getLogger(AbstractCanTrafficController.class);

    public AbstractCanTrafficController() {
        this.allowUnexpectedReply = true;
    }

    @Override
    public synchronized void addCanListener(CanListener l) {
        this.addListener(l);
    }

    public synchronized void addCanConsoleListener(CanListener l) {
        this.addConsoleListener(l);
    }

    @Override
    public synchronized void removeCanListener(CanListener l) {
        this.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        block15: {
            log.debug("forwardToPort message: [{}]", (Object)m);
            this.mLastSender = reply;
            AbstractMRTrafficController.XmtNotifier r = new AbstractMRTrafficController.XmtNotifier(m, this.mLastSender, this);
            SwingUtilities.invokeLater(r);
            AbstractMRMessage hm = ((CanMessage)m).isTranslated() ? m : this.encodeForHardware((CanMessage)m);
            log.debug("Encoded for hardware: [{}]", (Object)hm.toString());
            byte[] msg = new byte[this.lengthOfByteStream(hm)];
            int offset = this.addHeaderToOutput(msg, hm);
            int len = hm.getNumDataElements();
            for (int i = 0; i < len; ++i) {
                msg[i + offset] = (byte)hm.getElement(i);
            }
            this.addTrailerToOutput(msg, len + offset, hm);
            try {
                if (this.ostream != null) {
                    if (log.isDebugEnabled()) {
                        StringBuilder buf = new StringBuilder();
                        for (int i = 0; i < msg.length; ++i) {
                            buf.append(Integer.toHexString(0xFF & msg[i]));
                            buf.append(" ");
                        }
                        log.debug("formatted message: {}", (Object)buf.toString());
                    }
                    while (hm.getRetries() >= 0) {
                        if (this.portReadyToSend(this.controller)) {
                            this.ostream.write(msg);
                            log.debug("message written");
                            break block15;
                        }
                        if (hm.getRetries() >= 0) {
                            if (log.isDebugEnabled()) {
                                log.debug("Retry message: {} attempts remaining: {}", (Object)hm.toString(), (Object)hm.getRetries());
                            }
                            hm.setRetries(hm.getRetries() - 1);
                            try {
                                Runnable buf = this.xmtRunnable;
                                synchronized (buf) {
                                    this.xmtRunnable.wait(hm.getTimeout());
                                    continue;
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                log.error("retry wait interrupted");
                                continue;
                            }
                        }
                        log.warn("sendMessage: port not ready for data sending: {}", (Object)Arrays.toString(msg));
                    }
                    break block15;
                }
                this.connectionWarn();
            }
            catch (IOException | RuntimeException e) {
                this.portWarn(e);
            }
        }
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    protected abstract AbstractMRMessage newMessage();

    public abstract CanReply decodeFromHardware(AbstractMRReply var1);

    public abstract AbstractMRMessage encodeForHardware(CanMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    public void handleOneIncomingReply() throws IOException {
        block24: {
            block23: {
                AbstractMRReply hmsg = this.newReply();
                this.waitForStartOfReply(this.istream);
                this.loadChars(hmsg, this.istream);
                CanReply msg = this.decodeFromHardware(hmsg);
                if (msg == null) {
                    return;
                }
                this.replyInDispatch = true;
                if (log.isDebugEnabled()) {
                    log.debug("dispatch reply of length {} contains {} state {}", new Object[]{msg.getNumDataElements(), msg.toString(), this.mCurrentState});
                }
                this.distributeOneReply(msg, this.mLastSender);
                if (msg.isUnsolicited()) break block23;
                log.debug("switch on state {}", (Object)this.mCurrentState);
                switch (this.mCurrentState) {
                    case 25: {
                        Runnable runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 15;
                            this.replyInDispatch = false;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    case 30: {
                        Runnable runnable;
                        this.mCurrentMode = 4;
                        this.replyInDispatch = false;
                        int warmUpDelay = this.enterProgModeDelayTime();
                        if (warmUpDelay != 0) {
                            try {
                                runnable = this.xmtRunnable;
                                synchronized (runnable) {
                                    this.xmtRunnable.wait(warmUpDelay);
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    case 35: {
                        this.mCurrentMode = 1;
                        this.replyInDispatch = false;
                        Runnable runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    default: {
                        this.replyInDispatch = false;
                        if (this.allowUnexpectedReply) {
                            log.debug("Allowed unexpected reply received in state: {} was {}", (Object)this.mCurrentState, (Object)msg);
                            break;
                        }
                        this.unexpectedReplyStateError(this.mCurrentState, msg.toString());
                        break;
                    }
                }
                break block24;
            }
            this.replyInDispatch = false;
        }
    }

    public void distributeOneReply(CanReply msg, AbstractMRListener mLastSender) {
        if (msg == null) {
            log.error("found unexpected null message", (Throwable)new Exception("traceback"));
        }
        AbstractMRTrafficController.RcvNotifier r = this.newRcvNotifier(msg, mLastSender, this);
        this.distributeReply(r);
    }
}

