/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can;

import javax.annotation.concurrent.Immutable;
import jmri.util.StringUtil;

@Immutable
public interface CanFrame {
    public int getHeader();

    public boolean isExtended();

    public boolean isRtr();

    public int getNumDataElements();

    public int getElement(int var1);

    default public String monString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append("(");
        buf.append(Integer.toHexString(this.getHeader()));
        buf.append(this.isExtended() ? " ext)" : ")");
        this.appendHexElements(buf);
        return buf.toString();
    }

    default public String getToString() {
        StringBuilder buf = new StringBuilder(28);
        buf.append("[");
        buf.append(Integer.toHexString(this.getHeader()));
        buf.append("]");
        this.appendHexElements(buf);
        return buf.toString();
    }

    default public void appendHexElements(StringBuilder sb) {
        for (int i = 0; i < this.getNumDataElements(); ++i) {
            sb.append(" ");
            sb.append(StringUtil.twoHexFromInt(this.getElement(i)));
        }
    }

    default public boolean isEqual(Object a, Object b) {
        if (a instanceof CanFrame && b instanceof CanFrame) {
            CanFrame aa = (CanFrame)a;
            CanFrame bb = (CanFrame)b;
            if (aa.isRtr() == bb.isRtr() && aa.isExtended() == bb.isExtended() && aa.getHeader() == bb.getHeader() && this.dataFramesEqual(aa, bb)) {
                return true;
            }
        }
        return false;
    }

    default public boolean dataFramesEqual(CanFrame a, CanFrame b) {
        if (a.getNumDataElements() != b.getNumDataElements()) {
            return false;
        }
        for (int i = 0; i < a.getNumDataElements(); ++i) {
            if (a.getElement(i) == b.getElement(i)) continue;
            return false;
        }
        return true;
    }

    default public boolean extendedOrRtr() {
        return this.isExtended() || this.isRtr();
    }
}

